/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.timemodel.tcn;

import de.aristaflow.adept2.model.timemodel.tcn.NodeInstance;
import de.aristaflow.adept2.model.timemodel.tcn.NodeMapping;
import de.aristaflow.adept2.model.timemodel.tcn.TCNTimePoint;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;

public class JoinNodeMapping<N extends TCNTimePoint>
extends NodeMapping<N> {
    private final N[] prefixNodes;
    private final NodeInstance[] branches;

    public JoinNodeMapping(String label, NodeInstance nodeInstance, N[] prefixNodes, N startNode, N[] intermediateEvents, N endNode) {
        super(label, nodeInstance, startNode, intermediateEvents, endNode);
        this.prefixNodes = prefixNodes == null ? (TCNTimePoint[])Array.newInstance(startNode.getClass(), 0) : prefixNodes;
        this.branches = new NodeInstance[this.prefixNodes.length];
    }

    @Override
    public N getPrefixNode() {
        throw new IllegalAccessError();
    }

    public N[] getPrefixNodes() {
        return this.prefixNodes;
    }

    public NodeInstance[] getBranches() {
        return this.branches;
    }

    @Override
    public Collection<N> getNodes() {
        Collection x = super.getNodes();
        x.addAll(Arrays.asList(this.prefixNodes));
        return x;
    }

    @Override
    public N getPrefixNode(int branchID) {
        if (this.branches.length > 0) {
            return this.prefixNodes[branchID];
        }
        return this.getStartNode();
    }

    @Override
    public void setBranchID(int branchID, NodeMapping<N> pred) {
        if (this.branches.length > 0) {
            this.branches[branchID] = pred.getNodeInstance();
        }
    }

    @Override
    public int getBranchID(N branchNode) {
        if (!this.getNodes().contains(branchNode)) {
            throw new IllegalArgumentException();
        }
        if (branchNode == this.getStartNode() && this.prefixNodes.length == 0) {
            return 0;
        }
        int i = 0;
        while (i < this.prefixNodes.length) {
            if (this.prefixNodes[i] == branchNode) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public int getBranchID(NodeMapping<N> pred) {
        if (this.branches.length > 0) {
            NodeInstance nodeInstance = pred.getNodeInstance();
            int i = 0;
            while (i < this.branches.length) {
                NodeInstance n = this.branches[i];
                if (n == nodeInstance) {
                    return i;
                }
                ++i;
            }
        } else {
            return 0;
        }
        return -1;
    }

    @Override
    public boolean checkComplete() {
        int i = 0;
        while (i < this.branches.length) {
            assert (this.branches[i] != null);
            ++i;
        }
        return super.checkComplete();
    }
}

