/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.timemodel.tcn;

import de.aristaflow.adept2.model.timemodel.tcn.NodeInstance;
import de.aristaflow.adept2.model.timemodel.tcn.TCNTimePoint;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public class NodeMapping<N extends TCNTimePoint> {
    private final String label;
    private final NodeInstance nodeInstance;
    private final N startNode;
    private final N endNode;
    private final N[] intermediateEvents;

    public NodeMapping(String label, NodeInstance nodeInstance, N startNode, N[] intermediateEvents, N endNode) {
        this.label = label;
        this.nodeInstance = nodeInstance;
        this.startNode = startNode;
        this.intermediateEvents = intermediateEvents == null ? (TCNTimePoint[])Array.newInstance(startNode.getClass(), 0) : intermediateEvents;
        this.endNode = endNode;
    }

    public String getLabel() {
        return this.label;
    }

    public NodeInstance getNodeInstance() {
        return this.nodeInstance;
    }

    public N getStartNode() {
        return this.startNode;
    }

    public N getEndNode() {
        return this.endNode;
    }

    public Collection<N> getNodes() {
        ArrayList<Object> asList = new ArrayList<Object>();
        asList.add(this.startNode);
        asList.addAll(Arrays.asList(this.getIntermediateEvents()));
        asList.add(this.endNode);
        return asList;
    }

    public String toString() {
        if (this.label != null && this.label.length() > 0) {
            return this.label;
        }
        return "Node " + this.nodeInstance;
    }

    public N[] getIntermediateEvents() {
        return this.intermediateEvents;
    }

    public N getPrefixNode() {
        return this.startNode;
    }

    public N getSuffixNode() {
        return this.endNode;
    }

    public void setBranchID(int branchID, NodeMapping<N> node) {
    }

    public void setBranch(N branchNode, NodeMapping<N> node) {
        int branchID = this.getBranchID(branchNode);
        if (branchID != -1) {
            this.setBranchID(branchID, node);
        }
    }

    public int getBranchID(NodeMapping<N> node) {
        return 0;
    }

    public int getBranchID(N branchNode) {
        return 0;
    }

    public N getPrefixNode(int branchID) {
        return this.startNode;
    }

    public N getSuffixNode(int branchID) {
        return this.endNode;
    }

    public boolean checkComplete() {
        return true;
    }

    public N getSuffixNode(NodeMapping<N> succPoints) {
        int branchID = this.getBranchID((N)succPoints);
        return this.getSuffixNode(branchID);
    }

    public N getPrefixNode(NodeMapping<N> predPoints) {
        int branchID = this.getBranchID((N)predPoints);
        return this.getPrefixNode(branchID);
    }
}

