/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.timemodel.tcn;

import de.aristaflow.adept2.model.timemodel.tcn.NodeInstance;
import de.aristaflow.adept2.model.timemodel.tcn.NodeMapping;
import de.aristaflow.adept2.model.timemodel.tcn.TCNTimePoint;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;

public class SplitNodeMapping<N extends TCNTimePoint>
extends NodeMapping<N> {
    private final N[] suffixNodes;
    private NodeInstance[] branches;

    public SplitNodeMapping(String label, NodeInstance nodeInstance, N startNode, N[] intermediateEvents, N endNode, N[] suffixNodes) {
        super(label, nodeInstance, startNode, intermediateEvents, endNode);
        this.suffixNodes = suffixNodes == null ? (TCNTimePoint[])Array.newInstance(startNode.getClass(), 0) : suffixNodes;
        this.branches = new NodeInstance[this.suffixNodes.length];
    }

    @Override
    public N getSuffixNode() {
        throw new IllegalAccessError();
    }

    public N[] getSuffixNodes() {
        return this.suffixNodes;
    }

    public NodeInstance[] getBranches() {
        return this.branches;
    }

    @Override
    public Collection<N> getNodes() {
        Collection x = super.getNodes();
        x.addAll(Arrays.asList(this.suffixNodes));
        return x;
    }

    @Override
    public void setBranchID(int branchID, NodeMapping<N> pred) {
        if (this.branches.length > 0) {
            this.branches[branchID] = pred.getNodeInstance();
        }
    }

    @Override
    public int getBranchID(NodeMapping<N> succ) {
        if (this.branches.length > 0) {
            NodeInstance nodeInstance = succ.getNodeInstance();
            int i = 0;
            while (i < this.branches.length) {
                NodeInstance n = this.branches[i];
                if (n == nodeInstance) {
                    return i;
                }
                ++i;
            }
        } else {
            return 0;
        }
        return -1;
    }

    @Override
    public N getSuffixNode(int branchID) {
        if (this.suffixNodes.length > 0) {
            return this.suffixNodes[branchID];
        }
        return this.getEndNode();
    }

    @Override
    public int getBranchID(N branchNode) {
        if (!this.getNodes().contains(branchNode)) {
            throw new IllegalArgumentException();
        }
        if (branchNode == this.getEndNode() && this.suffixNodes.length == 0) {
            return 0;
        }
        int i = 0;
        while (i < this.suffixNodes.length) {
            if (this.suffixNodes[i] == branchNode) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public boolean checkComplete() {
        int i = 0;
        while (i < this.branches.length) {
            assert (this.branches[i] != null);
            ++i;
        }
        return super.checkComplete();
    }
}

