/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.timemodel.tcn;

import de.aristaflow.adept2.model.common.timedata.CalendarElement;
import de.aristaflow.adept2.model.common.timedata.TimeDistance;
import de.aristaflow.adept2.model.common.timedata.defaultimplementation.DefaultTimeDistance;
import de.aristaflow.adept2.model.globals.TimeModelConstants;
import de.aristaflow.adept2.model.timemodel.InstanceTimeModel;
import de.aristaflow.adept2.model.timemodel.Interval;
import de.aristaflow.adept2.model.timemodel.TimeModelOperations;
import de.aristaflow.adept2.model.timemodel.UpdateableInstanceTimeModel;
import de.aristaflow.adept2.model.timemodel.defaultimplementation.DefaultInterval;
import de.aristaflow.adept2.model.timemodel.defaultimplementation.DefaultTimeModelOperations;
import de.aristaflow.adept2.model.timemodel.tcn.IterationChain;
import de.aristaflow.adept2.model.timemodel.tcn.NodeMapping;
import de.aristaflow.adept2.model.timemodel.tcn.STN;
import de.aristaflow.adept2.model.timemodel.tcn.TCN;
import de.aristaflow.adept2.model.timemodel.tcn.TCNEdge;
import de.aristaflow.adept2.model.timemodel.tcn.TCNTimePoint;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.AbstractTCN;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public abstract class TCNInstanceTimeModel<N extends TCNTimePoint, E extends TCNEdge<N, ?>>
implements InstanceTimeModel,
UpdateableInstanceTimeModel {
    protected STN<N, E> stn;
    protected UUID templateID;
    public IterationChain iterationChain;
    protected TimeModelOperations timeModelOperations = new DefaultTimeModelOperations();
    private UUID instanceID;
    protected List<NodeMapping<N>> nodeMappings;
    private N processCreationNode;
    private N processStartNode;
    private N processEndNode;
    protected Map<Integer, List<URI>> updateTriggers;

    public TCNInstanceTimeModel(UUID instanceID, UUID templateID, STN<N, E> tcn, Collection<NodeMapping<N>> nodeMapping, N creationTimePoint, N startTimePoint, N endTimePoint, Map<Integer, List<URI>> updateTriggers) {
        this.instanceID = instanceID;
        this.templateID = templateID;
        this.stn = tcn;
        this.updateTriggers = updateTriggers != null ? new HashMap<Integer, List<URI>>(updateTriggers) : Collections.emptyMap();
        this.nodeMappings = new ArrayList<NodeMapping<N>>(nodeMapping);
        this.processCreationNode = creationTimePoint;
        this.processStartNode = startTimePoint;
        this.processEndNode = endTimePoint;
        this.iterationChain = this.getProcessCreationTimePoint().getNodeInstance().getIteration();
    }

    @Override
    public UUID getBaseTemplateID() {
        return this.templateID;
    }

    @Override
    public UUID getInstanceID() {
        return this.instanceID;
    }

    @Override
    public Interval<TimeDistance> getInstanceDuration() {
        return this.getTimeFrame(this.getProcessStartTimePoint(), this.getProcessEndTimePoint());
    }

    protected Interval<TimeDistance> getTimeFrame(N from, N to) {
        TimeDistance minValue;
        TimeDistance maxValue;
        if (from != to) {
            Object maxEdge = this.stn.getEdge(from, to);
            Object minEdge = this.stn.getEdge(to, from);
            maxValue = maxEdge != null ? this.getValue(maxEdge) : DefaultTimeDistance.POSITIVE_INFINITE_TIME_DISTANCE;
            minValue = minEdge != null ? this.getValue(minEdge).neg() : DefaultTimeDistance.NEGATIVE_INFINITE_TIME_DISTANCE;
        } else {
            minValue = maxValue = DefaultTimeDistance.ZERO_TIME_DISTANCE;
        }
        return this.toTimeFrame(minValue, maxValue);
    }

    protected Interval<TimeDistance> toTimeFrame(TimeDistance minValue, TimeDistance maxValue) {
        return new DefaultInterval<TimeDistance>(minValue, maxValue);
    }

    protected Interval<CalendarElement> toTimePoint(TimeDistance minValue, TimeDistance maxValue) {
        return new DefaultInterval<CalendarElement>(this.timeModelOperations.convertToCalendarElement(minValue), this.timeModelOperations.convertToCalendarElement(maxValue));
    }

    protected abstract TimeDistance getValue(E var1);

    @Override
    public Interval<CalendarElement> getInstanceStartTimeframe() {
        return this.getTimePoint(this.getProcessStartTimePoint());
    }

    protected N getTimeBaseEvent() {
        return this.stn.getTimeBaseEvent();
    }

    protected Interval<CalendarElement> getTimePoint(N of) {
        TimeDistance minValue;
        TimeDistance maxValue;
        N baseEvent = this.getTimeBaseEvent();
        if (baseEvent != of) {
            Object maxEdge = this.stn.getEdge(baseEvent, of);
            Object minEdge = this.stn.getEdge(of, baseEvent);
            maxValue = maxEdge != null ? this.getValue(maxEdge) : DefaultTimeDistance.POSITIVE_INFINITE_TIME_DISTANCE;
            minValue = minEdge != null ? this.getValue(minEdge).neg() : DefaultTimeDistance.NEGATIVE_INFINITE_TIME_DISTANCE;
        } else {
            minValue = maxValue = DefaultTimeDistance.ZERO_TIME_DISTANCE;
        }
        return this.toTimePoint(minValue, maxValue);
    }

    @Override
    public Interval<CalendarElement> getInstanceCompletionTimeframe() {
        return this.getTimePoint(this.getProcessEndTimePoint());
    }

    @Override
    public Interval<TimeDistance> getActivityInstanceDuration(int nodeID, int iteration) {
        NodeMapping<N> nodeMapping = this.getNodeMapping(nodeID, this.iterationChain);
        return this.getTimeFrame(nodeMapping.getStartNode(), nodeMapping.getEndNode());
    }

    @Override
    public Interval<CalendarElement> getActivityInstanceStartTimeframe(int nodeID, int iteration) {
        NodeMapping<N> nodeMapping = this.getNodeMapping(nodeID, this.iterationChain);
        return this.getTimePoint(nodeMapping.getStartNode());
    }

    @Override
    public Interval<CalendarElement> getActivityInstanceCompletionTimeframe(int nodeID, int iteration) {
        NodeMapping<N> nodeMapping = this.getNodeMapping(nodeID, this.iterationChain);
        return this.getTimePoint(nodeMapping.getEndNode());
    }

    @Override
    public Interval<TimeDistance> getTimeLag(int fromNodeID, int fromIteration, int toNodeID, int toIteration, TimeModelConstants.RelationType relationType) {
        N toNode;
        N fromNode;
        NodeMapping<N> fromNodeMapping = this.getNodeMapping(fromNodeID, this.iterationChain);
        NodeMapping<N> toNodeMapping = this.getNodeMapping(toNodeID, this.iterationChain);
        switch (relationType) {
            case START_START: {
                fromNode = fromNodeMapping.getStartNode();
                toNode = toNodeMapping.getStartNode();
                break;
            }
            case START_END: {
                fromNode = fromNodeMapping.getStartNode();
                toNode = toNodeMapping.getEndNode();
                break;
            }
            case END_END: {
                fromNode = fromNodeMapping.getEndNode();
                toNode = toNodeMapping.getEndNode();
                break;
            }
            default: {
                fromNode = fromNodeMapping.getEndNode();
                toNode = toNodeMapping.getStartNode();
            }
        }
        return this.getTimeFrame(fromNode, toNode);
    }

    public N getProcessCreationTimePoint() {
        return this.processCreationNode;
    }

    public N getProcessStartTimePoint() {
        return this.processStartNode;
    }

    public N getProcessEndTimePoint() {
        return this.processEndNode;
    }

    public NodeMapping<N> getNodeMapping(int nodeId, IterationChain iterationChain) {
        for (NodeMapping<N> nm : this.getNodeMapping()) {
            if (nm.getNodeInstance().getNodeID() != nodeId || !nm.getNodeInstance().getIteration().equals(iterationChain)) continue;
            return nm;
        }
        return null;
    }

    public Collection<NodeMapping<N>> getNodeMapping() {
        return this.nodeMappings;
    }

    public void setProcessBounds(N processCreationNode, N processStartNode, N processEndNode) {
        this.processCreationNode = processCreationNode;
        this.processStartNode = processStartNode;
        this.processEndNode = processEndNode;
    }

    protected void insertNodeMapping(NodeMapping<N> nodeMapping) {
        assert (nodeMapping.checkComplete());
        for (TCNTimePoint n : nodeMapping.getNodes()) {
            ((AbstractTCN)this.getBaseTimeModel()).insertTimePoint(n);
        }
        this.nodeMappings.add(nodeMapping);
    }

    public void removeNode(NodeMapping<N> node) {
        this.nodeMappings.remove(node);
        for (TCNTimePoint n : node.getNodes()) {
            ((AbstractTCN)this.getBaseTimeModel()).removeTimePoint(n);
        }
    }

    public void addNodeMapping(NodeMapping<N> nodeMapping) {
        for (TCNTimePoint n : nodeMapping.getNodes()) {
            if (this.stn.contains(n)) continue;
            throw new IllegalArgumentException("Node does not exist: " + n);
        }
        this.insertNodeMapping(nodeMapping);
    }

    public TCN<N, E> getBaseSTN() {
        return this.stn;
    }

    public abstract TCN<N, ?> getBaseTimeModel();

    public Map<Integer, List<URI>> getUpdateTriggers() {
        return Collections.unmodifiableMap(this.updateTriggers);
    }

    @Override
    public List<URI> getUpdateTrigger(int nodeID) {
        List<URI> list = this.updateTriggers.get(nodeID);
        if (list != null) {
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }
}

