/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.timemodel.tcn;

import de.aristaflow.adept2.model.common.timedata.TimeDistance;
import de.aristaflow.adept2.model.common.timedata.TimePoint;
import de.aristaflow.adept2.model.common.timedata.defaultimplementation.DefaultTimeDistance;
import de.aristaflow.adept2.model.globals.TimeModelConstants;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.timemodel.Interval;
import de.aristaflow.adept2.model.timemodel.TemplateTimeModel;
import de.aristaflow.adept2.model.timemodel.TimeModelOperations;
import de.aristaflow.adept2.model.timemodel.defaultimplementation.DefaultInterval;
import de.aristaflow.adept2.model.timemodel.defaultimplementation.DefaultTimeModelOperations;
import de.aristaflow.adept2.model.timemodel.tcn.IterationChain;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledValue;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledValueSet;
import de.aristaflow.adept2.model.timemodel.tcn.NodeMapping;
import de.aristaflow.adept2.model.timemodel.tcn.STN;
import de.aristaflow.adept2.model.timemodel.tcn.SimpleConstraintValue;
import de.aristaflow.adept2.model.timemodel.tcn.TCN;
import de.aristaflow.adept2.model.timemodel.tcn.TCNEdge;
import de.aristaflow.adept2.model.timemodel.tcn.TCNTimePoint;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.AbstractTCN;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class TCNTemplateTimeModel<N extends TCNTimePoint, E extends TCNEdge<N, ?>>
implements TemplateTimeModel {
    private final STN<N, E> tcn;
    protected Template template;
    protected IterationChain iterationChain;
    protected TimeModelOperations timeModelOperations = new DefaultTimeModelOperations();
    private int startNodeID;
    protected List<NodeMapping<N>> nodeMappings;
    private N processCreationNode;
    private N processStartNode;
    private N processEndNode;
    protected Map<Integer, List<URI>> updateTriggers;

    public TCNTemplateTimeModel(Template template, STN<N, E> tcn, Collection<NodeMapping<N>> nodeMapping, N creationTimePoint, N startTimePoint, N endTimePoint, Map<Integer, List<URI>> updateTriggers) {
        this.template = template;
        this.tcn = tcn;
        this.processCreationNode = creationTimePoint;
        this.processStartNode = startTimePoint;
        this.processEndNode = endTimePoint;
        this.updateTriggers = updateTriggers != null ? new HashMap<Integer, List<URI>>(updateTriggers) : Collections.emptyMap();
        this.nodeMappings = new ArrayList<NodeMapping<N>>(nodeMapping);
        this.startNodeID = template.getStartNode().getID();
        this.iterationChain = new IterationChain(template.getStartNode().getID());
    }

    @Override
    public UUID getTemplateID() {
        return this.template.getID();
    }

    @Override
    public Template getBaseTemplate() {
        return this.template;
    }

    public N getProcessCreationTimePoint() {
        return this.processCreationNode;
    }

    public N getProcessStartTimePoint() {
        return this.processStartNode;
    }

    public N getProcessEndTimePoint() {
        return this.processEndNode;
    }

    public NodeMapping<N> getNodeMapping(int nodeId, IterationChain iterationChain) {
        for (NodeMapping<N> nm : this.getNodeMapping()) {
            if (nm.getNodeInstance().getNodeID() != nodeId || !nm.getNodeInstance().getIteration().equals(iterationChain)) continue;
            return nm;
        }
        return null;
    }

    public NodeMapping<N> getNodeMapping(N event) {
        for (NodeMapping<N> nm : this.getNodeMapping()) {
            if (!nm.getNodes().contains(event)) continue;
            return nm;
        }
        return null;
    }

    public Collection<NodeMapping<N>> getNodeMapping() {
        return this.nodeMappings;
    }

    public void setProcessBounds(N processCreationNode, N processStartNode, N processEndNode) {
        this.processCreationNode = processCreationNode;
        this.processStartNode = processStartNode;
        this.processEndNode = processEndNode;
    }

    protected void insertNodeMapping(NodeMapping<N> nodeMapping) {
        assert (nodeMapping.checkComplete());
        for (TCNTimePoint n : nodeMapping.getNodes()) {
            ((AbstractTCN)this.getBaseTimeModel()).insertTimePoint(n);
        }
        this.nodeMappings.add(nodeMapping);
    }

    public void removeNode(NodeMapping<N> node) {
        this.nodeMappings.remove(node);
        for (TCNTimePoint n : node.getNodes()) {
            ((AbstractTCN)this.getBaseTimeModel()).removeTimePoint(n);
        }
    }

    public void addNodeMapping(NodeMapping<N> nodeMapping) {
        for (TCNTimePoint n : nodeMapping.getNodes()) {
            if (this.tcn.contains(n)) continue;
            throw new IllegalArgumentException("Node does not exist: " + n);
        }
        this.insertNodeMapping(nodeMapping);
    }

    @Override
    public Interval<TimeDistance> getProcessDuration() {
        Node startNode = this.template.getStartNode();
        Node endNode = this.template.getEndNode();
        NodeMapping<N> startNodeMapping = this.getNodeMapping(startNode.getID(), this.iterationChain);
        NodeMapping<N> endNodeMapping = this.getNodeMapping(endNode.getID(), this.iterationChain);
        return this.getTimeFrame(startNodeMapping.getEndNode(), endNodeMapping.getStartNode());
    }

    protected TimeDistance getValue(E edge) {
        if (edge == null) {
            return null;
        }
        Object value = edge.getValue();
        if (value instanceof LabeledValueSet) {
            LabeledValueSet valueSet = (LabeledValueSet)value;
            assert (valueSet.getLabeledValues().size() == 1);
            LabeledValue label = valueSet.getLabeledValues().iterator().next();
            return label.getValue();
        }
        if (value instanceof SimpleConstraintValue) {
            return ((SimpleConstraintValue)value).getValue();
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Interval<TimePoint> getProcessStartTimeframe() {
        N timeBase = this.getTimeBaseEvent();
        NodeMapping<N> startNodeMapping = this.getNodeMapping(this.startNodeID, this.iterationChain);
        return this.getTimePoint(timeBase, startNodeMapping.getEndNode());
    }

    private N getTimeBaseEvent() {
        NodeMapping<N> startNodeMapping = this.getNodeMapping(this.startNodeID, this.iterationChain);
        return startNodeMapping.getStartNode();
    }

    @Override
    public Interval<TimePoint> getProcessCompletionTimeframe() {
        Node endNode = this.template.getEndNode();
        N timeBase = this.getTimeBaseEvent();
        NodeMapping<N> endNodeMapping = this.getNodeMapping(endNode.getID(), this.iterationChain);
        return this.getTimePoint(timeBase, endNodeMapping.getStartNode());
    }

    @Override
    public Interval<TimeDistance> getActivityDuration(int nodeID) {
        NodeMapping<N> nodeMapping = this.getNodeMapping(nodeID, this.iterationChain);
        return this.getTimeFrame(nodeMapping.getStartNode(), nodeMapping.getEndNode());
    }

    @Override
    public Interval<TimePoint> getActivityStartTimeframe(int nodeID) {
        N timeBase = this.getTimeBaseEvent();
        NodeMapping<N> nodeMapping = this.getNodeMapping(nodeID, this.iterationChain);
        return this.getTimePoint(timeBase, nodeMapping.getStartNode());
    }

    @Override
    public Interval<TimePoint> getActivityCompletionTimeframe(int nodeID) {
        N timeBase = this.getTimeBaseEvent();
        NodeMapping<N> nodeMapping = this.getNodeMapping(nodeID, this.iterationChain);
        return this.getTimePoint(timeBase, nodeMapping.getEndNode());
    }

    @Override
    public Interval<TimeDistance> getTimeLag(int fromNodeID, int toNodeID, TimeModelConstants.RelationType relationType) {
        N toNode;
        N fromNode;
        NodeMapping<N> fromNodeMapping = this.getNodeMapping(fromNodeID, this.iterationChain);
        NodeMapping<N> toNodeMapping = this.getNodeMapping(toNodeID, this.iterationChain);
        switch (relationType) {
            case START_START: {
                fromNode = fromNodeMapping.getStartNode();
                toNode = toNodeMapping.getStartNode();
                break;
            }
            case START_END: {
                fromNode = fromNodeMapping.getStartNode();
                toNode = toNodeMapping.getEndNode();
                break;
            }
            case END_END: {
                fromNode = fromNodeMapping.getEndNode();
                toNode = toNodeMapping.getEndNode();
                break;
            }
            default: {
                fromNode = fromNodeMapping.getEndNode();
                toNode = toNodeMapping.getStartNode();
            }
        }
        return this.getTimeFrame(fromNode, toNode);
    }

    public STN<N, E> getBaseSTN() {
        return this.tcn;
    }

    protected Interval<TimePoint> toInterval(TimeDistance minValue, TimeDistance maxValue) {
        assert (minValue != null);
        assert (maxValue != null);
        TimePoint min = this.timeModelOperations.convertToTimePoint(minValue);
        TimePoint max = this.timeModelOperations.convertToTimePoint(maxValue);
        return new DefaultInterval<TimePoint>(min, max);
    }

    protected Interval<TimePoint> getTimePoint(N from, N to) {
        TimeDistance minValue;
        TimeDistance maxValue;
        if (from != to) {
            Object maxEdge = this.tcn.getEdge(from, to);
            Object minEdge = this.tcn.getEdge(to, from);
            maxValue = this.getValue(maxEdge);
            TimeDistance timeDistance = this.getValue(minEdge);
            minValue = timeDistance != null ? timeDistance.neg() : null;
        } else {
            minValue = maxValue = DefaultTimeDistance.ZERO_TIME_DISTANCE;
        }
        return this.toInterval(minValue, maxValue);
    }

    protected Interval<TimeDistance> getTimeFrame(N from, N to) {
        TimeDistance minValue = null;
        TimeDistance maxValue = null;
        if (from != to) {
            Object maxEdge = this.tcn.getEdge(from, to);
            Object minEdge = this.tcn.getEdge(to, from);
            maxValue = this.getValue(maxEdge);
            TimeDistance timeDistance = this.getValue(minEdge);
            minValue = timeDistance != null ? timeDistance.neg() : null;
        } else {
            minValue = maxValue = DefaultTimeDistance.ZERO_TIME_DISTANCE;
        }
        return new DefaultInterval<TimeDistance>(minValue, maxValue);
    }

    public TCN<N, ?> getBaseTimeModel() {
        return this.tcn;
    }

    public Map<Integer, List<URI>> getUpdateTriggers() {
        return Collections.unmodifiableMap(this.updateTriggers);
    }

    public List<URI> getUpdateTrigger(int nodeID) {
        List<URI> list = this.updateTriggers.get(nodeID);
        if (list != null) {
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }
}

