/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.timemodel.tcn;

import de.aristaflow.adept2.model.common.timedata.TimeDistance;
import de.aristaflow.adept2.model.common.timedata.TimePoint;
import de.aristaflow.adept2.model.common.timedata.defaultimplementation.DefaultTimeDistance;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.StructuredConstraintEdge;
import de.aristaflow.adept2.model.processmodel.StructuredEdge;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.TemporalNode;
import de.aristaflow.adept2.model.processmodel.TemporalTemplate;
import de.aristaflow.adept2.model.processmodel.timemodel.ActivityDuration;
import de.aristaflow.adept2.model.processmodel.timemodel.FixedDate;
import de.aristaflow.adept2.model.processmodel.timemodel.ProcessDuration;
import de.aristaflow.adept2.model.processmodel.timemodel.TimeLag;
import de.aristaflow.adept2.model.processmodel.tools.ProcessModelTools;
import de.aristaflow.adept2.model.timemodel.Interval;
import de.aristaflow.adept2.model.timemodel.defaultimplementation.DefaultInterval;
import de.aristaflow.adept2.model.timemodel.tcn.ChangeableTCN;
import de.aristaflow.adept2.model.timemodel.tcn.IterationChain;
import de.aristaflow.adept2.model.timemodel.tcn.JoinNodeMapping;
import de.aristaflow.adept2.model.timemodel.tcn.Label;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledTimePoint;
import de.aristaflow.adept2.model.timemodel.tcn.NodeMapping;
import de.aristaflow.adept2.model.timemodel.tcn.SplitNodeMapping;
import de.aristaflow.adept2.model.timemodel.tcn.TCN;
import de.aristaflow.adept2.model.timemodel.tcn.TCNEdge;
import de.aristaflow.adept2.model.timemodel.tcn.TCNTimePoint;
import de.aristaflow.adept2.util.Tuple;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.Configuration;

public abstract class TCNTransformation<N extends TCNTimePoint, E extends TCNEdge<N, ?>> {
    public static final String CONF_PREFIX = "TCNTransformation.";
    public static final String CONF_NODE_MIN_DURATION = "TCNTransformation.NodeMinDuration";
    public static final String CONF_NODE_MAX_DURATION = "TCNTransformation.NodeMaxDuration";
    public static final String CONF_STRUCTURE_NODE_MIN_DURATION = "TCNTransformation.StructureNodeMinDuration";
    public static final String CONF_STRUCTURE_NODE_MAX_DURATION = "TCNTransformation.StructureNodeMaxDuration";
    public static final String CONF_STRUCTURE_NODE_MIN_TIME_LAG = "TCNTransformation.StructureNodeMinTimeLag";
    public static final String CONF_STRUCTURE_NODE_MAX_TIME_LAG = "TCNTransformation.StructureNodeMaxTimeLag";
    public static final String CONF_CONTROL_FLOW_MIN_TIME_LAG = "TCNTransformation.ControlFlowMinTimeLag";
    public static final String CONF_CONTROL_FLOW_MAX_TIME_LAG = "TCNTransformation.ControlFlowMaxTimeLag";
    public static final String CONF_NO_INSTANCE_CREATION_EVENT = "TCNTransformation.NoInstanceCreationEvent";
    public static final String CONF_NO_DISTINCT_TIMEBASE_EVENT = "TCNTransformation.NoDistinctTimeBaseEvent";
    public static TimeDistance DEFAULT_NODE_MIN_DURATION = DefaultTimeDistance.EPSILON_TIME_DISTANCE;
    public static TimeDistance DEFAULT_NODE_MAX_DURATION = DefaultTimeDistance.POSITIVE_INFINITE_TIME_DISTANCE;
    public static TimeDistance DEFAULT_STRUCTURE_NODE_MIN_DURATION = DefaultTimeDistance.EPSILON_TIME_DISTANCE;
    public static TimeDistance DEFAULT_STRUCTURE_NODE_MAX_DURATION = new DefaultTimeDistance(5L, 0L, 0L, 0L, 0L);
    public static TimeDistance DEFAULT_STRUCTURE_NODE_MIN_TIME_LAG = DefaultTimeDistance.EPSILON_TIME_DISTANCE;
    public static TimeDistance DEFAULT_STRUCTURE_NODE_MAX_TIME_LAG = DefaultTimeDistance.ONE_TIME_DISTANCE;
    public static TimeDistance DEFAULT_CONTROL_FLOW_MIN_TIME_LAG = DefaultTimeDistance.EPSILON_TIME_DISTANCE;
    public static TimeDistance DEFAULT_CONTROL_FLOW_MAX_TIME_LAG = DefaultTimeDistance.POSITIVE_INFINITE_TIME_DISTANCE;
    protected TimeDistance NODE_MIN_DURATION;
    protected TimeDistance NODE_MAX_DURATION;
    protected TimeDistance STRUCTURE_NODE_MIN_DURATION;
    protected TimeDistance STRUCTURE_NODE_MAX_DURATION;
    protected TimeDistance STRUCTURE_NODE_MIN_TIME_LAG;
    protected TimeDistance STRUCTURE_NODE_MAX_TIME_LAG;
    protected TimeDistance CONTROL_FLOW_MIN_TIME_LAG;
    protected TimeDistance CONTROL_FLOW_MAX_TIME_LAG;
    protected boolean NO_INSTANCE_CREATION_EVENT;
    protected boolean NO_DISTINCT_TIMEBASE_EVENT;
    protected TemporalTemplate template;
    private int lookAhead;
    private List<N> nodes;
    private List<E> edges;
    private Collection<NodeMapping<N>> nodeMapping;
    private N instanceCreationTimePoint;
    private N instanceStartTimePoint;
    private N instanceEndTimePoint;
    protected Configuration configuration;
    protected static final int REPEAT_BRANCH = 0;
    protected static final int EXIT_BRANCH = 1;

    public TCNTransformation(Configuration configuration, TemporalTemplate template) {
        this(configuration, template, 0);
    }

    public TCNTransformation(Configuration configuration, TemporalTemplate template, int lookAhead) {
        this.template = template;
        this.lookAhead = lookAhead;
        this.setConfiguration(configuration);
    }

    protected void setConfiguration(Configuration configuration) {
        this.configuration = configuration == null ? new BaseConfiguration() : configuration;
        this.readConfiguration();
    }

    protected void readConfiguration() {
        this.NODE_MIN_DURATION = this.longToTimeDistance(this.configuration.getLong(CONF_NODE_MIN_DURATION, DEFAULT_NODE_MIN_DURATION.toMilliseconds()));
        this.NODE_MAX_DURATION = this.longToTimeDistance(this.configuration.getLong(CONF_NODE_MAX_DURATION, DEFAULT_NODE_MAX_DURATION.toMilliseconds()));
        this.STRUCTURE_NODE_MIN_DURATION = this.longToTimeDistance(this.configuration.getLong(CONF_STRUCTURE_NODE_MIN_DURATION, DEFAULT_STRUCTURE_NODE_MIN_DURATION.toMilliseconds()));
        this.STRUCTURE_NODE_MAX_DURATION = this.longToTimeDistance(this.configuration.getLong(CONF_STRUCTURE_NODE_MAX_DURATION, DEFAULT_STRUCTURE_NODE_MAX_DURATION.toMilliseconds()));
        this.STRUCTURE_NODE_MIN_TIME_LAG = this.longToTimeDistance(this.configuration.getLong(CONF_STRUCTURE_NODE_MIN_TIME_LAG, DEFAULT_STRUCTURE_NODE_MIN_TIME_LAG.toMilliseconds()));
        this.STRUCTURE_NODE_MAX_TIME_LAG = this.longToTimeDistance(this.configuration.getLong(CONF_STRUCTURE_NODE_MAX_TIME_LAG, DEFAULT_STRUCTURE_NODE_MAX_TIME_LAG.toMilliseconds()));
        this.CONTROL_FLOW_MIN_TIME_LAG = this.longToTimeDistance(this.configuration.getLong(CONF_CONTROL_FLOW_MIN_TIME_LAG, DEFAULT_CONTROL_FLOW_MIN_TIME_LAG.toMilliseconds()));
        this.CONTROL_FLOW_MAX_TIME_LAG = this.longToTimeDistance(this.configuration.getLong(CONF_CONTROL_FLOW_MAX_TIME_LAG, DEFAULT_CONTROL_FLOW_MAX_TIME_LAG.toMilliseconds()));
        this.NO_INSTANCE_CREATION_EVENT = this.configuration.getBoolean(CONF_NO_INSTANCE_CREATION_EVENT, false);
        this.NO_DISTINCT_TIMEBASE_EVENT = this.configuration.getBoolean(CONF_NO_DISTINCT_TIMEBASE_EVENT, false);
    }

    protected TimeDistance longToTimeDistance(long miliseconds) {
        return new DefaultTimeDistance(miliseconds, 0L, 0L, 0L, 0L, 0L);
    }

    public TCN<N, E> transform() {
        Object startNodeStartEvent;
        this.nodes = new ArrayList<N>();
        this.edges = new ArrayList();
        this.nodeMapping = new ArrayList<NodeMapping<N>>();
        this.instanceCreationTimePoint = null;
        this.instanceEndTimePoint = null;
        this.instanceStartTimePoint = null;
        N timeBaseNode = this.getTimeBaseNode();
        this.addNode(timeBaseNode);
        int startNodeID = this.template.getStartNode().getID();
        int endNodeID = this.template.getEndNode().getID();
        Label branches = this.createInitialBranch();
        IterationChain iterationChain = new IterationChain(startNodeID);
        N instanceCreationEvent = this.NO_INSTANCE_CREATION_EVENT ? this.getTimeBaseNode() : this.transformInstanceCreationEvent(iterationChain, branches);
        Tuple<NodeMapping<N>, NodeMapping<N>> boundary = this.transformSequenceBlock(startNodeID, endNodeID, iterationChain, branches);
        if (instanceCreationEvent != timeBaseNode) {
            this.createTCNEdge((TCNTimePoint)timeBaseNode, (TCNTimePoint)instanceCreationEvent, branches, this.CONTROL_FLOW_MIN_TIME_LAG, this.CONTROL_FLOW_MAX_TIME_LAG, true);
        }
        if ((startNodeStartEvent = ((NodeMapping)boundary.getFirst()).getStartNode()) != instanceCreationEvent) {
            this.createTCNEdge((TCNTimePoint)instanceCreationEvent, (TCNTimePoint)startNodeStartEvent, branches, this.CONTROL_FLOW_MIN_TIME_LAG, this.CONTROL_FLOW_MAX_TIME_LAG, true);
        }
        this.processSyncEdges();
        this.transformProcessDuration((NodeMapping)boundary.getFirst(), (NodeMapping)boundary.getSecond());
        this.transformTimeLags();
        this.transformProcessValidityPeriod((NodeMapping)boundary.getFirst(), (NodeMapping)boundary.getSecond());
        ChangeableTCN<N, E> tcn = this.createTCN(this.nodes, this.edges, this.nodeMapping);
        this.instanceCreationTimePoint = instanceCreationEvent;
        this.instanceStartTimePoint = ((NodeMapping)boundary.getFirst()).getStartNode();
        this.instanceEndTimePoint = ((NodeMapping)boundary.getSecond()).getEndNode();
        return tcn;
    }

    public N getProcessCreationTimePoint() {
        return this.instanceCreationTimePoint;
    }

    public N getProcessStartTimePoint() {
        return this.instanceStartTimePoint;
    }

    public N getProcessEndTimePoint() {
        return this.instanceEndTimePoint;
    }

    public Collection<NodeMapping<N>> getNodeMapping() {
        return this.nodeMapping;
    }

    protected abstract N getTimeBaseNode();

    protected abstract ChangeableTCN<N, E> createTCN(Collection<N> var1, Collection<E> var2, Collection<NodeMapping<N>> var3);

    protected Tuple<NodeMapping<N>, NodeMapping<N>> transformSequenceBlock(int startNodeID, int endNodeID, IterationChain iterationChain, Label branches) {
        ProcessConstants.NodeType nodeType;
        NodeMapping startNode = null;
        NodeMapping latestNodeProcessed = null;
        int currentNodeID = startNodeID;
        Label currentBranches = branches;
        block6: while (true) {
            nodeType = this.template.getNodeType(currentNodeID);
            switch (nodeType) {
                case NT_AND_SPLIT: 
                case NT_XOR_SPLIT: 
                case NT_STARTLOOP: {
                    int blockStartNode = currentNodeID;
                    int blockEndNode = this.template.getNodeCorrespondingBlockNodeID(blockStartNode);
                    Tuple<NodeMapping<N>, NodeMapping<N>> block = this.transformBlock(blockStartNode, blockEndNode, iterationChain, currentBranches);
                    assert (((NodeMapping)block.getFirst()).getNodeInstance().getNodeID() == blockStartNode);
                    assert (((NodeMapping)block.getSecond()).getNodeInstance().getNodeID() == blockEndNode);
                    if (startNode == null) {
                        startNode = (NodeMapping)block.getFirst();
                    }
                    if (latestNodeProcessed != null) {
                        if (ProcessConstants.NodeType.NT_AND_SPLIT.equals((Object)nodeType) || ProcessConstants.NodeType.NT_STARTLOOP.equals((Object)nodeType)) {
                            this.transformControlEdge(latestNodeProcessed, (NodeMapping)block.getFirst(), currentBranches, this.STRUCTURE_NODE_MIN_TIME_LAG, this.STRUCTURE_NODE_MAX_TIME_LAG);
                        } else {
                            this.transformControlEdge(latestNodeProcessed, (NodeMapping)block.getFirst(), null);
                        }
                    }
                    latestNodeProcessed = (NodeMapping)block.getSecond();
                    currentBranches = latestNodeProcessed.getSuffixNode().getLabel();
                    if (endNodeID != blockEndNode) {
                        currentNodeID = this.template.getSuccByEdgeType(blockEndNode, new ProcessConstants.EdgeType[]{ProcessConstants.EdgeType.ET_CONTROL})[0];
                        continue block6;
                    }
                    return new Tuple((Object)startNode, (Object)latestNodeProcessed);
                }
                case NT_STARTFLOW: {
                    NodeMapping processStartNode;
                    startNode = processStartNode = this.transformProcessStartNode(currentNodeID, iterationChain, currentBranches);
                    latestNodeProcessed = processStartNode;
                    currentNodeID = this.template.getSuccByEdgeType(currentNodeID, new ProcessConstants.EdgeType[]{ProcessConstants.EdgeType.ET_CONTROL})[0];
                    continue block6;
                }
                case NT_NORMAL: {
                    NodeMapping<N> node = this.transformActivity(currentNodeID, iterationChain, currentBranches);
                    if (startNode == null) {
                        startNode = node;
                    }
                    if (latestNodeProcessed != null) {
                        this.transformControlEdge(latestNodeProcessed, node, null);
                    }
                    latestNodeProcessed = node;
                    if (currentNodeID != endNodeID) {
                        currentNodeID = this.template.getSuccByEdgeType(currentNodeID, new ProcessConstants.EdgeType[]{ProcessConstants.EdgeType.ET_CONTROL})[0];
                        continue block6;
                    }
                    return new Tuple(startNode, latestNodeProcessed);
                }
                case NT_ENDFLOW: {
                    NodeMapping<N> processEndNode = this.transformProcessEndNode(currentNodeID, iterationChain, currentBranches);
                    if (latestNodeProcessed != null) {
                        this.transformControlEdge(latestNodeProcessed, processEndNode, null, this.STRUCTURE_NODE_MIN_TIME_LAG, this.STRUCTURE_NODE_MAX_TIME_LAG);
                    }
                    return new Tuple(startNode, processEndNode);
                }
            }
            break;
        }
        throw new IllegalArgumentException(currentNodeID + " " + nodeType);
    }

    protected Tuple<NodeMapping<N>, NodeMapping<N>> transformBlock(int startNodeID, int endNodeID, IterationChain iterationChain, Label branches) {
        ProcessConstants.NodeType blockType = this.template.getNodeType(startNodeID);
        switch (blockType) {
            case NT_AND_SPLIT: {
                return this.transformANDBlock(startNodeID, endNodeID, iterationChain, branches);
            }
            case NT_STARTLOOP: {
                return this.transformLoopBlock(startNodeID, endNodeID, iterationChain, branches);
            }
            case NT_XOR_SPLIT: {
                return this.transformXORBlock(startNodeID, endNodeID, iterationChain, branches);
            }
        }
        throw new IllegalArgumentException();
    }

    protected Tuple<NodeMapping<N>, NodeMapping<N>> transformANDBlock(int startNodeID, int endNodeID, IterationChain iteration, Label branches) {
        ProcessConstants.NodeType blockType = this.template.getNodeType(startNodeID);
        if (blockType != ProcessConstants.NodeType.NT_AND_SPLIT) {
            throw new IllegalArgumentException();
        }
        Label currentBranches = branches;
        SplitNodeMapping<N> splitNode = this.transformANDSplit(startNodeID, iteration, currentBranches);
        int[] succs = this.template.getSuccByEdgeType(startNodeID, new ProcessConstants.EdgeType[]{ProcessConstants.EdgeType.ET_CONTROL});
        Tuple[] branchBlocks = new Tuple[succs.length];
        Label[] newBranches = new Label[succs.length];
        int i = 0;
        while (i < succs.length) {
            N splitNodeEndEvent = splitNode.getSuffixNode(i);
            int branchStartNode = succs[i];
            if (branchStartNode == endNodeID) {
                branchBlocks[i] = null;
                newBranches[i] = splitNodeEndEvent.getLabel();
            } else {
                int branchID1 = this.template.getNodeBranchID(branchStartNode);
                int branchEndNode = ProcessModelTools.getBranchEndNode((Template)this.template, (int)startNodeID, (int)branchID1);
                branchBlocks[i] = this.transformSequenceBlock(branchStartNode, branchEndNode, iteration, currentBranches);
                newBranches[i] = ((NodeMapping)branchBlocks[i].getSecond()).getSuffixNode().getLabel();
            }
            ++i;
        }
        currentBranches = this.mergeANDBranches(currentBranches, newBranches);
        JoinNodeMapping<N> joinNode = this.transformANDJoin(endNodeID, iteration, currentBranches);
        i = 0;
        while (i < branchBlocks.length) {
            Tuple b = branchBlocks[i];
            N splitNodeEndEvent = splitNode.getSuffixNode(i);
            N joinNodeStartEvent = joinNode.getPrefixNode(i);
            if (b != null) {
                Object branchStartNodeStartEvent = ((NodeMapping)b.getFirst()).getPrefixNode();
                this.transformControlEdge(splitNode, splitNodeEndEvent, (NodeMapping)b.getFirst(), branchStartNodeStartEvent, splitNodeEndEvent.getLabel());
                Object branchEndNodeEndEvent = ((NodeMapping)b.getSecond()).getSuffixNode();
                this.transformControlEdge((NodeMapping)b.getSecond(), branchEndNodeEndEvent, joinNode, joinNodeStartEvent, branchEndNodeEndEvent.getLabel());
            } else {
                this.transformControlEdge(splitNode, splitNodeEndEvent, joinNode, joinNodeStartEvent, splitNodeEndEvent.getLabel());
            }
            ++i;
        }
        return new Tuple(splitNode, joinNode);
    }

    protected Tuple<NodeMapping<N>, NodeMapping<N>> transformXORBlock(int startNodeID, int endNodeID, IterationChain iteration, Label branches) {
        if (this.template.getNodeType(startNodeID) != ProcessConstants.NodeType.NT_XOR_SPLIT) {
            throw new IllegalArgumentException();
        }
        Label currentBranches = branches;
        SplitNodeMapping<N> xorSplitNode = this.transformXORSplitNode(startNodeID, iteration, currentBranches);
        int[] succs = this.template.getSuccByEdgeType(startNodeID, new ProcessConstants.EdgeType[]{ProcessConstants.EdgeType.ET_CONTROL});
        Tuple[] branchBlocks = new Tuple[succs.length];
        Label[] newBranchPaths = new Label[succs.length];
        int i = 0;
        while (i < succs.length) {
            int branchStartNode = succs[i];
            N branchDecisionEvent = xorSplitNode.getSuffixNode(i);
            Label newBranch = branchDecisionEvent.getLabel();
            if (branchStartNode == endNodeID) {
                newBranchPaths[i] = newBranch;
                branchBlocks[i] = null;
            } else {
                int branchID = this.template.getNodeBranchID(branchStartNode);
                int branchEndNode = ProcessModelTools.getBranchEndNode((Template)this.template, (int)startNodeID, (int)branchID);
                Tuple<NodeMapping<N>, NodeMapping<N>> b = this.transformSequenceBlock(branchStartNode, branchEndNode, iteration, newBranch);
                Object branchStartEvent = ((NodeMapping)b.getFirst()).getPrefixNode();
                this.transformControlEdge(xorSplitNode, branchDecisionEvent, (NodeMapping)b.getFirst(), branchStartEvent, newBranch);
                branchBlocks[i] = b;
                newBranchPaths[i] = ((NodeMapping)b.getSecond()).getSuffixNode().getLabel();
            }
            ++i;
        }
        currentBranches = this.mergeXORBranches(currentBranches, newBranchPaths);
        JoinNodeMapping<N> xorJoinNode = this.transformXORJoinNode(endNodeID, iteration, currentBranches);
        i = 0;
        while (i < branchBlocks.length) {
            N xorJoinStartEvent = xorJoinNode.getPrefixNode(i);
            Tuple b = branchBlocks[i];
            if (b != null) {
                Object branchEndEvent = ((NodeMapping)b.getSecond()).getSuffixNode();
                this.transformControlEdge((NodeMapping)b.getSecond(), branchEndEvent, xorJoinNode, xorJoinStartEvent, branchEndEvent.getLabel(), this.STRUCTURE_NODE_MIN_TIME_LAG, this.STRUCTURE_NODE_MAX_TIME_LAG);
            } else {
                N branchDecisionEvent = xorSplitNode.getSuffixNode(i);
                this.transformControlEdge(xorSplitNode, branchDecisionEvent, xorJoinNode, xorJoinStartEvent, branchDecisionEvent.getLabel());
            }
            ++i;
        }
        return new Tuple(xorSplitNode, xorJoinNode);
    }

    protected Tuple<NodeMapping<N>, NodeMapping<N>> transformLoopBlock(int startNodeID, int endNodeID, IterationChain iteration, Label branches) {
        ProcessConstants.NodeType blockType = this.template.getNodeType(startNodeID);
        if (blockType != ProcessConstants.NodeType.NT_STARTLOOP) {
            throw new IllegalArgumentException();
        }
        IterationChain newIteration = iteration.subIteration(startNodeID);
        Tuple<NodeMapping<N>, NodeMapping<N>> blockNodes = this.transformLoopContent(startNodeID, endNodeID, newIteration, branches, this.lookAhead);
        return blockNodes;
    }

    protected Tuple<NodeMapping<N>, NodeMapping<N>> transformLoopContent(int startNodeID, int endNodeID, IterationChain iteration, Label branches, int lookAhead) {
        SplitNodeMapping<N> loopStartNode = this.transformLoopStartNode(startNodeID, iteration, branches);
        int[] succs = this.template.getSuccByEdgeType(startNodeID, new ProcessConstants.EdgeType[]{ProcessConstants.EdgeType.ET_CONTROL});
        int branchStartNode = succs[0];
        int branchEndNode = 0;
        Label exitBranch = loopStartNode.getSuffixNode(1).getLabel();
        NodeMapping latestNode = loopStartNode;
        N latestEvent = loopStartNode.getSuffixNode(0);
        Label repeatBranch = latestEvent.getLabel();
        if (branchStartNode == endNodeID) {
            Object branchBlock = null;
        } else {
            int branchID = this.template.getNodeBranchID(branchStartNode);
            branchEndNode = ProcessModelTools.getBranchEndNode((Template)this.template, (int)startNodeID, (int)branchID);
            Tuple<NodeMapping<N>, NodeMapping<N>> branchBlock = this.transformSequenceBlock(branchStartNode, branchEndNode, iteration, repeatBranch);
            N loopIterationEvent = loopStartNode.getSuffixNode(0);
            Object branchStartEvent = ((NodeMapping)branchBlock.getFirst()).getPrefixNode();
            this.transformControlEdge(loopStartNode, loopIterationEvent, (NodeMapping)branchBlock.getFirst(), branchStartEvent, repeatBranch);
            latestNode = (NodeMapping)branchBlock.getSecond();
            latestEvent = latestNode.getSuffixNode();
            repeatBranch = latestEvent.getLabel();
        }
        if (lookAhead > 0) {
            Tuple<NodeMapping<N>, NodeMapping<N>> loopContent = this.transformLoopContent(startNodeID, endNodeID, iteration.incrementIteration(), repeatBranch, lookAhead - 1);
            NodeMapping loopContentStart = (NodeMapping)loopContent.getFirst();
            this.transformControlEdge(latestNode, latestEvent, loopContentStart, loopContentStart.getPrefixNode(), repeatBranch);
            latestNode = (NodeMapping)loopContent.getSecond();
            latestEvent = latestNode.getSuffixNode();
        }
        JoinNodeMapping<N> loopEndNode = this.transformLoopEndNode(endNodeID, iteration, branches);
        this.transformControlEdge(loopStartNode, loopStartNode.getSuffixNode(1), loopEndNode, loopEndNode.getPrefixNode(1), exitBranch);
        this.transformControlEdge(latestNode, latestEvent, loopEndNode, loopEndNode.getPrefixNode(0), repeatBranch);
        return new Tuple(loopStartNode, loopEndNode);
    }

    protected abstract JoinNodeMapping<N> transformLoopEndNode(int var1, IterationChain var2, Label var3);

    protected abstract SplitNodeMapping<N> transformLoopStartNode(int var1, IterationChain var2, Label var3);

    protected TCNActivityDuration getActivityDuration(int nodeID) {
        TemporalNode node = this.template.getNode(nodeID);
        ActivityDuration activityDuration = node.getActivityDuration();
        TimeDistance flexibleMinDuration = this.NODE_MIN_DURATION;
        TimeDistance flexibleMaxDuration = this.NODE_MAX_DURATION;
        if (activityDuration != null) {
            TimePoint flexibleMaximumDuration;
            TimePoint lowerMinimumDuration = activityDuration.getMinimumDuration();
            if (lowerMinimumDuration != null) {
                flexibleMinDuration = new DefaultTimeDistance(lowerMinimumDuration);
            }
            if ((flexibleMaximumDuration = activityDuration.getMaximumDuration()) != null) {
                flexibleMaxDuration = new DefaultTimeDistance(flexibleMaximumDuration);
            }
        }
        return new TCNActivityDuration(flexibleMinDuration, flexibleMaxDuration);
    }

    protected void processSyncEdges() {
        for (StructuredEdge syncEdge : this.template.getEdgeStructure(new ProcessConstants.EdgeType[]{ProcessConstants.EdgeType.ET_SYNC})) {
            NodeMapping<N>[] nodes;
            NodeMapping<N>[] nodeMappingArray = nodes = this.findNodes(syncEdge.getSourceNodeID());
            int n = nodes.length;
            int n2 = 0;
            while (n2 < n) {
                NodeMapping<N> source = nodeMappingArray[n2];
                NodeMapping<N> destination = this.findNode(syncEdge.getDestinationNodeID(), source.getNodeInstance().getIteration());
                if (destination != null) {
                    N e1 = source.getEndNode();
                    N e2 = destination.getStartNode();
                    Label branches = this.mergeBranches(e1, e2);
                    this.transformSyncEdge((TCNTimePoint)e1, (TCNTimePoint)e2, branches);
                }
                ++n2;
            }
        }
    }

    protected void transformProcessDuration(NodeMapping<N> startNode, NodeMapping<N> endNode) {
        Interval<TimeDistance> processDuration = this.getProcessDuration();
        N processStartNodeEndEvent = startNode.getEndNode();
        N processEndNodeStartEvent = endNode.getStartNode();
        Label branches = processEndNodeStartEvent.getLabel();
        this.createTCNEdge((TCNTimePoint)processStartNodeEndEvent, (TCNTimePoint)processEndNodeStartEvent, branches, processDuration.getMinValue(), processDuration.getMaxValue(), false);
    }

    protected void transformTimeLags() {
        for (StructuredConstraintEdge ste : this.template.getConstraintEdgeStructure()) {
            this.transformTimeLag(ste);
        }
    }

    protected void transformTimeLag(StructuredConstraintEdge ste) {
        TimeLag[] timeLagArray = this.template.getTimeLagsConstraint(ste.getSourceNodeID(), ste.getDestinationNodeID());
        int n = timeLagArray.length;
        int n2 = 0;
        while (n2 < n) {
            TimeLag timeLag = timeLagArray[n2];
            if (timeLag != null) {
                NodeMapping<N>[] nodes;
                NodeMapping<N>[] nodeMappingArray = nodes = this.findNodes(ste.getSourceNodeID());
                int n3 = nodes.length;
                int n4 = 0;
                while (n4 < n3) {
                    NodeMapping<N> source = nodeMappingArray[n4];
                    NodeMapping<N> destination = this.findNode(ste.getDestinationNodeID(), source.getNodeInstance().getIteration());
                    if (destination != null) {
                        N destinationEvents;
                        N sourceEvents;
                        switch (timeLag.getRelationType()) {
                            case END_END: {
                                sourceEvents = source.getEndNode();
                                destinationEvents = destination.getEndNode();
                                break;
                            }
                            case END_START: {
                                sourceEvents = source.getEndNode();
                                destinationEvents = destination.getStartNode();
                                break;
                            }
                            case START_END: {
                                sourceEvents = source.getStartNode();
                                destinationEvents = destination.getEndNode();
                                break;
                            }
                            case START_START: {
                                sourceEvents = source.getStartNode();
                                destinationEvents = destination.getStartNode();
                                break;
                            }
                            default: {
                                throw new RuntimeException();
                            }
                        }
                        this.transformTimeLag(sourceEvents, destinationEvents, timeLag);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    protected Interval<TimeDistance> transformTimeLag(N sourceEvent, N destinationEvent, TimeLag timeLag) {
        Interval<TimeDistance> timeSpan = this.toTimeSpan(timeLag);
        Label branches = this.mergeBranches(sourceEvent, destinationEvent);
        this.createTCNEdge((TCNTimePoint)sourceEvent, (TCNTimePoint)destinationEvent, branches, timeSpan.getMinValue(), timeSpan.getMaxValue(), false);
        return timeSpan;
    }

    private Interval<TimeDistance> toTimeSpan(TimeLag timeLag) {
        TimePoint minimumTimeLag = timeLag.getLowerMinimumTimeLag();
        TimeDistance minDuration = minimumTimeLag != null ? new DefaultTimeDistance(minimumTimeLag) : DefaultTimeDistance.NEGATIVE_INFINITE_TIME_DISTANCE;
        TimePoint maximumTimeLag = timeLag.getUpperMaximumTimeLag();
        TimeDistance maxDuration = maximumTimeLag != null ? new DefaultTimeDistance(maximumTimeLag) : DefaultTimeDistance.POSITIVE_INFINITE_TIME_DISTANCE;
        DefaultInterval<TimeDistance> timeSpan = new DefaultInterval<TimeDistance>(minDuration, maxDuration);
        return timeSpan;
    }

    protected void processActivityFixedDate(int nodeID, NodeMapping<N> node) {
        FixedDate completionFixedDate;
        TemporalNode n = this.template.getNode(nodeID);
        FixedDate startFixedDate = n.getStartFixedDate();
        if (startFixedDate != null) {
            N startNode = node.getStartNode();
            this.createFixedDateForNode(startNode);
        }
        if ((completionFixedDate = n.getCompletionFixedDate()) != null) {
            N endNode = node.getEndNode();
            this.createFixedDateForNode(endNode);
        }
    }

    protected void createFixedDateForNode(N startNode) {
        this.createTCNEdge((TCNTimePoint)this.getTimeBaseNode(), (TCNTimePoint)startNode, startNode.getLabel(), DefaultTimeDistance.ZERO_TIME_DISTANCE, DefaultTimeDistance.POSITIVE_INFINITE_TIME_DISTANCE, false);
    }

    protected void processActivityValidityPeriod(int nodeID, NodeMapping<LabeledTimePoint> node) {
    }

    protected void transformProcessValidityPeriod(NodeMapping<N> startNode, NodeMapping<N> endNode) {
    }

    protected Interval<TimeDistance> getProcessDuration() {
        ProcessDuration processDuration = this.template.getProcessDuration();
        TimeDistance minDuration = DefaultTimeDistance.ZERO_TIME_DISTANCE;
        TimeDistance maxDuration = DefaultTimeDistance.POSITIVE_INFINITE_TIME_DISTANCE;
        if (processDuration != null) {
            TimePoint upperMaximumDuration;
            TimePoint lowerMinimumDuration = processDuration.getMinimumDuration();
            if (lowerMinimumDuration != null) {
                minDuration = new DefaultTimeDistance(lowerMinimumDuration);
            }
            if ((upperMaximumDuration = processDuration.getMaximumDuration()) != null) {
                maxDuration = new DefaultTimeDistance(upperMaximumDuration);
            }
        }
        return new DefaultInterval<TimeDistance>(minDuration, maxDuration);
    }

    protected abstract E[] transformSyncEdge(N var1, N var2, Label var3);

    private NodeMapping<N> findNode(int nodeID, IterationChain iterationChain) {
        for (NodeMapping<N> m : this.nodeMapping) {
            if (m.getNodeInstance().getNodeID() != nodeID || !m.getNodeInstance().getIteration().equals(iterationChain)) continue;
            return m;
        }
        return null;
    }

    private NodeMapping<N>[] findNodes(int nodeID) {
        ArrayList<NodeMapping<N>> res = new ArrayList<NodeMapping<N>>();
        for (NodeMapping<N> m : this.nodeMapping) {
            if (m.getNodeInstance().getNodeID() != nodeID) continue;
            res.add(m);
        }
        return res.toArray(new NodeMapping[res.size()]);
    }

    protected abstract E[] createTCNEdge(N var1, N var2, Label var3, TimeDistance var4, TimeDistance var5, boolean var6);

    protected abstract NodeMapping<N> transformProcessEndNode(int var1, IterationChain var2, Label var3);

    protected abstract NodeMapping<N> transformActivity(int var1, IterationChain var2, Label var3);

    protected abstract NodeMapping<N> transformProcessStartNode(int var1, IterationChain var2, Label var3);

    protected abstract JoinNodeMapping<N> transformXORJoinNode(int var1, IterationChain var2, Label var3);

    protected abstract SplitNodeMapping<N> transformXORSplitNode(int var1, IterationChain var2, Label var3);

    protected abstract JoinNodeMapping<N> transformANDJoin(int var1, IterationChain var2, Label var3);

    protected abstract SplitNodeMapping<N> transformANDSplit(int var1, IterationChain var2, Label var3);

    protected abstract Label createInitialBranch();

    protected abstract N transformInstanceCreationEvent(IterationChain var1, Label var2);

    protected void transformControlEdge(NodeMapping<N> pred, NodeMapping<N> succ, Label branches) {
        this.transformControlEdge(pred, succ, branches, this.CONTROL_FLOW_MIN_TIME_LAG, this.CONTROL_FLOW_MAX_TIME_LAG);
    }

    protected void transformControlEdge(NodeMapping<N> pred, NodeMapping<N> succ, Label branches, TimeDistance minDistance, TimeDistance maxDistance) {
        N from = pred.getSuffixNode();
        N to = succ.getPrefixNode();
        this.transformControlEdge(pred, from, succ, to, branches, minDistance, maxDistance);
    }

    protected void transformControlEdge(NodeMapping<N> pred, N from, NodeMapping<N> succ, N to, Label branches) {
        this.transformControlEdge(pred, from, succ, to, branches, this.CONTROL_FLOW_MIN_TIME_LAG, this.CONTROL_FLOW_MAX_TIME_LAG);
    }

    protected void transformControlEdge(NodeMapping<N> pred, N from, NodeMapping<N> succ, N to, Label branches, TimeDistance minDistance, TimeDistance maxDistance) {
        if (branches == null) {
            branches = to.getLabel().merge(from.getLabel());
        }
        this.createTCNEdge((TCNTimePoint)from, (TCNTimePoint)to, branches, minDistance, maxDistance, true);
        pred.setBranch(from, succ);
        succ.setBranch(to, pred);
    }

    protected abstract Label mergeBranches(N var1, N var2);

    protected abstract Label mergeANDBranches(Label var1, Label[] var2);

    protected abstract Label mergeXORBranches(Label var1, Label[] var2);

    protected <M extends NodeMapping<N>> M addNodeMapping(M mapping) {
        this.nodeMapping.add(mapping);
        return mapping;
    }

    protected N addNode(N nodeTemplate) {
        if (this.nodes.contains(nodeTemplate)) {
            int index = this.nodes.indexOf(nodeTemplate);
            throw new IllegalArgumentException("Node already exists: " + nodeTemplate + " as " + this.nodes.get(index));
        }
        this.nodes.add(nodeTemplate);
        return nodeTemplate;
    }

    protected E addEdge(E edgeTemplate) {
        if (!this.nodes.contains(edgeTemplate.getSourceNode())) {
            throw new IllegalArgumentException();
        }
        if (!this.nodes.contains(edgeTemplate.getTargetNode())) {
            throw new IllegalArgumentException();
        }
        for (TCNEdge e : this.edges) {
            if (e.getSourceNode() != edgeTemplate.getSourceNode() || e.getTargetNode() != edgeTemplate.getTargetNode()) continue;
            TCNEdge edge = this.mergeEdges(e, edgeTemplate);
            if (edge != e) {
                this.edges.add(edge);
                this.edges.remove(e);
            }
            return (E)edge;
        }
        this.edges.add(edgeTemplate);
        return edgeTemplate;
    }

    protected abstract E mergeEdges(E var1, E var2);

    protected String getNodeName(int nodeID) {
        return this.template.getNode(nodeID).getName();
    }

    protected static class TCNActivityDuration {
        public final TimeDistance minDuration;
        public final TimeDistance maxDuration;

        public TCNActivityDuration(TimeDistance minDuration, TimeDistance maxDuration) {
            this.minDuration = minDuration;
            this.maxDuration = maxDuration;
        }
    }
}

