/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.timemodel.tcn.cstnImpl;

import de.aristaflow.adept2.model.common.timedata.TimeDistance;
import de.aristaflow.adept2.model.common.timedata.defaultimplementation.DefaultTimeDistance;
import de.aristaflow.adept2.model.timemodel.ChangeSet;
import de.aristaflow.adept2.model.timemodel.defaultimplementation.Path;
import de.aristaflow.adept2.model.timemodel.defaultimplementation.Triangle;
import de.aristaflow.adept2.model.timemodel.tcn.CSTN;
import de.aristaflow.adept2.model.timemodel.tcn.ChangeableCSTN;
import de.aristaflow.adept2.model.timemodel.tcn.Label;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledEdge;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledTimePoint;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledValue;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledValueSet;
import de.aristaflow.adept2.model.timemodel.tcn.TCNEdge;
import de.aristaflow.adept2.model.timemodel.tcn.TCNInconsistencyException;
import de.aristaflow.adept2.model.timemodel.tcn.cstnuImpl.CSTNUReductionProjection;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.AbstractSTNSolver;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.ContingentLabeledValue;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.DefaultLabeledEdge;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.DefaultLabeledValue;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.DefaultLabeledValueSet;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.DefaultObservationTimePoint;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.ObservationBinding;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.Proposition;
import de.aristaflow.adept2.util.ArgChecks;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

public abstract class AbstractCSTNSolver
extends AbstractSTNSolver<LabeledTimePoint, LabeledValueSet, LabeledEdge> {
    public AbstractCSTNSolver() {
    }

    public AbstractCSTNSolver(Level debugLevel) {
        super(debugLevel);
    }

    @Override
    protected Label mergeLabels(Label branch1, Label branch2) {
        return branch1.merge(branch2);
    }

    public LabeledValueSet applySimplificationRules(LabeledValueSet labeledValueSet) {
        Map<Label, LabeledValue> labels = DefaultLabeledValueSet.toMap(labeledValueSet);
        this.applySimplificationRules(labels);
        if (labels.size() != labeledValueSet.getLabeledValues().size()) {
            DefaultLabeledValueSet newLabeledValueSet = new DefaultLabeledValueSet(labels.values());
            assert (!labeledValueSet.equals(newLabeledValueSet));
            assert (this.debug(Level.FINER, "\tSimplifying %s to %s", labeledValueSet, newLabeledValueSet));
            return newLabeledValueSet;
        }
        return labeledValueSet;
    }

    public boolean applySimplificationRules(Map<Label, LabeledValue> labels) {
        boolean changes = false;
        boolean localChanges = true;
        while (localChanges) {
            localChanges = false;
            localChanges |= this.redundantLabelEliminationRule1(labels);
            changes |= (localChanges |= this.redundantLabelEliminationRule2(labels));
        }
        assert (labels.size() > 0);
        return changes;
    }

    protected boolean redundantLabelEliminationRule2(Map<Label, LabeledValue> labels) {
        boolean changes = false;
        HashSet<DefaultLabeledValue> markForAdd = new HashSet<DefaultLabeledValue>();
        HashSet<Label> markForRemoval = new HashSet<Label>();
        ArrayList<LabeledValue> list = new ArrayList<LabeledValue>(labels.values());
        HashMap map = new HashMap();
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            LabeledValue v1 = (LabeledValue)listIterator.next();
            if (!listIterator.hasNext()) break;
            ListIterator iter2 = list.listIterator(listIterator.nextIndex());
            while (iter2.hasNext()) {
                HashSet<LabeledValue> choices;
                LabeledValue v2 = (LabeledValue)iter2.next();
                Label.ChoiceVariable diff = this.singlediff(v1.getLabel(), v2.getLabel());
                if (diff == null) continue;
                Label context = v1.getLabel().removeVariable(diff);
                HashMap<Label.ChoiceVariable, HashSet<LabeledValue>> baseLabels = (HashMap<Label.ChoiceVariable, HashSet<LabeledValue>>)map.get(context);
                if (baseLabels == null) {
                    baseLabels = new HashMap<Label.ChoiceVariable, HashSet<LabeledValue>>();
                    map.put(context, baseLabels);
                }
                if ((choices = (HashSet<LabeledValue>)baseLabels.get(diff)) == null) {
                    choices = new HashSet<LabeledValue>(diff.getOptions() * 2);
                    baseLabels.put(diff, choices);
                }
                choices.add(v1);
                choices.add(v2);
            }
        }
        for (Map.Entry entry : map.entrySet()) {
            Label context = (Label)entry.getKey();
            Map choices = (Map)entry.getValue();
            for (Map.Entry entry2 : choices.entrySet()) {
                int compare;
                TimeDistance value;
                if (((Label.ChoiceVariable)entry2.getKey()).getOptions() != ((Set)entry2.getValue()).size()) continue;
                TimeDistance max = DefaultTimeDistance.NEGATIVE_INFINITE_TIME_DISTANCE;
                for (LabeledValue l : (Set)entry2.getValue()) {
                    value = l.getValue();
                    compare = value.compareTo(max);
                    if (compare <= 0) continue;
                    max = value;
                }
                markForAdd.add(new DefaultLabeledValue(context, max));
                for (LabeledValue l : (Set)entry2.getValue()) {
                    value = l.getValue();
                    compare = value.compareTo(max);
                    if (compare < 0) continue;
                    markForRemoval.add(l.getLabel());
                }
            }
        }
        for (Label label : markForRemoval) {
            changes |= labels.remove(label) != null;
        }
        for (LabeledValue labeledValue : markForAdd) {
            changes |= this.addOrReplaceIfNecessary(labels, labeledValue);
        }
        assert (labels.size() > 0) : "MarkForAdd: " + markForAdd + " | MarkForRemoval: " + markForRemoval;
        return changes;
    }

    protected boolean redundantLabelEliminationRule1(Map<Label, LabeledValue> labels) {
        boolean changes = false;
        Iterator<LabeledValue> iter1 = labels.values().iterator();
        block0: while (iter1.hasNext()) {
            LabeledValue v1 = iter1.next();
            for (LabeledValue v2 : labels.values()) {
                if (v1 == v2 || !v2.dominates(v1)) continue;
                assert (this.debug(Level.FINEST, "\tRLE1: Removing label %s because it subsumes %s", v1, v2));
                iter1.remove();
                changes = true;
                continue block0;
            }
        }
        assert (labels.size() > 0);
        return changes;
    }

    protected Set<Label.ChoiceVariable> conflictLiterals(Label label1, Label label2) {
        Proposition prop1 = (Proposition)label1;
        Proposition prop2 = (Proposition)label2;
        Set<ObservationBinding> observations1 = prop1.getObservations();
        Set<ObservationBinding> observations2 = prop2.getObservations();
        HashSet<Label.ChoiceVariable> conflicts = new HashSet<Label.ChoiceVariable>();
        block0: for (ObservationBinding l1 : observations1) {
            for (ObservationBinding l2 : observations2) {
                if (!l1.getVariable().equals(l2.getVariable())) continue;
                if (l1.getValue() == l2.getValue()) continue block0;
                conflicts.add(l1.getVariable());
                continue block0;
            }
        }
        return conflicts;
    }

    protected Label.ChoiceVariable singlediff(Label label1, Label label2) {
        Proposition prop1 = (Proposition)label1;
        Proposition prop2 = (Proposition)label2;
        Set<ObservationBinding> observations1 = prop1.getObservations();
        Set<ObservationBinding> observations2 = prop2.getObservations();
        if (observations1.size() != observations2.size()) {
            return null;
        }
        Set<Label.ChoiceVariable> conflicts = this.conflictLiterals(label1, label2);
        if (conflicts.size() == 1) {
            return conflicts.iterator().next();
        }
        return null;
    }

    protected void addOrReplaceIfNecessary(LabeledTimePoint Q, LabeledTimePoint T, Map<Label, LabeledValue> labels, LabeledValue label) {
        if (Q.getLabel().satisfiable(label.getLabel()) && T.getLabel().satisfiable(label.getLabel())) {
            this.addOrReplaceIfNecessary(labels, label);
        } else {
            this.debug(Level.SEVERE, "\tDropping %s because the Label is inconsistent with the nodes!", label);
        }
    }

    public Map<Label, LabeledValue> intersect(LabeledValueSet op1, Map<Label, LabeledValue> op2) {
        if (op1 == null) {
            return op2;
        }
        ArgChecks.checkForNull(op2, (String)"op2");
        Map<Label, LabeledValue> labels = DefaultLabeledValueSet.toMap(op1);
        Collection<LabeledValue> lvs_op2 = op2.values();
        for (LabeledValue l_op2 : lvs_op2) {
            Label label = l_op2.getLabel();
            LabeledValue existingValue = labels.get(label);
            if (existingValue != null) {
                LabeledValue newValue = this.merge(l_op2, existingValue);
                if (existingValue == newValue) continue;
                labels.put(label, newValue);
                continue;
            }
            boolean foundGeneralization = false;
            Iterator<LabeledValue> iterator = labels.values().iterator();
            while (iterator.hasNext()) {
                LabeledValue lbl = iterator.next();
                if (lbl.dominates(l_op2)) {
                    foundGeneralization = true;
                    break;
                }
                if (!l_op2.dominates(lbl)) continue;
                iterator.remove();
            }
            if (foundGeneralization) continue;
            labels.put(label, l_op2);
        }
        assert (this.debug(Level.FINER, "\tIntersect LabeledValueSet\t (%s) \\cap (%s) = (%s)", op1, op2, labels.values()));
        return labels;
    }

    public LabeledValue merge(LabeledValue newValue, LabeledValue oldValue) {
        int compare = oldValue.getValue().compareTo(newValue.getValue());
        if (compare > 0) {
            return newValue;
        }
        return oldValue;
    }

    public boolean addOrReplaceIfNecessary(Map<Label, LabeledValue> labels, LabeledValue newValue) {
        boolean changes = false;
        Label label = newValue.getLabel();
        LabeledValue oldValue = labels.get(label);
        if (oldValue != null) {
            LabeledValue value = this.merge(newValue, oldValue);
            if (value != null && value != oldValue) {
                labels.put(label, value);
                changes = true;
            }
        } else {
            labels.put(label, newValue);
            changes = true;
        }
        return changes;
    }

    protected LabeledEdge createEdge(LabeledTimePoint from, LabeledTimePoint to, LabeledValueSet labeledValueSet, boolean controledge, boolean implicit, TCNEdge.FlowDirection flowDirection) {
        return new DefaultLabeledEdge(from, to, labeledValueSet, controledge, implicit, flowDirection);
    }

    protected void applyPropositionModificationRules(CSTN cstnu, LabeledTimePoint Q, LabeledTimePoint S, LabeledTimePoint T, Map<Label, LabeledValue> labeledValuesQT) throws TCNInconsistencyException {
        this.propositionModificationRuleR0(Q, T, labeledValuesQT);
        this.propositionModificationRuleR1(cstnu, Q, S, labeledValuesQT);
        this.propositionModificationRuleR2(cstnu, Q, T, labeledValuesQT);
        this.propositionModificationRuleR3(cstnu, S, T, Q, labeledValuesQT);
    }

    public void propositionModificationRuleR3(CSTN cstnu, LabeledTimePoint P, LabeledTimePoint X, LabeledTimePoint Y, Map<Label, LabeledValue> labeledValuesYX) {
        assert (P != null);
        assert (X != null);
        if (!(P instanceof DefaultObservationTimePoint)) {
            return;
        }
        DefaultObservationTimePoint oP = (DefaultObservationTimePoint)P;
        LabeledEdge PX = (LabeledEdge)cstnu.getEdge(P, X);
        if (PX == null) {
            return;
        }
        LabeledEdge YP = (LabeledEdge)cstnu.getEdge(Y, P);
        if (YP != null) {
            boolean after = true;
            for (LabeledValue l_YP : ((LabeledValueSet)YP.getValue()).getLabeledValues()) {
                if (l_YP.getValue().compareTo(DefaultTimeDistance.ZERO_TIME_DISTANCE) < 0) continue;
                after = false;
            }
            if (after) {
                assert (this.debug(Level.FINER, "Skipping RuleR3 for (%s->%s) because Y may only happen after P.", Y, X));
                return;
            }
        }
        ArrayList<LabeledValue> newValues = new ArrayList<LabeledValue>();
        Iterator<LabeledValue> iterator = labeledValuesYX.values().iterator();
        while (iterator.hasNext()) {
            Label betaGammaP;
            Label betaGamma;
            LabeledValue l_YX = iterator.next();
            if (l_YX instanceof ContingentLabeledValue && ContingentLabeledValue.ConstraintCase.LOWERCASE.equals((Object)((ContingentLabeledValue)l_YX).getCase()) || (betaGamma = (betaGammaP = l_YX.getLabel()).removeVariable(oP.getObservation())).equals(betaGammaP)) continue;
            Collection<LabeledValue> lvs_PX = ((LabeledValueSet)PX.getValue()).getLabeledValues();
            boolean foundSuitablePartner = false;
            for (LabeledValue l_PX : lvs_PX) {
                Label[] notAlpha;
                TimeDistance v;
                Label alphaBeta;
                TimeDistance w;
                if (l_PX instanceof ContingentLabeledValue || DefaultTimeDistance.ZERO_TIME_DISTANCE.compareTo(w = l_PX.getValue().neg()) >= 0 || !this.satisfiable(betaGamma, alphaBeta = l_PX.getLabel()) || alphaBeta.containsVariable(oP.getObservation()) || (v = l_YX.getValue().neg()).compareTo(w) >= 0 && (!(l_YX instanceof ContingentLabeledValue) || (v = ((ContingentLabeledValue)l_YX).getContingentValue().neg()).compareTo(w) >= 0)) continue;
                assert (this.debug(Level.FINE, "Applying RuleR3 to PX: (%1$s->%2$s) = %3$s and YX: (%4$s->%2$s) = %5$s", P, X, l_PX, Y, l_YX));
                assert (DefaultTimeDistance.ZERO_TIME_DISTANCE.compareTo(l_PX.getValue()) >= 0);
                assert (w.compareTo(l_YX.getValue().neg()) >= 0 || l_YX instanceof ContingentLabeledValue && w.compareTo(((ContingentLabeledValue)l_YX).getContingentValue().neg()) >= 0);
                if (!Y.getLabel().containsVariable(oP.getObservation())) {
                    foundSuitablePartner = true;
                    Label alphaBetaGamma = this.mergeLabels(betaGamma, alphaBeta);
                    LabeledValue newLabeledValue = this.updateLabel(l_YX, alphaBetaGamma);
                    assert (this.debug(Level.FINER, "\tR3:\t\t Replacing %s by %s", l_YX, newLabeledValue));
                    newValues.add(newLabeledValue);
                } else assert (this.debug(Level.WARNING, String.format("WARNING: cannot apply R3 because of a label mismatch: %s vs. %s", PX, labeledValuesYX.values())));
                Label alpha = alphaBeta.removeLabel(betaGamma);
                if (alpha.isEmptyLabel()) continue;
                foundSuitablePartner = true;
                Label[] labelArray = notAlpha = alpha.negate();
                int n = notAlpha.length;
                int n2 = 0;
                while (n2 < n) {
                    Label nA = labelArray[n2];
                    Label notAlphaBetaGammaS = this.mergeLabels(nA, betaGammaP);
                    LabeledValue newLabeledValue = this.updateLabel(l_YX, notAlphaBetaGammaS);
                    newValues.add(newLabeledValue);
                    assert (this.debug(Level.FINER, "\tR3 (cont.):\t Replacing %s by %s", l_YX, newLabeledValue));
                    ++n2;
                }
            }
            if (!foundSuitablePartner) continue;
            iterator.remove();
        }
        for (LabeledValue newValue : newValues) {
            this.addOrReplaceIfNecessary(labeledValuesYX, newValue);
        }
    }

    public void propositionModificationRuleR2(CSTN cstnu, LabeledTimePoint X, LabeledTimePoint P, Map<Label, LabeledValue> labeledValuesQT) {
        assert (X != null);
        assert (P != null);
        if (!(P instanceof DefaultObservationTimePoint)) {
            return;
        }
        DefaultObservationTimePoint oP = (DefaultObservationTimePoint)P;
        LabeledEdge PX = (LabeledEdge)cstnu.getEdge(P, X);
        if (PX == null) {
            return;
        }
        ArrayList<LabeledValue> newValues = new ArrayList<LabeledValue>();
        Iterator<LabeledValue> iterator = labeledValuesQT.values().iterator();
        while (iterator.hasNext()) {
            Label betaGammaP;
            Label betaGamma;
            LabeledValue l_XP = iterator.next();
            if (l_XP instanceof ContingentLabeledValue && ContingentLabeledValue.ConstraintCase.LOWERCASE.equals((Object)((ContingentLabeledValue)l_XP).getCase()) || (betaGamma = (betaGammaP = l_XP.getLabel()).removeVariable(oP.getObservation())).equals(betaGammaP)) continue;
            Collection<LabeledValue> lvs_PX = ((LabeledValueSet)PX.getValue()).getLabeledValues();
            boolean foundSuitablePartner = false;
            for (LabeledValue l_PX : lvs_PX) {
                Label[] notAlpha;
                TimeDistance v;
                Label alphaBeta;
                TimeDistance w;
                if (l_PX instanceof ContingentLabeledValue || DefaultTimeDistance.ZERO_TIME_DISTANCE.compareTo(w = l_PX.getValue().neg()) > 0 || !this.satisfiable(betaGamma, alphaBeta = l_PX.getLabel()) || alphaBeta.containsVariable(oP.getObservation()) || (v = l_XP.getValue()).compareTo(w) < 0 && (!(l_XP instanceof ContingentLabeledValue) || (v = ((ContingentLabeledValue)l_XP).getContingentValue()).compareTo(w) < 0)) continue;
                assert (DefaultTimeDistance.ZERO_TIME_DISTANCE.compareTo(l_PX.getValue()) >= 0);
                assert (w.compareTo(l_XP.getValue()) <= 0 || l_XP instanceof ContingentLabeledValue && w.compareTo(((ContingentLabeledValue)l_XP).getContingentValue()) <= 0);
                if (!X.getLabel().containsVariable(oP.getObservation())) {
                    foundSuitablePartner = true;
                    Label alphaBetaGamma = this.mergeLabels(betaGamma, alphaBeta);
                    LabeledValue newLabeledValue = this.updateLabel(l_XP, alphaBetaGamma);
                    this.debug(Level.FINER, "\tR2:\t\t Replacing %s by %s", l_XP, newLabeledValue);
                    newValues.add(newLabeledValue);
                } else assert (this.debug(Level.SEVERE, "ERROR: cannot apply R2 because of a label mismatch"));
                Label alpha = alphaBeta.removeLabel(betaGamma);
                if (alpha.isEmptyLabel()) continue;
                foundSuitablePartner = true;
                Label[] labelArray = notAlpha = alpha.negate();
                int n = notAlpha.length;
                int n2 = 0;
                while (n2 < n) {
                    Label nA = labelArray[n2];
                    Label notAlphaBetaGammaP = this.mergeLabels(nA, betaGammaP);
                    LabeledValue newLabeledValue = this.updateLabel(l_XP, notAlphaBetaGammaP);
                    newValues.add(newLabeledValue);
                    this.debug(Level.FINER, "R2 (cont.): Replacing %s by %s", l_XP, newLabeledValue);
                    ++n2;
                }
            }
            if (!foundSuitablePartner) continue;
            iterator.remove();
        }
        for (LabeledValue newValue : newValues) {
            this.addOrReplaceIfNecessary(labeledValuesQT, newValue);
        }
    }

    public void propositionModificationRuleR1(CSTN cstnu, LabeledTimePoint X, LabeledTimePoint P, Map<Label, LabeledValue> labeledValuesQT) {
        assert (X != null);
        assert (P != null);
        if (!(P instanceof DefaultObservationTimePoint)) {
            return;
        }
        DefaultObservationTimePoint oP = (DefaultObservationTimePoint)P;
        LabeledEdge PX = (LabeledEdge)cstnu.getEdge(P, X);
        if (PX == null) {
            return;
        }
        ArrayList<LabeledValue> newValues = new ArrayList<LabeledValue>();
        Iterator<LabeledValue> iterator = labeledValuesQT.values().iterator();
        while (iterator.hasNext()) {
            Label betaGammaP;
            Label betaGamma;
            LabeledValue l_XY = iterator.next();
            if (l_XY instanceof ContingentLabeledValue && ContingentLabeledValue.ConstraintCase.LOWERCASE.equals((Object)((ContingentLabeledValue)l_XY).getCase()) || (betaGamma = (betaGammaP = l_XY.getLabel()).removeVariable(oP.getObservation())).equals(betaGammaP)) continue;
            Collection<LabeledValue> lvs_PX = ((LabeledValueSet)PX.getValue()).getLabeledValues();
            boolean foundSuitablePartner = false;
            for (LabeledValue l_PX : lvs_PX) {
                Label[] notAlpha;
                TimeDistance v;
                Label alphaBeta;
                TimeDistance w;
                if (l_PX instanceof ContingentLabeledValue || DefaultTimeDistance.ZERO_TIME_DISTANCE.compareTo(w = l_PX.getValue().neg()) >= 0 || !this.satisfiable(betaGamma, alphaBeta = l_PX.getLabel()) || alphaBeta.containsVariable(oP.getObservation()) || (v = l_XY.getValue()).compareTo(w) > 0 && (!(l_XY instanceof ContingentLabeledValue) || (v = ((ContingentLabeledValue)l_XY).getContingentValue()).compareTo(w) > 0)) continue;
                foundSuitablePartner = true;
                assert (DefaultTimeDistance.ZERO_TIME_DISTANCE.compareTo(l_PX.getValue()) >= 0);
                assert (w.compareTo(l_XY.getValue()) >= 0 || l_XY instanceof ContingentLabeledValue && w.compareTo(((ContingentLabeledValue)l_XY).getContingentValue()) >= 0);
                Label alphaBetaGamma = this.mergeLabels(betaGamma, alphaBeta);
                LabeledValue newLabeledValue = this.updateLabel(l_XY, alphaBetaGamma);
                this.debug(Level.FINER, "\tR1:\t\t Replacing %s by %s", l_XY, newLabeledValue);
                newValues.add(newLabeledValue);
                Label alpha = alphaBeta.removeLabel(betaGamma);
                if (alpha.isEmptyLabel()) continue;
                Label[] labelArray = notAlpha = alpha.negate();
                int n = notAlpha.length;
                int n2 = 0;
                while (n2 < n) {
                    Label nA = labelArray[n2];
                    Label notAlphaBetaGammaS = this.mergeLabels(nA, betaGammaP);
                    newLabeledValue = this.updateLabel(l_XY, notAlphaBetaGammaS);
                    newValues.add(newLabeledValue);
                    this.debug(Level.FINER, "R1 (cont.): Replacing %s by %s", l_XY, newLabeledValue);
                    ++n2;
                }
            }
            if (!foundSuitablePartner) continue;
            iterator.remove();
        }
        for (LabeledValue newValue : newValues) {
            this.addOrReplaceIfNecessary(labeledValuesQT, newValue);
        }
    }

    protected LabeledValue updateLabel(LabeledValue labeledValue, Label label) {
        DefaultLabeledValue newLabeledValue = new DefaultLabeledValue(label, labeledValue.getValue());
        return newLabeledValue;
    }

    public void propositionModificationRuleR0(LabeledTimePoint P, LabeledTimePoint X, Map<Label, LabeledValue> labeledValuesQT) {
        assert (P != null);
        if (!(P instanceof DefaultObservationTimePoint)) {
            return;
        }
        DefaultObservationTimePoint oP = (DefaultObservationTimePoint)P;
        ArrayList<LabeledValue> newValues = new ArrayList<LabeledValue>();
        Iterator<LabeledValue> iterator = labeledValuesQT.values().iterator();
        while (iterator.hasNext()) {
            Label label;
            boolean applicable;
            LabeledValue l_PX = iterator.next();
            TimeDistance n_w = l_PX.getValue();
            boolean bl = applicable = DefaultTimeDistance.ZERO_TIME_DISTANCE.compareTo(n_w) >= 0;
            if (!applicable && l_PX instanceof ContingentLabeledValue) {
                if (ContingentLabeledValue.ConstraintCase.LOWERCASE.equals((Object)((ContingentLabeledValue)l_PX).getCase())) {
                    applicable = false;
                } else {
                    n_w = ((ContingentLabeledValue)l_PX).getContingentValue();
                    boolean bl2 = applicable = DefaultTimeDistance.ZERO_TIME_DISTANCE.compareTo(n_w) >= 0;
                }
            }
            if (!applicable || (label = l_PX.getLabel().removeVariable(oP.getObservation())).equals(l_PX.getLabel())) continue;
            assert (!(l_PX instanceof ContingentLabeledValue) || ContingentLabeledValue.ConstraintCase.UPPERCASE.equals((Object)((ContingentLabeledValue)l_PX).getCase()));
            assert (DefaultTimeDistance.ZERO_TIME_DISTANCE.compareTo(l_PX.getValue()) >= 0 || l_PX instanceof ContingentLabeledValue && DefaultTimeDistance.ZERO_TIME_DISTANCE.compareTo(((ContingentLabeledValue)l_PX).getContingentValue()) >= 0);
            LabeledValue labeledValue = this.updateLabel(l_PX, label);
            iterator.remove();
            newValues.add(labeledValue);
            this.debug(Level.FINER, "\tR0:\t\t Replacing %s by %s (in connection with %s)", l_PX, labeledValue, oP);
        }
        for (LabeledValue newValue : newValues) {
            this.addOrReplaceIfNecessary(labeledValuesQT, newValue);
        }
    }

    public LabeledValue observationCaseReduction(LabeledValue l_XY, LabeledValue l_YX, LabeledTimePoint P) {
        TimeDistance v;
        assert (P != null);
        assert (l_XY != null);
        assert (l_YX != null);
        if (!(P instanceof DefaultObservationTimePoint)) {
            return null;
        }
        if (l_XY instanceof ContingentLabeledValue) {
            return null;
        }
        if (l_YX instanceof ContingentLabeledValue) {
            return null;
        }
        if (this.satisfiable(l_XY.getLabel(), l_YX.getLabel())) {
            return null;
        }
        Set<Label.ChoiceVariable> conflictLiterals = this.conflictLiterals(l_XY.getLabel(), l_YX.getLabel());
        if (conflictLiterals == null || conflictLiterals.size() != 1) {
            return null;
        }
        Label.ChoiceVariable conflictLiteral = conflictLiterals.iterator().next();
        if (!conflictLiteral.getDecisionTimePoint().equals(P)) {
            return null;
        }
        TimeDistance u = l_XY.getValue();
        if (u.compareTo(v = l_YX.getValue().neg()) >= 0 || DefaultTimeDistance.ZERO_TIME_DISTANCE.compareTo(u) > 0) {
            return null;
        }
        assert (P instanceof DefaultObservationTimePoint);
        assert (!(l_XY instanceof ContingentLabeledValue));
        assert (!(l_YX instanceof ContingentLabeledValue));
        assert (conflictLiteral.getDecisionTimePoint().equals(P));
        assert (DefaultTimeDistance.ZERO_TIME_DISTANCE.compareTo(u) <= 0);
        assert (u.compareTo(v) < 0);
        Label r_XY = ((Proposition)l_XY.getLabel()).removeVariable(conflictLiteral);
        Label r_YX = ((Proposition)l_YX.getLabel()).removeVariable(conflictLiteral);
        assert (this.satisfiable(r_XY, r_YX));
        Label newLabel = this.mergeLabels(r_XY, r_YX);
        DefaultLabeledValue labeledValue = new DefaultLabeledValue(newLabel, DefaultTimeDistance.ZERO_TIME_DISTANCE);
        this.debug(Level.FINER, "\tObservationCase:\t %s & %s -> %s", l_XY, l_YX, labeledValue);
        return labeledValue;
    }

    @Deprecated
    protected Map<LabeledTimePoint, Set<LabeledTimePoint>> collapseRigidComponents(ChangeableCSTN tcn, ChangeSet<LabeledEdge, LabeledValueSet, Triangle<LabeledTimePoint>> changeSet, Set<LabeledTimePoint> nodes, Collection<Set<LabeledTimePoint>> rigidComponents) throws TCNInconsistencyException, InterruptedException {
        HashMap<LabeledTimePoint, Set<LabeledTimePoint>> collapsedComponents = new HashMap<LabeledTimePoint, Set<LabeledTimePoint>>();
        for (Set<LabeledTimePoint> set : rigidComponents) {
            LabeledTimePoint representative;
            this.tightlyCoupleComponent(tcn, set);
            HashSet<LabeledTimePoint> collapsedComponent = new HashSet<LabeledTimePoint>(set);
            List<LabeledTimePoint> observationNodes = this.getObservationNodes(collapsedComponent);
            if (observationNodes.size() == 0) {
                representative = (LabeledTimePoint)collapsedComponent.iterator().next();
            } else if (observationNodes.size() == 1) {
                representative = observationNodes.get(0);
            } else {
                representative = observationNodes.remove(0);
                collapsedComponent.removeAll(observationNodes);
            }
            collapsedComponent.remove(representative);
            collapsedComponents.put(representative, collapsedComponent);
            nodes.removeAll(collapsedComponent);
        }
        for (Map.Entry entry : collapsedComponents.entrySet()) {
            this.collapseComponent(tcn, changeSet, nodes, (LabeledTimePoint)entry.getKey(), (Set)entry.getValue());
        }
        return collapsedComponents;
    }

    @Deprecated
    protected void tightlyCoupleComponent(ChangeableCSTN tcn, Set<LabeledTimePoint> rigidComponent) throws TCNInconsistencyException, InterruptedException {
        if (rigidComponent.size() > 2) {
            this.solveComponent(new CSTNUReductionProjection(tcn, (Collection<LabeledTimePoint>)rigidComponent), null);
        }
    }

    @Deprecated
    protected void collapseComponent(ChangeableCSTN tcn, ChangeSet<LabeledEdge, LabeledValueSet, Triangle<LabeledTimePoint>> changeSet, Set<LabeledTimePoint> nodes, LabeledTimePoint representative, Set<LabeledTimePoint> componentToCollapse) throws TCNInconsistencyException {
        for (LabeledTimePoint node : nodes) {
            if (node == representative) continue;
            for (LabeledTimePoint nodeToReduce : componentToCollapse) {
                LabeledEdge rigidEdge;
                assert (nodeToReduce != representative);
                LabeledEdge edgeToReduce = (LabeledEdge)tcn.getEdge(node, nodeToReduce);
                if (edgeToReduce != null && (rigidEdge = (LabeledEdge)tcn.getEdge(nodeToReduce, representative)) != null) {
                    this.processPath(tcn, changeSet, new Path<LabeledTimePoint>(node, representative), nodeToReduce);
                }
                if ((edgeToReduce = (LabeledEdge)tcn.getEdge(nodeToReduce, node)) == null || (rigidEdge = (LabeledEdge)tcn.getEdge(representative, nodeToReduce)) == null) continue;
                this.processPath(tcn, changeSet, new Path<LabeledTimePoint>(representative, node), nodeToReduce);
            }
        }
    }

    protected abstract boolean processPath(ChangeableCSTN var1, ChangeSet<LabeledEdge, LabeledValueSet, Triangle<LabeledTimePoint>> var2, Path<LabeledTimePoint> var3, LabeledTimePoint var4) throws TCNInconsistencyException;

    @Deprecated
    protected void uncollapseRigidComponents(ChangeableCSTN tcn, ChangeSet<LabeledEdge, LabeledValueSet, Triangle<LabeledTimePoint>> changeSet, Collection<LabeledTimePoint> nodes, Map<LabeledTimePoint, Set<LabeledTimePoint>> collapsedComponents) {
        for (Map.Entry<LabeledTimePoint, Set<LabeledTimePoint>> collapsedComponent : collapsedComponents.entrySet()) {
            try {
                this.uncollapseComponent(tcn, changeSet, nodes, collapsedComponent.getKey(), collapsedComponent.getValue());
            }
            catch (TCNInconsistencyException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Deprecated
    protected void uncollapseComponent(ChangeableCSTN tcn, ChangeSet<LabeledEdge, LabeledValueSet, Triangle<LabeledTimePoint>> changeSet, Collection<LabeledTimePoint> nodes, LabeledTimePoint representative, Set<LabeledTimePoint> collapsedNodes) throws TCNInconsistencyException {
        for (LabeledTimePoint n : nodes) {
            LabeledEdge repEdge1 = (LabeledEdge)tcn.getEdge(n, representative);
            LabeledEdge repEdge2 = (LabeledEdge)tcn.getEdge(representative, n);
            if (repEdge1 == null && repEdge2 == null) continue;
            for (LabeledTimePoint reducedNode : collapsedNodes) {
                LabeledEdge rigidEdge;
                if (repEdge1 != null && (rigidEdge = (LabeledEdge)tcn.getEdge(representative, reducedNode)) != null) {
                    this.processPath(tcn, changeSet, new Path<LabeledTimePoint>(n, reducedNode), representative);
                }
                if (repEdge2 == null || (rigidEdge = (LabeledEdge)tcn.getEdge(reducedNode, representative)) == null) continue;
                this.processPath(tcn, changeSet, new Path<LabeledTimePoint>(reducedNode, n), representative);
            }
        }
    }

    protected List<LabeledTimePoint> getObservationNodes(Collection<LabeledTimePoint> nodes) {
        ArrayList<LabeledTimePoint> observationNodes = new ArrayList<LabeledTimePoint>();
        for (LabeledTimePoint node : nodes) {
            if (!(node instanceof DefaultObservationTimePoint)) continue;
            observationNodes.add(node);
        }
        return observationNodes;
    }

    @Override
    protected boolean checkConsistency(LabeledValueSet value1, LabeledValueSet value2) {
        for (LabeledValue labeledValue1 : value1.getLabeledValues()) {
            for (LabeledValue labeledValue2 : value2.getLabeledValues()) {
                if (!this.satisfiable(labeledValue1.getLabel(), labeledValue2.getLabel()) || this.isConsistent(labeledValue1, labeledValue2)) continue;
                return false;
            }
        }
        return true;
    }

    protected abstract void solveComponent(ChangeableCSTN var1, ChangeSet<LabeledEdge, LabeledValueSet, Triangle<LabeledTimePoint>> var2) throws TCNInconsistencyException, InterruptedException;
}

