/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.timemodel.tcn.cstnImpl;

import de.aristaflow.adept2.model.common.timedata.TimeDistance;
import de.aristaflow.adept2.model.timemodel.tcn.CSTN;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledEdge;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledTimePoint;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledValue;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledValueSet;
import de.aristaflow.adept2.model.timemodel.tcn.STN;
import de.aristaflow.adept2.model.timemodel.tcn.TCN;
import de.aristaflow.adept2.model.timemodel.tcn.TCNEdge;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.DefaultConstraintValue;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.Projection;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.STNEdge;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.SimpleSTN;
import de.aristaflow.adept2.model.timemodel.tools.GraphVisitor;
import java.util.ArrayList;
import java.util.Collection;

public class CSTN2STNProjection
implements STN<LabeledTimePoint, STNEdge>,
Projection<LabeledTimePoint, LabeledEdge, STNEdge>,
Cloneable {
    protected CSTN cstn;

    public CSTN2STNProjection(CSTN cstn) {
        this.cstn = cstn;
    }

    @Override
    public STNEdge getEdge(LabeledTimePoint from, LabeledTimePoint to) {
        LabeledEdge labeledEdge = (LabeledEdge)this.cstn.getEdge(from, to);
        TimeDistance resultEdgeValue = null;
        if (labeledEdge != null) {
            Collection<LabeledValue> values = ((LabeledValueSet)labeledEdge.getValue()).getLabeledValues();
            for (LabeledValue vx : values) {
                TimeDistance timeDistance = resultEdgeValue = resultEdgeValue == null ? vx.getValue() : this.min(resultEdgeValue, vx.getValue());
            }
        }
        if (resultEdgeValue == null) {
            return null;
        }
        return new STNEdge(from, to, new DefaultConstraintValue(resultEdgeValue), labeledEdge != null ? labeledEdge.isControlEdge() : false, labeledEdge != null ? labeledEdge.isImplicit() : false, labeledEdge != null ? labeledEdge.getFlowDirection() : TCNEdge.FlowDirection.UNKOWN);
    }

    @Override
    public Collection<STNEdge> getIncomingEdges(LabeledTimePoint to) {
        Collection<LabeledTimePoint> timePoints = this.getTimePoints();
        ArrayList<STNEdge> edges = new ArrayList<STNEdge>(timePoints.size());
        for (LabeledTimePoint from : timePoints) {
            STNEdge edge = this.getEdge(from, to);
            if (edge == null) continue;
            edges.add(edge);
        }
        return edges;
    }

    @Override
    public Collection<STNEdge> getOutgoingEdges(LabeledTimePoint from) {
        Collection<LabeledTimePoint> timePoints = this.getTimePoints();
        ArrayList<STNEdge> edges = new ArrayList<STNEdge>(timePoints.size());
        for (LabeledTimePoint to : timePoints) {
            STNEdge edge = this.getEdge(from, to);
            if (edge == null) continue;
            edges.add(edge);
        }
        return edges;
    }

    public TimeDistance min(TimeDistance v1, TimeDistance v2) {
        if (v1.compareTo(v2) <= 0) {
            return v1;
        }
        return v2;
    }

    public int hashCode() {
        return this.cstn.hashCode();
    }

    @Override
    public LabeledTimePoint getTimeBaseEvent() {
        return (LabeledTimePoint)this.cstn.getTimeBaseEvent();
    }

    @Override
    public Collection<LabeledTimePoint> getTimePoints() {
        return this.cstn.getTimePoints();
    }

    @Override
    public boolean contains(LabeledTimePoint timePoint) {
        return this.cstn.contains(timePoint);
    }

    @Override
    public Collection<STNEdge> getEdges() {
        ArrayList<STNEdge> edges = new ArrayList<STNEdge>();
        for (LabeledTimePoint n1 : this.cstn.getTimePoints()) {
            for (LabeledTimePoint n2 : this.cstn.getTimePoints()) {
                STNEdge edge = this.getEdge(n1, n2);
                if (edge == null) continue;
                edges.add(edge);
            }
        }
        return edges;
    }

    public boolean equals(Object obj) {
        return this.cstn.equals(obj);
    }

    @Override
    public void visit(GraphVisitor<LabeledTimePoint, STNEdge> visitor) {
        visitor.discoverGraph(this);
        for (LabeledTimePoint e : this.getTimePoints()) {
            visitor.discoverVertex(e);
            visitor.finishVertex(e);
        }
        for (LabeledTimePoint ei : this.getTimePoints()) {
            for (LabeledTimePoint ej : this.getTimePoints()) {
                STNEdge e = this.getEdge(ei, ej);
                if (e == null) continue;
                visitor.discoverEdge(e.getSourceNode(), e.getTargetNode(), e);
                visitor.finishEdge(e.getSourceNode(), e.getTargetNode(), e);
            }
        }
        visitor.finishGraph(this);
    }

    public String toString() {
        return this.cstn.toString();
    }

    @Override
    public TCN<LabeledTimePoint, LabeledEdge> getBaseTCN() {
        return this.cstn;
    }

    @Override
    public STN<LabeledTimePoint, STNEdge> clone() {
        ArrayList<LabeledTimePoint> nodes = new ArrayList<LabeledTimePoint>(this.getTimePoints());
        ArrayList<STNEdge> edges = new ArrayList<STNEdge>();
        for (LabeledTimePoint n1 : nodes) {
            for (LabeledTimePoint n2 : nodes) {
                STNEdge edge = this.getEdge(n1, n2);
                if (edge == null) continue;
                edges.add(edge.clone());
            }
        }
        return new SimpleSTN((Collection<LabeledTimePoint>)nodes, (Collection<STNEdge>)edges);
    }

    @Override
    public boolean isConsistent() {
        return this.cstn.isConsistent();
    }

    @Override
    public Collection<LabeledTimePoint> getVertices() {
        return this.getTimePoints();
    }
}

