/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.timemodel.tcn.cstnImpl;

import de.aristaflow.adept2.model.common.timedata.TimeDistance;
import de.aristaflow.adept2.model.timemodel.tcn.Label;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledEdge;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledTimePoint;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledValue;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledValueSet;
import de.aristaflow.adept2.model.timemodel.tcn.TCN;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.AbstractConstraintDependencyGraph;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.DefaultLabeledValue;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.DefaultLabeledValueSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.logging.Level;

public class CSTNConstraintDependencyGraph
extends AbstractConstraintDependencyGraph<LabeledTimePoint, LabeledEdge, LabeledValueSet> {
    public CSTNConstraintDependencyGraph(TCN<LabeledTimePoint, LabeledEdge> tcn) {
        super(tcn);
    }

    @Override
    protected boolean equalBound(LabeledValueSet t, LabeledValueSet t2) {
        Collection<LabeledValue> lvs_ij = t.getLabeledValues();
        Collection<LabeledValue> lvs_jk = t2.getLabeledValues();
        for (LabeledValue cl_ij : lvs_ij) {
            for (LabeledValue cl_jk : lvs_jk) {
                if (!this.satisfiable(cl_ij.getLabel(), cl_jk.getLabel()) || !cl_ij.getValue().equals(cl_jk.getValue())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected LabeledValueSet add(LabeledValueSet sum1, LabeledValueSet sum2) {
        HashMap<Label, LabeledValue> labels = new HashMap<Label, LabeledValue>();
        Collection<LabeledValue> lvs_ij = sum1.getLabeledValues();
        Collection<LabeledValue> lvs_jk = sum2.getLabeledValues();
        for (LabeledValue cl_ij : lvs_ij) {
            for (LabeledValue cl_jk : lvs_jk) {
                if (!this.satisfiable(cl_ij.getLabel(), cl_jk.getLabel())) continue;
                LabeledValue labeledValue = this.add(cl_ij, cl_jk);
                DefaultLabeledValueSet.addOrReplaceIfNecessary(labels, labeledValue);
            }
        }
        DefaultLabeledValueSet nls_ik = null;
        if (labels.size() > 0) {
            nls_ik = new DefaultLabeledValueSet(labels.values());
        }
        this.debug(Level.FINER, "Sum LabeledValueSet\t (" + sum1 + ") + (" + sum2 + ") = (" + nls_ik + ")");
        return nls_ik;
    }

    @Override
    private LabeledValue add(LabeledValue sum1, LabeledValue sum2) {
        TimeDistance sum = sum1.getValue().add(sum2.getValue());
        Label label = sum1.getLabel().merge(sum2.getLabel());
        DefaultLabeledValue labeledValue = new DefaultLabeledValue(label, sum);
        return labeledValue;
    }

    public boolean satisfiable(Label b1, Label b2) {
        return b1.satisfiable(b2);
    }
}

