/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.timemodel.tcn.cstnImpl;

import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.model.common.timedata.CalendarElement;
import de.aristaflow.adept2.model.common.timedata.TimeDistance;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.timemodel.InstanceTimeModel;
import de.aristaflow.adept2.model.timemodel.Interval;
import de.aristaflow.adept2.model.timemodel.UpdateableInstanceTimeModel;
import de.aristaflow.adept2.model.timemodel.tcn.CSTN;
import de.aristaflow.adept2.model.timemodel.tcn.ChangeableCSTN;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledEdge;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledTimePoint;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledValue;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledValueSet;
import de.aristaflow.adept2.model.timemodel.tcn.NodeMapping;
import de.aristaflow.adept2.model.timemodel.tcn.TCNEdge;
import de.aristaflow.adept2.model.timemodel.tcn.TCNInstanceTimeModel;
import de.aristaflow.adept2.model.timemodel.tcn.cstnImpl.CSTN2STNProjection;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.DefaultLabeledEdge;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.DefaultLabeledValue;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.DefaultLabeledValueSet;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.STNEdge;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class CSTNInstanceTimeModel
extends TCNInstanceTimeModel<LabeledTimePoint, STNEdge>
implements InstanceTimeModel,
UpdateableInstanceTimeModel {
    private ChangeableCSTN cstn;

    public CSTNInstanceTimeModel(UUID instanceID, UUID templateID, ChangeableCSTN cstn, Collection<NodeMapping<LabeledTimePoint>> nodeMapping, LabeledTimePoint creationTimePoint, LabeledTimePoint startTimePoint, LabeledTimePoint endTimePoint, Map<Integer, List<URI>> updateTriggers) {
        super(instanceID, templateID, new CSTN2STNProjection(cstn), nodeMapping, creationTimePoint, startTimePoint, endTimePoint, updateTriggers);
        this.cstn = cstn;
    }

    @Override
    public void setInstanceCreationTime(long timestamp) {
        LabeledTimePoint node = (LabeledTimePoint)this.getProcessCreationTimePoint();
        this.setToTimeStamp(node, timestamp);
        this.handleTriggerEvent(node);
    }

    @Override
    public void setInstanceStartTime(long timestamp) {
        LabeledTimePoint processStart = (LabeledTimePoint)this.getProcessStartTimePoint();
        this.setToTimeStamp(processStart, timestamp);
        this.handleTriggerEvent(processStart);
    }

    private void setToTimeStamp(LabeledTimePoint event, long timestamp) {
        LabeledTimePoint timeBaseEvent = (LabeledTimePoint)this.getTimeBaseEvent();
        TimeDistance timeDistance = this.timeModelOperations.millisecondsToTimeDistance(timestamp);
        this.setToDistance(timeBaseEvent, event, timeDistance);
    }

    private void setToDistance(LabeledTimePoint from, LabeledTimePoint to, TimeDistance timeDistance) {
        DefaultLabeledEdge maxEdge = new DefaultLabeledEdge(from, to, new DefaultLabeledValueSet(new DefaultLabeledValue(from.getLabel(), timeDistance)), false, false, TCNEdge.FlowDirection.FORWARD);
        this.cstn.updateConstraint(maxEdge);
        DefaultLabeledEdge minEdge = new DefaultLabeledEdge(to, from, new DefaultLabeledValueSet(new DefaultLabeledValue(from.getLabel(), timeDistance.neg())), false, false, TCNEdge.FlowDirection.BACKWARD);
        this.cstn.updateConstraint(minEdge);
    }

    @Override
    public void setInstanceFinishTime(long timestamp) {
        LabeledTimePoint processEnd = (LabeledTimePoint)this.getProcessEndTimePoint();
        this.setToTimeStamp(processEnd, timestamp);
        this.handleTriggerEvent(processEnd);
    }

    @Override
    public void setNodeActivationTime(int nodeID, int iteration, long timestamp) {
    }

    @Override
    public void setActivityInstanceStartTime(int nodeID, int iteration, long timestamp) {
        NodeMapping nodeMapping = this.getNodeMapping(nodeID, this.iterationChain);
        LabeledTimePoint node = (LabeledTimePoint)nodeMapping.getStartNode();
        this.setToTimeStamp(node, timestamp);
        this.handleTriggerEvent(node);
    }

    @Override
    public void setActivityInstanceFinishTime(int nodeID, int iteration, long timestamp) {
        NodeMapping nodeMapping = this.getNodeMapping(nodeID, this.iterationChain);
        LabeledTimePoint node = (LabeledTimePoint)nodeMapping.getEndNode();
        this.setToTimeStamp(node, timestamp);
        Interval<CalendarElement> timePoint = this.getTimePoint((LabeledTimePoint)nodeMapping.getStartNode());
        long startTime = this.toTimeStamp(timePoint.getMinValue());
        long duration = timestamp - startTime;
        this.setToDistance((LabeledTimePoint)nodeMapping.getStartNode(), (LabeledTimePoint)nodeMapping.getEndNode(), this.timeModelOperations.millisecondsToTimeDistance(duration));
        LabeledTimePoint[] labeledTimePointArray = (LabeledTimePoint[])nodeMapping.getIntermediateEvents();
        int n = labeledTimePointArray.length;
        int n2 = 0;
        while (n2 < n) {
            LabeledTimePoint n3 = labeledTimePointArray[n2];
            this.handleTriggerEvent(n3);
            ++n2;
        }
        this.handleTriggerEvent(node);
        this.setToTimeStamp(node, timestamp);
    }

    private long toTimeStamp(CalendarElement value) {
        return value.getTimeInMillis();
    }

    private void handleTriggerEvent(LabeledTimePoint node) {
        Collection edges = this.cstn.getEdges();
        for (LabeledEdge edge : edges) {
            boolean needsUpdate = false;
            ArrayList<LabeledValue> newValues = new ArrayList<LabeledValue>();
            for (LabeledValue labeledValue : ((LabeledValueSet)edge.getValue()).getLabeledValues()) {
                newValues.add(labeledValue);
            }
            if (!needsUpdate) continue;
            DefaultLabeledEdge newEdge = new DefaultLabeledEdge((LabeledTimePoint)edge.getSourceNode(), (LabeledTimePoint)edge.getTargetNode(), new DefaultLabeledValueSet(newValues), edge.isControlEdge(), false, edge.getFlowDirection());
            this.cstn.updateConstraint(newEdge);
        }
    }

    @Override
    public void setActivityInstanceProgress(int nodeID, int iteration, float progress) {
    }

    @Override
    public void createNewIteration(List<Node> nodesInLoop, int iteration) {
    }

    public CSTN getBaseTimeModel() {
        return this.cstn;
    }

    @Override
    protected TimeDistance getValue(STNEdge edge) {
        if (edge != null) {
            return edge.getValue().getValue();
        }
        return null;
    }

    @Override
    public void setEarliestStartDate(SessionToken session, int nodeID, int iteration, CalendarElement date) {
        NodeMapping nodeMapping = this.getNodeMapping(nodeID, this.iterationChain);
        LabeledTimePoint node = (LabeledTimePoint)nodeMapping.getStartNode();
        this.setEarliestDate(node, date);
    }

    private void setEarliestDate(LabeledTimePoint node, CalendarElement date) {
        LabeledTimePoint timeBaseEvent = (LabeledTimePoint)this.getTimeBaseEvent();
        TimeDistance timeDistance = this.timeModelOperations.millisecondsToTimeDistance(date.getTimeInMillis());
        DefaultLabeledValue minValue = new DefaultLabeledValue(timeBaseEvent.getLabel(), timeDistance.neg());
        DefaultLabeledEdge minEdge = new DefaultLabeledEdge(node, timeBaseEvent, new DefaultLabeledValueSet(minValue), false, false, TCNEdge.FlowDirection.BACKWARD);
        this.cstn.updateConstraint(minEdge);
    }

    @Override
    public void setEarliestCompletionDate(SessionToken session, int nodeID, int iteration, CalendarElement date) {
        NodeMapping nodeMapping = this.getNodeMapping(nodeID, this.iterationChain);
        LabeledTimePoint node = (LabeledTimePoint)nodeMapping.getEndNode();
        this.setEarliestDate(node, date);
    }

    @Override
    public void setLatestStartDate(SessionToken session, int nodeID, int iteration, CalendarElement date) {
        NodeMapping nodeMapping = this.getNodeMapping(nodeID, this.iterationChain);
        LabeledTimePoint node = (LabeledTimePoint)nodeMapping.getStartNode();
        this.setLatestDate(node, date);
    }

    private void setLatestDate(LabeledTimePoint node, CalendarElement date) {
        long timestamp = date.getTimeInMillis();
        LabeledTimePoint timeBaseEvent = (LabeledTimePoint)this.getTimeBaseEvent();
        TimeDistance timeDistance = this.timeModelOperations.millisecondsToTimeDistance(timestamp);
        DefaultLabeledValue maxValue = new DefaultLabeledValue(timeBaseEvent.getLabel(), timeDistance);
        DefaultLabeledEdge maxEdge = new DefaultLabeledEdge(timeBaseEvent, node, new DefaultLabeledValueSet(maxValue), false, false, TCNEdge.FlowDirection.FORWARD);
        this.cstn.updateConstraint(maxEdge);
    }

    @Override
    public void setLatestCompletionDate(SessionToken session, int nodeID, int iteration, CalendarElement date) {
        NodeMapping nodeMapping = this.getNodeMapping(nodeID, this.iterationChain);
        LabeledTimePoint node = (LabeledTimePoint)nodeMapping.getEndNode();
        this.setLatestDate(node, date);
    }
}

