/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.timemodel.tcn.cstnImpl;

import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.TemporalTemplate;
import de.aristaflow.adept2.model.timemodel.tcn.CSTN;
import de.aristaflow.adept2.model.timemodel.tcn.ChangeableCSTN;
import de.aristaflow.adept2.model.timemodel.tcn.IterationChain;
import de.aristaflow.adept2.model.timemodel.tcn.JoinNodeMapping;
import de.aristaflow.adept2.model.timemodel.tcn.Label;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledEdge;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledTimePoint;
import de.aristaflow.adept2.model.timemodel.tcn.NodeInstance;
import de.aristaflow.adept2.model.timemodel.tcn.NodeMapping;
import de.aristaflow.adept2.model.timemodel.tcn.TCNEdge;
import de.aristaflow.adept2.model.timemodel.tcn.TCNTimePoint;
import de.aristaflow.adept2.model.timemodel.tcn.TCNTransformation;
import de.aristaflow.adept2.model.timemodel.tcn.cstnImpl.DefaultCSTN;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.AbstractLabeledTemplateTransformation;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.DefaultLabeledEdge;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.DefaultLabeledValue;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.DefaultLabeledValueSet;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.DefaultObservationTimePoint;
import java.util.Collection;
import java.util.HashSet;
import org.apache.commons.configuration.Configuration;

public class CSTNTemplateTransformation
extends AbstractLabeledTemplateTransformation {
    public CSTNTemplateTransformation(Configuration configuration, TemporalTemplate template, int lookAhead) {
        super(configuration, template, lookAhead);
    }

    public CSTNTemplateTransformation(Configuration configuration, TemporalTemplate template) {
        super(configuration, template);
    }

    public CSTNTemplateTransformation(TemporalTemplate template, int lookAhead) {
        this(null, template, lookAhead);
    }

    public CSTNTemplateTransformation(TemporalTemplate template) {
        this(null, template);
    }

    protected ChangeableCSTN createTCN(Collection<LabeledTimePoint> nodes, Collection<LabeledEdge> edges, Collection<NodeMapping<LabeledTimePoint>> nodeMapping) {
        HashSet<Label.ChoiceVariable> observations = new HashSet<Label.ChoiceVariable>();
        for (LabeledTimePoint node : nodes) {
            if (!(node instanceof DefaultObservationTimePoint)) continue;
            observations.add(((DefaultObservationTimePoint)node).getObservation());
        }
        DefaultCSTN timeModel = new DefaultCSTN(nodes, edges, observations);
        return timeModel;
    }

    public CSTN transform() {
        return (CSTN)super.transform();
    }

    @Override
    protected NodeMapping<LabeledTimePoint> transformActivity(int nodeID, IterationChain iterationChain, Label branches) {
        if (this.template.getNodeType(nodeID) != ProcessConstants.NodeType.NT_NORMAL) {
            throw new IllegalArgumentException("" + this.template.getNodeType(nodeID));
        }
        int topologicalID = this.template.getNodeTopologicalID(nodeID);
        NodeInstance nodeInstance = new NodeInstance(nodeID, iterationChain, topologicalID);
        LabeledTimePoint A_S = this.createTCNNode(nodeInstance, "S", branches);
        LabeledTimePoint A_E = this.createTCNNode(nodeInstance, "E", branches);
        this.addNode(A_S);
        this.addNode(A_E);
        TCNTransformation.TCNActivityDuration duration = this.getActivityDuration(nodeID);
        LabeledEdge minEdge = new DefaultLabeledEdge(A_E, A_S, new DefaultLabeledValueSet(new DefaultLabeledValue(branches, duration.minDuration.neg())), true, false, TCNEdge.FlowDirection.BACKWARD);
        minEdge = this.addEdge(minEdge);
        LabeledEdge maxEdge = new DefaultLabeledEdge(A_S, A_E, new DefaultLabeledValueSet(new DefaultLabeledValue(branches, duration.maxDuration)), true, false, TCNEdge.FlowDirection.FORWARD);
        maxEdge = this.addEdge(maxEdge);
        NodeMapping node = new NodeMapping(this.getNodeName(nodeID), nodeInstance, (TCNTimePoint)A_S, null, (TCNTimePoint)A_E);
        this.processActivityValidityPeriod(nodeID, node);
        return this.addNodeMapping(node);
    }

    @Override
    protected JoinNodeMapping<LabeledTimePoint> transformANDJoin(int nodeID, IterationChain iterationChain, Label branches) {
        if (this.template.getNodeType(nodeID) != ProcessConstants.NodeType.NT_AND_JOIN) {
            throw new IllegalArgumentException("" + this.template.getNodeType(nodeID));
        }
        int topologicalID = this.template.getNodeTopologicalID(nodeID);
        NodeInstance nodeInstance = new NodeInstance(nodeID, iterationChain, topologicalID);
        LabeledTimePoint A_S = this.createTCNNode(nodeInstance, "S", branches);
        LabeledTimePoint A_E = this.createTCNNode(nodeInstance, "E", branches);
        this.addNode(A_S);
        this.addNode(A_E);
        this.createTCNEdge(A_S, A_E, branches, this.STRUCTURE_NODE_MIN_DURATION, this.STRUCTURE_NODE_MAX_DURATION, true);
        return this.addNodeMapping(new JoinNodeMapping(this.getNodeName(nodeID), nodeInstance, null, (TCNTimePoint)A_S, null, (TCNTimePoint)A_E));
    }
}

