/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.timemodel.tcn.cstnImpl;

import de.aristaflow.adept2.model.processmodel.Instance;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.TemporalTemplate;
import de.aristaflow.adept2.model.processmodel.defaultimplementation.DefaultTemporalTemplate;
import de.aristaflow.adept2.model.timemodel.InstanceTimeContext;
import de.aristaflow.adept2.model.timemodel.InstanceTimeModel;
import de.aristaflow.adept2.model.timemodel.TemplateTimeModel;
import de.aristaflow.adept2.model.timemodel.TimeModel;
import de.aristaflow.adept2.model.timemodel.TimeModelFactory;
import de.aristaflow.adept2.model.timemodel.TimeModelOperations;
import de.aristaflow.adept2.model.timemodel.TimeModelSolver;
import de.aristaflow.adept2.model.timemodel.defaultimplementation.DefaultTimeModelOperations;
import de.aristaflow.adept2.model.timemodel.defaultimplementation.TimeModelTools;
import de.aristaflow.adept2.model.timemodel.tcn.CSTN;
import de.aristaflow.adept2.model.timemodel.tcn.ChangeableCSTN;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledTimePoint;
import de.aristaflow.adept2.model.timemodel.tcn.cstnImpl.CSTNInstanceTimeModel;
import de.aristaflow.adept2.model.timemodel.tcn.cstnImpl.CSTNTemplateTimeModel;
import de.aristaflow.adept2.model.timemodel.tcn.cstnImpl.CSTNTemplateTransformation;
import de.aristaflow.adept2.model.timemodel.tcn.cstnImpl.DCCSTNTemplateTimeModelSolver;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.configuration.Configuration;

public class CSTNTimeModelFactory
implements TimeModelFactory {
    private final Configuration configuration;

    public CSTNTimeModelFactory() {
        this.configuration = null;
    }

    public CSTNTimeModelFactory(Configuration configuration) {
        this.configuration = configuration;
    }

    @Override
    public TemplateTimeModel createTimeModelForTemplate(TemporalTemplate template) {
        CSTNTemplateTransformation trafo = new CSTNTemplateTransformation(this.configuration, template);
        CSTN cstn = trafo.transform();
        Map<Integer, List<URI>> updateTriggers = TimeModelTools.createUpdateTriggerMapping(template);
        return new CSTNTemplateTimeModel((Template)template, cstn, trafo.getNodeMapping(), (LabeledTimePoint)trafo.getProcessCreationTimePoint(), (LabeledTimePoint)trafo.getProcessStartTimePoint(), (LabeledTimePoint)trafo.getProcessEndTimePoint(), updateTriggers);
    }

    @Override
    public InstanceTimeModel createTimeModelForInstance(Instance instance, InstanceTimeContext timeContext, TemplateTimeModel templateTimeModel) {
        UUID instanceID;
        CSTNTemplateTimeModel timeModel = (CSTNTemplateTimeModel)templateTimeModel;
        UUID uUID = instanceID = instance != null ? instance.getID() : null;
        assert (instance == null || instance.getTemplate().getID() == templateTimeModel.getTemplateID());
        return new CSTNInstanceTimeModel(instanceID, templateTimeModel.getTemplateID(), (ChangeableCSTN)timeModel.getBaseTimeModel(), timeModel.getNodeMapping(), (LabeledTimePoint)timeModel.getProcessCreationTimePoint(), (LabeledTimePoint)timeModel.getProcessStartTimePoint(), (LabeledTimePoint)timeModel.getProcessEndTimePoint(), timeModel.getUpdateTriggers());
    }

    @Override
    public TimeModelOperations getTimeModelOperations() {
        return new DefaultTimeModelOperations();
    }

    @Override
    public void setCreateChangeable(boolean changeable) {
    }

    @Override
    public TemporalTemplate createTemporalTemplate(Template template) {
        return new DefaultTemporalTemplate(template);
    }

    @Override
    public TimeModelSolver getTimeModelSolver(Class<? extends TimeModel> clazz) {
        return new DCCSTNTemplateTimeModelSolver();
    }
}

