/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.timemodel.tcn.cstnImpl;

import de.aristaflow.adept2.model.common.timedata.TimeDistance;
import de.aristaflow.adept2.model.common.timedata.defaultimplementation.DefaultTimeDistance;
import de.aristaflow.adept2.model.timemodel.tcn.CSTN;
import de.aristaflow.adept2.model.timemodel.tcn.ChangeableCSTN;
import de.aristaflow.adept2.model.timemodel.tcn.Label;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledEdge;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledTimePoint;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledValue;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledValueSet;
import de.aristaflow.adept2.model.timemodel.tcn.ObservationTimePoint;
import de.aristaflow.adept2.model.timemodel.tcn.TCNEdge;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.AbstractTCN;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.ContingentLabeledValue;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.DefaultLabeledEdge;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.DefaultLabeledValue;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.DefaultLabeledValueSet;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.DefaultObservationTimePoint;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.ObservationBinding;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.Proposition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DefaultCSTN
extends AbstractTCN<LabeledTimePoint, LabeledValueSet, LabeledEdge>
implements CSTN,
ChangeableCSTN {
    public static boolean ENFORCE_WD2 = true;
    private final List<Label.ChoiceVariable> observations;

    public DefaultCSTN(Collection<LabeledTimePoint> nodes, Collection<LabeledEdge> edges, Collection<Label.ChoiceVariable> labels) {
        super(nodes, edges);
        this.observations = new ArrayList<Label.ChoiceVariable>(labels);
    }

    @Override
    public void init() {
        Collection nodes = this.getTimePoints();
        for (LabeledTimePoint node : nodes) {
            Label lbl = node.getLabel();
            Proposition proposition = (Proposition)lbl;
            for (ObservationBinding observation : proposition.getObservations()) {
                DefaultObservationTimePoint observationNode = observation.getVariable().getDecisionTimePoint();
                LabeledEdge edge = (LabeledEdge)this.getEdge(node, observationNode);
                if (!ENFORCE_WD2 || edge != null) continue;
                this.updateConstraint(new DefaultLabeledEdge(node, observation.getVariable().getDecisionTimePoint(), new DefaultLabeledValueSet(new DefaultLabeledValue(node.getLabel(), DefaultTimeDistance.EPSILON_TIME_DISTANCE.neg())), false, true, TCNEdge.FlowDirection.BACKWARD));
            }
        }
    }

    @Override
    public LabeledEdge updateConstraint(LabeledEdge edge) {
        if (edge.isContingent()) {
            throw new IllegalArgumentException("Contingent Constraints are not supported");
        }
        assert (((LabeledValueSet)edge.getValue()).subsumes(((LabeledTimePoint)edge.getSourceNode()).getLabel()));
        assert (((LabeledValueSet)edge.getValue()).subsumes(((LabeledTimePoint)edge.getTargetNode()).getLabel()));
        return super.updateConstraint(edge);
    }

    @Override
    public LabeledTimePoint getTimeBaseEvent() {
        return TIMEBASE_NODE;
    }

    @Override
    public List<Label.ChoiceVariable> getObservations() {
        return this.observations;
    }

    @Override
    protected boolean doCheckConsistency(LabeledEdge edge1, LabeledEdge edge2) {
        LabeledValueSet value1 = (LabeledValueSet)edge1.getValue();
        LabeledValueSet value2 = (LabeledValueSet)edge2.getValue();
        Collection<LabeledValue> lvs1 = value1.getLabeledValues();
        Collection<LabeledValue> lvs2 = value2.getLabeledValues();
        for (LabeledValue lv1 : lvs1) {
            TimeDistance v1 = lv1.getValue();
            if (lv1 instanceof ContingentLabeledValue) {
                throw new IllegalStateException("Contingent Values are not supported by CSTN!");
            }
            Label label1 = lv1.getLabel();
            for (LabeledValue lv2 : lvs2) {
                TimeDistance v2 = lv2.getValue();
                if (lv2 instanceof ContingentLabeledValue) {
                    throw new IllegalStateException("Contingent Values are not supported by CSTN!");
                }
                Label label2 = lv2.getLabel();
                if (!label1.satisfiable(label2) || v1.compareTo(v2.neg()) >= 0) continue;
                throw new IllegalStateException(String.format("Value [%s, %s] is inconsistent!", v2.neg(), v1));
            }
            if (!label1.satisfiable(label1)) {
                throw new IllegalStateException(String.format("Label %s is illegal!", label1));
            }
            if (!label1.subsumes(((LabeledTimePoint)edge1.getSourceNode()).getLabel())) {
                throw new IllegalStateException(String.format("Label %s does not subsume source node %s!", label1, edge1.getSourceNode()));
            }
            if (label1.subsumes(((LabeledTimePoint)edge1.getTargetNode()).getLabel())) continue;
            throw new IllegalStateException(String.format("Label %s does not subsume target node %s!", label1, edge1.getTargetNode()));
        }
        return true;
    }

    @Override
    protected boolean doCheckConsistency(LabeledTimePoint node) {
        Label label = node.getLabel();
        Proposition proposition = (Proposition)label;
        for (ObservationBinding observation : proposition.getObservations()) {
            DefaultObservationTimePoint observationNode = observation.getVariable().getDecisionTimePoint();
            if (!label.subsumes(observationNode.getLabel())) {
                throw new IllegalStateException();
            }
            if (!ENFORCE_WD2) continue;
            LabeledEdge edge = (LabeledEdge)this.getEdge(node, observationNode);
            if (edge == null) {
                throw new IllegalStateException();
            }
            for (LabeledValue value : ((LabeledValueSet)edge.getValue()).getLabeledValues()) {
                if (value.getValue().compareTo(DefaultTimeDistance.ZERO_TIME_DISTANCE) < 0) continue;
                throw new IllegalStateException(String.format("Violation of WD2: %s must happen at least > 0 after %s", edge.getSourceNode(), edge.getTargetNode()));
            }
        }
        return true;
    }

    @Override
    public CSTN clone() {
        return new DefaultCSTN(this.getTimePoints(), this.getEdges(), this.getObservations());
    }

    @Override
    public LabeledTimePoint insertTimePoint(LabeledTimePoint node) {
        LabeledTimePoint timePoint = super.insertTimePoint(node);
        if (timePoint instanceof ObservationTimePoint) {
            this.observations.add(((ObservationTimePoint)timePoint).getChoiceVariable());
        }
        return timePoint;
    }

    @Override
    public void removeTimePoint(LabeledTimePoint node) throws IllegalStateException {
        if (node instanceof ObservationTimePoint) {
            this.observations.remove(((ObservationTimePoint)node).getChoiceVariable());
        }
        super.removeTimePoint(node);
    }
}

