/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.timemodel.tcn.cstnImpl;

import de.aristaflow.adept2.model.common.timedata.TimeDistance;
import de.aristaflow.adept2.model.timemodel.ChangeSet;
import de.aristaflow.adept2.model.timemodel.defaultimplementation.Path;
import de.aristaflow.adept2.model.timemodel.defaultimplementation.Triangle;
import de.aristaflow.adept2.model.timemodel.tcn.CSTN;
import de.aristaflow.adept2.model.timemodel.tcn.ChangeableCSTN;
import de.aristaflow.adept2.model.timemodel.tcn.ChangeableTCN;
import de.aristaflow.adept2.model.timemodel.tcn.Label;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledEdge;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledTimePoint;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledValue;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledValueSet;
import de.aristaflow.adept2.model.timemodel.tcn.TCNEdge;
import de.aristaflow.adept2.model.timemodel.tcn.TCNInconsistencyException;
import de.aristaflow.adept2.model.timemodel.tcn.cstnImpl.AbstractCSTNSolver;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.DefaultLabeledValue;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.DefaultLabeledValueSet;
import de.aristaflow.adept2.model.timemodel.tools.DuplicateFreeQueue;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

public class LabelBasedPC2Solver
extends AbstractCSTNSolver {
    public LabelBasedPC2Solver() {
        super(Level.ALL);
    }

    public LabelBasedPC2Solver(Level debugLevel) {
        super(debugLevel);
    }

    @Override
    public <T extends ChangeableTCN<LabeledTimePoint, LabeledEdge>> T solve(T tcn) throws TCNInconsistencyException, InterruptedException {
        return this.solve(tcn, (ChangeSet<LabeledEdge, LabeledValueSet, Triangle<LabeledTimePoint>>)null);
    }

    @Override
    public <T extends ChangeableTCN<LabeledTimePoint, LabeledEdge>> T solve(T tcn, ChangeSet<LabeledEdge, LabeledValueSet, Triangle<LabeledTimePoint>> changeSet) throws TCNInconsistencyException, InterruptedException {
        if (tcn instanceof ChangeableCSTN) {
            return (T)((ChangeableTCN)((Object)this.solve((ChangeableCSTN)tcn, changeSet)));
        }
        throw new IllegalArgumentException("" + tcn.getClass());
    }

    @Override
    public CSTN solve(ChangeableCSTN model, ChangeSet<LabeledEdge, LabeledValueSet, Triangle<LabeledTimePoint>> changeSet) throws TCNInconsistencyException, InterruptedException {
        this.logger.fine("Starting PC2");
        this.logger.fine("Initializing Paths");
        this.solveComponent(model, changeSet);
        model.setConsistent();
        return model;
    }

    @Override
    protected void solveComponent(ChangeableCSTN model, ChangeSet<LabeledEdge, LabeledValueSet, Triangle<LabeledTimePoint>> changeSet) throws TCNInconsistencyException, InterruptedException {
        Collection nodes = model.getTimePoints();
        Collection changed = null;
        int nodeCount = nodes.size();
        DuplicateFreeQueue queue = new DuplicateFreeQueue(nodeCount * nodeCount * 2);
        if (changed == null) {
            this.getInitialPaths(nodes, queue);
        } else {
            for (LabeledEdge e : changed) {
                queue.add(new Path<LabeledTimePoint>((LabeledTimePoint)e.getSourceNode(), (LabeledTimePoint)e.getTargetNode()));
            }
        }
        while (!queue.isEmpty()) {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
            Path triangle = (Path)((Object)queue.remove());
            LabeledTimePoint i = (LabeledTimePoint)triangle.getFirst();
            LabeledTimePoint j = (LabeledTimePoint)triangle.getSecond();
            for (LabeledTimePoint k : nodes) {
                if (i.equals(k) || j.equals(k)) continue;
                if (this.processPath(model, changeSet, new Path<LabeledTimePoint>(i, k), j)) {
                    queue.add(new Path<LabeledTimePoint>(i, k));
                }
                if (!this.processPath(model, changeSet, new Path<LabeledTimePoint>(k, j), i)) continue;
                queue.add(new Path<LabeledTimePoint>(k, j));
            }
        }
    }

    @Override
    protected boolean processPath(ChangeableCSTN model, ChangeSet<LabeledEdge, LabeledValueSet, Triangle<LabeledTimePoint>> changeSet, Path<LabeledTimePoint> p, LabeledTimePoint via) throws TCNInconsistencyException {
        LabeledTimePoint from = p.getFrom();
        LabeledTimePoint to = p.getTo();
        LabeledEdge e_ij = (LabeledEdge)model.getEdge(from, via);
        LabeledEdge e_jk = (LabeledEdge)model.getEdge(via, to);
        LabeledEdge e_ik = (LabeledEdge)model.getEdge(from, to);
        assert (this.debug(Level.FINE, "Evaluating (%s, %s) = (%s) \\cap (%s) + (%s)", from, to, e_ik, e_ij, e_jk));
        Map<Label, LabeledValue> newValues = this.applyEdgeGenerationRules(model, from, via, to);
        if (newValues != null) {
            this.applySimplificationRules(newValues);
            LabeledValueSet ls_ik = null;
            if (e_ik != null) {
                ls_ik = (LabeledValueSet)e_ik.getValue();
            }
            newValues = this.intersect(ls_ik, newValues);
            this.applyPropositionModificationRules(model, from, via, to, newValues);
            assert (this.debug(Level.FINE, "   Label Removal Rules resulted in %s", newValues.values()));
            this.applySimplificationRules(newValues);
            DefaultLabeledValueSet newValueSet = new DefaultLabeledValueSet(newValues.values());
            if (!((Object)newValueSet).equals(ls_ik)) {
                LabeledEdge labeledEdge = this.createEdge(from, to, newValueSet, e_ik != null && e_ik.isControlEdge(), e_ik == null || e_ik.isImplicit(), e_ik != null ? e_ik.getFlowDirection() : TCNEdge.FlowDirection.UNKOWN);
                assert (this.debug(Level.FINE, "Updating (%s) to (%s)", e_ik, labeledEdge));
                this.logChange(changeSet, p, via, labeledEdge, e_ik != null ? (LabeledValueSet)e_ik.getValue() : null);
                this.checkConsistency(model, labeledEdge, new Triangle<LabeledTimePoint>(p, via));
                try {
                    model.updateConstraint(labeledEdge);
                }
                catch (IllegalArgumentException e) {
                    this.debug(Level.SEVERE, "Trying to update contingent constraint %s -> %s: %s -> %s", from, to, e_ik, newValueSet);
                    throw new TCNInconsistencyException("Trying to update contingent constraint!", p, via, model, e);
                }
                this.debug(Level.FINER, "Adding related Paths for %s -> %s", from, to);
                return true;
            }
            this.debug(Level.FINE, " Ignoring\t %s to %s (because no changes)", e_ik, newValueSet);
        }
        return false;
    }

    protected Map<Label, LabeledValue> applyEdgeGenerationRules(ChangeableCSTN model, LabeledTimePoint i, LabeledTimePoint j, LabeledTimePoint k) {
        LabeledEdge e_ij = (LabeledEdge)model.getEdge(i, j);
        if (e_ij == null) {
            return null;
        }
        LabeledEdge e_jk = (LabeledEdge)model.getEdge(j, k);
        LabeledEdge e_ji = (LabeledEdge)model.getEdge(j, i);
        HashMap<Label, LabeledValue> labels = new HashMap<Label, LabeledValue>();
        if (e_jk != null) {
            for (LabeledValue cl_ij : ((LabeledValueSet)e_ij.getValue()).getLabeledValues()) {
                for (LabeledValue cl_jk : ((LabeledValueSet)e_jk.getValue()).getLabeledValues()) {
                    if (!this.satisfiable(cl_ij.getLabel(), cl_jk.getLabel())) continue;
                    LabeledValue labeledValue = this.add(cl_ij, cl_jk);
                    this.addOrReplaceIfNecessary(i, k, labels, labeledValue);
                }
            }
        }
        if (e_ji != null) {
            for (LabeledValue l_ij : ((LabeledValueSet)e_ij.getValue()).getLabeledValues()) {
                for (LabeledValue l_ji : ((LabeledValueSet)e_ji.getValue()).getLabeledValues()) {
                    LabeledValue observationCase = this.observationCaseReduction(l_ji, l_ij, k);
                    if (observationCase == null) continue;
                    this.addOrReplaceIfNecessary(i, k, labels, observationCase);
                }
            }
        }
        HashMap<Label, LabeledValue> sum = null;
        if (labels.size() > 0) {
            sum = labels;
        }
        return sum;
    }

    protected LabeledValue add(LabeledValue sum1, LabeledValue sum2) {
        TimeDistance sum = sum1.getValue().add(sum2.getValue());
        Label label = this.mergeLabels(sum1.getLabel(), sum2.getLabel());
        DefaultLabeledValue labeledValue = new DefaultLabeledValue(label, sum);
        assert (this.debug(Level.FINEST, "\tAdding LabeledValue\t (%s) + (%s) = (%s)", sum1, sum2, labeledValue));
        return labeledValue;
    }
}

