/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.timemodel.tcn.cstnuImpl;

import de.aristaflow.adept2.model.timemodel.tcn.ChangeableCSTN;
import de.aristaflow.adept2.model.timemodel.tcn.ChangeableCSTNU;
import de.aristaflow.adept2.model.timemodel.tcn.Label;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledEdge;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledTimePoint;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledValue;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledValueSet;
import de.aristaflow.adept2.model.timemodel.tcn.STN;
import de.aristaflow.adept2.model.timemodel.tcn.cstnImpl.AbstractCSTNProjection;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.ContingentLabeledValue;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.DefaultLabeledEdge;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.DefaultLabeledValue;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.DefaultLabeledValueSet;
import java.util.ArrayList;
import java.util.List;

public class CSTNU2CSTNProjection
extends AbstractCSTNProjection
implements STN<LabeledTimePoint, LabeledEdge>,
Cloneable,
ChangeableCSTN {
    protected final boolean contingentValues;

    public CSTNU2CSTNProjection(ChangeableCSTNU cstnu, boolean propagate, boolean useContingentValues) {
        super(cstnu, propagate);
        this.contingentValues = useContingentValues;
    }

    @Override
    protected LabeledEdge transformEdge(LabeledTimePoint from, LabeledTimePoint to, LabeledEdge edge) {
        if (edge.isContingent()) {
            edge = this.convertToNormalEdge(edge);
            return edge;
        }
        return edge;
    }

    private LabeledEdge convertToNormalEdge(LabeledEdge edge) {
        ArrayList<LabeledValue> values = new ArrayList<LabeledValue>();
        for (LabeledValue l : ((LabeledValueSet)edge.getValue()).getLabeledValues()) {
            if (l instanceof ContingentLabeledValue) {
                ContingentLabeledValue cl = (ContingentLabeledValue)l;
                DefaultLabeledValue label = this.contingentValues ? (cl.getTrigger() == edge.getTargetNode() || cl.getTrigger() == edge.getSourceNode() ? new DefaultLabeledValue(l.getLabel(), cl.getValue()) : new DefaultLabeledValue(l.getLabel(), cl.getContingentValue())) : new DefaultLabeledValue(l.getLabel(), cl.getValue());
                values.add(label);
                continue;
            }
            values.add(l);
        }
        DefaultLabeledEdge labeledEdge = new DefaultLabeledEdge((LabeledTimePoint)edge.getSourceNode(), (LabeledTimePoint)edge.getTargetNode(), new DefaultLabeledValueSet(values), edge.isControlEdge(), edge.isImplicit(), edge.getFlowDirection());
        return labeledEdge;
    }

    @Override
    public List<Label.ChoiceVariable> getObservations() {
        return this.getBaseTCN().getObservations();
    }

    @Override
    public LabeledTimePoint insertTimePoint(LabeledTimePoint timePoint) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeTimePoint(LabeledTimePoint timePoint) {
        throw new UnsupportedOperationException();
    }
}

