/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.timemodel.tcn.cstnuImpl;

import de.aristaflow.adept2.model.common.timedata.TimeDistance;
import de.aristaflow.adept2.model.timemodel.tcn.CSTNU;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledEdge;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledTimePoint;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledValue;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledValueSet;
import de.aristaflow.adept2.model.timemodel.tcn.STN;
import de.aristaflow.adept2.model.timemodel.tcn.TCN;
import de.aristaflow.adept2.model.timemodel.tcn.TCNEdge;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.ContingentLabeledValue;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.DefaultConstraintValue;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.Projection;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.STNEdge;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.SimpleSTN;
import de.aristaflow.adept2.model.timemodel.tools.GraphVisitor;
import java.util.ArrayList;
import java.util.Collection;

public class CSTNU2STNProjection
implements STN<LabeledTimePoint, STNEdge>,
Projection<LabeledTimePoint, LabeledEdge, STNEdge>,
Cloneable {
    protected CSTNU cstnu;

    public CSTNU2STNProjection(CSTNU cstnu) {
        this.cstnu = cstnu;
    }

    @Override
    public STNEdge getEdge(LabeledTimePoint from, LabeledTimePoint to) {
        LabeledEdge labeledEdge = (LabeledEdge)this.cstnu.getEdge(from, to);
        TimeDistance resultEdgeValue = null;
        if (labeledEdge != null) {
            Collection<LabeledValue> values = ((LabeledValueSet)labeledEdge.getValue()).getLabeledValues();
            for (LabeledValue vx : values) {
                if (vx instanceof ContingentLabeledValue) {
                    ContingentLabeledValue v = (ContingentLabeledValue)vx;
                    if (v.getTrigger() == to || v.getTrigger() == from) {
                        LabeledEdge opDir = (LabeledEdge)this.cstnu.getEdge(to, from);
                        if (opDir == null) continue;
                        Collection<LabeledValue> opValues = ((LabeledValueSet)opDir.getValue()).getLabeledValues();
                        for (LabeledValue ovx : opValues) {
                            ContingentLabeledValue ov;
                            if (!(ovx instanceof ContingentLabeledValue) || (ov = (ContingentLabeledValue)ovx).getTrigger() != v.getTrigger()) continue;
                            TimeDistance timeDistance = resultEdgeValue = resultEdgeValue == null ? ov.getContingentValue().neg() : this.min(resultEdgeValue, ov.getContingentValue().neg());
                        }
                        continue;
                    }
                    STNEdge triggerEdge = this.getEdge(from, v.getTrigger());
                    TimeDistance min = triggerEdge == null ? v.getContingentValue() : this.min(v.getContingentValue(), triggerEdge.getValue().getValue());
                    resultEdgeValue = resultEdgeValue == null ? min : this.min(resultEdgeValue, min);
                    continue;
                }
                TimeDistance timeDistance = resultEdgeValue = resultEdgeValue == null ? vx.getValue() : this.min(resultEdgeValue, vx.getValue());
            }
        } else {
            LabeledEdge opDir = (LabeledEdge)this.cstnu.getEdge(to, from);
            if (opDir != null) {
                Collection<LabeledValue> opValues = ((LabeledValueSet)opDir.getValue()).getLabeledValues();
                for (LabeledValue ovx : opValues) {
                    if (!(ovx instanceof ContingentLabeledValue)) continue;
                    ContingentLabeledValue ov = (ContingentLabeledValue)ovx;
                    TimeDistance timeDistance = resultEdgeValue = resultEdgeValue == null ? ov.getContingentValue().neg() : this.min(resultEdgeValue, ov.getContingentValue().neg());
                }
            }
        }
        if (resultEdgeValue == null) {
            return null;
        }
        return new STNEdge(from, to, new DefaultConstraintValue(resultEdgeValue), labeledEdge != null ? labeledEdge.isControlEdge() : false, labeledEdge != null ? labeledEdge.isImplicit() : false, labeledEdge != null ? labeledEdge.getFlowDirection() : TCNEdge.FlowDirection.UNKOWN);
    }

    @Override
    public Collection<STNEdge> getIncomingEdges(LabeledTimePoint to) {
        Collection<LabeledTimePoint> timePoints = this.getTimePoints();
        ArrayList<STNEdge> edges = new ArrayList<STNEdge>(timePoints.size());
        for (LabeledTimePoint from : timePoints) {
            STNEdge edge = this.getEdge(from, to);
            if (edge == null) continue;
            edges.add(edge);
        }
        return edges;
    }

    @Override
    public Collection<STNEdge> getOutgoingEdges(LabeledTimePoint from) {
        Collection<LabeledTimePoint> timePoints = this.getTimePoints();
        ArrayList<STNEdge> edges = new ArrayList<STNEdge>(timePoints.size());
        for (LabeledTimePoint to : timePoints) {
            STNEdge edge = this.getEdge(from, to);
            if (edge == null) continue;
            edges.add(edge);
        }
        return edges;
    }

    public TimeDistance min(TimeDistance v1, TimeDistance v2) {
        if (v1.compareTo(v2) <= 0) {
            return v1;
        }
        return v2;
    }

    public int hashCode() {
        return this.cstnu.hashCode();
    }

    @Override
    public LabeledTimePoint getTimeBaseEvent() {
        return (LabeledTimePoint)this.cstnu.getTimeBaseEvent();
    }

    @Override
    public Collection<LabeledTimePoint> getTimePoints() {
        return this.cstnu.getTimePoints();
    }

    @Override
    public Collection<STNEdge> getEdges() {
        ArrayList<STNEdge> edges = new ArrayList<STNEdge>();
        for (LabeledTimePoint n1 : this.cstnu.getTimePoints()) {
            for (LabeledTimePoint n2 : this.cstnu.getTimePoints()) {
                STNEdge edge = this.getEdge(n1, n2);
                if (edge == null) continue;
                edges.add(edge);
            }
        }
        return edges;
    }

    public boolean equals(Object obj) {
        return this.cstnu.equals(obj);
    }

    @Override
    public void visit(GraphVisitor<LabeledTimePoint, STNEdge> visitor) {
        visitor.discoverGraph(this);
        for (LabeledTimePoint e : this.getTimePoints()) {
            visitor.discoverVertex(e);
            visitor.finishVertex(e);
        }
        for (LabeledTimePoint ei : this.getTimePoints()) {
            for (LabeledTimePoint ej : this.getTimePoints()) {
                STNEdge e = this.getEdge(ei, ej);
                if (e == null) continue;
                visitor.discoverEdge(e.getSourceNode(), e.getTargetNode(), e);
                visitor.finishEdge(e.getSourceNode(), e.getTargetNode(), e);
            }
        }
        visitor.finishGraph(this);
    }

    public String toString() {
        return this.cstnu.toString();
    }

    @Override
    public TCN<LabeledTimePoint, LabeledEdge> getBaseTCN() {
        return this.cstnu;
    }

    @Override
    public STN<LabeledTimePoint, STNEdge> clone() {
        ArrayList<LabeledTimePoint> nodes = new ArrayList<LabeledTimePoint>(this.getTimePoints());
        ArrayList<STNEdge> edges = new ArrayList<STNEdge>();
        for (LabeledTimePoint n1 : nodes) {
            for (LabeledTimePoint n2 : nodes) {
                STNEdge edge = this.getEdge(n1, n2);
                if (edge == null) continue;
                edges.add(edge.clone());
            }
        }
        return new SimpleSTN((Collection<LabeledTimePoint>)nodes, (Collection<STNEdge>)edges);
    }

    @Override
    public boolean isConsistent() {
        return this.cstnu.isConsistent();
    }

    @Override
    public Collection<LabeledTimePoint> getVertices() {
        return this.getTimePoints();
    }

    @Override
    public boolean contains(LabeledTimePoint timePoint) {
        return this.getTimePoints().contains(timePoint);
    }
}

