/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.timemodel.tcn.cstnuImpl;

import de.aristaflow.adept2.model.common.timedata.TimeDistance;
import de.aristaflow.adept2.model.common.timedata.defaultimplementation.DefaultTimeDistance;
import de.aristaflow.adept2.model.timemodel.ChangeSet;
import de.aristaflow.adept2.model.timemodel.defaultimplementation.Path;
import de.aristaflow.adept2.model.timemodel.defaultimplementation.Triangle;
import de.aristaflow.adept2.model.timemodel.tcn.CSTN;
import de.aristaflow.adept2.model.timemodel.tcn.ChangeableCSTN;
import de.aristaflow.adept2.model.timemodel.tcn.ChangeableCSTNU;
import de.aristaflow.adept2.model.timemodel.tcn.ChangeableTCN;
import de.aristaflow.adept2.model.timemodel.tcn.Label;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledEdge;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledTimePoint;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledValue;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledValueSet;
import de.aristaflow.adept2.model.timemodel.tcn.SimpleConstraintValue;
import de.aristaflow.adept2.model.timemodel.tcn.TCNEdge;
import de.aristaflow.adept2.model.timemodel.tcn.TCNInconsistencyException;
import de.aristaflow.adept2.model.timemodel.tcn.TCNSolver;
import de.aristaflow.adept2.model.timemodel.tcn.cstnImpl.AbstractCSTNSolver;
import de.aristaflow.adept2.model.timemodel.tcn.cstnImpl.LabelBasedPC2Solver;
import de.aristaflow.adept2.model.timemodel.tcn.cstnuImpl.CSTNUAllMaxProjection;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.ContingentLabeledValue;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.DefaultContingentLabeledValue;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.DefaultLabeledValue;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.DefaultLabeledValueSet;
import de.aristaflow.adept2.model.timemodel.tools.DuplicateFreeQueue;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

public class CSTNUDCSolver
extends AbstractCSTNSolver
implements TCNSolver<LabeledTimePoint, LabeledValueSet, LabeledEdge> {
    protected int updateCount;
    protected CSTNUAllMaxProjection allMax;
    protected Collection<LabeledEdge> changedEdges;
    public static boolean SIMPLIFY = true;

    public CSTNUDCSolver() {
    }

    public CSTNUDCSolver(Level debugLevel) {
        super(debugLevel);
    }

    @Override
    public <T extends ChangeableTCN<LabeledTimePoint, LabeledEdge>> T solve(T tcn) throws TCNInconsistencyException, InterruptedException {
        return this.solve(tcn, (ChangeSet<LabeledEdge, LabeledValueSet, Triangle<LabeledTimePoint>>)null);
    }

    @Override
    public <T extends ChangeableTCN<LabeledTimePoint, LabeledEdge>> T solve(T tcn, ChangeSet<LabeledEdge, LabeledValueSet, Triangle<LabeledTimePoint>> changeSet) throws TCNInconsistencyException, InterruptedException {
        if (tcn instanceof ChangeableCSTNU) {
            return (T)this.solve((ChangeableCSTNU)tcn, changeSet);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public ChangeableCSTNU solve(ChangeableCSTNU cstnu) throws TCNInconsistencyException, InterruptedException {
        return this.solve(cstnu, (ChangeSet<LabeledEdge, LabeledValueSet, Triangle<LabeledTimePoint>>)null);
    }

    @Override
    public ChangeableCSTNU solve(ChangeableCSTNU model, ChangeSet<LabeledEdge, LabeledValueSet, Triangle<LabeledTimePoint>> changeSet) throws TCNInconsistencyException, InterruptedException {
        this.allMax = null;
        this.updateCount = 0;
        this.changedEdges = null;
        if (model.isControllable()) {
            return model;
        }
        ChangeableCSTNU cstnu = this.preProcessing(model);
        this.internalSolveComponent(cstnu, changeSet);
        ChangeableCSTNU result = this.postProcessing(cstnu);
        result.setControllable();
        return result;
    }

    protected ChangeableCSTNU postProcessing(ChangeableCSTNU cstnu) {
        return cstnu;
    }

    protected ChangeableCSTNU preProcessing(ChangeableCSTNU model) {
        return model;
    }

    @Override
    protected void solveComponent(ChangeableCSTN model, ChangeSet<LabeledEdge, LabeledValueSet, Triangle<LabeledTimePoint>> changeSet) throws TCNInconsistencyException, InterruptedException {
        this.internalSolveComponent((ChangeableCSTNU)model, changeSet);
    }

    protected void internalSolveComponent(ChangeableCSTNU model, ChangeSet<LabeledEdge, LabeledValueSet, Triangle<LabeledTimePoint>> changeSet) throws TCNInconsistencyException, InterruptedException {
        long cutoff;
        Collection nodes = model.getTimePoints();
        BigInteger observationCount = BigInteger.valueOf(Math.max(model.getObservations().size(), 1));
        BigInteger nodeCount = BigInteger.valueOf(nodes.size());
        BigInteger contingentNodeCount = BigInteger.valueOf(nodes.size());
        BigInteger cutoffBound = observationCount.multiply(nodeCount.pow(2).add(nodeCount.multiply(contingentNodeCount)).add(contingentNodeCount)).multiply(nodeCount.pow(4));
        if (cutoffBound.compareTo(BigInteger.valueOf(Long.MAX_VALUE)) == 1) {
            assert (this.debug(Level.SEVERE, "Overflow detected when calculating cuttOff Bound.Limiting cutOff Bound to Long.MAX_VALUE.Note: The algorithm might not give accurate results in case cutoffBound is reached."));
            cutoff = Long.MAX_VALUE;
        } else {
            cutoff = cutoffBound.longValue();
        }
        new LabelBasedPC2Solver();
        this.allMax = new CSTNUAllMaxProjection(model);
        int nodeCount2 = nodes.size();
        DuplicateFreeQueue<Path<Object>> nextQueue = new DuplicateFreeQueue(nodeCount2 * nodeCount2 * 2);
        this.changedEdges = model.getChanges();
        if (this.changedEdges == null) {
            this.getInitialPaths(nodes, nextQueue);
        } else {
            for (LabeledEdge changedEdge : this.changedEdges) {
                nextQueue.add(new Path<LabeledTimePoint>((LabeledTimePoint)changedEdge.getSourceNode(), (LabeledTimePoint)changedEdge.getTargetNode()));
            }
        }
        long iter = 0L;
        while (iter < cutoff) {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
            assert (this.debug(Level.FINE, "Iteration %s", iter));
            this.updateCount = 0;
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
            DuplicateFreeQueue currentQueue = nextQueue;
            nextQueue = new DuplicateFreeQueue(nodeCount2 * nodeCount2 * 2);
            this.changedEdges = new ArrayList<LabeledEdge>();
            boolean changes = false;
            while (!currentQueue.isEmpty()) {
                if (Thread.currentThread().isInterrupted()) {
                    throw new InterruptedException();
                }
                Path triangle = (Path)((Object)currentQueue.remove());
                LabeledTimePoint i = (LabeledTimePoint)triangle.getFirst();
                LabeledTimePoint j = (LabeledTimePoint)triangle.getSecond();
                for (LabeledTimePoint k : nodes) {
                    Path<LabeledTimePoint> e;
                    if (i.equals(k) || j.equals(k)) continue;
                    if (this.processPath(model, changeSet, new Path<LabeledTimePoint>(i, k), j)) {
                        changes = true;
                        e = new Path<LabeledTimePoint>(i, k);
                        if (!currentQueue.contains(e)) {
                            nextQueue.add(e);
                        }
                    }
                    if (!this.processPath(model, changeSet, new Path<LabeledTimePoint>(k, j), i)) continue;
                    changes = true;
                    e = new Path<LabeledTimePoint>(k, j);
                    if (currentQueue.contains(e)) continue;
                    nextQueue.add(e);
                }
            }
            if (!changes) {
                assert (this.debug(Level.FINE, "Controllable!"));
                assert (nextQueue.isEmpty());
                break;
            }
            assert (this.debug(Level.FINE, "%s Updates", this.updateCount));
            ++iter;
        }
        if (iter >= cutoff) {
            assert (this.debug(Level.FINE, "Cutoff bound reached"));
            throw new TCNInconsistencyException("CutoffBound reached", model);
        }
    }

    @Override
    protected boolean processPath(ChangeableCSTN model, ChangeSet<LabeledEdge, LabeledValueSet, Triangle<LabeledTimePoint>> changeSet, Path<LabeledTimePoint> p, LabeledTimePoint via) throws TCNInconsistencyException {
        LabeledTimePoint from = p.getFrom();
        LabeledTimePoint to = p.getTo();
        LabeledEdge e_ij = (LabeledEdge)model.getEdge(from, via);
        LabeledEdge e_jk = (LabeledEdge)model.getEdge(via, to);
        LabeledEdge e_ik = (LabeledEdge)model.getEdge(from, to);
        assert (this.debug(Level.FINE, "Processing (%s, %s) with %s ~ %s + %s", from, to, e_ik, e_ij, e_jk));
        Map<Label, LabeledValue> newValues = this.applyEdgeGenerationRules(model, from, via, to);
        assert (this.debug(Level.FINE, "   Generation Rules generated %s", newValues));
        if (newValues == null || newValues.isEmpty()) {
            assert (this.debug(Level.FINE, " Ignoring\t %s->%s (because no labels have been generated)", from, to));
            return false;
        }
        LabeledValueSet ls_DA = null;
        if (e_ik != null) {
            ls_DA = (LabeledValueSet)e_ik.getValue();
        }
        try {
            newValues = this.intersect(ls_DA, newValues);
        }
        catch (AssertionError e) {
            System.err.println(String.format(" Error with %s->%s", from, to));
            throw e;
        }
        assert (this.debug(Level.FINE, "   Intersection resulted in %s", newValues));
        newValues = this.applyLabelRemovalRules(model, from, via, to, newValues);
        this.applyPropositionModificationRules(model, from, via, to, newValues);
        assert (this.debug(Level.FINE, "   Label Removal Rules resulted in %s", newValues));
        if (SIMPLIFY) {
            this.applySimplificationRules(newValues);
        }
        assert (newValues != null);
        DefaultLabeledValueSet newValueSet = new DefaultLabeledValueSet(newValues.values());
        if (ls_DA != null && ls_DA.equals(newValueSet)) {
            assert (this.debug(Level.FINE, " Ignoring\t %s to %s (because no changes)", e_ik, newValueSet));
            return false;
        }
        LabeledEdge labeledEdge = this.createEdge(from, to, newValueSet, e_ik != null && e_ik.isControlEdge(), e_ik == null || e_ik.isImplicit(), e_ik != null ? e_ik.getFlowDirection() : TCNEdge.FlowDirection.UNKOWN);
        assert (this.debug(Level.FINE, " Updating\t %s to %s (because of %s and %s)", e_ik, labeledEdge, e_ij, e_jk));
        this.updateConstraint(changeSet, model, labeledEdge, new Triangle<LabeledTimePoint>(new Path<LabeledTimePoint>(from, to), via));
        return true;
    }

    protected Map<Label, LabeledValue> applyLabelRemovalRules(CSTN cstnu, LabeledTimePoint Q, LabeledTimePoint S, LabeledTimePoint T, Map<Label, LabeledValue> newLabel) throws TCNInconsistencyException {
        this.labelRemovalReduction(cstnu, Q, T, newLabel);
        return newLabel;
    }

    protected void labelRemovalReduction(CSTN cstnu, LabeledTimePoint S, LabeledTimePoint T, Map<Label, LabeledValue> labeledValues) throws TCNInconsistencyException {
        assert (S != null);
        assert (T != null);
        ArrayList<DefaultLabeledValue> newValues = new ArrayList<DefaultLabeledValue>();
        Iterator<LabeledValue> iterator = labeledValues.values().iterator();
        while (iterator.hasNext()) {
            TimeDistance x;
            ContingentLabeledValue cl_TR;
            ContingentLabeledValue cl_ST;
            LabeledValue l_ST = iterator.next();
            if (!(l_ST instanceof ContingentLabeledValue) || !ContingentLabeledValue.ConstraintCase.UPPERCASE.equals((Object)((ContingentLabeledValue)l_ST).getCase()) || (cl_ST = (ContingentLabeledValue)l_ST).getTrigger() == S || cl_ST.getTrigger() == T || (cl_TR = this.getContingentDurationConstraint(cstnu, T, cl_ST.getTrigger())) == null) continue;
            assert (cl_TR != null);
            assert (ContingentLabeledValue.ConstraintCase.LOWERCASE.equals((Object)cl_TR.getCase()));
            TimeDistance v = cl_ST.getContingentValue();
            if (v.compareTo((x = cl_TR.getContingentValue()).neg()) < 0) continue;
            assert (cl_TR.getCase().equals((Object)ContingentLabeledValue.ConstraintCase.LOWERCASE));
            assert (cl_ST.getCase().equals((Object)ContingentLabeledValue.ConstraintCase.UPPERCASE));
            DefaultLabeledValue newValue = new DefaultLabeledValue(cl_ST.getLabel(), v);
            assert (this.debug(Level.FINER, "\tLabelRemoval:\t Replacing %s by %s", cl_ST, newValue));
            iterator.remove();
            newValues.add(newValue);
        }
        for (LabeledValue labeledValue : newValues) {
            this.addOrReplaceIfNecessary(labeledValues, labeledValue);
        }
    }

    protected LabeledValue lowerCaseReduction(ContingentLabeledValue cl_QS, LabeledValue l_ST, LabeledTimePoint S) {
        if (l_ST instanceof ContingentLabeledValue) {
            return null;
        }
        if (!ContingentLabeledValue.ConstraintCase.LOWERCASE.equals((Object)cl_QS.getCase())) {
            return null;
        }
        TimeDistance v = l_ST.getValue();
        long cv = v.sign();
        if (cv >= 0L && cv != 0L) {
            return null;
        }
        if (!this.satisfiable(cl_QS.getLabel(), l_ST.getLabel())) {
            return null;
        }
        assert (!(l_ST instanceof ContingentLabeledValue));
        assert (ContingentLabeledValue.ConstraintCase.LOWERCASE.equals((Object)cl_QS.getCase()));
        assert (cl_QS.getTrigger() == S);
        TimeDistance value = l_ST.getValue().add(cl_QS.getContingentValue());
        Label proposition = this.mergeLabels(l_ST.getLabel(), cl_QS.getLabel());
        DefaultLabeledValue newLabel = new DefaultLabeledValue(proposition, value);
        assert (this.debug(Level.FINER, "\tLowerCase:\t %s + %s -> %s", cl_QS, l_ST, newLabel));
        return newLabel;
    }

    protected Map<Label, LabeledValue> applyEdgeGenerationRules(ChangeableCSTN cstnu, LabeledTimePoint Q, LabeledTimePoint S, LabeledTimePoint T) {
        LabeledEdge QS = (LabeledEdge)cstnu.getEdge(Q, S);
        if (QS == null) {
            return null;
        }
        LabeledEdge SQ = (LabeledEdge)cstnu.getEdge(S, Q);
        LabeledEdge ST = (LabeledEdge)cstnu.getEdge(S, T);
        HashMap<Label, LabeledValue> labels = new HashMap<Label, LabeledValue>();
        if (ST != null) {
            for (LabeledValue l_QS : ((LabeledValueSet)QS.getValue()).getLabeledValues()) {
                ContingentLabeledValue cl_QS = null;
                if (l_QS instanceof ContingentLabeledValue) {
                    cl_QS = (ContingentLabeledValue)l_QS;
                }
                for (LabeledValue l_ST : ((LabeledValueSet)ST.getValue()).getLabeledValues()) {
                    LabeledValue lowerCase;
                    LabeledValue upperCase;
                    LabeledValue crossCase;
                    LabeledValue noCase;
                    ContingentLabeledValue cl_ST = null;
                    if (l_ST instanceof ContingentLabeledValue) {
                        cl_ST = (ContingentLabeledValue)l_ST;
                    }
                    if ((noCase = this.noCaseReduction(l_QS, l_ST, (LabeledTimePoint)ST.getSourceNode())) != null) {
                        this.addOrReplaceIfNecessary(Q, T, labels, noCase);
                    }
                    if (cl_QS != null && cl_ST != null && (crossCase = this.crossCaseReduction(cl_QS, cl_ST, (LabeledTimePoint)ST.getSourceNode())) != null) {
                        this.addOrReplaceIfNecessary(Q, T, labels, crossCase);
                    }
                    if (cl_ST != null && (upperCase = this.upperCaseReduction(l_QS, cl_ST, (LabeledTimePoint)ST.getSourceNode())) != null) {
                        this.addOrReplaceIfNecessary(Q, T, labels, upperCase);
                    }
                    if (cl_QS == null || (lowerCase = this.lowerCaseReduction(cl_QS, l_ST, (LabeledTimePoint)ST.getSourceNode())) == null) continue;
                    this.addOrReplaceIfNecessary(Q, T, labels, lowerCase);
                }
            }
        }
        if (SQ != null) {
            for (LabeledValue l_QS : ((LabeledValueSet)QS.getValue()).getLabeledValues()) {
                for (LabeledValue l_SQ : ((LabeledValueSet)SQ.getValue()).getLabeledValues()) {
                    LabeledValue observationCase = this.observationCaseReduction(l_SQ, l_QS, T);
                    if (observationCase == null) continue;
                    this.addOrReplaceIfNecessary(Q, T, labels, observationCase);
                }
            }
        }
        if (labels.size() > 0) {
            return labels;
        }
        return null;
    }

    protected ContingentLabeledValue getContingentDurationConstraint(CSTN cstnu, LabeledTimePoint from, LabeledTimePoint to) {
        LabeledEdge edge = (LabeledEdge)cstnu.getEdge(from, to);
        ContingentLabeledValue res = null;
        if (edge != null) {
            res = this.getContingentLabeledValue(edge);
            assert (res != null || this.debug(Level.WARNING, "Case missing for contingent constraint '%s->%s'!", from, to));
            assert (res == null || res.getTrigger() == edge.getSourceNode() || res.getTrigger() == edge.getTargetNode());
        }
        return res;
    }

    protected ContingentLabeledValue getContingentLabeledValue(LabeledEdge edge) {
        Collection<LabeledValue> labeledValues = ((LabeledValueSet)edge.getValue()).getLabeledValues();
        assert (labeledValues.size() == 1);
        LabeledValue labeledValue = labeledValues.iterator().next();
        if (labeledValue instanceof ContingentLabeledValue) {
            return (ContingentLabeledValue)labeledValue;
        }
        return null;
    }

    protected LabeledValue crossCaseReduction(ContingentLabeledValue cl_QS, ContingentLabeledValue cl_ST, LabeledTimePoint S) {
        if (!ContingentLabeledValue.ConstraintCase.UPPERCASE.equals((Object)cl_ST.getCase())) {
            return null;
        }
        if (!ContingentLabeledValue.ConstraintCase.LOWERCASE.equals((Object)cl_QS.getCase())) {
            return null;
        }
        if (cl_ST.getContingentValue().sign() > 0) {
            return null;
        }
        if (cl_ST.getTrigger() == S) {
            return null;
        }
        if (!this.satisfiable(cl_QS.getLabel(), cl_ST.getLabel())) {
            return null;
        }
        assert (cl_ST.getCase().equals((Object)ContingentLabeledValue.ConstraintCase.UPPERCASE));
        assert (cl_QS.getCase().equals((Object)ContingentLabeledValue.ConstraintCase.LOWERCASE));
        assert (cl_ST.getTrigger() != S);
        assert (cl_QS.getTrigger() == S);
        TimeDistance value = cl_ST.getContingentValue().add(cl_QS.getContingentValue());
        Label proposition = this.mergeLabels(cl_ST.getLabel(), cl_QS.getLabel());
        LabeledValue newLabel = this.createContingentConstraint(proposition, value, cl_ST.getTrigger());
        assert (this.debug(Level.FINER, "\tCrossCase:\t %s + %s -> %s", cl_QS, cl_ST, newLabel));
        return newLabel;
    }

    protected LabeledValue upperCaseReduction(LabeledValue l_QS, ContingentLabeledValue cl_ST, LabeledTimePoint S) {
        if (!ContingentLabeledValue.ConstraintCase.UPPERCASE.equals((Object)cl_ST.getCase())) {
            return null;
        }
        if (!this.satisfiable(l_QS.getLabel(), cl_ST.getLabel())) {
            return null;
        }
        assert (cl_ST.getCase().equals((Object)ContingentLabeledValue.ConstraintCase.UPPERCASE));
        TimeDistance value = l_QS.getValue().add(cl_ST.getContingentValue());
        Label proposition = this.mergeLabels(l_QS.getLabel(), cl_ST.getLabel());
        LabeledTimePoint trigger = cl_ST.getTrigger();
        LabeledValue newLabel = this.createContingentConstraint(proposition, value, trigger);
        assert (this.debug(Level.FINER, "\tUpperCase:\t %s + %s -> %s", l_QS, cl_ST, newLabel));
        return newLabel;
    }

    protected LabeledValue createContingentConstraint(Label proposition, TimeDistance value, LabeledTimePoint trigger) {
        DefaultContingentLabeledValue newLabel = new DefaultContingentLabeledValue(proposition, ContingentLabeledValue.ConstraintCase.UPPERCASE, DefaultTimeDistance.POSITIVE_INFINITE_TIME_DISTANCE, trigger, value);
        return newLabel;
    }

    protected LabeledValue noCaseReduction(LabeledValue l_QS, LabeledValue l_ST, LabeledTimePoint S) {
        if (!this.satisfiable(l_QS.getLabel(), l_ST.getLabel())) {
            return null;
        }
        if (l_QS.getValue().isInfinity() || l_ST.getValue().isInfinity()) {
            return null;
        }
        TimeDistance value = l_QS.getValue().add(l_ST.getValue());
        Label proposition = this.mergeLabels(l_QS.getLabel(), l_ST.getLabel());
        DefaultLabeledValue newLabel = new DefaultLabeledValue(proposition, value);
        assert (this.debug(Level.FINER, "\tNoCase:\t\t %s + %s -> %s", l_QS, l_ST, newLabel));
        return newLabel;
    }

    protected void updateConstraint(ChangeSet<LabeledEdge, LabeledValueSet, Triangle<LabeledTimePoint>> changeSet, ChangeableCSTN cstnu, LabeledEdge newEdge, Triangle<LabeledTimePoint> causedBy) throws TCNInconsistencyException {
        ContingentLabeledValue oldValue;
        LabeledEdge oldEdge = (LabeledEdge)cstnu.getEdge((LabeledTimePoint)newEdge.getSourceNode(), (LabeledTimePoint)newEdge.getTargetNode());
        if (oldEdge != null && oldEdge.isContingentDuration()) {
            oldValue = this.getContingentLabeledValue(oldEdge);
            if (!newEdge.isContingentDuration()) {
                throw new TCNInconsistencyException("Cannot update contingent constraints " + oldEdge + " to " + newEdge, new Path<LabeledTimePoint>((LabeledTimePoint)newEdge.getSourceNode(), (LabeledTimePoint)newEdge.getTargetNode()), (LabeledTimePoint)causedBy.getSecond(), cstnu);
            }
            ContingentLabeledValue newValue = this.getContingentLabeledValue(newEdge);
            if (!oldValue.getContingentValue().equals(newValue.getContingentValue())) {
                throw new TCNInconsistencyException("Cannot update contingent constraints " + oldEdge + " to " + newEdge, new Path<LabeledTimePoint>((LabeledTimePoint)newEdge.getSourceNode(), (LabeledTimePoint)newEdge.getTargetNode()), (LabeledTimePoint)causedBy.getSecond(), cstnu);
            }
        } else if (newEdge.isContingentDuration()) {
            throw new IllegalArgumentException("Adding contingent duration constraints is not allowed!");
        }
        if (changeSet != null) {
            oldValue = oldEdge != null ? (LabeledValueSet)oldEdge.getValue() : null;
            this.logChange(changeSet, (Path)((Object)causedBy.getFirst()), (LabeledTimePoint)causedBy.getSecond(), newEdge, oldValue);
        }
        this.checkConsistency(cstnu, newEdge, causedBy);
        try {
            cstnu.updateConstraint(newEdge);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.debug(Level.SEVERE, "Inconsistent: %s -> %s: %s", newEdge.getSourceNode(), newEdge.getTargetNode(), newEdge);
            throw new TCNInconsistencyException(String.format("Inconsistent: %s -> %s: %s vs. %s", newEdge.getSourceNode(), newEdge.getTargetNode(), newEdge, oldEdge), new Path<LabeledTimePoint>((LabeledTimePoint)newEdge.getSourceNode(), (LabeledTimePoint)newEdge.getTargetNode()), (LabeledTimePoint)causedBy.getSecond(), cstnu);
        }
        if (this.changedEdges != null) {
            this.changedEdges.add(newEdge);
        }
        if (this.allMax != null) {
            this.allMax.removeDelta(newEdge);
        }
        ++this.updateCount;
    }

    @Override
    protected boolean isConsistent(SimpleConstraintValue value1, SimpleConstraintValue value2) {
        TimeDistance d2;
        TimeDistance d1;
        boolean consistent = super.isConsistent(value1, value2);
        if (consistent && value1 instanceof ContingentLabeledValue) {
            ContingentLabeledValue contingent1 = (ContingentLabeledValue)value1;
            d1 = contingent1.getContingentValue().neg();
            consistent &= d1.compareTo(d2 = value2.getValue()) <= 0;
        }
        if (consistent && value2 instanceof ContingentLabeledValue) {
            ContingentLabeledValue contingent2 = (ContingentLabeledValue)value2;
            d1 = value1.getValue();
            consistent &= d1.compareTo(d2 = contingent2.getContingentValue().neg()) >= 0;
        }
        return consistent;
    }

    @Override
    protected LabeledValue updateLabel(LabeledValue labeledValue, Label label) {
        LabeledValue newLabeledValue;
        if (labeledValue instanceof ContingentLabeledValue) {
            ContingentLabeledValue cl_XY = (ContingentLabeledValue)labeledValue;
            newLabeledValue = new DefaultContingentLabeledValue(label, cl_XY.getCase(), cl_XY.getSTNValue(), cl_XY.getTrigger(), cl_XY.getContingentValue());
        } else {
            newLabeledValue = super.updateLabel(labeledValue, label);
        }
        return newLabeledValue;
    }

    @Override
    protected boolean redundantLabelEliminationRule2(Map<Label, LabeledValue> labels) {
        boolean changes = false;
        HashSet<DefaultLabeledValue> markForAdd = new HashSet<DefaultLabeledValue>();
        HashSet<Label> markForRemoval = new HashSet<Label>();
        ArrayList<LabeledValue> list = new ArrayList<LabeledValue>(labels.values());
        HashMap map = new HashMap();
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            LabeledValue v1 = (LabeledValue)listIterator.next();
            if (!listIterator.hasNext()) break;
            ListIterator iter2 = list.listIterator(listIterator.nextIndex());
            while (iter2.hasNext()) {
                HashSet<LabeledValue> choices;
                LabeledValue v2 = (LabeledValue)iter2.next();
                Label.ChoiceVariable diff = this.singlediff(v1.getLabel(), v2.getLabel());
                if (diff == null) continue;
                Label context = v1.getLabel().removeVariable(diff);
                HashMap<Label.ChoiceVariable, HashSet<LabeledValue>> baseLabels = (HashMap<Label.ChoiceVariable, HashSet<LabeledValue>>)map.get(context);
                if (baseLabels == null) {
                    baseLabels = new HashMap<Label.ChoiceVariable, HashSet<LabeledValue>>();
                    map.put(context, baseLabels);
                }
                if ((choices = (HashSet<LabeledValue>)baseLabels.get(diff)) == null) {
                    choices = new HashSet<LabeledValue>(diff.getOptions() * 2);
                    baseLabels.put(diff, choices);
                }
                choices.add(v1);
                choices.add(v2);
            }
        }
        for (Map.Entry entry : map.entrySet()) {
            Label context = (Label)entry.getKey();
            Map choices = (Map)entry.getValue();
            for (Map.Entry entry2 : choices.entrySet()) {
                int compare;
                TimeDistance value;
                if (((Label.ChoiceVariable)entry2.getKey()).getOptions() != ((Set)entry2.getValue()).size()) continue;
                TimeDistance max = DefaultTimeDistance.NEGATIVE_INFINITE_TIME_DISTANCE;
                TimeDistance maxCont = DefaultTimeDistance.NEGATIVE_INFINITE_TIME_DISTANCE;
                boolean allContingent = true;
                LabeledTimePoint trigger = null;
                for (LabeledValue l : (Set)entry2.getValue()) {
                    value = l.getValue();
                    compare = value.compareTo(max);
                    if (compare > 0) {
                        max = value;
                    }
                    if (allContingent && l instanceof ContingentLabeledValue) {
                        ContingentLabeledValue contingentLabeledValue = (ContingentLabeledValue)l;
                        if (trigger == null) {
                            trigger = contingentLabeledValue.getTrigger();
                        } else if (trigger != contingentLabeledValue.getTrigger()) {
                            allContingent = false;
                            continue;
                        }
                        value = contingentLabeledValue.getContingentValue();
                        compare = value.compareTo(maxCont);
                        if (compare <= 0) continue;
                        maxCont = value;
                        continue;
                    }
                    allContingent = false;
                }
                if (allContingent) {
                    markForAdd.add(new DefaultContingentLabeledValue(context, ContingentLabeledValue.ConstraintCase.UPPERCASE, max, trigger, maxCont));
                } else {
                    markForAdd.add(new DefaultLabeledValue(context, max));
                }
                for (LabeledValue l : (Set)entry2.getValue()) {
                    value = l.getValue();
                    compare = value.compareTo(max);
                    if (compare < 0) continue;
                    markForRemoval.add(l.getLabel());
                }
            }
        }
        for (Label label : markForRemoval) {
            changes |= labels.remove(label) != null;
        }
        for (LabeledValue labeledValue : markForAdd) {
            changes |= this.addOrReplaceIfNecessary(labels, labeledValue);
        }
        assert (labels.size() > 0) : "MarkForAdd: " + markForAdd + " | MarkForRemoval: " + markForRemoval;
        return changes;
    }

    @Override
    public LabeledValue merge(LabeledValue newValue, LabeledValue oldValue) {
        if (newValue instanceof ContingentLabeledValue) {
            TimeDistance newTD;
            if (oldValue instanceof ContingentLabeledValue) {
                ContingentLabeledValue clNew = (ContingentLabeledValue)newValue;
                ContingentLabeledValue clOld = (ContingentLabeledValue)oldValue;
                int compareNonCont = clOld.getValue().compareTo(clNew.getValue());
                int compareCont = clOld.getContingentValue().compareTo(clNew.getContingentValue());
                if (compareCont > 0 || compareNonCont > 0) {
                    assert (clNew.getCase() == clOld.getCase()) : clOld + " vs. " + clNew;
                    assert (clNew.getTrigger() == clOld.getTrigger()) : "Trying to merge contingent constraints with different triggers!";
                    if (compareCont >= 0 && compareNonCont >= 0) {
                        return newValue;
                    }
                    TimeDistance nonContValue = compareNonCont > 0 ? clNew.getValue() : clOld.getValue();
                    TimeDistance contValue = compareCont > 0 ? clNew.getContingentValue() : clOld.getContingentValue();
                    return this.updateLabeledValue(oldValue, clNew, nonContValue, contValue);
                }
                return oldValue;
            }
            ContingentLabeledValue clNew = (ContingentLabeledValue)newValue;
            TimeDistance oldTD = oldValue.getValue();
            int compareNonCont = oldTD.compareTo(newTD = clNew.getValue());
            if (compareNonCont >= 0) {
                return newValue;
            }
            TimeDistance contValue = clNew.getContingentValue();
            TimeDistance nonContValue = oldValue.getValue();
            return this.updateLabeledValue(oldValue, clNew, nonContValue, contValue);
        }
        if (oldValue instanceof ContingentLabeledValue) {
            ContingentLabeledValue clOld = (ContingentLabeledValue)oldValue;
            int compareNonCont = clOld.getValue().compareTo(newValue.getValue());
            if (compareNonCont > 0) {
                TimeDistance nonContValue = newValue.getValue();
                TimeDistance contValue = clOld.getContingentValue();
                return this.updateLabeledValue(oldValue, clOld, nonContValue, contValue);
            }
            return oldValue;
        }
        int compare = oldValue.getValue().compareTo(newValue.getValue());
        if (compare > 0) {
            return newValue;
        }
        return oldValue;
    }

    protected LabeledValue updateLabeledValue(LabeledValue oldValue, ContingentLabeledValue value, TimeDistance nonContValue, TimeDistance contValue) {
        DefaultLabeledValue newValue = nonContValue.compareTo(contValue) <= 0 ? new DefaultLabeledValue(value.getLabel(), nonContValue) : new DefaultContingentLabeledValue(value.getLabel(), value.getCase(), nonContValue, value.getTrigger(), contValue);
        return newValue;
    }
}

