/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.timemodel.tcn.cstnuImpl;

import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.model.common.timedata.CalendarElement;
import de.aristaflow.adept2.model.common.timedata.TimeDistance;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.timemodel.InstanceTimeModel;
import de.aristaflow.adept2.model.timemodel.Interval;
import de.aristaflow.adept2.model.timemodel.UpdateableInstanceTimeModel;
import de.aristaflow.adept2.model.timemodel.tcn.CSTNU;
import de.aristaflow.adept2.model.timemodel.tcn.ChangeableCSTNU;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledEdge;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledTimePoint;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledValue;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledValueSet;
import de.aristaflow.adept2.model.timemodel.tcn.NodeMapping;
import de.aristaflow.adept2.model.timemodel.tcn.TCNEdge;
import de.aristaflow.adept2.model.timemodel.tcn.TCNInstanceTimeModel;
import de.aristaflow.adept2.model.timemodel.tcn.cstnuImpl.CSTNU2STNProjection;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.ContingentLabeledValue;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.DefaultLabeledEdge;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.DefaultLabeledValue;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.DefaultLabeledValueSet;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.STNEdge;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class CSTNUInstanceTimeModel
extends TCNInstanceTimeModel<LabeledTimePoint, STNEdge>
implements InstanceTimeModel,
UpdateableInstanceTimeModel {
    private ChangeableCSTNU cstnu;

    public CSTNUInstanceTimeModel(UUID instanceID, UUID templateID, ChangeableCSTNU cstnu, Collection<NodeMapping<LabeledTimePoint>> nodeMapping, LabeledTimePoint creationTimePoint, LabeledTimePoint startTimePoint, LabeledTimePoint endTimePoint, Map<Integer, List<URI>> updateTriggers) {
        super(instanceID, templateID, new CSTNU2STNProjection(cstnu), nodeMapping, creationTimePoint, startTimePoint, endTimePoint, updateTriggers);
        this.cstnu = cstnu;
    }

    @Override
    public void setInstanceCreationTime(long timestamp) {
        LabeledTimePoint node = (LabeledTimePoint)this.getProcessCreationTimePoint();
        this.setToTimeStamp(node, timestamp);
        this.handleTriggerEvent(node);
    }

    @Override
    public void setInstanceStartTime(long timestamp) {
        LabeledTimePoint processStart = (LabeledTimePoint)this.getProcessStartTimePoint();
        this.setToTimeStamp(processStart, timestamp);
        this.handleTriggerEvent(processStart);
    }

    private void setToTimeStamp(LabeledTimePoint event, long timestamp) {
        LabeledTimePoint timeBaseEvent = (LabeledTimePoint)this.getTimeBaseEvent();
        TimeDistance timeDistance = this.timeModelOperations.millisecondsToTimeDistance(timestamp);
        System.out.println("Setting " + event + " to " + timeDistance);
        assert (timeDistance.toMilliseconds() == timestamp);
        this.setToDistance(timeBaseEvent, event, timeDistance);
    }

    private void setToDistance(LabeledTimePoint from, LabeledTimePoint to, TimeDistance timeDistance) {
        LabeledEdge max = (LabeledEdge)this.cstnu.getEdge(from, to);
        LabeledEdge min = (LabeledEdge)this.cstnu.getEdge(to, from);
        DefaultLabeledValue maxValue = new DefaultLabeledValue(from.getLabel(), timeDistance);
        DefaultLabeledEdge maxEdge = new DefaultLabeledEdge(from, to, new DefaultLabeledValueSet(maxValue), false, false, TCNEdge.FlowDirection.FORWARD);
        this.cstnu.updateContingentConstraint(maxEdge);
        DefaultLabeledValue minValue = new DefaultLabeledValue(from.getLabel(), timeDistance.neg());
        DefaultLabeledEdge minEdge = new DefaultLabeledEdge(to, from, new DefaultLabeledValueSet(minValue), false, false, TCNEdge.FlowDirection.BACKWARD);
        this.cstnu.updateContingentConstraint(minEdge);
        System.out.println(String.format("Updating [%s, %s] to [%s, %s]", min == null ? "infty" : min.getValue(), max == null ? "infty" : max.getValue(), minEdge.getValue(), maxEdge.getValue()));
    }

    @Override
    public void setInstanceFinishTime(long timestamp) {
        LabeledTimePoint processEnd = (LabeledTimePoint)this.getProcessEndTimePoint();
        this.setToTimeStamp(processEnd, timestamp);
        this.handleTriggerEvent(processEnd);
    }

    @Override
    public void setNodeActivationTime(int nodeID, int iteration, long timestamp) {
    }

    @Override
    public void setActivityInstanceStartTime(int nodeID, int iteration, long timestamp) {
        NodeMapping nodeMapping = this.getNodeMapping(nodeID, this.iterationChain);
        LabeledTimePoint node = (LabeledTimePoint)nodeMapping.getStartNode();
        this.setToTimeStamp(node, timestamp);
        this.handleTriggerEvent(node);
    }

    @Override
    public void setActivityInstanceFinishTime(int nodeID, int iteration, long timestamp) {
        NodeMapping nodeMapping = this.getNodeMapping(nodeID, this.iterationChain);
        LabeledTimePoint node = (LabeledTimePoint)nodeMapping.getEndNode();
        this.setToTimeStamp(node, timestamp);
        Interval<CalendarElement> timePoint = this.getTimePoint((LabeledTimePoint)nodeMapping.getStartNode());
        long startTime = this.toTimeStamp(timePoint.getMinValue());
        long duration = timestamp - startTime;
        this.setToDistance((LabeledTimePoint)nodeMapping.getStartNode(), (LabeledTimePoint)nodeMapping.getEndNode(), this.timeModelOperations.millisecondsToTimeDistance(duration));
        LabeledTimePoint[] labeledTimePointArray = (LabeledTimePoint[])nodeMapping.getIntermediateEvents();
        int n = labeledTimePointArray.length;
        int n2 = 0;
        while (n2 < n) {
            LabeledTimePoint n3 = labeledTimePointArray[n2];
            this.handleTriggerEvent(n3);
            ++n2;
        }
        this.handleTriggerEvent(node);
    }

    private long toTimeStamp(CalendarElement value) {
        return value.getTimeInMillis();
    }

    private void handleTriggerEvent(LabeledTimePoint node) {
        Collection edges = this.cstnu.getEdges();
        for (LabeledEdge edge : edges) {
            boolean needsUpdate = false;
            STNEdge triggerEdge = null;
            ArrayList<LabeledValue> newValues = new ArrayList<LabeledValue>();
            for (LabeledValue labeledValue : ((LabeledValueSet)edge.getValue()).getLabeledValues()) {
                LabeledValue value = labeledValue;
                if (value instanceof ContingentLabeledValue && ((ContingentLabeledValue)value).getTrigger() == node) {
                    needsUpdate = true;
                    if (triggerEdge == null) {
                        triggerEdge = (STNEdge)this.stn.getEdge((LabeledTimePoint)edge.getSourceNode(), node);
                    }
                    if (triggerEdge != null) {
                        newValues.add(new DefaultLabeledValue(value.getLabel(), triggerEdge.getValue().getValue()));
                        continue;
                    }
                    newValues.add(new DefaultLabeledValue(value.getLabel(), value.getValue()));
                    continue;
                }
                newValues.add(labeledValue);
            }
            if (!needsUpdate) continue;
            DefaultLabeledEdge newEdge = new DefaultLabeledEdge((LabeledTimePoint)edge.getSourceNode(), (LabeledTimePoint)edge.getTargetNode(), new DefaultLabeledValueSet(newValues), edge.isControlEdge(), false, edge.getFlowDirection());
            this.cstnu.updateContingentConstraint(newEdge);
        }
    }

    @Override
    public void setActivityInstanceProgress(int nodeID, int iteration, float progress) {
    }

    @Override
    public void createNewIteration(List<Node> nodesInLoop, int iteration) {
    }

    public CSTNU getBaseTimeModel() {
        return this.cstnu;
    }

    @Override
    protected TimeDistance getValue(STNEdge edge) {
        if (edge != null) {
            return edge.getValue().getValue();
        }
        return null;
    }

    @Override
    public void setEarliestStartDate(SessionToken session, int nodeID, int iteration, CalendarElement date) {
        NodeMapping nodeMapping = this.getNodeMapping(nodeID, this.iterationChain);
        LabeledTimePoint node = (LabeledTimePoint)nodeMapping.getStartNode();
        this.setEarliestDate(node, date);
    }

    private void setEarliestDate(LabeledTimePoint node, CalendarElement date) {
        LabeledTimePoint timeBaseEvent = (LabeledTimePoint)this.getTimeBaseEvent();
        TimeDistance timeDistance = this.timeModelOperations.millisecondsToTimeDistance(date.getTimeInMillis());
        DefaultLabeledValue minValue = new DefaultLabeledValue(timeBaseEvent.getLabel(), timeDistance.neg());
        DefaultLabeledEdge minEdge = new DefaultLabeledEdge(node, timeBaseEvent, new DefaultLabeledValueSet(minValue), false, false, TCNEdge.FlowDirection.BACKWARD);
        this.cstnu.updateContingentConstraint(minEdge);
    }

    @Override
    public void setEarliestCompletionDate(SessionToken session, int nodeID, int iteration, CalendarElement date) {
        NodeMapping nodeMapping = this.getNodeMapping(nodeID, this.iterationChain);
        LabeledTimePoint node = (LabeledTimePoint)nodeMapping.getEndNode();
        this.setEarliestDate(node, date);
    }

    @Override
    public void setLatestStartDate(SessionToken session, int nodeID, int iteration, CalendarElement date) {
        NodeMapping nodeMapping = this.getNodeMapping(nodeID, this.iterationChain);
        LabeledTimePoint node = (LabeledTimePoint)nodeMapping.getStartNode();
        this.setLatestDate(node, date);
    }

    private void setLatestDate(LabeledTimePoint node, CalendarElement date) {
        long timestamp = date.getTimeInMillis();
        LabeledTimePoint timeBaseEvent = (LabeledTimePoint)this.getTimeBaseEvent();
        TimeDistance timeDistance = this.timeModelOperations.millisecondsToTimeDistance(timestamp);
        DefaultLabeledValue maxValue = new DefaultLabeledValue(timeBaseEvent.getLabel(), timeDistance);
        DefaultLabeledEdge maxEdge = new DefaultLabeledEdge(timeBaseEvent, node, new DefaultLabeledValueSet(maxValue), false, false, TCNEdge.FlowDirection.FORWARD);
        this.cstnu.updateContingentConstraint(maxEdge);
    }

    @Override
    public void setLatestCompletionDate(SessionToken session, int nodeID, int iteration, CalendarElement date) {
        NodeMapping nodeMapping = this.getNodeMapping(nodeID, this.iterationChain);
        LabeledTimePoint node = (LabeledTimePoint)nodeMapping.getEndNode();
        this.setLatestDate(node, date);
    }
}

