/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.timemodel.tcn.cstnuImpl;

import de.aristaflow.adept2.model.common.timedata.TimeDistance;
import de.aristaflow.adept2.model.common.timedata.TimePoint;
import de.aristaflow.adept2.model.common.timedata.defaultimplementation.DefaultTimeDistance;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.TemporalNode;
import de.aristaflow.adept2.model.processmodel.TemporalTemplate;
import de.aristaflow.adept2.model.processmodel.timemodel.ActivityDuration;
import de.aristaflow.adept2.model.timemodel.tcn.CSTNU;
import de.aristaflow.adept2.model.timemodel.tcn.ChangeableCSTNU;
import de.aristaflow.adept2.model.timemodel.tcn.IterationChain;
import de.aristaflow.adept2.model.timemodel.tcn.JoinNodeMapping;
import de.aristaflow.adept2.model.timemodel.tcn.Label;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledEdge;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledTimePoint;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledValueSet;
import de.aristaflow.adept2.model.timemodel.tcn.NodeInstance;
import de.aristaflow.adept2.model.timemodel.tcn.NodeMapping;
import de.aristaflow.adept2.model.timemodel.tcn.TCNEdge;
import de.aristaflow.adept2.model.timemodel.tcn.TCNTimePoint;
import de.aristaflow.adept2.model.timemodel.tcn.TCNTransformation;
import de.aristaflow.adept2.model.timemodel.tcn.cstnuImpl.DefaultCSTNU;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.AbstractLabeledTemplateTransformation;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.ContingentLabeledValue;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.DefaultContingentLabeledValue;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.DefaultLabeledEdge;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.DefaultLabeledValueSet;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.DefaultObservationTimePoint;
import java.util.Collection;
import java.util.HashSet;
import org.apache.commons.configuration.Configuration;

public class CSTNUTemplateTransformation
extends AbstractLabeledTemplateTransformation {
    public static final String CONF_ADVANCED_ACTIVITY_TRANSFORMATION = "TCNTransformation.AdvancedActivityTransformation";
    public static final int ACTIVITY_TRANSFORMATION_BASIC = 0;
    public static final int ACTIVITY_TRANSFORMATION_COOPIS = 1;
    protected int advancedActivityTransformation;

    public CSTNUTemplateTransformation(Configuration configuration, TemporalTemplate template) {
        this(configuration, template, 0);
    }

    public CSTNUTemplateTransformation(Configuration configuration, TemporalTemplate template, int lookAhead) {
        super(configuration, template, lookAhead);
    }

    public CSTNUTemplateTransformation(TemporalTemplate template) {
        this(null, template, 0);
    }

    public CSTNUTemplateTransformation(TemporalTemplate template, int lookAhead) {
        this(null, template, lookAhead);
    }

    @Override
    protected void readConfiguration() {
        super.readConfiguration();
        this.advancedActivityTransformation = this.configuration.getInt(CONF_ADVANCED_ACTIVITY_TRANSFORMATION, 0);
    }

    public CSTNU transform() {
        return (CSTNU)super.transform();
    }

    protected ChangeableCSTNU createTCN(Collection<LabeledTimePoint> nodes, Collection<LabeledEdge> edges, Collection<NodeMapping<LabeledTimePoint>> nodeMapping) {
        HashSet<Label.ChoiceVariable> observations = new HashSet<Label.ChoiceVariable>();
        for (LabeledTimePoint node : nodes) {
            if (!(node instanceof DefaultObservationTimePoint)) continue;
            observations.add(((DefaultObservationTimePoint)node).getObservation());
        }
        DefaultCSTNU timeModel = new DefaultCSTNU(nodes, edges, observations);
        return timeModel;
    }

    @Override
    protected ContingentActivityDuration getActivityDuration(int nodeID) {
        ContingentActivityDuration duration;
        TemporalNode node = this.template.getNode(nodeID);
        ActivityDuration activityDuration = node.getActivityDuration();
        if (activityDuration != null) {
            TimePoint guardMinimumDuration;
            TimePoint flexibleMaximumDuration;
            TimeDistance flexibleMinDuration = this.NODE_MIN_DURATION;
            TimeDistance flexibleMaxDuration = this.NODE_MAX_DURATION;
            TimePoint lowerMinimumDuration = activityDuration.getMinimumDuration();
            if (lowerMinimumDuration != null) {
                flexibleMinDuration = new DefaultTimeDistance(lowerMinimumDuration);
            }
            if ((flexibleMaximumDuration = activityDuration.getMaximumDuration()) != null) {
                flexibleMaxDuration = new DefaultTimeDistance(flexibleMaximumDuration);
            }
            TimeDistance guardMinDuration = (guardMinimumDuration = activityDuration.getGuardMinimumDuration()) != null ? new DefaultTimeDistance(guardMinimumDuration) : flexibleMaxDuration;
            TimePoint guardMaximumDuration = activityDuration.getGuardMaximumDuration();
            TimeDistance guardMaxDuration = guardMaximumDuration != null ? new DefaultTimeDistance(guardMaximumDuration) : flexibleMinDuration;
            duration = new ContingentActivityDuration(flexibleMinDuration, flexibleMaxDuration, guardMinDuration, guardMaxDuration);
        } else {
            duration = new ContingentActivityDuration(this.NODE_MIN_DURATION, this.NODE_MAX_DURATION, this.NODE_MAX_DURATION, this.NODE_MIN_DURATION);
        }
        return duration;
    }

    @Override
    protected NodeMapping<LabeledTimePoint> transformActivity(int nodeID, IterationChain iterationChain, Label branch) {
        NodeMapping<LabeledTimePoint> node;
        switch (this.advancedActivityTransformation) {
            case 1: {
                node = this.transformActivityAdvanced(nodeID, iterationChain, branch);
                break;
            }
            case 2: {
                throw new RuntimeException("No longer supported; Use CSTNPSU Transformation");
            }
            default: {
                node = this.transformActivityBasic(nodeID, iterationChain, branch);
            }
        }
        this.processActivityValidityPeriod(nodeID, node);
        return node;
    }

    protected NodeMapping<LabeledTimePoint> transformActivityBasic(int nodeID, IterationChain iterationChain, Label branches) {
        if (this.template.getNodeType(nodeID) != ProcessConstants.NodeType.NT_NORMAL) {
            throw new IllegalArgumentException("" + this.template.getNodeType(nodeID));
        }
        int topologicalID = this.template.getNodeTopologicalID(nodeID);
        NodeInstance nodeInstance = new NodeInstance(nodeID, iterationChain, topologicalID);
        LabeledTimePoint A_S = this.createTCNNode(nodeInstance, "S", branches);
        LabeledTimePoint A_E = this.createTCNNode(nodeInstance, "E", branches);
        this.addNode(A_S);
        this.addNode(A_E);
        ContingentActivityDuration contigentDuration = this.getActivityDuration(nodeID);
        DefaultLabeledEdge minEdge = new DefaultLabeledEdge(A_S, A_E, new DefaultLabeledValueSet(new DefaultContingentLabeledValue(branches, ContingentLabeledValue.ConstraintCase.LOWERCASE, contigentDuration.maxDuration, A_E, contigentDuration.minGuard)), true, false, TCNEdge.FlowDirection.BACKWARD);
        this.addEdge(minEdge);
        DefaultLabeledEdge maxEdge = new DefaultLabeledEdge(A_E, A_S, new DefaultLabeledValueSet(new DefaultContingentLabeledValue(branches, ContingentLabeledValue.ConstraintCase.UPPERCASE, contigentDuration.minGuard.neg(), A_E, contigentDuration.maxGuard.neg())), true, false, TCNEdge.FlowDirection.FORWARD);
        this.addEdge(maxEdge);
        NodeMapping node = new NodeMapping(this.getNodeName(nodeID), nodeInstance, (TCNTimePoint)A_S, null, (TCNTimePoint)A_E);
        return this.addNodeMapping(node);
    }

    protected NodeMapping<LabeledTimePoint> transformActivityAdvanced(int nodeID, IterationChain iterationChain, Label branches) {
        if (this.template.getNodeType(nodeID) != ProcessConstants.NodeType.NT_NORMAL) {
            throw new IllegalArgumentException("" + this.template.getNodeType(nodeID));
        }
        int topologicalID = this.template.getNodeTopologicalID(nodeID);
        NodeInstance nodeInstance = new NodeInstance(nodeID, iterationChain, topologicalID);
        LabeledTimePoint A_S = this.createTCNNode(nodeInstance, "S", branches);
        LabeledTimePoint A_C = this.createTCNNode(nodeInstance, "C", branches);
        LabeledTimePoint A_E = this.createTCNNode(nodeInstance, "E", branches);
        this.addNode(A_S);
        this.addNode(A_C);
        this.addNode(A_E);
        ContingentActivityDuration duration = this.getActivityDuration(nodeID);
        TimeDistance contingentMinValue = duration.minGuard;
        TimeDistance contingentMaxValue = duration.maxGuard;
        if (contingentMinValue.isInfinity()) {
            contingentMinValue = this.NODE_MIN_DURATION;
        }
        if (contingentMaxValue.isInfinity()) {
            contingentMaxValue = contingentMinValue;
        }
        LabeledEdge maxEdge = new DefaultLabeledEdge(A_S, A_C, new DefaultLabeledValueSet(new DefaultContingentLabeledValue(branches, ContingentLabeledValue.ConstraintCase.LOWERCASE, contingentMaxValue, A_C, contingentMinValue)), true, false, TCNEdge.FlowDirection.FORWARD);
        maxEdge = this.addEdge(maxEdge);
        LabeledEdge minEdge = new DefaultLabeledEdge(A_C, A_S, new DefaultLabeledValueSet(new DefaultContingentLabeledValue(branches, ContingentLabeledValue.ConstraintCase.UPPERCASE, contingentMinValue.neg(), A_C, contingentMaxValue.neg())), true, false, TCNEdge.FlowDirection.BACKWARD);
        minEdge = this.addEdge(minEdge);
        this.createTCNEdge(A_C, A_E, branches, DefaultTimeDistance.ZERO_TIME_DISTANCE, duration.maxDuration.sub(contingentMinValue), true);
        this.createTCNEdge(A_S, A_E, branches, DefaultTimeDistance.ZERO_TIME_DISTANCE, duration.maxDuration, true);
        NodeMapping node = new NodeMapping(this.getNodeName(nodeID), nodeInstance, (TCNTimePoint)A_S, (TCNTimePoint[])new LabeledTimePoint[]{A_C}, (TCNTimePoint)A_E);
        return this.addNodeMapping(node);
    }

    @Override
    protected JoinNodeMapping<LabeledTimePoint> transformANDJoin(int nodeID, IterationChain iterationChain, Label branches) {
        if (this.template.getNodeType(nodeID) != ProcessConstants.NodeType.NT_AND_JOIN) {
            throw new IllegalArgumentException("" + this.template.getNodeType(nodeID));
        }
        int[] preds = this.template.getPredByEdgeType(nodeID, new ProcessConstants.EdgeType[]{ProcessConstants.EdgeType.ET_CONTROL});
        TCNTimePoint[] nodes = new LabeledTimePoint[preds.length];
        int topologicalID = this.template.getNodeTopologicalID(nodeID);
        NodeInstance nodeInstance = new NodeInstance(nodeID, iterationChain, topologicalID);
        int i = 0;
        while (i < preds.length) {
            LabeledTimePoint waitNode = this.createTCNNode(nodeInstance, "w_{" + i + "}", branches);
            this.addNode(waitNode);
            nodes[i] = waitNode;
            ++i;
        }
        LabeledTimePoint A_S = this.createTCNNode(nodeInstance, "S", branches);
        LabeledTimePoint A_E = this.createTCNNode(nodeInstance, "E", branches);
        this.addNode(A_S);
        this.addNode(A_E);
        int i2 = 0;
        while (i2 < preds.length) {
            LabeledTimePoint waitNode = nodes[i2];
            this.createTCNEdge(waitNode, A_S, branches, this.CONTROL_FLOW_MIN_TIME_LAG, this.CONTROL_FLOW_MAX_TIME_LAG, true);
            ++i2;
        }
        this.createTCNEdge(A_S, A_E, branches, this.STRUCTURE_NODE_MIN_DURATION, this.STRUCTURE_NODE_MAX_DURATION, true);
        return this.addNodeMapping(new JoinNodeMapping(this.getNodeName(nodeID), nodeInstance, nodes, (TCNTimePoint)A_S, null, (TCNTimePoint)A_E));
    }

    @Override
    protected LabeledEdge mergeEdges(LabeledEdge e1, LabeledEdge e2) {
        LabeledEdge mergedEdge = super.mergeEdges(e1, e2);
        assert (((LabeledValueSet)mergedEdge.getValue()).getLabeledValues().size() == 1);
        return mergedEdge;
    }

    protected static class ContingentActivityDuration
    extends TCNTransformation.TCNActivityDuration {
        public final TimeDistance minGuard;
        public final TimeDistance maxGuard;

        public ContingentActivityDuration(TimeDistance minDuration, TimeDistance maxDuration, TimeDistance minGuard, TimeDistance maxGuard) {
            super(minDuration, maxDuration);
            this.minGuard = minGuard;
            this.maxGuard = maxGuard;
        }
    }
}

