/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.timemodel.tcn.cstnuImpl;

import de.aristaflow.adept2.model.processmodel.Instance;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.TemporalTemplate;
import de.aristaflow.adept2.model.processmodel.defaultimplementation.DefaultTemporalTemplate;
import de.aristaflow.adept2.model.timemodel.InstanceTimeContext;
import de.aristaflow.adept2.model.timemodel.InstanceTimeModel;
import de.aristaflow.adept2.model.timemodel.TemplateTimeModel;
import de.aristaflow.adept2.model.timemodel.TimeModel;
import de.aristaflow.adept2.model.timemodel.TimeModelFactory;
import de.aristaflow.adept2.model.timemodel.TimeModelOperations;
import de.aristaflow.adept2.model.timemodel.TimeModelSolver;
import de.aristaflow.adept2.model.timemodel.defaultimplementation.DefaultTimeModelOperations;
import de.aristaflow.adept2.model.timemodel.defaultimplementation.TimeModelTools;
import de.aristaflow.adept2.model.timemodel.tcn.CSTNU;
import de.aristaflow.adept2.model.timemodel.tcn.ChangeableCSTNU;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledTimePoint;
import de.aristaflow.adept2.model.timemodel.tcn.cstnuImpl.CSTNUInstanceTimeModel;
import de.aristaflow.adept2.model.timemodel.tcn.cstnuImpl.CSTNUTemplateTimeModel;
import de.aristaflow.adept2.model.timemodel.tcn.cstnuImpl.CSTNUTemplateTransformation;
import de.aristaflow.adept2.model.timemodel.tcn.cstnuImpl.DCCSTNUTemplateTimeModelSolver;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.Configuration;

public class CSTNUTimeModelFactory
implements TimeModelFactory {
    protected final Configuration configuration;

    public CSTNUTimeModelFactory() {
        this.configuration = new BaseConfiguration();
        this.configuration.setProperty("TCNTransformation.AdvancedActivityTransformation", (Object)0);
    }

    public CSTNUTimeModelFactory(Configuration configuration) {
        this.configuration = configuration;
    }

    @Override
    public TemplateTimeModel createTimeModelForTemplate(TemporalTemplate template) {
        CSTNUTemplateTransformation trafo = new CSTNUTemplateTransformation(this.configuration, template);
        CSTNU cstnu = trafo.transform();
        Map<Integer, List<URI>> updateTriggers = TimeModelTools.createUpdateTriggerMapping(template);
        return new CSTNUTemplateTimeModel((Template)template, cstnu, trafo.getNodeMapping(), (LabeledTimePoint)trafo.getProcessCreationTimePoint(), (LabeledTimePoint)trafo.getProcessStartTimePoint(), (LabeledTimePoint)trafo.getProcessEndTimePoint(), updateTriggers);
    }

    @Override
    public InstanceTimeModel createTimeModelForInstance(Instance instance, InstanceTimeContext timeContext, TemplateTimeModel templateTimeModel) {
        UUID instanceID;
        CSTNUTemplateTimeModel timeModel = (CSTNUTemplateTimeModel)templateTimeModel;
        UUID uUID = instanceID = instance != null ? instance.getID() : null;
        assert (instance == null || instance.getTemplate().getID() == templateTimeModel.getTemplateID());
        return new CSTNUInstanceTimeModel(instanceID, templateTimeModel.getTemplateID(), (ChangeableCSTNU)timeModel.getBaseTimeModel().clone(), timeModel.getNodeMapping(), (LabeledTimePoint)timeModel.getProcessCreationTimePoint(), (LabeledTimePoint)timeModel.getProcessStartTimePoint(), (LabeledTimePoint)timeModel.getProcessEndTimePoint(), timeModel.getUpdateTriggers());
    }

    @Override
    public TimeModelOperations getTimeModelOperations() {
        return new DefaultTimeModelOperations();
    }

    @Override
    public void setCreateChangeable(boolean changeable) {
    }

    @Override
    public TemporalTemplate createTemporalTemplate(Template template) {
        return new DefaultTemporalTemplate(template);
    }

    @Override
    public TimeModelSolver getTimeModelSolver(Class<? extends TimeModel> clazz) {
        return new DCCSTNUTemplateTimeModelSolver();
    }
}

