/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.timemodel.tcn.cstnuImpl;

import de.aristaflow.adept2.model.common.timedata.TimeDistance;
import de.aristaflow.adept2.model.common.timedata.defaultimplementation.DefaultTimeDistance;
import de.aristaflow.adept2.model.timemodel.tcn.CSTN;
import de.aristaflow.adept2.model.timemodel.tcn.CSTNU;
import de.aristaflow.adept2.model.timemodel.tcn.ChangeableCSTNU;
import de.aristaflow.adept2.model.timemodel.tcn.Label;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledEdge;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledTimePoint;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledValue;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledValueSet;
import de.aristaflow.adept2.model.timemodel.tcn.ObservationTimePoint;
import de.aristaflow.adept2.model.timemodel.tcn.TCNEdge;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.AbstractTCN;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.ContingentLabeledValue;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.DefaultLabeledEdge;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.DefaultLabeledValue;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.DefaultLabeledValueSet;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.DefaultObservationTimePoint;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.ObservationBinding;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.Proposition;
import de.aristaflow.adept2.util.NullArgumentException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DefaultCSTNU
extends AbstractTCN<LabeledTimePoint, LabeledValueSet, LabeledEdge>
implements Cloneable,
CSTN,
CSTNU,
ChangeableCSTNU {
    public static boolean CONNECT_OBSERVATION_NODES = true;
    private final List<Label.ChoiceVariable> observations;
    private boolean controllable;

    public DefaultCSTNU(Collection<LabeledTimePoint> nodes, Collection<LabeledEdge> edges, Collection<Label.ChoiceVariable> labels) {
        super(nodes, edges);
        this.observations = new ArrayList<Label.ChoiceVariable>(labels);
    }

    @Override
    public void init() {
        if (CONNECT_OBSERVATION_NODES) {
            Collection nodes = this.getTimePoints();
            for (LabeledTimePoint node : nodes) {
                Label lbl = node.getLabel();
                Proposition proposition = (Proposition)lbl;
                for (ObservationBinding observation : proposition.getObservations()) {
                    DefaultObservationTimePoint observationNode = observation.getVariable().getDecisionTimePoint();
                    LabeledEdge edge = (LabeledEdge)this.getEdge(node, observationNode);
                    if (edge != null) continue;
                    this.updateConstraint(new DefaultLabeledEdge(node, observationNode, new DefaultLabeledValueSet(new DefaultLabeledValue(node.getLabel(), DefaultTimeDistance.EPSILON_TIME_DISTANCE.neg())), false, true, TCNEdge.FlowDirection.BACKWARD));
                }
            }
        }
    }

    @Override
    protected boolean checkConsistency(LabeledEdge tcnEdge1, LabeledEdge tcnEdge2) {
        if (tcnEdge1 != null && tcnEdge2 != null) {
            Collection<LabeledValue> lvs1 = ((LabeledValueSet)tcnEdge1.getValue()).getLabeledValues();
            Collection<LabeledValue> lvs2 = ((LabeledValueSet)tcnEdge2.getValue()).getLabeledValues();
            for (LabeledValue lv1 : lvs1) {
                this.checkConsistency(tcnEdge1, lv1);
                lv1.getValue();
                for (LabeledValue lv2 : lvs2) {
                    this.checkConsistency(tcnEdge2, lv2);
                    lv2.getValue();
                    if (!lv1.getLabel().satisfiable(lv2.getLabel()) || !(lv1 instanceof ContingentLabeledValue) || !(lv2 instanceof ContingentLabeledValue)) continue;
                    ContingentLabeledValue cfr_ignored_0 = (ContingentLabeledValue)lv1;
                    ContingentLabeledValue cfr_ignored_1 = (ContingentLabeledValue)lv2;
                }
            }
            return true;
        }
        return true;
    }

    protected void checkConsistency(LabeledEdge tcnEdge1, LabeledValue lv1) {
        if (!lv1.getLabel().subsumes(((LabeledTimePoint)tcnEdge1.getSourceNode()).getLabel())) {
            throw new IllegalStateException(String.format("!(%s => %s) for %s for %s", lv1.getLabel(), ((LabeledTimePoint)tcnEdge1.getSourceNode()).getLabel(), tcnEdge1, tcnEdge1.getSourceNode()));
        }
        if (!lv1.getLabel().subsumes(((LabeledTimePoint)tcnEdge1.getTargetNode()).getLabel())) {
            throw new IllegalStateException(String.format("!(%s => %s) for %s for %s", lv1.getLabel(), ((LabeledTimePoint)tcnEdge1.getTargetNode()).getLabel(), tcnEdge1, tcnEdge1.getTargetNode()));
        }
    }

    @Override
    protected boolean doCheckConsistency(LabeledEdge edge1, LabeledEdge edge2) {
        LabeledValueSet dir = (LabeledValueSet)edge1.getValue();
        LabeledValueSet inverseDir = (LabeledValueSet)edge2.getValue();
        Collection<LabeledValue> lvs1 = dir.getLabeledValues();
        Collection<LabeledValue> lvs2 = inverseDir.getLabeledValues();
        for (LabeledValue lv1 : lvs1) {
            TimeDistance v1 = lv1.getValue();
            for (LabeledValue lv2 : lvs2) {
                TimeDistance v2 = lv2.getValue();
                if (!lv1.getLabel().satisfiable(lv2.getLabel())) continue;
                if (v1.compareTo(v2.neg()) < 0) {
                    throw new IllegalStateException();
                }
                if (!(lv1 instanceof ContingentLabeledValue) || !(lv2 instanceof ContingentLabeledValue)) continue;
                ContingentLabeledValue clv1 = (ContingentLabeledValue)lv1;
                ContingentLabeledValue clv2 = (ContingentLabeledValue)lv2;
                if (clv1.getContingentValue().compareTo(clv2.getContingentValue().neg()) <= 0) continue;
                throw new IllegalStateException();
            }
            if (!lv1.getLabel().satisfiable(lv1.getLabel())) {
                throw new IllegalStateException();
            }
            if (!lv1.getLabel().subsumes(((LabeledTimePoint)edge1.getSourceNode()).getLabel())) {
                throw new IllegalStateException();
            }
            if (!lv1.getLabel().subsumes(((LabeledTimePoint)edge1.getTargetNode()).getLabel())) {
                throw new IllegalStateException();
            }
            Proposition prop = (Proposition)lv1.getLabel();
            for (ObservationBinding observation : prop.getObservations()) {
                DefaultObservationTimePoint observationNode = observation.getVariable().getDecisionTimePoint();
                if (lv1.getLabel().subsumes(observationNode.getLabel())) continue;
                throw new IllegalStateException();
            }
        }
        return true;
    }

    @Override
    protected boolean doCheckConsistency(LabeledTimePoint node) {
        Proposition proposition = (Proposition)node.getLabel();
        for (ObservationBinding observation : proposition.getObservations()) {
            DefaultObservationTimePoint observationNode = observation.getVariable().getDecisionTimePoint();
            if (!proposition.subsumes(observationNode.getLabel())) {
                throw new IllegalStateException();
            }
            if (!CONNECT_OBSERVATION_NODES) continue;
            LabeledEdge edge = (LabeledEdge)this.getEdge(node, observationNode);
            if (edge == null) {
                throw new IllegalStateException();
            }
            for (LabeledValue value : ((LabeledValueSet)edge.getValue()).getLabeledValues()) {
                if (value.getValue().compareTo(DefaultTimeDistance.ZERO_TIME_DISTANCE) < 0) continue;
                throw new IllegalStateException();
            }
        }
        return true;
    }

    @Override
    public LabeledEdge updateConstraint(LabeledEdge edge) {
        int target;
        if (edge == null) {
            throw new NullArgumentException();
        }
        assert (((LabeledValueSet)edge.getValue()).subsumes(((LabeledTimePoint)edge.getSourceNode()).getLabel()));
        assert (((LabeledValueSet)edge.getValue()).subsumes(((LabeledTimePoint)edge.getTargetNode()).getLabel()));
        int source = this.getNodeKey((LabeledTimePoint)edge.getSourceNode());
        LabeledEdge old = (LabeledEdge)this.internalGetConstraint(source, target = this.getNodeKey((LabeledTimePoint)edge.getTargetNode()));
        if (old != null && old.isContingentDuration()) {
            ContingentLabeledValue oldValue = this.getContingentLabeledValue(old);
            ContingentLabeledValue newValue = this.getContingentLabeledValue(edge);
            if (!oldValue.getContingentValue().equals(newValue.getContingentValue())) {
                throw new IllegalArgumentException("Updating contingent duration constraints is not allowed!");
            }
        } else if (edge.isContingentDuration()) {
            throw new IllegalArgumentException("Adding contingent duration constraints is not allowed!");
        }
        this.internalSetConstraint(source, target, edge);
        return edge;
    }

    public ContingentLabeledValue getContingentLabeledValue(LabeledEdge edge) {
        Collection<LabeledValue> labeledValues = ((LabeledValueSet)edge.getValue()).getLabeledValues();
        assert (labeledValues.size() == 1);
        LabeledValue labeledValue = labeledValues.iterator().next();
        assert (labeledValue instanceof ContingentLabeledValue);
        return (ContingentLabeledValue)labeledValue;
    }

    @Override
    public LabeledEdge updateContingentConstraint(LabeledEdge edge) {
        int source = this.getNodeKey((LabeledTimePoint)edge.getSourceNode());
        int target = this.getNodeKey((LabeledTimePoint)edge.getTargetNode());
        this.internalSetConstraint(source, target, edge);
        return edge;
    }

    @Override
    public ChangeableCSTNU clone() {
        DefaultCSTNU cstnu = new DefaultCSTNU(this.getTimePoints(), this.getEdges(), this.getObservations());
        if (this.isConsistent()) {
            cstnu.setConsistent();
        }
        if (this.isControllable()) {
            cstnu.setControllable();
        }
        return cstnu;
    }

    @Override
    public LabeledTimePoint getTimeBaseEvent() {
        return TIMEBASE_NODE;
    }

    @Override
    public List<Label.ChoiceVariable> getObservations() {
        return this.observations;
    }

    @Override
    public void setControllable() {
        this.controllable = true;
        this.setConsistent();
    }

    @Override
    public boolean isControllable() {
        return this.controllable;
    }

    @Override
    public void modified() {
        super.modified();
        this.controllable = false;
    }

    @Override
    public LabeledTimePoint insertTimePoint(LabeledTimePoint node) {
        LabeledTimePoint timePoint = super.insertTimePoint(node);
        if (timePoint instanceof ObservationTimePoint) {
            this.observations.add(((ObservationTimePoint)timePoint).getChoiceVariable());
        }
        return timePoint;
    }

    @Override
    public void removeTimePoint(LabeledTimePoint node) throws IllegalStateException {
        if (node instanceof ObservationTimePoint) {
            this.observations.remove(((ObservationTimePoint)node).getChoiceVariable());
        }
        super.removeTimePoint(node);
    }
}

