/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.timemodel.tcn.cstnuImpl;

import de.aristaflow.adept2.model.common.timedata.TimeDistance;
import de.aristaflow.adept2.model.common.timedata.defaultimplementation.DefaultTimeDistance;
import de.aristaflow.adept2.model.timemodel.tcn.CSTNU;
import de.aristaflow.adept2.model.timemodel.tcn.ChangeableCSTNU;
import de.aristaflow.adept2.model.timemodel.tcn.ExecutableCSTNU;
import de.aristaflow.adept2.model.timemodel.tcn.Label;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledEdge;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledTimePoint;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledValue;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledValueSet;
import de.aristaflow.adept2.model.timemodel.tcn.ObservationTimePoint;
import de.aristaflow.adept2.model.timemodel.tcn.SimpleConstraintValue;
import de.aristaflow.adept2.model.timemodel.tcn.TCN;
import de.aristaflow.adept2.model.timemodel.tcn.TCNEdge;
import de.aristaflow.adept2.model.timemodel.tcn.TCNInconsistencyException;
import de.aristaflow.adept2.model.timemodel.tcn.TCNSolver;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.ContingentLabeledValue;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.DefaultLabeledEdge;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.DefaultLabeledValue;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.DefaultLabeledValueSet;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.Proposition;
import de.aristaflow.adept2.model.timemodel.tools.GraphVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DefaultExecutableCSTNU
implements ExecutableCSTNU {
    private Label scenario;
    private ChangeableCSTNU coreCSTNU;
    private Map<LabeledTimePoint, LabeledTimePoint> contingentTimePoints;
    private Set<LabeledTimePoint> executedTimePoints;
    private LabeledTimePoint origin;
    private Set<LabeledTimePoint> activeTimePoints;
    private TCNSolver<LabeledTimePoint, LabeledValueSet, LabeledEdge> solver;
    private Map<LabeledTimePoint, Set<LabeledTimePoint>> predecessors;
    private HashMap<LabeledTimePoint, Set<LabeledTimePoint>> successors;

    public DefaultExecutableCSTNU(ChangeableCSTNU coreCSTNU, TCNSolver<LabeledTimePoint, LabeledValueSet, LabeledEdge> solver, long timeStamp) throws TCNInconsistencyException {
        if (!coreCSTNU.isControllable()) {
            throw new IllegalArgumentException();
        }
        this.scenario = Proposition.EMPTY_PROPOSITION;
        this.coreCSTNU = (ChangeableCSTNU)coreCSTNU.clone();
        this.solver = solver;
        this.executedTimePoints = new HashSet<LabeledTimePoint>();
        this.contingentTimePoints = this.getContingentTimePoints(this.coreCSTNU);
        this.origin = (LabeledTimePoint)this.coreCSTNU.getTimeBaseEvent();
        this.executedTimePoints.add(this.origin);
        this.initializePartialOrder(this.coreCSTNU);
        assert (!this.predecessors.containsKey(this.origin));
        TimeDistance now = this.toTimeDistance(timeStamp);
        this.updateNow(now);
        this.propagate();
        this.activeTimePoints = new HashSet<LabeledTimePoint>();
        this.activeTimePoints.addAll(this.updatePartialOrder(this.origin));
    }

    protected List<LabeledTimePoint> updatePartialOrder(LabeledTimePoint tp) {
        ArrayList<LabeledTimePoint> newRoot = new ArrayList<LabeledTimePoint>();
        for (LabeledTimePoint succ : this.successors.get(tp)) {
            Set<LabeledTimePoint> set = this.predecessors.get(succ);
            set.remove(tp);
            if (!set.isEmpty()) continue;
            this.predecessors.remove(succ);
            newRoot.add(succ);
        }
        return newRoot;
    }

    private void initializePartialOrder(TCN<LabeledTimePoint, LabeledEdge> cstnu) {
        this.predecessors = new HashMap<LabeledTimePoint, Set<LabeledTimePoint>>();
        this.successors = new HashMap();
        for (LabeledTimePoint tp : cstnu.getTimePoints()) {
            for (LabeledTimePoint pred : cstnu.getTimePoints()) {
                TimeDistance dist;
                LabeledEdge edge = cstnu.getEdge(tp, pred);
                if (edge == null || (dist = this.minValue(edge)).compareTo(DefaultTimeDistance.ZERO_TIME_DISTANCE) >= 0) continue;
                Set<LabeledTimePoint> set = this.predecessors.get(tp);
                if (set == null) {
                    set = new HashSet<LabeledTimePoint>();
                    this.predecessors.put(tp, set);
                }
                set.add(pred);
                set = this.successors.get(pred);
                if (set == null) {
                    set = new HashSet<LabeledTimePoint>();
                    this.successors.put(pred, set);
                }
                set.add(tp);
            }
        }
    }

    private TimeDistance minValue(LabeledEdge edge) {
        TimeDistance min = DefaultTimeDistance.POSITIVE_INFINITE_TIME_DISTANCE;
        SimpleConstraintValue[] simpleConstraintValueArray = ((LabeledValueSet)edge.getValue()).getValues();
        int n = simpleConstraintValueArray.length;
        int n2 = 0;
        while (n2 < n) {
            SimpleConstraintValue value = simpleConstraintValueArray[n2];
            if (min.compareTo(value.getValue()) > 0) {
                min = value.getValue();
            }
            ++n2;
        }
        return min;
    }

    protected boolean propagate() throws TCNInconsistencyException {
        try {
            this.solver.solve(this.coreCSTNU);
            return true;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
    }

    protected Map<LabeledTimePoint, LabeledTimePoint> getContingentTimePoints(CSTNU coreCSTNU) {
        HashMap<LabeledTimePoint, LabeledTimePoint> contingentTimePoints = new HashMap<LabeledTimePoint, LabeledTimePoint>();
        for (LabeledEdge edge : coreCSTNU.getEdges()) {
            for (LabeledValue value : ((LabeledValueSet)edge.getValue()).getLabeledValues()) {
                if (!(value instanceof ContingentLabeledValue)) continue;
                ContingentLabeledValue contingentLabeledValue = (ContingentLabeledValue)value;
                LabeledTimePoint trigger = contingentLabeledValue.getTrigger();
                if (ContingentLabeledValue.ConstraintCase.LOWERCASE.equals((Object)contingentLabeledValue.getCase())) {
                    contingentTimePoints.put(trigger, (LabeledTimePoint)edge.getSourceNode());
                    continue;
                }
                contingentTimePoints.put(trigger, (LabeledTimePoint)edge.getTargetNode());
            }
        }
        return contingentTimePoints;
    }

    protected Collection<LabeledTimePoint> getNextTimePoints() {
        ArrayList<LabeledTimePoint> tp = new ArrayList<LabeledTimePoint>(this.coreCSTNU.getTimePoints());
        tp.removeAll(this.predecessors.keySet());
        return tp;
    }

    protected TimeDistance toTimeDistance(long now) {
        return new DefaultTimeDistance(now, 0L, 0L, 0L, 0L, 0L);
    }

    protected void updateNow(TimeDistance now) {
        DefaultLabeledValue labeledValue = new DefaultLabeledValue(Proposition.EMPTY_PROPOSITION, now.neg());
        for (LabeledTimePoint timePoint : this.coreCSTNU.getTimePoints()) {
            LabeledEdge edge = (LabeledEdge)this.coreCSTNU.getEdge(timePoint, this.origin);
            if (edge == null) {
                this.coreCSTNU.updateConstraint(new DefaultLabeledEdge(timePoint, this.origin, new DefaultLabeledValueSet(labeledValue), false, true, TCNEdge.FlowDirection.BACKWARD));
                continue;
            }
            Map<Label, LabeledValue> labeledValues = DefaultLabeledValueSet.toMap((LabeledValueSet)edge.getValue());
            DefaultLabeledValueSet.addOrReplaceIfNecessary(labeledValues, labeledValue);
            this.coreCSTNU.updateConstraint(this.replaceValues(edge, labeledValues.values()));
        }
    }

    protected TimeDistance scenarioProjection(LabeledEdge edge) {
        TimeDistance min = DefaultTimeDistance.POSITIVE_INFINITE_TIME_DISTANCE;
        for (LabeledValue value : ((LabeledValueSet)edge.getValue()).getLabeledValues()) {
            if (!value.getLabel().satisfiable(this.scenario) || value.getValue().compareTo(min) >= 0) continue;
            min = value.getValue();
        }
        return min;
    }

    @Override
    public Collection<LabeledTimePoint> getExecutableTimePoints(long now) {
        ArrayList<LabeledTimePoint> executable = new ArrayList<LabeledTimePoint>();
        TimeDistance currentTime = this.toTimeDistance(now).neg();
        for (LabeledTimePoint active : this.activeTimePoints) {
            LabeledEdge edge = (LabeledEdge)this.coreCSTNU.getEdge(active, this.origin);
            if (edge != null) {
                TimeDistance minTime = this.scenarioProjection(edge);
                if (minTime.compareTo(currentTime) < 0) continue;
                executable.add(active);
                continue;
            }
            executable.add(active);
        }
        return executable;
    }

    @Override
    public Collection<LabeledTimePoint> getActiveTimePoints() {
        return this.activeTimePoints;
    }

    @Override
    public void executeTimePoint(LabeledTimePoint timePoint, long now) throws TCNInconsistencyException {
        if (timePoint instanceof ObservationTimePoint) {
            throw new IllegalArgumentException();
        }
        this.internallyExecuteTimePoint(timePoint, now);
        this.propagate();
        this.activeTimePoints.remove(timePoint);
        this.activeTimePoints.addAll(this.updatePartialOrder(timePoint));
    }

    protected void internallyExecuteTimePoint(LabeledTimePoint timePoint, long now) throws TCNInconsistencyException {
        this.executedTimePoints.add(timePoint);
        TimeDistance currentTime = this.toTimeDistance(now);
        this.updateNow(currentTime);
        this.coreCSTNU.updateConstraint(new DefaultLabeledEdge(this.origin, timePoint, new DefaultLabeledValueSet(new DefaultLabeledValue(Proposition.EMPTY_PROPOSITION, currentTime))));
        this.coreCSTNU.updateConstraint(new DefaultLabeledEdge(timePoint, this.origin, new DefaultLabeledValueSet(new DefaultLabeledValue(Proposition.EMPTY_PROPOSITION, currentTime.neg()))));
        LabeledTimePoint activationTimePoint = this.contingentTimePoints.remove(timePoint);
        if (activationTimePoint != null) {
            for (LabeledTimePoint tp : this.coreCSTNU.getTimePoints()) {
                LabeledEdge edge = (LabeledEdge)this.coreCSTNU.getEdge(tp, activationTimePoint);
                ArrayList<LabeledValue> values = new ArrayList<LabeledValue>();
                boolean changes = false;
                for (LabeledValue value : ((LabeledValueSet)edge.getValue()).getLabeledValues()) {
                    if (value instanceof ContingentLabeledValue) {
                        assert (((ContingentLabeledValue)value).getTrigger() == timePoint);
                        values.add(new DefaultLabeledValue(value.getLabel(), ((ContingentLabeledValue)value).getSTNValue()));
                        changes = true;
                        continue;
                    }
                    values.add(value);
                }
                if (!changes) continue;
                DefaultLabeledEdge newEdge = new DefaultLabeledEdge(tp, activationTimePoint, new DefaultLabeledValueSet(values), edge.isControlEdge(), edge.isImplicit(), edge.getFlowDirection());
                this.coreCSTNU.updateContingentConstraint(newEdge);
            }
        }
    }

    @Override
    public void executeObservationTimePoint(ObservationTimePoint timePoint, long now, Label.ChoiceVariableBinding observation) throws TCNInconsistencyException {
        this.scenario = this.scenario.addVariableBinding(observation);
        this.purgeUnsatisfiableLabels();
        this.internallyExecuteTimePoint(timePoint, now);
        this.propagate();
        this.activeTimePoints.remove(timePoint);
        this.activeTimePoints.addAll(this.updatePartialOrder(timePoint));
    }

    private void purgeUnsatisfiableLabels() {
        Collection timePoints = this.coreCSTNU.getTimePoints();
        for (LabeledTimePoint tp1 : timePoints) {
            if (!tp1.getLabel().satisfiable(this.scenario)) {
                this.coreCSTNU.removeTimePoint(tp1);
                continue;
            }
            for (LabeledTimePoint tp2 : this.coreCSTNU.getTimePoints()) {
                LabeledEdge edge;
                LabeledEdge newEdge;
                if (!tp2.getLabel().satisfiable(this.scenario) || (newEdge = this.purgeUnsatisfiableLabels(edge = (LabeledEdge)this.coreCSTNU.getEdge(tp1, tp2))) == edge) continue;
                this.coreCSTNU.updateContingentConstraint(newEdge);
            }
        }
    }

    private LabeledEdge purgeUnsatisfiableLabels(LabeledEdge edge) {
        ArrayList<LabeledValue> values = new ArrayList<LabeledValue>(((LabeledValueSet)edge.getValue()).getLabeledValues());
        boolean changed = false;
        Iterator iterator = values.iterator();
        while (iterator.hasNext()) {
            LabeledValue value = (LabeledValue)iterator.next();
            if (value.getLabel().satisfiable(this.scenario)) continue;
            changed = true;
            iterator.remove();
        }
        if (changed) {
            return this.replaceValues(edge, values);
        }
        return edge;
    }

    protected DefaultLabeledEdge replaceValues(LabeledEdge edge, Collection<LabeledValue> values) {
        return new DefaultLabeledEdge((LabeledTimePoint)edge.getSourceNode(), (LabeledTimePoint)edge.getTargetNode(), new DefaultLabeledValueSet(values), edge.isControlEdge(), edge.isImplicit(), edge.getFlowDirection());
    }

    public ChangeableCSTNU getBaseTCN() {
        return this.coreCSTNU;
    }

    @Override
    public List<Label.ChoiceVariable> getObservations() {
        return this.getBaseTCN().getObservations();
    }

    @Override
    public boolean isControllable() {
        return this.getBaseTCN().isControllable();
    }

    @Override
    public Collection<LabeledTimePoint> getTimePoints() {
        return Collections.unmodifiableCollection(this.coreCSTNU.getTimePoints());
    }

    protected LabeledEdge transformEdge(LabeledTimePoint from, LabeledTimePoint to, LabeledEdge originalEdge) {
        if (this.coreCSTNU.contains(from) && this.coreCSTNU.contains(to)) {
            return originalEdge;
        }
        return null;
    }

    @Override
    public TCN<LabeledTimePoint, LabeledEdge> clone() {
        throw new UnsupportedOperationException();
    }

    @Override
    public LabeledEdge getEdge(LabeledTimePoint from, LabeledTimePoint to) {
        if (this.coreCSTNU.contains(from) && this.coreCSTNU.contains(to)) {
            return (LabeledEdge)this.coreCSTNU.getEdge(from, to);
        }
        return null;
    }

    @Override
    public LabeledTimePoint getTimeBaseEvent() {
        return (LabeledTimePoint)this.coreCSTNU.getTimeBaseEvent();
    }

    public boolean equals(Object obj) {
        return this.coreCSTNU.equals(obj);
    }

    public int hashCode() {
        return this.coreCSTNU.hashCode();
    }

    @Override
    public void visit(GraphVisitor<LabeledTimePoint, LabeledEdge> visitor) {
        visitor.discoverGraph(this);
        for (LabeledTimePoint e : this.getTimePoints()) {
            visitor.discoverVertex(e);
            visitor.finishVertex(e);
        }
        for (LabeledTimePoint ei : this.getTimePoints()) {
            for (LabeledTimePoint ej : this.getTimePoints()) {
                LabeledEdge e = this.getEdge(ei, ej);
                if (e == null) continue;
                visitor.discoverEdge((LabeledTimePoint)e.getSourceNode(), (LabeledTimePoint)e.getTargetNode(), e);
                visitor.finishEdge((LabeledTimePoint)e.getSourceNode(), (LabeledTimePoint)e.getTargetNode(), e);
            }
        }
        visitor.finishGraph(this);
    }

    @Override
    public Collection<LabeledEdge> getEdges() {
        ArrayList<LabeledEdge> edges = new ArrayList<LabeledEdge>();
        for (LabeledTimePoint from : this.getTimePoints()) {
            for (LabeledTimePoint to : this.getTimePoints()) {
                LabeledEdge edge = this.getEdge(from, to);
                if (edge == null) continue;
                edges.add(edge);
            }
        }
        return edges;
    }

    @Override
    public Collection<LabeledEdge> getIncomingEdges(LabeledTimePoint to) {
        Collection<LabeledTimePoint> timePoints = this.getTimePoints();
        ArrayList<LabeledEdge> edges = new ArrayList<LabeledEdge>(timePoints.size());
        for (LabeledTimePoint from : timePoints) {
            LabeledEdge edge = this.getEdge(from, to);
            if (edge == null) continue;
            edges.add(edge);
        }
        return edges;
    }

    @Override
    public Collection<LabeledEdge> getOutgoingEdges(LabeledTimePoint from) {
        Collection<LabeledTimePoint> timePoints = this.getTimePoints();
        ArrayList<LabeledEdge> edges = new ArrayList<LabeledEdge>(timePoints.size());
        for (LabeledTimePoint to : timePoints) {
            LabeledEdge edge = this.getEdge(from, to);
            if (edge == null) continue;
            edges.add(edge);
        }
        return edges;
    }

    public String toString() {
        return this.coreCSTNU.toString();
    }

    @Override
    public boolean isConsistent() {
        return this.coreCSTNU.isConsistent();
    }

    @Override
    public Collection<LabeledTimePoint> getVertices() {
        return this.getTimePoints();
    }

    @Override
    public boolean contains(LabeledTimePoint timePoint) {
        return this.coreCSTNU.contains(timePoint);
    }
}

