/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.timemodel.tcn.cstnuImpl;

import de.aristaflow.adept2.model.common.timedata.TimeDistance;
import de.aristaflow.adept2.model.common.timedata.defaultimplementation.DefaultTimeDistance;
import de.aristaflow.adept2.model.timemodel.tcn.ChangeableSTNU;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledEdge;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledTimePoint;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledValue;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledValueSet;
import de.aristaflow.adept2.model.timemodel.tcn.TCNEdge;
import de.aristaflow.adept2.model.timemodel.tcn.TCNInconsistencyException;
import de.aristaflow.adept2.model.timemodel.tcn.TCNSolver;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.ContingentLabeledValue;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.DefaultLabeledEdge;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.DefaultLabeledValue;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.DefaultLabeledValueSet;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.Proposition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class RTEDExecutionStrategy {
    protected final Logger logger = Logger.getLogger(this.getClass().getName());
    protected ChangeableSTNU<LabeledTimePoint, LabeledValueSet, LabeledEdge> stnu;
    protected Map<LabeledTimePoint, TimeDistance> partialSchedule = new HashMap<LabeledTimePoint, TimeDistance>();
    protected TimeDistance maximumExecutionTime;
    protected HashSet<LabeledTimePoint> unexecutedTimePoints;
    protected HashSet<LabeledTimePoint> nonContUnexecutedTimePoints;
    protected HashSet<LabeledTimePoint> contUnexecutedTimePoints;
    protected HashSet<LabeledTimePoint> contActivatedUnexecutedTimePoints;
    protected TCNSolver<LabeledTimePoint, LabeledValueSet, LabeledEdge> solver;

    public RTEDExecutionStrategy(TCNSolver<LabeledTimePoint, LabeledValueSet, LabeledEdge> solver, ChangeableSTNU<LabeledTimePoint, LabeledValueSet, LabeledEdge> stnu) throws TCNInconsistencyException, InterruptedException {
        this.solver = solver;
        this.stnu = stnu;
        this.partialSchedule.put((LabeledTimePoint)this.stnu.getTimeBaseEvent(), DefaultTimeDistance.ZERO_TIME_DISTANCE);
        this.maximumExecutionTime = DefaultTimeDistance.ZERO_TIME_DISTANCE;
        this.unexecutedTimePoints = new HashSet(stnu.getVertices());
        this.unexecutedTimePoints.remove(this.stnu.getTimeBaseEvent());
        this.nonContUnexecutedTimePoints = new HashSet<LabeledTimePoint>(this.unexecutedTimePoints);
        this.contUnexecutedTimePoints = new HashSet();
        this.contActivatedUnexecutedTimePoints = new HashSet();
        for (LabeledEdge edge : stnu.getEdges()) {
            if (!edge.isContingentDuration()) continue;
            block5: for (LabeledValue v : ((LabeledValueSet)edge.getValue()).getLabeledValues()) {
                if (!(v instanceof ContingentLabeledValue)) continue;
                switch (((ContingentLabeledValue)v).getCase()) {
                    case UPPERCASE: {
                        this.nonContUnexecutedTimePoints.remove(edge.getSourceNode());
                        this.contUnexecutedTimePoints.add((LabeledTimePoint)edge.getSourceNode());
                        if (!((LabeledTimePoint)edge.getTargetNode()).equals(this.stnu.getTimeBaseEvent())) continue block5;
                        this.contActivatedUnexecutedTimePoints.add((LabeledTimePoint)edge.getSourceNode());
                        break;
                    }
                    case LOWERCASE: {
                        this.nonContUnexecutedTimePoints.remove(edge.getTargetNode());
                        this.contUnexecutedTimePoints.add((LabeledTimePoint)edge.getTargetNode());
                        if (!((LabeledTimePoint)edge.getSourceNode()).equals(this.stnu.getTimeBaseEvent())) continue block5;
                        this.activate(edge);
                        break;
                    }
                    default: {
                        throw new RuntimeException("Missing case: " + (Object)((Object)((ContingentLabeledValue)v).getCase()));
                    }
                }
            }
        }
        this.updateNow(DefaultTimeDistance.ZERO_TIME_DISTANCE);
        if (!stnu.isControllable()) {
            solver.solve(stnu);
        }
    }

    private void updateNow(TimeDistance now) {
        LabeledTimePoint Z = (LabeledTimePoint)this.stnu.getTimeBaseEvent();
        for (LabeledTimePoint tp : this.nonContUnexecutedTimePoints) {
            LabeledValueSet newValues;
            LabeledEdge edge = (LabeledEdge)this.stnu.getEdge(tp, Z);
            if (edge != null) {
                LabeledValueSet values = (LabeledValueSet)edge.getValue();
                newValues = values.addOrReplaceIfNecessary(new DefaultLabeledValue(Proposition.EMPTY_PROPOSITION, now.neg()));
            } else {
                newValues = new DefaultLabeledValueSet(new DefaultLabeledValue(Proposition.EMPTY_PROPOSITION, now.neg()));
            }
            DefaultLabeledEdge newEdge = new DefaultLabeledEdge(tp, Z, newValues, edge != null ? edge.isControlEdge() : false, edge != null ? edge.isImplicit() : true, edge != null ? edge.getFlowDirection() : TCNEdge.FlowDirection.BACKWARD);
            this.stnu.updateConstraint(newEdge);
        }
    }

    public ExecutionDecision getExecutionDecision() {
        ArrayList<LabeledTimePoint> goList = new ArrayList<LabeledTimePoint>();
        TimeDistance goTime = DefaultTimeDistance.POSITIVE_INFINITE_TIME_DISTANCE;
        if (this.nonContUnexecutedTimePoints.isEmpty()) {
            goList.clear();
            goTime = DefaultTimeDistance.POSITIVE_INFINITE_TIME_DISTANCE;
        } else {
            block0: for (LabeledTimePoint tp : this.nonContUnexecutedTimePoints) {
                TimeDistance lowerBound;
                LabeledEdge maxEdge = (LabeledEdge)this.stnu.getEdge((LabeledTimePoint)this.stnu.getTimeBaseEvent(), tp);
                LabeledEdge minEdge = (LabeledEdge)this.stnu.getEdge(tp, (LabeledTimePoint)this.stnu.getTimeBaseEvent());
                TimeDistance timeDistance = lowerBound = minEdge != null ? this.getValue(minEdge).neg() : DefaultTimeDistance.NEGATIVE_INFINITE_TIME_DISTANCE;
                if (maxEdge != null) {
                    this.getValue(maxEdge);
                }
                TimeDistance waits = DefaultTimeDistance.NEGATIVE_INFINITE_TIME_DISTANCE;
                for (LabeledEdge e : this.stnu.getOutgoingEdges(tp)) {
                    for (LabeledValue value : ((LabeledValueSet)e.getValue()).getLabeledValues()) {
                        if (value instanceof ContingentLabeledValue) {
                            ContingentLabeledValue contValue = (ContingentLabeledValue)value;
                            if (!ContingentLabeledValue.ConstraintCase.UPPERCASE.equals((Object)contValue.getCase())) continue;
                            if (this.contActivatedUnexecutedTimePoints.contains(contValue.getTrigger())) {
                                TimeDistance wait_i = contValue.getContingentValue().neg();
                                TimeDistance psiA_i = this.partialSchedule.get(e.getTargetNode());
                                waits = this.max(waits, psiA_i.add(wait_i));
                            } else if (!this.partialSchedule.containsKey(e.getTargetNode())) {
                                this.logger.warning("Activation time point of wait has not yet been executed!");
                                continue block0;
                            }
                        }
                        if (value.getValue().compareTo(DefaultTimeDistance.ZERO_TIME_DISTANCE) < 0 && this.unexecutedTimePoints.contains(e.getTargetNode())) continue block0;
                    }
                }
                TimeDistance go = this.max(lowerBound, waits);
                if (goTime.compareTo(go) > 0) {
                    goTime = go;
                    goList.clear();
                    goList.add(tp);
                    continue;
                }
                if (goTime.compareTo(go) != 0) continue;
                goList.add(tp);
            }
        }
        return new ExecutionDecision(goTime, goList);
    }

    public Collection<LabeledTimePoint> getActivatedContingents() {
        return this.contActivatedUnexecutedTimePoints;
    }

    public void execute(Collection<LabeledTimePoint> timepoints, TimeDistance now) throws TCNInconsistencyException, InterruptedException {
        DefaultLabeledValue maxValue = new DefaultLabeledValue(((LabeledTimePoint)this.stnu.getTimeBaseEvent()).getLabel(), now);
        DefaultLabeledValue minValue = new DefaultLabeledValue(((LabeledTimePoint)this.stnu.getTimeBaseEvent()).getLabel(), now.neg());
        for (LabeledTimePoint tp : timepoints) {
            this.partialSchedule.put(tp, now);
            this.unexecutedTimePoints.remove(tp);
            this.contUnexecutedTimePoints.remove(tp);
            this.nonContUnexecutedTimePoints.remove(tp);
            if (this.contActivatedUnexecutedTimePoints.remove(tp)) {
                this.executeContingentTimepoint(tp);
            }
            Collection outgoingEdges = this.stnu.getOutgoingEdges(tp);
            for (LabeledEdge edge : outgoingEdges) {
                if (!edge.isContingentDuration()) continue;
                this.activate(edge);
            }
            this.stnu.updateConstraint(new DefaultLabeledEdge((LabeledTimePoint)this.stnu.getTimeBaseEvent(), tp, new DefaultLabeledValueSet(maxValue)));
            this.stnu.updateConstraint(new DefaultLabeledEdge(tp, (LabeledTimePoint)this.stnu.getTimeBaseEvent(), new DefaultLabeledValueSet(minValue)));
        }
        this.updateNow(now);
        this.solver.solve(this.stnu);
    }

    protected void activate(LabeledEdge edge) {
        this.contActivatedUnexecutedTimePoints.add((LabeledTimePoint)edge.getTargetNode());
    }

    private void executeContingentTimepoint(LabeledTimePoint contingentTP) {
        Collection incomingEdges = this.stnu.getIncomingEdges(contingentTP);
        for (LabeledEdge edge : incomingEdges) {
            ContingentLabeledValue contValue;
            if (!edge.isContingentDuration() || !(contValue = (ContingentLabeledValue)((LabeledValueSet)edge.getValue()).getValues()[0]).getTrigger().equals(contingentTP)) continue;
            LabeledTimePoint activationTP = (LabeledTimePoint)edge.getSourceNode();
            LabeledEdge lowerCaseEdge = (LabeledEdge)this.stnu.getEdge(activationTP, contingentTP);
            LabeledValue value = this.getConstraintValue(lowerCaseEdge);
            this.stnu.updateContingentConstraint(new DefaultLabeledEdge(activationTP, contingentTP, new DefaultLabeledValueSet(new DefaultLabeledValue(value.getLabel(), value.getValue())), lowerCaseEdge.isControlEdge(), lowerCaseEdge.isImplicit(), lowerCaseEdge.getFlowDirection()));
            this.handleWaits(contingentTP, activationTP);
        }
    }

    private void handleWaits(LabeledTimePoint contingentTP, LabeledTimePoint activationTP) {
        Collection incomingEdges = this.stnu.getIncomingEdges(activationTP);
        for (LabeledEdge e : incomingEdges) {
            if (!e.isContingent()) continue;
            ArrayList<LabeledValue> values = new ArrayList<LabeledValue>();
            for (LabeledValue value : ((LabeledValueSet)e.getValue()).getLabeledValues()) {
                if (value instanceof ContingentLabeledValue) {
                    ContingentLabeledValue cValue = (ContingentLabeledValue)this.getConstraintValue(e);
                    if (cValue.getTrigger().equals(contingentTP)) {
                        values.add(new DefaultLabeledValue(cValue.getLabel(), cValue.getValue()));
                        continue;
                    }
                    values.add(value);
                    continue;
                }
                values.add(value);
            }
            this.stnu.updateContingentConstraint(new DefaultLabeledEdge((LabeledTimePoint)e.getSourceNode(), (LabeledTimePoint)e.getTargetNode(), new DefaultLabeledValueSet(values), e.isControlEdge(), e.isImplicit(), e.getFlowDirection()));
        }
    }

    protected TimeDistance max(TimeDistance v1, TimeDistance v2) {
        if (v1.compareTo(v2) < 0) {
            return v2;
        }
        return v1;
    }

    protected TimeDistance getValue(LabeledEdge minEdge) {
        return this.getConstraintValue(minEdge).getValue();
    }

    protected LabeledValue getConstraintValue(LabeledEdge minEdge) {
        return ((LabeledValueSet)minEdge.getValue()).getLabeledValues().iterator().next();
    }

    public static class ExecutionDecision {
        private TimeDistance goTime;
        private List<LabeledTimePoint> list;

        public ExecutionDecision(TimeDistance goTime, List<LabeledTimePoint> goList) {
            this.goTime = goTime;
            this.list = goList;
        }

        public TimeDistance getGoTime() {
            return this.goTime;
        }

        public List<LabeledTimePoint> getTimepoints() {
            return this.list;
        }

        public String toString() {
            return "ExecutionDecision [goTime=" + this.goTime + ", list=" + this.list + "]";
        }
    }
}

