/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation;

import de.aristaflow.adept2.model.timemodel.tcn.ChangeableTCN;
import de.aristaflow.adept2.model.timemodel.tcn.TCNEdge;
import de.aristaflow.adept2.model.timemodel.tcn.TCNTimePoint;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.AbstractProjection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractChangeableProjection<N extends TCNTimePoint, E extends TCNEdge<N, ?>, T extends TCNEdge<N, ?>>
extends AbstractProjection<N, E, T>
implements ChangeableTCN<N, T> {
    protected final boolean propagate;
    private TCNEdge<?, ?>[][] edges;
    private Map<N, Integer> nodeKeys;
    private int nextKey;

    public AbstractChangeableProjection(ChangeableTCN<N, E> tcn, boolean propagate) {
        super(tcn);
        this.propagate = propagate;
        int nodeCount = tcn.getTimePoints().size() + 1;
        this.edges = new TCNEdge[nodeCount][nodeCount];
        this.nodeKeys = new HashMap<N, Integer>();
        this.nextKey = 0;
    }

    @Override
    public ChangeableTCN<N, E> getBaseTCN() {
        return (ChangeableTCN)super.getBaseTCN();
    }

    @Override
    public Collection<T> getChanges() {
        return null;
    }

    @Override
    public T updateConstraint(T edge) {
        if (!this.propagate) {
            this.internalSetEdge(edge);
            this.changed();
            return edge;
        }
        return this.propagateUpdate(edge);
    }

    protected void internalSetEdge(T edge) {
        int fromID = this.getOrCreateNodeKey(edge.getSourceNode());
        int toID = this.getOrCreateNodeKey(edge.getTargetNode());
        this.edges[fromID][toID] = edge;
    }

    protected int getOrCreateNodeKey(N node) {
        Integer integer = this.nodeKeys.get(node);
        if (integer == null) {
            integer = this.nextKey++;
            this.nodeKeys.put(node, integer);
        }
        return integer;
    }

    protected int getNodeKey(N node) {
        Integer integer = this.nodeKeys.get(node);
        if (integer == null) {
            return this.nextKey;
        }
        return integer;
    }

    protected abstract T propagateUpdate(T var1);

    protected T internalGetEdge(N from, N to) {
        if (this.edges != null) {
            int fromID = this.getNodeKey(from);
            int toID = this.getNodeKey(to);
            return (T)this.edges[fromID][toID];
        }
        return null;
    }

    public void removeDelta(E edge) {
        if (this.edges != null) {
            int fromID = this.getNodeKey(edge.getSourceNode());
            int toID = this.getNodeKey(edge.getTargetNode());
            this.edges[fromID][toID] = null;
            this.changed();
        }
    }

    @Override
    public T getEdge(N from, N to) {
        T edge = this.internalGetEdge(from, to);
        if (edge != null) {
            return edge;
        }
        Object oldEdge = this.getBaseTCN().getEdge(this.getBaseNode(from), this.getBaseNode(to));
        if (oldEdge == null) {
            return null;
        }
        T transform = this.transformEdge(from, to, oldEdge);
        if (transform != null && transform != oldEdge) {
            this.internalSetEdge(transform);
        }
        return transform;
    }

    @Override
    public Collection<N> getTimePoints() {
        Collection baseNodes = super.getTimePoints();
        ArrayList<TCNTimePoint> nodes = new ArrayList<TCNTimePoint>(baseNodes.size());
        for (TCNTimePoint node : baseNodes) {
            TCNTimePoint transform = this.transformNode(node);
            if (transform == null) continue;
            nodes.add(transform);
        }
        return nodes;
    }

    protected N transformNode(N node) {
        return node;
    }

    protected N getBaseNode(N node) {
        return node;
    }

    protected abstract T transformEdge(N var1, N var2, E var3);
}

