/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation;

import de.aristaflow.adept2.model.timemodel.defaultimplementation.Path;
import de.aristaflow.adept2.model.timemodel.defaultimplementation.Triangle;
import de.aristaflow.adept2.model.timemodel.tcn.ConstraintDependencyGraph;
import de.aristaflow.adept2.model.timemodel.tcn.ConstraintValue;
import de.aristaflow.adept2.model.timemodel.tcn.TCN;
import de.aristaflow.adept2.model.timemodel.tcn.TCNEdge;
import de.aristaflow.adept2.model.timemodel.tcn.TCNTimePoint;
import de.aristaflow.adept2.model.timemodel.tools.DirectedGraph;
import de.aristaflow.adept2.model.timemodel.tools.GraphVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;

public abstract class AbstractConstraintDependencyGraph<N extends TCNTimePoint, E extends TCNEdge<N, T>, T extends ConstraintValue>
implements ConstraintDependencyGraph<E> {
    protected Level debugLevel = Level.OFF;
    private Set<E> nodes = new HashSet();
    private Set<Triangle<E>> edges = new HashSet<Triangle<E>>();

    public AbstractConstraintDependencyGraph(TCN<N, E> tcn) {
        if (!tcn.isConsistent()) {
            throw new IllegalArgumentException("TCN must be minimal in order to build a constraint dependency graph!");
        }
        this.nodes.addAll(tcn.getEdges());
        this.initGraph(tcn);
    }

    private void initGraph(TCN<N, E> tcn) {
        for (TCNTimePoint x : tcn.getTimePoints()) {
            for (TCNTimePoint z : tcn.getTimePoints()) {
                E c_xz;
                if (x == z || (c_xz = tcn.getEdge(x, z)) == null) continue;
                for (TCNTimePoint y : tcn.getTimePoints()) {
                    if (x == y || z == y) continue;
                    E c_xy = tcn.getEdge(x, y);
                    E c_yz = tcn.getEdge(y, z);
                    if (c_xy == null || c_yz == null) continue;
                    Object c_xyz = this.add(c_xy.getValue(), c_yz.getValue());
                    if (!this.equalBound(c_xz.getValue(), c_xyz)) continue;
                    this.edges.add(new Triangle<E>(new Path<E>(c_xy, c_yz), c_xz));
                }
            }
        }
    }

    protected abstract boolean equalBound(T var1, T var2);

    protected abstract T add(T var1, T var2);

    @Override
    public Collection<E> getVertices() {
        return Collections.unmodifiableCollection(this.nodes);
    }

    @Override
    public Collection<Object> getEdges() {
        return new ArrayList<Triangle<E>>(this.edges);
    }

    @Override
    public Object getEdge(E from, E to) {
        Path<E> o = new Path<E>(from, to);
        if (this.edges.contains(o)) {
            return o;
        }
        return null;
    }

    protected void debug(Level logLevel, String message) {
        if (logLevel.intValue() >= this.debugLevel.intValue()) {
            System.out.println(message);
        }
    }

    protected void debug(Level logLevel, String message, Object ... params) {
        this.debug(logLevel, String.format(message, params));
    }

    public String toString() {
        return this.edges.toString();
    }

    @Override
    public void visit(GraphVisitor<Object, Object> visitor) {
        GraphWrapper graph = new GraphWrapper(this);
        visitor.discoverGraph(graph);
        for (TCNEdge tCNEdge : this.nodes) {
            visitor.discoverVertex(tCNEdge);
            visitor.finishVertex(tCNEdge);
        }
        for (Triangle triangle : this.edges) {
            Path jointVertex = (Path)((Object)triangle.getFirst());
            visitor.discoverVertex((Object)jointVertex);
            visitor.discoverEdge(((Path)((Object)triangle.getFirst())).getFirst(), (Object)jointVertex, ((Path)((Object)triangle.getFirst())).getFirst());
            visitor.discoverEdge(((Path)((Object)triangle.getFirst())).getSecond(), (Object)jointVertex, ((Path)((Object)triangle.getFirst())).getSecond());
            visitor.discoverEdge((Object)jointVertex, triangle.getSecond(), "");
            visitor.finishEdge(((Path)((Object)triangle.getFirst())).getFirst(), (Object)jointVertex, ((Path)((Object)triangle.getFirst())).getFirst());
            visitor.finishEdge(((Path)((Object)triangle.getFirst())).getSecond(), (Object)jointVertex, ((Path)((Object)triangle.getFirst())).getSecond());
            visitor.finishEdge((Object)jointVertex, triangle.getSecond(), "");
            visitor.finishVertex((Object)jointVertex);
        }
        visitor.finishGraph(graph);
    }

    protected static final class GraphWrapper<E extends TCNEdge<?, ?>>
    implements DirectedGraph<Object, Object> {
        private final ConstraintDependencyGraph<E> graph;

        public GraphWrapper(ConstraintDependencyGraph<E> graph) {
            this.graph = graph;
        }

        @Override
        public Collection<Object> getVertices() {
            return new ArrayList<Object>(this.graph.getVertices());
        }

        @Override
        public Collection<Object> getEdges() {
            return new ArrayList<Object>(this.graph.getEdges());
        }

        @Override
        public Object getEdge(Object from, Object to) {
            return null;
        }

        @Override
        public void visit(GraphVisitor<Object, Object> visitor) {
        }
    }
}

