/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation;

import de.aristaflow.adept2.model.common.timedata.TimeDistance;
import de.aristaflow.adept2.model.processmodel.TemporalTemplate;
import de.aristaflow.adept2.model.timemodel.tcn.Label;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledEdge;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledTimePoint;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledValueSet;
import de.aristaflow.adept2.model.timemodel.tcn.TCNEdge;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.AbstractTemplateTransformation;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.DefaultLabeledEdge;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.DefaultLabeledValue;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.DefaultLabeledValueSet;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.Proposition;
import de.aristaflow.adept2.util.NullArgumentException;
import org.apache.commons.configuration.Configuration;

public abstract class AbstractLabeledTemplateTransformation
extends AbstractTemplateTransformation<LabeledEdge> {
    public AbstractLabeledTemplateTransformation(Configuration configuration, TemporalTemplate template) {
        super(configuration, template);
    }

    public AbstractLabeledTemplateTransformation(Configuration configuration, TemporalTemplate template, int lookAhead) {
        super(configuration, template, lookAhead);
    }

    @Override
    protected Label createInitialBranch() {
        return Proposition.EMPTY_PROPOSITION;
    }

    protected LabeledEdge[] createTCNEdge(LabeledTimePoint from, LabeledTimePoint to, Label branches, TimeDistance minValue, TimeDistance maxValue, boolean controlEdge) {
        if (minValue == null) {
            throw new NullArgumentException();
        }
        if (maxValue == null) {
            throw new NullArgumentException();
        }
        LabeledEdge minEdge = new DefaultLabeledEdge(to, from, new DefaultLabeledValueSet(new DefaultLabeledValue(branches, minValue.neg())), controlEdge, false, TCNEdge.FlowDirection.BACKWARD);
        minEdge = this.addEdge(minEdge);
        LabeledEdge maxEdge = new DefaultLabeledEdge(from, to, new DefaultLabeledValueSet(new DefaultLabeledValue(branches, maxValue)), controlEdge, false, TCNEdge.FlowDirection.FORWARD);
        maxEdge = this.addEdge(maxEdge);
        return new LabeledEdge[]{minEdge, maxEdge};
    }

    @Override
    protected LabeledEdge mergeEdges(LabeledEdge e1, LabeledEdge e2) {
        LabeledValueSet labeledValueSet = ((LabeledValueSet)e1.getValue()).merge((LabeledValueSet)e2.getValue());
        return new DefaultLabeledEdge((LabeledTimePoint)e1.getSourceNode(), (LabeledTimePoint)e2.getTargetNode(), labeledValueSet, e1.isControlEdge() || e2.isControlEdge(), e1.isImplicit() && e2.isImplicit(), e1.getFlowDirection() == e2.getFlowDirection() ? e1.getFlowDirection() : TCNEdge.FlowDirection.UNKOWN);
    }
}

