/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation;

import de.aristaflow.adept2.model.timemodel.tcn.TCN;
import de.aristaflow.adept2.model.timemodel.tcn.TCNEdge;
import de.aristaflow.adept2.model.timemodel.tcn.TCNTimePoint;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.Projection;
import de.aristaflow.adept2.model.timemodel.tools.GraphVisitor;
import java.util.ArrayList;
import java.util.Collection;

public abstract class AbstractProjection<N extends TCNTimePoint, E extends TCNEdge<N, ?>, T extends TCNEdge<N, ?>>
implements TCN<N, T>,
Projection<N, E, T>,
Cloneable {
    private final TCN<N, E> tcn;
    private boolean changes = false;

    public AbstractProjection(TCN<N, E> tcn) {
        this.tcn = tcn;
    }

    public int hashCode() {
        return this.tcn.hashCode();
    }

    @Override
    public N getTimeBaseEvent() {
        return this.tcn.getTimeBaseEvent();
    }

    protected void changed() {
        this.changes = false;
    }

    public boolean equals(Object obj) {
        return this.tcn.equals(obj);
    }

    @Override
    public void visit(GraphVisitor<N, T> visitor) {
        visitor.discoverGraph(this);
        for (TCNTimePoint e : this.getTimePoints()) {
            visitor.discoverVertex(e);
            visitor.finishVertex(e);
        }
        for (TCNTimePoint ei : this.getTimePoints()) {
            for (TCNTimePoint ej : this.getTimePoints()) {
                T e = this.getEdge((N)ei, (N)ej);
                if (e == null) continue;
                visitor.discoverEdge(e.getSourceNode(), e.getTargetNode(), e);
                visitor.finishEdge(e.getSourceNode(), e.getTargetNode(), e);
            }
        }
        visitor.finishGraph(this);
    }

    @Override
    public T getEdge(N from, N to) {
        return this.getEdge(from, to);
    }

    @Override
    public Collection<T> getEdges() {
        ArrayList<T> edges = new ArrayList<T>();
        for (TCNTimePoint from : this.getTimePoints()) {
            for (TCNTimePoint to : this.getTimePoints()) {
                T edge = this.getEdge((N)from, (N)to);
                if (edge == null) continue;
                edges.add(edge);
            }
        }
        return edges;
    }

    @Override
    public Collection<T> getIncomingEdges(N to) {
        Collection<N> timePoints = this.getTimePoints();
        ArrayList<T> edges = new ArrayList<T>(timePoints.size());
        for (TCNTimePoint from : timePoints) {
            T edge = this.getEdge((N)from, to);
            if (edge == null) continue;
            edges.add(edge);
        }
        return edges;
    }

    @Override
    public Collection<T> getOutgoingEdges(N from) {
        Collection<N> timePoints = this.getTimePoints();
        ArrayList<T> edges = new ArrayList<T>(timePoints.size());
        for (TCNTimePoint to : timePoints) {
            T edge = this.getEdge(from, (N)to);
            if (edge == null) continue;
            edges.add(edge);
        }
        return edges;
    }

    @Override
    public Collection<N> getTimePoints() {
        return this.tcn.getTimePoints();
    }

    @Override
    public boolean contains(N timePoint) {
        return this.getTimePoints().contains(timePoint);
    }

    public String toString() {
        return this.tcn.toString();
    }

    @Override
    public TCN<N, E> getBaseTCN() {
        return this.tcn;
    }

    @Override
    public boolean isConsistent() {
        return !this.changes && this.tcn.isConsistent();
    }

    public void setConsistent() {
        this.changes = false;
    }

    @Override
    public Collection<N> getVertices() {
        return this.getTimePoints();
    }

    @Override
    public abstract TCN<N, T> clone();

    public N insertTimePoint(N timePoint) {
        throw new UnsupportedOperationException();
    }

    public void removeTimePoint(N timePoint) {
        throw new UnsupportedOperationException();
    }
}

