/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation;

import de.aristaflow.adept2.model.common.timedata.TimeDistance;
import de.aristaflow.adept2.model.timemodel.ChangeSet;
import de.aristaflow.adept2.model.timemodel.defaultimplementation.Path;
import de.aristaflow.adept2.model.timemodel.defaultimplementation.Triangle;
import de.aristaflow.adept2.model.timemodel.tcn.ConstraintValue;
import de.aristaflow.adept2.model.timemodel.tcn.Label;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledValue;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledValueSet;
import de.aristaflow.adept2.model.timemodel.tcn.SimpleConstraintValue;
import de.aristaflow.adept2.model.timemodel.tcn.TCN;
import de.aristaflow.adept2.model.timemodel.tcn.TCNEdge;
import de.aristaflow.adept2.model.timemodel.tcn.TCNInconsistencyException;
import de.aristaflow.adept2.model.timemodel.tcn.TCNSolver;
import de.aristaflow.adept2.model.timemodel.tcn.TCNTimePoint;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.Proposition;
import java.util.Collection;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractSTNSolver<N extends TCNTimePoint, V extends ConstraintValue, E extends TCNEdge<N, V>>
implements TCNSolver<N, V, E> {
    protected Logger logger = Logger.getLogger(this.getClass().getName());

    public AbstractSTNSolver() {
    }

    public AbstractSTNSolver(Level debugLevel) {
        this.logger.setLevel(debugLevel);
    }

    protected void getInitialPaths(Collection<N> nodes, Queue<Path<N>> queue) {
        for (TCNTimePoint from : nodes) {
            for (TCNTimePoint to : nodes) {
                if (from.equals(to)) continue;
                queue.add(new Path<TCNTimePoint>(from, to));
                queue.add(new Path<TCNTimePoint>(to, from));
            }
        }
    }

    protected void logChange(ChangeSet<E, V, Triangle<N>> changeSet, Path<N> p, N k, E e_ik, V oldValue) {
        this.logChange(changeSet, p, k, e_ik, oldValue, this.getClass().getSimpleName());
    }

    protected void logChange(ChangeSet<E, V, Triangle<N>> changeSet, Path<N> p, N k, E e_ik, V oldValue, String reason) {
        assert (e_ik != null);
        assert (this.debug(Level.FINEST, "Updating Constraint %s -> %s from %s to %s", e_ik.getSourceNode(), e_ik.getTargetNode(), oldValue, e_ik.getValue()));
        if (changeSet != null) {
            changeSet.logChange(e_ik, oldValue, e_ik.getValue(), new Triangle<TCNTimePoint>((TCNTimePoint)p.getFirst(), (TCNTimePoint)p.getSecond(), (TCNTimePoint)k), reason);
        }
    }

    protected Label mergeLabels(Label branch1, Label branch2) {
        return Proposition.EMPTY_PROPOSITION;
    }

    public boolean satisfiable(Label b1, Label b2) {
        return b1.satisfiable(b2);
    }

    protected TimeDistance getTimeDistance(E edge) {
        Object value = edge.getValue();
        if (value instanceof LabeledValueSet) {
            LabeledValueSet valueSet = (LabeledValueSet)value;
            assert (valueSet.getLabeledValues().size() == 1);
            LabeledValue labeledValue = valueSet.getLabeledValues().iterator().next();
            return labeledValue.getValue();
        }
        if (value instanceof LabeledValue) {
            LabeledValue labeledValue = (LabeledValue)value;
            return labeledValue.getValue();
        }
        if (value instanceof SimpleConstraintValue) {
            return ((SimpleConstraintValue)value).getValue();
        }
        throw new IllegalArgumentException();
    }

    protected boolean debug(Level logLevel, String message) {
        boolean assertOn = false;
        if (!$assertionsDisabled) {
            assertOn = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (!assertOn) {
            throw new AssertionError((Object)"Debug should be on only if assertions is on");
        }
        if (this.logger.isLoggable(logLevel)) {
            System.out.println(message);
            this.logger.log(logLevel, message);
        }
        return true;
    }

    protected boolean debug(Level logLevel, String message, Object ... params) {
        if (this.logger.isLoggable(logLevel)) {
            this.debug(logLevel, String.format(message, params));
        }
        return true;
    }

    protected void checkConsistency(TCN<N, E> model, E edge, Triangle<N> causedBy) throws TCNInconsistencyException {
        Object value2;
        Object value1;
        Object from = edge.getSourceNode();
        Object to = edge.getTargetNode();
        E oppositeEdge = model.getEdge(to, from);
        if (oppositeEdge != null && !this.checkConsistency(value1 = oppositeEdge.getValue(), value2 = edge.getValue())) {
            assert (this.debug(Level.SEVERE, "Inconsistent: %s -> %s: %s < %s", from, to, value1, value2));
            throw new TCNInconsistencyException(String.format("Distance cannot be empty! Inconsistent: %s -> %s: %s < %s", from, to, value1, value2), new Path(from, to), (TCNTimePoint)causedBy.getSecond(), model);
        }
    }

    protected abstract boolean checkConsistency(V var1, V var2);

    protected boolean isConsistent(SimpleConstraintValue value1, SimpleConstraintValue value2) {
        TimeDistance d2;
        TimeDistance d1 = value1.getValue();
        boolean consistent = d1.compareTo((d2 = value2.getValue()).neg()) >= 0;
        return consistent;
    }
}

