/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation;

import de.aristaflow.adept2.model.common.PluginData;
import de.aristaflow.adept2.model.timemodel.tcn.ChangeableTCN;
import de.aristaflow.adept2.model.timemodel.tcn.ConstraintValue;
import de.aristaflow.adept2.model.timemodel.tcn.IterationChain;
import de.aristaflow.adept2.model.timemodel.tcn.Label;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledTimePoint;
import de.aristaflow.adept2.model.timemodel.tcn.NodeInstance;
import de.aristaflow.adept2.model.timemodel.tcn.NodeMapping;
import de.aristaflow.adept2.model.timemodel.tcn.TCN;
import de.aristaflow.adept2.model.timemodel.tcn.TCNEdge;
import de.aristaflow.adept2.model.timemodel.tcn.TCNTimePoint;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.DefaultLabeledNode;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.Proposition;
import de.aristaflow.adept2.model.timemodel.tools.DirectedGraph;
import de.aristaflow.adept2.model.timemodel.tools.GraphVisitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;

public abstract class AbstractTCN<N extends TCNTimePoint, V extends ConstraintValue, E extends TCNEdge<N, V>>
implements TCN<N, E>,
ChangeableTCN<N, E> {
    public static final LabeledTimePoint TIMEBASE_NODE = new DefaultLabeledNode("Origin", new NodeInstance(Integer.MIN_VALUE, new IterationChain(0), Integer.MIN_VALUE), (Label)Proposition.EMPTY_PROPOSITION){
        private static final long serialVersionUID = 1892338209580518661L;

        public void addSupportedPlugin(String extensionPointID, String pluginID, PluginData data) {
        }

        public void setUserAttributeValue(String attributeName, String attributeValue) {
        }

        public void setUserAttributes(Map<String, String> userAttributes) {
        }
    };
    private Map<N, Integer> nodes = new IdentityHashMap<N, Integer>();
    private int maxNodeID = 0;
    private E[][] edges;
    private boolean consistent = false;
    private Set<E> changeSet;

    public AbstractTCN(Collection<N> nodes, Collection<E> edges) {
        this.nodes.put(this.getTimeBaseEvent(), this.maxNodeID++);
        for (TCNTimePoint n : nodes) {
            if (this.nodes.containsKey(n)) continue;
            this.nodes.put(n, this.maxNodeID++);
        }
        this.ensureCapacity(this.maxNodeID);
        for (TCNEdge edge : edges) {
            int target;
            int source = this.getNodeKey(edge.getSourceNode());
            if (this.internalGetConstraint(source, target = this.getNodeKey(edge.getTargetNode())) != null) {
                throw new IllegalStateException("Duplicate Edge: " + edge);
            }
            this.internalSetConstraint(source, target, edge);
        }
        this.init();
        assert (this.checkConsistency());
    }

    public abstract void init();

    protected boolean checkConsistency() {
        int i = 0;
        while (i < this.edges.length) {
            int j = 0;
            while (j < i) {
                if (!this.checkConsistency(this.edges[i][j], this.edges[j][i])) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        for (TCNTimePoint node : this.nodes.keySet()) {
            if (this.doCheckConsistency(node)) continue;
            return false;
        }
        return true;
    }

    protected abstract boolean doCheckConsistency(N var1);

    protected boolean checkConsistency(E tcnEdge1, E tcnEdge2) {
        if (tcnEdge1 != null && tcnEdge2 != null) {
            return this.doCheckConsistency(tcnEdge1, tcnEdge2);
        }
        return true;
    }

    protected abstract boolean doCheckConsistency(E var1, E var2);

    private void ensureCapacity(int size) {
        if (this.edges == null) {
            int newSize = size;
            this.edges = new TCNEdge[newSize][newSize];
        } else if (this.edges.length <= size) {
            int newSize = (int)((double)size * 1.1);
            TCNEdge[][] newArray = new TCNEdge[newSize][newSize];
            int i = 0;
            while (i < this.edges.length) {
                System.arraycopy(this.edges[i], 0, newArray[i], 0, this.edges.length);
                ++i;
            }
            this.edges = newArray;
        }
    }

    protected int getNodeKey(N node) {
        Integer key = this.nodes.get(node);
        if (key == null) {
            throw new IllegalArgumentException("Node does not exist: " + node);
        }
        assert (key != null);
        return key;
    }

    @Override
    public E updateConstraint(E edge) {
        int source = this.getNodeKey(edge.getSourceNode());
        int target = this.getNodeKey(edge.getTargetNode());
        this.internalSetConstraint(source, target, edge);
        return edge;
    }

    protected void internalSetConstraint(int source, int target, E edge) {
        this.edges[source][target] = edge;
        this.logChange(edge);
        this.modified();
        assert (this.checkConsistency(this.edges[source][target], this.edges[target][source]));
    }

    public void removeEdge(E edge) {
        int source = this.getNodeKey(edge.getSourceNode());
        int target = this.getNodeKey(edge.getTargetNode());
        this.internalSetConstraint(source, target, null);
    }

    private void logChange(E edge) {
        if (this.changeSet != null && edge != null) {
            this.changeSet.add(edge);
        }
    }

    @Override
    public Collection<E> getChanges() {
        if (this.changeSet != null) {
            return new ArrayList<E>(this.changeSet);
        }
        return null;
    }

    protected void modified() {
        this.consistent = false;
    }

    @Override
    public Collection<N> getTimePoints() {
        return Collections.unmodifiableSet(this.nodes.keySet());
    }

    @Override
    public Collection<E> getEdges() {
        ArrayList<E> eg = new ArrayList<E>();
        int i = 0;
        while (i < this.maxNodeID) {
            int j = 0;
            while (j < this.maxNodeID) {
                E constraint = this.internalGetConstraint(i, j);
                if (constraint != null) {
                    eg.add(constraint);
                }
                ++j;
            }
            ++i;
        }
        return Collections.unmodifiableList(eg);
    }

    @Override
    public E getEdge(N from, N to) {
        int fromID = this.getNodeKey(from);
        int toID = this.getNodeKey(to);
        return this.internalGetConstraint(fromID, toID);
    }

    @Override
    public Collection<E> getOutgoingEdges(N from) {
        int fromID = this.getNodeKey(from);
        ArrayList<E> edges = new ArrayList<E>(this.maxNodeID);
        int i = 0;
        while (i < this.maxNodeID) {
            E e = this.internalGetConstraint(fromID, i);
            if (e != null) {
                edges.add(e);
            }
            ++i;
        }
        return edges;
    }

    @Override
    public Collection<E> getIncomingEdges(N to) {
        int toID = this.getNodeKey(to);
        ArrayList<E> edges = new ArrayList<E>(this.maxNodeID);
        int i = 0;
        while (i < this.maxNodeID) {
            E e = this.internalGetConstraint(i, toID);
            if (e != null) {
                edges.add(e);
            }
            ++i;
        }
        return edges;
    }

    protected E internalGetConstraint(int fromID, int toID) {
        return this.edges[fromID][toID];
    }

    @Override
    public void visit(GraphVisitor<N, E> visitor) {
        visitor.discoverGraph(this);
        for (TCNTimePoint e : this.getTimePoints()) {
            visitor.discoverVertex(e);
            visitor.finishVertex(e);
        }
        for (TCNTimePoint ei : this.getTimePoints()) {
            for (TCNTimePoint ej : this.getTimePoints()) {
                E e = this.getEdge((N)ei, (N)ej);
                if (e == null) continue;
                visitor.discoverEdge(e.getSourceNode(), e.getTargetNode(), e);
                visitor.finishEdge(e.getSourceNode(), e.getTargetNode(), e);
            }
        }
        visitor.finishGraph(this);
    }

    @Override
    public boolean contains(LabeledTimePoint timePoint) {
        return this.nodes.containsKey(timePoint);
    }

    @Override
    public void removeTimePoint(N node) throws IllegalStateException {
        int nodeKey = this.getNodeKey(node);
        this.nodes.remove(node);
        int i = 0;
        while (i < this.edges.length) {
            this.edges[nodeKey][i] = null;
            this.edges[i][nodeKey] = null;
            ++i;
        }
    }

    @Override
    public boolean isConsistent() {
        return this.consistent;
    }

    @Override
    public void setConsistent() {
        this.consistent = true;
        if (this.changeSet == null) {
            this.changeSet = new HashSet();
        } else {
            this.changeSet.clear();
        }
    }

    @Override
    public N insertTimePoint(N node) {
        if (this.nodes.containsKey(node)) {
            return node;
        }
        int nodeID = Integer.MIN_VALUE;
        if (this.maxNodeID > this.nodes.size()) {
            int i = 0;
            while (i < this.maxNodeID) {
                if (!this.nodes.containsValue(i)) {
                    nodeID = i;
                    break;
                }
                ++i;
            }
            if (nodeID == Integer.MIN_VALUE) {
                nodeID = this.maxNodeID++;
            } else {
                Arrays.fill(this.edges[nodeID], null);
                i = 0;
                while (i < this.edges.length) {
                    this.edges[i][nodeID] = null;
                    ++i;
                }
            }
        } else {
            nodeID = this.maxNodeID++;
        }
        this.nodes.put(node, nodeID);
        this.modified();
        this.ensureCapacity(this.maxNodeID);
        return node;
    }

    @Override
    public Collection<N> getVertices() {
        return this.getTimePoints();
    }

    @Override
    public abstract TCN<N, E> clone();

    public static final class DirectedGraphImplementation<N extends TCNTimePoint, E extends TCNEdge<N, ?>>
    implements DirectedGraph<N, E> {
        private NodeMapping<N> nodeMapping;

        public DirectedGraphImplementation(NodeMapping<N> nodeMapping) {
            this.nodeMapping = nodeMapping;
        }

        @Override
        public Collection<N> getVertices() {
            return new ArrayList();
        }

        @Override
        public Collection<E> getEdges() {
            return new ArrayList();
        }

        @Override
        public E getEdge(N from, N to) {
            return null;
        }

        @Override
        public void visit(GraphVisitor<N, E> visitor) {
            visitor.discoverGraph(this);
            for (TCNTimePoint e : this.nodeMapping.getNodes()) {
                visitor.discoverVertex(e);
                visitor.finishVertex(e);
            }
            visitor.finishGraph(this);
        }

        public String toString() {
            return this.nodeMapping.toString();
        }
    }
}

