/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation;

import de.aristaflow.adept2.model.common.timedata.TimeDistance;
import de.aristaflow.adept2.model.common.timedata.defaultimplementation.DefaultTimeDistance;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.Edge;
import de.aristaflow.adept2.model.processmodel.TemporalTemplate;
import de.aristaflow.adept2.model.timemodel.tcn.IterationChain;
import de.aristaflow.adept2.model.timemodel.tcn.JoinNodeMapping;
import de.aristaflow.adept2.model.timemodel.tcn.Label;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledTimePoint;
import de.aristaflow.adept2.model.timemodel.tcn.NodeInstance;
import de.aristaflow.adept2.model.timemodel.tcn.NodeMapping;
import de.aristaflow.adept2.model.timemodel.tcn.SplitNodeMapping;
import de.aristaflow.adept2.model.timemodel.tcn.TCNEdge;
import de.aristaflow.adept2.model.timemodel.tcn.TCNTimePoint;
import de.aristaflow.adept2.model.timemodel.tcn.TCNTransformation;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.AbstractTCN;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.DefaultLabeledNode;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.DefaultObservationTimePoint;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.ObservationBinding;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.Proposition;
import java.util.Map;
import org.apache.commons.configuration.Configuration;

public abstract class AbstractTemplateTransformation<E extends TCNEdge<LabeledTimePoint, ?>>
extends TCNTransformation<LabeledTimePoint, E> {
    public static final String CONF_XORSPLIT_MAX_DURATION = "TCNTransformation.XORSplitMaxDuration";
    public static TimeDistance DEFAULT_XORSPLIT_MAX_DURATION = new DefaultTimeDistance(5L, 0L, 0L, 0L, 0L);
    protected TimeDistance XORSPLIT_MAX_DURATION;

    public AbstractTemplateTransformation(Configuration configuration, TemporalTemplate template) {
        super(configuration, template);
    }

    public AbstractTemplateTransformation(Configuration configuration, TemporalTemplate template, int lookAhead) {
        super(configuration, template, lookAhead);
    }

    @Override
    protected void readConfiguration() {
        super.readConfiguration();
        this.XORSPLIT_MAX_DURATION = this.longToTimeDistance(this.configuration.getLong(CONF_XORSPLIT_MAX_DURATION, DEFAULT_XORSPLIT_MAX_DURATION.toMilliseconds()));
    }

    @Override
    protected LabeledTimePoint transformInstanceCreationEvent(IterationChain iterationChain, Label branch) {
        LabeledTimePoint instanceCreationEvent = new DefaultLabeledNode(new NodeInstance(-1, iterationChain, -1), "Instance", branch);
        instanceCreationEvent = this.addNode(instanceCreationEvent);
        return instanceCreationEvent;
    }

    @Override
    protected E[] transformSyncEdge(LabeledTimePoint from, LabeledTimePoint to, Label branches) {
        return this.createTCNEdge(from, to, branches, this.CONTROL_FLOW_MIN_TIME_LAG, this.CONTROL_FLOW_MAX_TIME_LAG, true);
    }

    @Override
    protected NodeMapping<LabeledTimePoint> transformProcessEndNode(int nodeID, IterationChain iterationChain, Label branches) {
        if (this.template.getNodeType(nodeID) != ProcessConstants.NodeType.NT_ENDFLOW) {
            throw new IllegalArgumentException("" + this.template.getNodeType(nodeID));
        }
        int topologicalID = this.template.getNodeTopologicalID(nodeID);
        NodeInstance nodeInstance = new NodeInstance(nodeID, iterationChain, topologicalID);
        LabeledTimePoint A_S = this.createTCNNode(nodeInstance, "S", branches);
        LabeledTimePoint A_E = this.createTCNNode(nodeInstance, "E", branches);
        this.addNode(A_S);
        this.addNode(A_E);
        this.createTCNEdge(A_S, A_E, branches, this.STRUCTURE_NODE_MIN_DURATION, this.STRUCTURE_NODE_MAX_DURATION, true);
        return this.addNodeMapping(new NodeMapping(this.getNodeName(nodeID), nodeInstance, (TCNTimePoint)A_S, null, (TCNTimePoint)A_E));
    }

    protected LabeledTimePoint createTCNNode(NodeInstance nodeInstance, String eventID, Label branches) {
        return new DefaultLabeledNode(nodeInstance, eventID, branches);
    }

    @Override
    protected NodeMapping<LabeledTimePoint> transformProcessStartNode(int nodeID, IterationChain iterationChain, Label branches) {
        if (this.template.getNodeType(nodeID) != ProcessConstants.NodeType.NT_STARTFLOW) {
            throw new IllegalArgumentException("" + this.template.getNodeType(nodeID));
        }
        int topologicalID = this.template.getNodeTopologicalID(nodeID);
        NodeInstance nodeInstance = new NodeInstance(nodeID, iterationChain, topologicalID);
        LabeledTimePoint A_S = this.NO_DISTINCT_TIMEBASE_EVENT ? this.getTimeBaseNode() : this.addNode(this.createTCNNode(nodeInstance, "S", branches));
        LabeledTimePoint A_E = this.addNode(this.createTCNNode(nodeInstance, "E", branches));
        this.createTCNEdge(A_S, A_E, branches, this.STRUCTURE_NODE_MIN_DURATION, this.STRUCTURE_NODE_MAX_DURATION, true);
        return this.addNodeMapping(new NodeMapping(this.getNodeName(nodeID), nodeInstance, (TCNTimePoint)A_S, null, (TCNTimePoint)A_E));
    }

    @Override
    protected Label mergeANDBranches(Label baseBranch, Label[] newBranches) {
        return baseBranch;
    }

    @Override
    protected Label mergeBranches(LabeledTimePoint node1, LabeledTimePoint node2) {
        Label label = node1.getLabel().merge(node2.getLabel());
        return label;
    }

    @Override
    protected SplitNodeMapping<LabeledTimePoint> transformXORSplitNode(int nodeID, IterationChain iterationChain, Label branches) {
        if (this.template.getNodeType(nodeID) != ProcessConstants.NodeType.NT_XOR_SPLIT) {
            throw new IllegalArgumentException("" + this.template.getNodeType(nodeID));
        }
        int[] succs = this.template.getSuccByEdgeType(nodeID, new ProcessConstants.EdgeType[]{ProcessConstants.EdgeType.ET_CONTROL});
        Proposition parentProposition = (Proposition)branches;
        int topologicalID = this.template.getNodeTopologicalID(nodeID);
        NodeInstance nodeInstance = new NodeInstance(nodeID, iterationChain, topologicalID);
        long[] edgeCodes = new long[succs.length];
        int i = 0;
        while (i < succs.length) {
            long edgeCode;
            int succ = succs[i];
            edgeCodes[i] = edgeCode = this.getEdgeCode(nodeID, succ, ProcessConstants.EdgeType.ET_CONTROL);
            ++i;
        }
        LabeledTimePoint A_S = this.createTCNNode(nodeInstance, "S", branches);
        DefaultObservationTimePoint A_E = this.createObservationNode(nodeInstance, "E", branches, edgeCodes);
        Map<Long, ObservationBinding> decisionLabels = A_E.getEdgeCodeMapping();
        this.addNode(A_S);
        this.addNode(A_E);
        this.createTCNEdge(A_S, A_E, branches, this.STRUCTURE_NODE_MIN_DURATION, this.XORSPLIT_MAX_DURATION, true);
        TCNTimePoint[] nodes = new LabeledTimePoint[succs.length];
        int i2 = 0;
        while (i2 < succs.length) {
            int succ = succs[i2];
            long edgeCode = this.getEdgeCode(nodeID, succ, ProcessConstants.EdgeType.ET_CONTROL);
            ObservationBinding observation = decisionLabels.get(edgeCode);
            Label xorBranch = parentProposition.addVariableBinding(observation);
            LabeledTimePoint s = this.createTCNNode(nodeInstance, "" + edgeCode, xorBranch);
            this.addNode(s);
            this.createTCNEdge(A_E, s, xorBranch, this.STRUCTURE_NODE_MIN_DURATION, this.XORSPLIT_MAX_DURATION, true);
            this.createTCNEdge(A_S, s, xorBranch, this.STRUCTURE_NODE_MIN_DURATION, this.XORSPLIT_MAX_DURATION, true);
            nodes[i2] = s;
            ++i2;
        }
        return this.addNodeMapping(new SplitNodeMapping(this.getNodeName(nodeID), nodeInstance, (TCNTimePoint)A_S, null, (TCNTimePoint)A_E, nodes));
    }

    protected DefaultObservationTimePoint createObservationNode(NodeInstance nodeInstance, String eventID, Label branches, long[] edgeCodes) {
        return new DefaultObservationTimePoint(nodeInstance, eventID, branches, edgeCodes);
    }

    @Override
    protected JoinNodeMapping<LabeledTimePoint> transformXORJoinNode(int nodeID, IterationChain iterationChain, Label branches) {
        if (this.template.getNodeType(nodeID) != ProcessConstants.NodeType.NT_XOR_JOIN) {
            throw new IllegalArgumentException("" + this.template.getNodeType(nodeID));
        }
        int topologicalID = this.template.getNodeTopologicalID(nodeID);
        NodeInstance nodeInstance = new NodeInstance(nodeID, iterationChain, topologicalID);
        LabeledTimePoint A_S = this.createTCNNode(nodeInstance, "S", branches);
        LabeledTimePoint A_E = this.createTCNNode(nodeInstance, "E", branches);
        this.addNode(A_S);
        this.addNode(A_E);
        this.createTCNEdge(A_S, A_E, branches, this.STRUCTURE_NODE_MIN_DURATION, this.STRUCTURE_NODE_MAX_DURATION, true);
        return this.addNodeMapping(new JoinNodeMapping(this.getNodeName(nodeID), nodeInstance, null, (TCNTimePoint)A_S, null, (TCNTimePoint)A_E));
    }

    @Override
    protected SplitNodeMapping<LabeledTimePoint> transformANDSplit(int nodeID, IterationChain iterationChain, Label branches) {
        if (this.template.getNodeType(nodeID) != ProcessConstants.NodeType.NT_AND_SPLIT) {
            throw new IllegalArgumentException("" + this.template.getNodeType(nodeID));
        }
        int topologicalID = this.template.getNodeTopologicalID(nodeID);
        NodeInstance nodeInstance = new NodeInstance(nodeID, iterationChain, topologicalID);
        LabeledTimePoint A_S = this.createTCNNode(nodeInstance, "S", branches);
        LabeledTimePoint A_E = this.createTCNNode(nodeInstance, "E", branches);
        this.addNode(A_S);
        this.addNode(A_E);
        this.createTCNEdge(A_S, A_E, branches, this.STRUCTURE_NODE_MIN_DURATION, this.STRUCTURE_NODE_MAX_DURATION, true);
        return this.addNodeMapping(new SplitNodeMapping(this.getNodeName(nodeID), nodeInstance, (TCNTimePoint)A_S, null, (TCNTimePoint)A_E, null));
    }

    @Override
    protected Label mergeXORBranches(Label branch, Label[] newBranchPaths) {
        return branch;
    }

    private long getEdgeCode(int startNodeID, int endNodeID, ProcessConstants.EdgeType edgeType) {
        Edge edge = this.template.getEdge(startNodeID, endNodeID, edgeType);
        return edge.getEdgeCode();
    }

    @Override
    protected JoinNodeMapping<LabeledTimePoint> transformLoopEndNode(int nodeID, IterationChain iterationChain, Label branches) {
        if (this.template.getNodeType(nodeID) != ProcessConstants.NodeType.NT_ENDLOOP) {
            throw new IllegalArgumentException("" + this.template.getNodeType(nodeID));
        }
        int topologicalID = this.template.getNodeTopologicalID(nodeID);
        NodeInstance nodeInstance = new NodeInstance(nodeID, iterationChain, topologicalID);
        LabeledTimePoint A_S = this.createTCNNode(nodeInstance, "S", branches);
        LabeledTimePoint A_E = this.createTCNNode(nodeInstance, "E", branches);
        this.addNode(A_S);
        this.addNode(A_E);
        this.createTCNEdge(A_S, A_E, branches, this.STRUCTURE_NODE_MIN_DURATION, this.STRUCTURE_NODE_MAX_DURATION, true);
        return this.addNodeMapping(new JoinNodeMapping(this.getNodeName(nodeID), nodeInstance, null, (TCNTimePoint)A_S, null, (TCNTimePoint)A_E));
    }

    @Override
    protected SplitNodeMapping<LabeledTimePoint> transformLoopStartNode(int nodeID, IterationChain iterationChain, Label branches) {
        if (this.template.getNodeType(nodeID) != ProcessConstants.NodeType.NT_STARTLOOP) {
            throw new IllegalArgumentException("" + this.template.getNodeType(nodeID));
        }
        int topologicalID = this.template.getNodeTopologicalID(nodeID);
        NodeInstance nodeInstance = new NodeInstance(nodeID, iterationChain, topologicalID);
        int[] succsRepeat = this.template.getPredByEdgeType(nodeID, new ProcessConstants.EdgeType[]{ProcessConstants.EdgeType.ET_LOOP});
        int[] succsExit = this.template.getSuccByEdgeType(nodeID, new ProcessConstants.EdgeType[]{ProcessConstants.EdgeType.ET_CONTROL});
        long edgeCodeRepeat = this.getEdgeCode(succsRepeat[0], nodeID, ProcessConstants.EdgeType.ET_LOOP);
        long edgeCodeExit = this.getEdgeCode(nodeID, succsExit[0], ProcessConstants.EdgeType.ET_CONTROL);
        long[] edgeCodes = new long[]{edgeCodeRepeat, edgeCodeExit};
        LabeledTimePoint A_S = this.createTCNNode(nodeInstance, "S", branches);
        DefaultObservationTimePoint A_E = this.createObservationNode(nodeInstance, "E", branches, edgeCodes);
        Map<Long, ObservationBinding> decisionLabels = A_E.getEdgeCodeMapping();
        this.addNode(A_S);
        this.addNode(A_E);
        this.createTCNEdge(A_S, A_E, branches, DefaultTimeDistance.ZERO_TIME_DISTANCE, DefaultTimeDistance.ZERO_TIME_DISTANCE, true);
        Proposition parentProposition = (Proposition)branches;
        Label repeatBranch = parentProposition.addVariableBinding(decisionLabels.get(edgeCodeRepeat));
        Label exitBranch = parentProposition.addVariableBinding(decisionLabels.get(edgeCodeExit));
        TCNTimePoint[] nodes = new LabeledTimePoint[2];
        nodes[0] = this.createTCNNode(nodeInstance, "R", repeatBranch);
        this.addNode(nodes[0]);
        this.createTCNEdge(A_E, nodes[0], repeatBranch, this.STRUCTURE_NODE_MIN_DURATION, this.STRUCTURE_NODE_MAX_DURATION, true);
        nodes[1] = this.createTCNNode(nodeInstance, "L", exitBranch);
        this.addNode(nodes[1]);
        this.createTCNEdge(A_E, nodes[1], exitBranch, this.STRUCTURE_NODE_MIN_DURATION, this.STRUCTURE_NODE_MAX_DURATION, true);
        return this.addNodeMapping(new SplitNodeMapping(this.getNodeName(nodeID), nodeInstance, (TCNTimePoint)A_S, null, (TCNTimePoint)A_E, nodes));
    }

    @Override
    protected LabeledTimePoint getTimeBaseNode() {
        return AbstractTCN.TIMEBASE_NODE;
    }
}

