/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation;

import de.aristaflow.adept2.model.timemodel.tools.DirectedGraph;
import de.aristaflow.adept2.model.timemodel.tools.Operand;
import de.aristaflow.adept2.model.timemodel.tools.WeightedEdge;
import java.util.HashMap;
import java.util.Map;

public class BellmanFord<V> {
    Operand ZERO = new Operand(){

        @Override
        public int compareTo(Operand o) {
            return -o.sign();
        }

        @Override
        public Operand add(Operand a) {
            return a;
        }

        @Override
        public int sign() {
            return 0;
        }
    };

    public Map<V, Operand> run(DirectedGraph<V, WeightedEdge<V, Operand>> graph, V start) {
        HashMap<V, Operand> distances = new HashMap<V, Operand>();
        distances.put(start, this.ZERO);
        int i = 0;
        while (i < graph.getVertices().size()) {
            for (V v1 : graph.getVertices()) {
                Operand distV1 = (Operand)distances.get(v1);
                if (distV1 == null) continue;
                for (V v2 : graph.getVertices()) {
                    WeightedEdge<V, Operand> weight = graph.getEdge(v1, v2);
                    if (weight == null) continue;
                    Operand distV2 = (Operand)distances.get(v2);
                    Operand newDist = distV1.add(weight.getWeight());
                    if (newDist == null || distV2 != null && newDist.compareTo(distV2) >= 0) continue;
                    distances.put(v2, newDist);
                }
            }
            ++i;
        }
        return distances;
    }
}

