/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation;

import de.aristaflow.adept2.model.common.timedata.TimeDistance;
import de.aristaflow.adept2.model.timemodel.tcn.Label;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledTimePoint;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledValue;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.ContingentLabeledValue;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.DefaultLabeledValue;

public class DefaultContingentLabeledValue
extends DefaultLabeledValue
implements ContingentLabeledValue {
    public static final String DOWN_LEFT = "\\";
    public static final String DOWN_RIGHT = "/";
    public static final String UP_LEFT = "/";
    public static final String UP_RIGHT = "\\";
    private final LabeledTimePoint trigger;
    private final TimeDistance contingentValue;
    protected final ContingentLabeledValue.ConstraintCase constraintCase;

    public DefaultContingentLabeledValue(Label proposition, ContingentLabeledValue.ConstraintCase cstnuCase, TimeDistance value, LabeledTimePoint trigger, TimeDistance contingentValue) {
        super(proposition, value);
        assert (trigger != null && cstnuCase != null);
        this.trigger = trigger;
        this.contingentValue = contingentValue;
        this.constraintCase = cstnuCase;
    }

    @Override
    public String toString() {
        String caseLabel = ContingentLabeledValue.ConstraintCase.LOWERCASE.equals((Object)this.constraintCase) ? "\\" + this.trigger.toString().toLowerCase() + "/" : "/" + this.trigger.toString().toUpperCase() + "\\";
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('<').append(this.label.toString()).append(", ").append(this.getSTNValue()).append(", ").append(caseLabel).append(", ").append(this.getContingentValue()).append('>');
        return stringBuilder.toString();
    }

    @Override
    public LabeledTimePoint getTrigger() {
        return this.trigger;
    }

    @Override
    public ContingentLabeledValue.ConstraintCase getCase() {
        return this.constraintCase;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultContingentLabeledValue other = (DefaultContingentLabeledValue)obj;
        if (this.contingentValue == null ? other.contingentValue != null : !this.contingentValue.equals(other.contingentValue)) {
            return false;
        }
        if (this.constraintCase != other.constraintCase) {
            return false;
        }
        if (this.label == null ? other.label != null : !this.label.equals(other.label)) {
            return false;
        }
        if (this.trigger == null ? other.trigger != null : !this.trigger.equals(other.trigger)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    @Override
    public TimeDistance getContingentValue() {
        return this.contingentValue;
    }

    @Override
    public TimeDistance getSTNValue() {
        return this.getValue();
    }

    @Override
    public boolean dominates(LabeledValue other) {
        if (other.getLabel().subsumes(this.label) && this.value.compareTo(other.getValue()) <= 0) {
            if (other instanceof ContingentLabeledValue) {
                ContingentLabeledValue c1 = (ContingentLabeledValue)other;
                if (this.getContingentValue().compareTo(c1.getContingentValue()) <= 0) {
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }
}

