/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation;

import de.aristaflow.adept2.model.timemodel.tcn.LabeledEdge;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledTimePoint;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledValue;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledValueSet;
import de.aristaflow.adept2.model.timemodel.tcn.TCNEdge;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.ContingentLabeledValue;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.DefaultLabeledValueSet;
import de.aristaflow.adept2.util.NullArgumentException;

public class DefaultLabeledEdge
implements TCNEdge<LabeledTimePoint, LabeledValueSet>,
Cloneable,
LabeledEdge {
    private final LabeledTimePoint from;
    private final LabeledTimePoint to;
    private final LabeledValueSet labeledValueSet;
    private final boolean implicit;
    private final boolean controledge;
    private final TCNEdge.FlowDirection flowDirection;

    public DefaultLabeledEdge(LabeledTimePoint from, LabeledTimePoint to, LabeledValueSet labelSet) {
        this(from, to, labelSet, false, false, TCNEdge.FlowDirection.UNKOWN);
    }

    public DefaultLabeledEdge(LabeledTimePoint from, LabeledTimePoint to, LabeledValueSet labeledValueSet, boolean controledge, boolean implicit, TCNEdge.FlowDirection flowDirection) {
        if (from == null || to == null || labeledValueSet == null) {
            throw new NullArgumentException();
        }
        assert (labeledValueSet.satisfiable(from.getLabel())) : "Illegal Label combination! Edge value " + labeledValueSet + " vs. from node label set " + from.getLabel() + " @ " + from + " --> " + to;
        assert (labeledValueSet.satisfiable(to.getLabel())) : "Illegal Label combination! Edge value " + labeledValueSet + " vs. to node label set " + to.getLabel() + " @ " + from + " --> " + to;
        assert (labeledValueSet.subsumes(from.getLabel())) : "Illegal Label combination! Edge label " + labeledValueSet + " must subsume from label " + from.getLabel() + " @ " + from + " --> " + to;
        assert (labeledValueSet.subsumes(to.getLabel())) : "Illegal Label combination! Edge label " + labeledValueSet + " must subsume to label " + to.getLabel() + " @ " + from + " --> " + to;
        this.from = from;
        this.to = to;
        this.labeledValueSet = labeledValueSet;
        this.controledge = controledge;
        this.implicit = implicit;
        this.flowDirection = flowDirection;
        assert (this.checkContingentDuration());
    }

    private boolean checkContingentDuration() {
        for (LabeledValue l : this.labeledValueSet.getLabeledValues()) {
            ContingentLabeledValue cl;
            if (!(l instanceof ContingentLabeledValue) || (cl = (ContingentLabeledValue)l).getTrigger() != this.getSourceNode() && cl.getTrigger() != this.getTargetNode() || this.labeledValueSet.getLabeledValues().size() == 1) continue;
            throw new IllegalArgumentException(String.valueOf(this));
        }
        return true;
    }

    @Override
    public LabeledTimePoint getSourceNode() {
        return this.from;
    }

    @Override
    public LabeledTimePoint getTargetNode() {
        return this.to;
    }

    public String toString() {
        return this.from + " -[" + this.labeledValueSet.toString() + "]-> " + this.to;
    }

    @Override
    public boolean isContingentDuration() {
        for (LabeledValue l : this.labeledValueSet.getLabeledValues()) {
            if (!(l instanceof ContingentLabeledValue)) continue;
            ContingentLabeledValue cl = (ContingentLabeledValue)l;
            if (cl.getTrigger() == this.getSourceNode() || cl.getTrigger() == this.getTargetNode()) {
                assert (this.labeledValueSet.getLabeledValues().size() == 1) : String.valueOf(this);
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean isContingent() {
        for (LabeledValue l : this.labeledValueSet.getLabeledValues()) {
            if (!(l instanceof ContingentLabeledValue)) continue;
            return true;
        }
        return false;
    }

    @Override
    public LabeledValueSet getValue() {
        return this.labeledValueSet;
    }

    @Override
    public boolean isImplicit() {
        return this.implicit;
    }

    @Override
    public boolean isControlEdge() {
        return this.controledge;
    }

    public int hashCode() {
        return this.from.hashCode() ^ this.to.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof LabeledEdge) {
            LabeledEdge other = (LabeledEdge)obj;
            boolean result = this.from.equals(other.getSourceNode());
            result &= this.to.equals(other.getTargetNode());
            return result &= this.labeledValueSet.equals(other.getValue());
        }
        return super.equals(obj);
    }

    @Override
    public LabeledEdge clone() {
        return new DefaultLabeledEdge(this.from, this.to, ((DefaultLabeledValueSet)this.labeledValueSet).clone(), this.controledge, this.implicit, this.flowDirection);
    }

    @Override
    public TCNEdge.FlowDirection getFlowDirection() {
        return this.flowDirection;
    }
}

