/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation;

import de.aristaflow.adept2.model.common.timedata.TimeDistance;
import de.aristaflow.adept2.model.timemodel.tcn.Label;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledValue;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.ContingentLabeledValue;
import de.aristaflow.adept2.util.NullArgumentException;

public class DefaultLabeledValue
implements LabeledValue {
    public static final char LANGLE = '<';
    public static final char RANGLE = '>';
    protected final Label label;
    protected final TimeDistance value;

    public DefaultLabeledValue(Label label, TimeDistance value) {
        if (value == null) {
            throw new NullArgumentException();
        }
        this.label = label;
        this.value = value;
    }

    @Override
    public Label getLabel() {
        return this.label;
    }

    @Override
    public TimeDistance getValue() {
        return this.value;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('<').append(this.label.toString()).append(", ").append(this.getValue()).append('>');
        return stringBuilder.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultLabeledValue other = (DefaultLabeledValue)obj;
        if (this.label == null ? other.label != null : !this.label.equals(other.label)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        return 31 * this.label.hashCode() + (this.value == null ? 0 : this.value.hashCode());
    }

    @Override
    public boolean dominates(LabeledValue other) {
        if (other.getLabel().subsumes(this.label) && this.value.compareTo(other.getValue()) <= 0) {
            if (other instanceof ContingentLabeledValue) {
                ContingentLabeledValue c1 = (ContingentLabeledValue)other;
                if (this.getValue().compareTo(c1.getContingentValue()) <= 0) {
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }
}

