/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation;

import de.aristaflow.adept2.model.common.timedata.TimeDistance;
import de.aristaflow.adept2.model.timemodel.tcn.Label;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledValue;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledValueSet;
import de.aristaflow.adept2.model.timemodel.tcn.SimpleConstraintValue;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.ContingentLabeledValue;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.DefaultContingentLabeledValue;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.DefaultLabeledValue;
import de.aristaflow.adept2.util.ArgChecks;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class DefaultLabeledValueSet
implements LabeledValueSet {
    private final Map<Label, LabeledValue> values;
    private final int cachedHashCode;

    public DefaultLabeledValueSet(LabeledValue ... values) {
        this(Arrays.asList(values));
    }

    public DefaultLabeledValueSet(Collection<LabeledValue> values) {
        ArgChecks.checkForEmpty(values, (String)"values");
        ArgChecks.checkForNulls(values, (String)"values");
        HashMap<Label, LabeledValue> lbls = new HashMap<Label, LabeledValue>();
        for (LabeledValue labeledValue : values) {
            assert (labeledValue.getLabel().satisfiable(labeledValue.getLabel()));
            LabeledValue old = lbls.put(labeledValue.getLabel(), labeledValue);
            assert (old == null);
        }
        this.values = Collections.unmodifiableMap(lbls);
        this.cachedHashCode = this.values.hashCode();
    }

    private DefaultLabeledValueSet(Map<Label, LabeledValue> values) {
        ArgChecks.checkForEmpty(values.values(), (String)"values");
        ArgChecks.checkForNulls(values.values(), (String)"values");
        HashMap<Label, LabeledValue> lbls = new HashMap<Label, LabeledValue>(values);
        for (LabeledValue labeledValue : values.values()) {
            assert (labeledValue.getLabel().satisfiable(labeledValue.getLabel()));
        }
        this.values = Collections.unmodifiableMap(lbls);
        this.cachedHashCode = this.values.hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        String sep = "";
        for (LabeledValue b : this.values.values()) {
            builder.append(sep);
            builder.append(b.toString());
            sep = ";";
        }
        return builder.toString();
    }

    @Override
    public Label[] getLabels() {
        return this.values.keySet().toArray(new Label[this.values.size()]);
    }

    @Override
    public boolean satisfiable(Label label) {
        Label[] labelArray = this.getLabels();
        int n = labelArray.length;
        int n2 = 0;
        while (n2 < n) {
            Label b = labelArray[n2];
            if (!b.satisfiable(label)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public boolean subsumes(Label label) {
        Label[] labelArray = this.getLabels();
        int n = labelArray.length;
        int n2 = 0;
        while (n2 < n) {
            Label l = labelArray[n2];
            if (!l.subsumes(label)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public Collection<LabeledValue> getLabeledValues() {
        return this.values.values();
    }

    @Override
    public SimpleConstraintValue[] getValues() {
        return this.values.values().toArray(new SimpleConstraintValue[this.values.size()]);
    }

    public int hashCode() {
        return this.cachedHashCode;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof DefaultLabeledValueSet) {
            DefaultLabeledValueSet other = (DefaultLabeledValueSet)obj;
            return this.values.equals(other.values);
        }
        return super.equals(obj);
    }

    public LabeledValueSet clone() {
        return new DefaultLabeledValueSet(this.values);
    }

    @Override
    public LabeledValueSet merge(LabeledValueSet other) {
        Map<Label, LabeledValue> labelMapping = DefaultLabeledValueSet.toMap(this);
        for (LabeledValue v : other.getLabeledValues()) {
            DefaultLabeledValueSet.addOrReplaceIfNecessary(labelMapping, v);
        }
        return new DefaultLabeledValueSet(labelMapping);
    }

    @Override
    public LabeledValueSet addOrReplaceIfNecessary(LabeledValue newLabel) {
        Map<Label, LabeledValue> map = DefaultLabeledValueSet.toMap(this);
        DefaultLabeledValueSet.addOrReplaceIfNecessary(map, newLabel);
        return new DefaultLabeledValueSet(map);
    }

    public static Map<Label, LabeledValue> toMap(LabeledValueSet values) {
        HashMap<Label, LabeledValue> map = new HashMap<Label, LabeledValue>();
        if (values instanceof DefaultLabeledValueSet) {
            map.putAll(((DefaultLabeledValueSet)values).values);
        } else {
            for (LabeledValue v : values.getLabeledValues()) {
                map.put(v.getLabel(), v);
            }
        }
        return map;
    }

    public static boolean addOrReplaceIfNecessary(Map<Label, LabeledValue> labels, LabeledValue newValue) {
        boolean changes = false;
        Label label = newValue.getLabel();
        LabeledValue oldValue = labels.get(label);
        if (oldValue != null) {
            LabeledValue value = DefaultLabeledValueSet.merge(newValue, oldValue);
            if (value != null && value != oldValue) {
                labels.put(label, value);
                changes = true;
            }
        } else {
            labels.put(label, newValue);
            changes = true;
        }
        return changes;
    }

    public static LabeledValue merge(LabeledValue newValue, LabeledValue oldValue) {
        if (newValue instanceof ContingentLabeledValue) {
            TimeDistance newTD;
            if (oldValue instanceof ContingentLabeledValue) {
                ContingentLabeledValue clNew = (ContingentLabeledValue)newValue;
                ContingentLabeledValue clOld = (ContingentLabeledValue)oldValue;
                int compareNonCont = clOld.getValue().compareTo(clNew.getValue());
                int compareCont = clOld.getContingentValue().compareTo(clNew.getContingentValue());
                if (compareCont > 0 || compareNonCont > 0) {
                    assert (clNew.getCase() == clOld.getCase()) : clOld + " vs. " + clNew;
                    assert (clNew.getTrigger() == clOld.getTrigger()) : "Trying to merge contingent constraints with different triggers!";
                    if (compareCont >= 0 && compareNonCont >= 0) {
                        return newValue;
                    }
                    TimeDistance nonContValeu = compareNonCont > 0 ? clNew.getValue() : clOld.getValue();
                    TimeDistance contValue = compareCont > 0 ? clNew.getContingentValue() : clOld.getContingentValue();
                    return DefaultLabeledValueSet.updateLabeledValue(clNew, nonContValeu, contValue);
                }
                return oldValue;
            }
            ContingentLabeledValue clNew = (ContingentLabeledValue)newValue;
            TimeDistance oldTD = oldValue.getValue();
            int compareNonCont = oldTD.compareTo(newTD = clNew.getValue());
            if (compareNonCont >= 0) {
                return newValue;
            }
            TimeDistance contValue = clNew.getContingentValue();
            TimeDistance nonContValue = oldValue.getValue();
            return DefaultLabeledValueSet.updateLabeledValue(clNew, nonContValue, contValue);
        }
        if (oldValue instanceof ContingentLabeledValue) {
            ContingentLabeledValue clOld = (ContingentLabeledValue)oldValue;
            int compareNonCont = clOld.getValue().compareTo(newValue.getValue());
            if (compareNonCont > 0) {
                TimeDistance nonContValue = newValue.getValue();
                TimeDistance contValue = clOld.getContingentValue();
                return DefaultLabeledValueSet.updateLabeledValue(clOld, nonContValue, contValue);
            }
            return oldValue;
        }
        int compare = oldValue.getValue().compareTo(newValue.getValue());
        if (compare > 0) {
            return newValue;
        }
        return oldValue;
    }

    protected static LabeledValue updateLabeledValue(ContingentLabeledValue oldValue, TimeDistance nonContValue, TimeDistance contValue) {
        DefaultLabeledValue value = nonContValue.compareTo(contValue) <= 0 ? new DefaultLabeledValue(oldValue.getLabel(), nonContValue) : new DefaultContingentLabeledValue(oldValue.getLabel(), oldValue.getCase(), nonContValue, oldValue.getTrigger(), contValue);
        return value;
    }
}

