/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation;

import de.aristaflow.adept2.model.timemodel.tcn.Label;
import de.aristaflow.adept2.model.timemodel.tcn.NodeInstance;
import de.aristaflow.adept2.model.timemodel.tcn.ObservationTimePoint;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.DefaultLabeledNode;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.Observation;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.ObservationBinding;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class DefaultObservationTimePoint
extends DefaultLabeledNode
implements ObservationTimePoint {
    private static final long serialVersionUID = -837847718619760659L;
    private final Map<Long, ObservationBinding> decisionLabels;
    private Observation observation;

    public DefaultObservationTimePoint(NodeInstance nodeInstance, String eventID, Label label, long[] edgeCodes, int[] observationIDs) {
        super(nodeInstance, eventID, label);
        if (edgeCodes.length != observationIDs.length) {
            throw new IllegalArgumentException("edgeCodes must have same length than observationIDs");
        }
        assert (edgeCodes.length > 1);
        this.observation = new Observation(this, edgeCodes.length);
        this.decisionLabels = new HashMap<Long, ObservationBinding>();
        int i = 0;
        while (i < edgeCodes.length) {
            long edgeCode = edgeCodes[i];
            this.decisionLabels.put(edgeCode, ObservationBinding.createObservationBinding(this.observation, edgeCode, observationIDs[i]));
            ++i;
        }
    }

    public DefaultObservationTimePoint(NodeInstance nodeInstance, String eventID, Label label, long[] edgeCodes) {
        super(nodeInstance, eventID, label);
        assert (edgeCodes.length > 1);
        this.observation = new Observation(this, edgeCodes.length);
        this.decisionLabels = new HashMap<Long, ObservationBinding>();
        int i = 0;
        while (i < edgeCodes.length) {
            long edgeCode = edgeCodes[i];
            this.decisionLabels.put(edgeCode, ObservationBinding.createObservationBinding(this.observation, edgeCode, i));
            ++i;
        }
    }

    @Override
    public String toString() {
        return "X " + super.toString();
    }

    public ObservationBinding[] getChoiceVariableBindings() {
        return this.decisionLabels.values().toArray(new ObservationBinding[0]);
    }

    public Map<Long, ObservationBinding> getEdgeCodeMapping() {
        return Collections.unmodifiableMap(this.decisionLabels);
    }

    public Observation getObservation() {
        return this.observation;
    }

    public ObservationBinding getObservationForEdgeCode(long edgeCode) {
        return this.decisionLabels.get(edgeCode);
    }

    @Override
    public Label.ChoiceVariable getChoiceVariable() {
        return this.observation;
    }
}

