/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation;

import de.aristaflow.adept2.model.common.timedata.TimeDistance;
import de.aristaflow.adept2.model.common.timedata.defaultimplementation.DefaultTimeDistance;
import de.aristaflow.adept2.model.timemodel.tcn.ChangeableCSTN;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledTimePoint;
import java.util.HashSet;
import java.util.TreeSet;

public class DijkstraSSSP {
    public void propagate(ChangeableCSTN cstn, LabeledTimePoint source) {
        TreeSet<SetElement> queue = new TreeSet<SetElement>();
        queue.add(new SetElement(source, DefaultTimeDistance.ZERO_TIME_DISTANCE));
        HashSet<LabeledTimePoint> processed = new HashSet<LabeledTimePoint>();
        while (!queue.isEmpty()) {
            SetElement current = (SetElement)queue.first();
            queue.remove(current);
            processed.add(current.timePoint);
            for (LabeledTimePoint neighbour : cstn.getTimePoints()) {
                if (!processed.contains(neighbour)) continue;
            }
        }
    }

    public class SetElement
    implements Comparable<SetElement> {
        LabeledTimePoint timePoint;
        TimeDistance value;

        public SetElement(LabeledTimePoint timePoint, TimeDistance value) {
            this.timePoint = timePoint;
            this.value = value;
        }

        @Override
        public int compareTo(SetElement o) {
            if (this.timePoint == o.timePoint) {
                return 0;
            }
            return this.value.compareTo(o.value);
        }

        public int hashCode() {
            return this.timePoint.hashCode();
        }
    }
}

