/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation;

import de.aristaflow.adept2.model.timemodel.tcn.Label;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.Observation;

public class ObservationBinding
implements Label.ChoiceVariableBinding,
Comparable<ObservationBinding> {
    private final long edgeCode;
    private final int value;
    private final Observation observation;

    public ObservationBinding(Observation observation, long edgeCode, int value) {
        if (value < 0) {
            throw new IllegalArgumentException("n");
        }
        int ofM = observation.getOptions();
        if (value >= ofM) {
            throw new IllegalArgumentException("n");
        }
        this.observation = observation;
        this.edgeCode = edgeCode;
        this.value = value;
    }

    public static ObservationBinding createObservationBinding(Observation observation, long edgeCode, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("n");
        }
        int ofM = observation.getOptions();
        if (n >= ofM) {
            throw new IllegalArgumentException("n");
        }
        assert (n >= 0);
        assert (ofM > n);
        return new ObservationBinding(observation, edgeCode, n);
    }

    public int getValue() {
        return this.value;
    }

    public int hashCode() {
        return this.observation.hashCode() * 31 ^ this.value;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ObservationBinding) {
            ObservationBinding other = (ObservationBinding)obj;
            return this.observation.equals(other.getVariable()) && this.value == other.value;
        }
        return super.equals(obj);
    }

    @Override
    public Observation getVariable() {
        return this.observation;
    }

    public long getEdgeCode() {
        return this.edgeCode;
    }

    public String toString() {
        int n = this.value;
        int ofM = this.observation.getOptions();
        StringBuilder s = new StringBuilder();
        s.append("(");
        s.append(this.observation.getDecisionTimePoint());
        s.append(';');
        s.append(n + 1);
        s.append(':');
        s.append(ofM);
        s.append(")");
        return s.toString();
    }

    @Override
    public int compareTo(ObservationBinding other) {
        int compare = this.observation.compareTo(other.observation);
        if (compare != 0) {
            return compare;
        }
        int thisVal = this.value;
        int anotherVal = other.value;
        compare = thisVal < anotherVal ? -1 : (thisVal == anotherVal ? 0 : 1);
        return compare;
    }
}

