/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation;

import de.aristaflow.adept2.model.common.timedata.TimeDistance;
import de.aristaflow.adept2.model.timemodel.ChangeSet;
import de.aristaflow.adept2.model.timemodel.defaultimplementation.Path;
import de.aristaflow.adept2.model.timemodel.defaultimplementation.Triangle;
import de.aristaflow.adept2.model.timemodel.tcn.ChangeableSTN;
import de.aristaflow.adept2.model.timemodel.tcn.ChangeableTCN;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledTimePoint;
import de.aristaflow.adept2.model.timemodel.tcn.STN;
import de.aristaflow.adept2.model.timemodel.tcn.SimpleConstraintValue;
import de.aristaflow.adept2.model.timemodel.tcn.TCNEdge;
import de.aristaflow.adept2.model.timemodel.tcn.TCNInconsistencyException;
import de.aristaflow.adept2.model.timemodel.tcn.TCNSolver;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.AbstractSTNSolver;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.DefaultConstraintValue;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.STNEdge;
import de.aristaflow.adept2.model.timemodel.tools.DuplicateFreeQueue;
import java.util.Collection;
import java.util.logging.Level;

public class PC2Solver<E extends STNEdge>
extends AbstractSTNSolver<LabeledTimePoint, SimpleConstraintValue, E>
implements TCNSolver<LabeledTimePoint, SimpleConstraintValue, E> {
    public PC2Solver() {
    }

    protected PC2Solver(Level debugLevel) {
        super(debugLevel);
    }

    @Override
    public <T extends ChangeableTCN<LabeledTimePoint, E>> T solve(T tcn) throws TCNInconsistencyException, InterruptedException {
        if (tcn instanceof ChangeableSTN) {
            return (T)((ChangeableTCN)((Object)this.solve((ChangeableSTN)tcn, null, null)));
        }
        throw new IllegalArgumentException();
    }

    @Override
    public <T extends ChangeableTCN<LabeledTimePoint, E>> T solve(T tcn, ChangeSet<E, SimpleConstraintValue, Triangle<LabeledTimePoint>> changeSet) throws TCNInconsistencyException, InterruptedException {
        if (tcn instanceof ChangeableSTN) {
            return (T)((ChangeableTCN)((Object)this.solve((ChangeableSTN)tcn, null, changeSet)));
        }
        throw new IllegalArgumentException();
    }

    public STN<LabeledTimePoint, E> solve(ChangeableSTN<LabeledTimePoint, E> model, Collection<Path<LabeledTimePoint>> changed, ChangeSet<E, SimpleConstraintValue, Triangle<LabeledTimePoint>> changeSet) throws TCNInconsistencyException, InterruptedException {
        assert (this.debug(Level.FINE, "Starting PC2"));
        Collection timePoints = model.getTimePoints();
        int nodeCount = timePoints.size();
        DuplicateFreeQueue queue = new DuplicateFreeQueue(nodeCount * nodeCount * 2);
        assert (this.debug(Level.FINE, "Initializing Paths"));
        if (changed == null) {
            this.getInitialPaths(timePoints, queue);
        } else {
            queue.addAll(changed);
        }
        while (!queue.isEmpty()) {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
            Path triangle = (Path)((Object)queue.remove());
            LabeledTimePoint i = (LabeledTimePoint)triangle.getFirst();
            LabeledTimePoint j = (LabeledTimePoint)triangle.getSecond();
            for (LabeledTimePoint k : timePoints) {
                if (i.equals(k) || j.equals(k)) continue;
                if (this.processPath(model, changeSet, new Path<LabeledTimePoint>(i, k), j)) {
                    assert (this.debug(Level.FINEST, "Adding related Paths for %s -> %s", i, k));
                    queue.add(new Path<LabeledTimePoint>(i, k));
                }
                if (!this.processPath(model, changeSet, new Path<LabeledTimePoint>(k, j), i)) continue;
                assert (this.debug(Level.FINEST, "Adding related Paths for %s -> %s", k, j));
                queue.add(new Path<LabeledTimePoint>(k, j));
            }
        }
        model.setConsistent();
        return model;
    }

    private boolean processPath(ChangeableSTN<LabeledTimePoint, E> model, ChangeSet<E, SimpleConstraintValue, Triangle<LabeledTimePoint>> changeSet, Path<LabeledTimePoint> p, LabeledTimePoint via) throws TCNInconsistencyException {
        TimeDistance sum;
        LabeledTimePoint from = p.getFrom();
        LabeledTimePoint to = p.getTo();
        STNEdge e_ij = (STNEdge)model.getEdge(from, via);
        STNEdge e_jk = (STNEdge)model.getEdge(via, to);
        if (e_ij == null || e_jk == null) {
            return false;
        }
        assert (model != null);
        assert (e_ij != null);
        assert (e_jk != null);
        assert (e_ij.getTargetNode() == e_jk.getSourceNode());
        STNEdge e_ik = (STNEdge)model.getEdge(from, to);
        assert (this.debug(Level.FINE, "Evaluating (%s, %s) = (%s) \\cap (%s) + (%s)", from, to, e_ik, e_ij, e_jk));
        SimpleConstraintValue ls_ij = e_ij.getValue();
        SimpleConstraintValue ls_jk = e_jk.getValue();
        TimeDistance v_ij = ls_ij.getValue();
        TimeDistance v_jk = ls_jk.getValue();
        try {
            sum = v_ij.add(v_jk);
        }
        catch (IllegalArgumentException e1) {
            throw new TCNInconsistencyException(e1.getMessage(), p, via, model);
        }
        assert (this.debug(Level.FINER, "\tSum\t (%s) + (%s) = (%s)", v_ij, v_jk, sum));
        TimeDistance v_ik = null;
        if (e_ik != null) {
            v_ik = this.getTimeDistance(e_ik);
        }
        TimeDistance newValue = v_ik != null ? this.intersect(v_ik, sum) : sum;
        assert (this.debug(Level.FINER, "\tIntersect\t (%s) u (%s) = (%s)", v_ik, sum, newValue));
        if (v_ik == null || !v_ik.equals(newValue)) {
            DefaultConstraintValue value = new DefaultConstraintValue(newValue);
            E stnEdge = this.createEdge(from, to, value, false, false, e_ik != null ? e_ik.getFlowDirection() : TCNEdge.FlowDirection.UNKOWN);
            assert (this.debug(Level.FINE, "Updating (%s) to (%s)", e_ik, stnEdge));
            this.logChange(changeSet, p, via, stnEdge, e_ik != null ? e_ik.getValue() : null);
            this.checkConsistency(model, stnEdge, new Triangle<LabeledTimePoint>(p, via));
            try {
                model.updateConstraint(stnEdge);
            }
            catch (IllegalArgumentException e) {
                assert (this.debug(Level.SEVERE, "Trying to update contingent constraint %s -> %s: %s -> %s", from, to, v_ik, newValue));
                throw new TCNInconsistencyException("Trying to update contingent constraint!", p, via, model, e);
            }
            catch (IllegalStateException e) {
                this.debug(Level.SEVERE, "Inconsistent: %s -> %s: %s", ((STNEdge)stnEdge).getSourceNode(), ((STNEdge)stnEdge).getTargetNode(), stnEdge);
                throw new TCNInconsistencyException(String.format("Inconsistent: %s -> %s: %s", ((STNEdge)stnEdge).getSourceNode(), ((STNEdge)stnEdge).getTargetNode(), stnEdge), new Path<LabeledTimePoint>(((STNEdge)stnEdge).getSourceNode(), ((STNEdge)stnEdge).getTargetNode()), via, model, e);
            }
            return true;
        }
        this.debug(Level.FINE, " Ignoring\t %s to %s (because no changes)", e_ik, newValue);
        return false;
    }

    public TimeDistance intersect(TimeDistance v1, TimeDistance v2) {
        if (v1.compareTo(v2) <= 0) {
            return v1;
        }
        return v2;
    }

    protected E createEdge(LabeledTimePoint from, LabeledTimePoint to, SimpleConstraintValue value, boolean controledge, boolean implicit, TCNEdge.FlowDirection flowDirection) {
        return (E)new STNEdge(from, to, value, controledge, implicit, flowDirection);
    }

    @Override
    protected boolean checkConsistency(SimpleConstraintValue value1, SimpleConstraintValue value2) {
        return this.isConsistent(value1, value2);
    }
}

