/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation;

import de.aristaflow.adept2.model.timemodel.tcn.Label;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.Observation;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.ObservationBinding;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class Proposition
implements Label {
    public static final String EMPTY_LABEL = "\u22a1";
    public static final Proposition EMPTY_PROPOSITION = new Proposition();
    private final SortedSet<ObservationBinding> observations;
    private int cachedHashCode;

    private Proposition() {
        this(Collections.emptyList());
    }

    public Proposition(ObservationBinding ... literals) {
        this(Arrays.asList(literals));
    }

    public Proposition(Collection<ObservationBinding> literals) {
        this.observations = Collections.unmodifiableSortedSet(new TreeSet<ObservationBinding>(literals));
        this.cachedHashCode = this.observations.hashCode();
        assert (this.satisfiable(this));
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        if (this.observations.size() > 0) {
            for (ObservationBinding l : this.observations) {
                s.append(l);
                s.append(" ");
            }
        } else {
            s.append(EMPTY_LABEL);
        }
        return s.toString();
    }

    public Set<ObservationBinding> getObservations() {
        return this.observations;
    }

    public int hashCode() {
        return this.cachedHashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Proposition) {
            Proposition other = (Proposition)obj;
            return this.observations.equals(other.observations);
        }
        return super.equals(obj);
    }

    @Override
    public boolean subsumes(Label label2) {
        Proposition prop2 = (Proposition)label2;
        if (prop2.isEmptyLabel()) {
            return true;
        }
        for (ObservationBinding l2 : prop2.observations) {
            if (this.observations.contains(l2)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean satisfiable(Label other) {
        if (!(other instanceof Proposition)) {
            throw new IllegalArgumentException("first argument must be a proposition");
        }
        Proposition p2 = (Proposition)other;
        SortedSet<ObservationBinding> literals1 = this.observations;
        SortedSet<ObservationBinding> literals2 = p2.observations;
        Iterator iterator1 = literals1.iterator();
        Iterator iterator2 = literals2.iterator();
        while (iterator1.hasNext() && iterator2.hasNext()) {
            ObservationBinding l1 = (ObservationBinding)iterator1.next();
            ObservationBinding l2 = (ObservationBinding)iterator2.next();
            int compareTo = l1.getVariable().compareTo(l2.getVariable());
            while (compareTo != 0) {
                if (compareTo > 0 && iterator2.hasNext()) {
                    l2 = (ObservationBinding)iterator2.next();
                } else if (compareTo < 0 && iterator1.hasNext()) {
                    l1 = (ObservationBinding)iterator1.next();
                } else if (!iterator1.hasNext() || !iterator2.hasNext()) {
                    return true;
                }
                compareTo = l1.getVariable().compareTo(l2.getVariable());
            }
            assert (l1.getVariable().equals(l2.getVariable()));
            if (l1.getValue() == l2.getValue()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Label merge(Label other) {
        if (!(other instanceof Proposition)) {
            throw new IllegalArgumentException("first argument must be a proposition");
        }
        if (this.isEmptyLabel()) {
            return other;
        }
        if (other.isEmptyLabel()) {
            return this;
        }
        Proposition prop2 = (Proposition)other;
        ArrayList<ObservationBinding> lit = new ArrayList<ObservationBinding>(this.observations.size() + prop2.observations.size());
        lit.addAll(this.observations);
        ListIterator<ObservationBinding> iterator = lit.listIterator();
        for (ObservationBinding l2 : prop2.observations) {
            if (iterator.hasNext()) {
                ObservationBinding lx = (ObservationBinding)iterator.next();
                int compareTo = lx.getVariable().compareTo(l2.getVariable());
                while (compareTo < 0 && iterator.hasNext()) {
                    lx = (ObservationBinding)iterator.next();
                    compareTo = lx.getVariable().compareTo(l2.getVariable());
                }
                if (compareTo == 0) {
                    if (lx.getValue() == l2.getValue()) continue;
                    throw new IllegalArgumentException(String.format("Cannot merge %s and %s because they are not satisfiable", this, other));
                }
            }
            iterator.add(l2);
        }
        return new Proposition(lit);
    }

    @Override
    public Label[] negate() {
        HashSet<Proposition> res = new HashSet<Proposition>();
        ObservationBinding[] literals = this.observations.toArray(new ObservationBinding[this.observations.size()]);
        if (literals.length == 0) {
            throw new IllegalStateException("Empty Label cannot be negated");
        }
        int[] gen = new int[literals.length];
        int[] genBase = new int[literals.length];
        int i = 0;
        while (i < gen.length) {
            ObservationBinding lg = literals[i];
            gen[i] = lg.getVariable().getOptions();
            genBase[i] = gen[i];
            ++i;
        }
        int pos = gen.length - 1;
        while (pos >= 0) {
            boolean diff = false;
            ObservationBinding[] lt = new ObservationBinding[gen.length];
            int i2 = 0;
            while (i2 < lt.length) {
                ObservationBinding baseLit = literals[i2];
                int branchID = baseLit.getValue();
                int one = branchID + 1;
                if (one != gen[i2]) {
                    diff = true;
                }
                lt[i2] = ObservationBinding.createObservationBinding(baseLit.getVariable(), Long.MIN_VALUE, gen[i2] - 1);
                ++i2;
            }
            if (diff) {
                res.add(new Proposition(lt));
            }
            int n = pos;
            gen[n] = gen[n] - 1;
            if (gen[pos] > 0) continue;
            while (--pos >= 0) {
                int n2 = pos;
                gen[n2] = gen[n2] - 1;
                if (gen[n2] <= 0) continue;
            }
            if (pos < 0) break;
            System.arraycopy(genBase, pos + 1, gen, pos + 1, gen.length - 1 - pos);
            pos = gen.length - 1;
        }
        return res.toArray(new Label[res.size()]);
    }

    @Override
    public Label removeVariable(Label.ChoiceVariable other) {
        if (!(other instanceof Observation)) {
            throw new IllegalArgumentException("first argument must be an Observation " + other.getClass());
        }
        TreeSet<ObservationBinding> reducedLiterals = new TreeSet<ObservationBinding>();
        for (ObservationBinding l : this.observations) {
            if (other == l.getVariable()) continue;
            reducedLiterals.add(l);
        }
        if (reducedLiterals.size() != this.observations.size()) {
            return new Proposition(reducedLiterals);
        }
        return this;
    }

    @Override
    public Label removeLabel(Label other) {
        if (!(other instanceof Proposition)) {
            throw new IllegalArgumentException("first argument must be an Observation");
        }
        assert (this.satisfiable(other));
        Proposition proposition = (Proposition)other;
        TreeSet<ObservationBinding> reduceLiterals = new TreeSet<ObservationBinding>(this.observations);
        if (reduceLiterals.removeAll(proposition.observations)) {
            return new Proposition(reduceLiterals);
        }
        return this;
    }

    @Override
    public boolean isEmptyLabel() {
        return this.observations.size() == 0;
    }

    @Override
    public boolean containsVariable(Label.ChoiceVariable other) {
        for (ObservationBinding l : this.observations) {
            if (other != l.getVariable()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Label addVariableBinding(Label.ChoiceVariableBinding choiceVariable) {
        ObservationBinding observation = (ObservationBinding)choiceVariable;
        for (ObservationBinding lx : this.observations) {
            if (!lx.getVariable().equals(observation.getVariable())) continue;
            if (lx.getValue() != observation.getValue()) {
                throw new IllegalArgumentException(String.format("Cannot append %s and %s because result is not satisfiable", this, observation));
            }
            return this;
        }
        TreeSet<ObservationBinding> lit = new TreeSet<ObservationBinding>();
        lit.addAll(this.observations);
        lit.add(observation);
        return new Proposition(lit);
    }

    @Override
    public Label.ChoiceVariableBinding getBinding(Label.ChoiceVariable variable) {
        for (Label.ChoiceVariableBinding choiceVariableBinding : this.observations) {
            if (!choiceVariableBinding.getVariable().equals(variable)) continue;
            return choiceVariableBinding;
        }
        return null;
    }
}

