/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation;

import de.aristaflow.adept2.model.common.timedata.TimeDistance;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.TemporalTemplate;
import de.aristaflow.adept2.model.timemodel.tcn.ChangeableSTN;
import de.aristaflow.adept2.model.timemodel.tcn.IterationChain;
import de.aristaflow.adept2.model.timemodel.tcn.JoinNodeMapping;
import de.aristaflow.adept2.model.timemodel.tcn.Label;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledTimePoint;
import de.aristaflow.adept2.model.timemodel.tcn.NodeInstance;
import de.aristaflow.adept2.model.timemodel.tcn.NodeMapping;
import de.aristaflow.adept2.model.timemodel.tcn.STN;
import de.aristaflow.adept2.model.timemodel.tcn.SimpleConstraintValue;
import de.aristaflow.adept2.model.timemodel.tcn.TCNEdge;
import de.aristaflow.adept2.model.timemodel.tcn.TCNTimePoint;
import de.aristaflow.adept2.model.timemodel.tcn.TCNTransformation;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.AbstractTemplateTransformation;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.DefaultConstraintValue;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.Proposition;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.STNEdge;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.SimpleSTN;
import de.aristaflow.adept2.util.NullArgumentException;
import java.util.Collection;
import org.apache.commons.configuration.Configuration;

public class STNTemplateTransformation
extends AbstractTemplateTransformation<STNEdge> {
    public STNTemplateTransformation(Configuration configuration, TemporalTemplate template) {
        super(configuration, template);
    }

    public STNTemplateTransformation(Configuration configuration, TemporalTemplate template, int lookAhead) {
        super(configuration, template, lookAhead);
    }

    public STNTemplateTransformation(TemporalTemplate template) {
        this(null, template);
    }

    public STNTemplateTransformation(TemporalTemplate template, int lookAhead) {
        this(null, template, lookAhead);
    }

    @Override
    protected ChangeableSTN<LabeledTimePoint, STNEdge> createTCN(Collection<LabeledTimePoint> nodes, Collection<STNEdge> edges, Collection<NodeMapping<LabeledTimePoint>> nodeMapping) {
        return new SimpleSTN(nodes, edges);
    }

    @Override
    public STN<LabeledTimePoint, STNEdge> transform() {
        return (STN)super.transform();
    }

    protected STNEdge[] createTCNEdge(LabeledTimePoint from, LabeledTimePoint to, Label branches, TimeDistance minValue, TimeDistance maxValue, boolean controlEdge) {
        if (minValue == null) {
            throw new NullArgumentException();
        }
        if (maxValue == null) {
            throw new NullArgumentException();
        }
        STNEdge minEdge = new STNEdge(to, from, new DefaultConstraintValue(minValue.neg()), controlEdge, false, TCNEdge.FlowDirection.BACKWARD);
        minEdge = this.addEdge(minEdge);
        STNEdge maxEdge = new STNEdge(from, to, new DefaultConstraintValue(maxValue), controlEdge, false, TCNEdge.FlowDirection.FORWARD);
        maxEdge = this.addEdge(maxEdge);
        return new STNEdge[]{minEdge, maxEdge};
    }

    @Override
    protected NodeMapping<LabeledTimePoint> transformActivity(int nodeID, IterationChain iterationChain, Label branches) {
        if (this.template.getNodeType(nodeID) != ProcessConstants.NodeType.NT_NORMAL) {
            throw new IllegalArgumentException("" + this.template.getNodeType(nodeID));
        }
        int topologicalID = this.template.getNodeTopologicalID(nodeID);
        NodeInstance nodeInstance = new NodeInstance(nodeID, iterationChain, topologicalID);
        LabeledTimePoint A_S = this.createTCNNode(nodeInstance, "S", branches);
        LabeledTimePoint A_E = this.createTCNNode(nodeInstance, "E", branches);
        this.addNode(A_S);
        this.addNode(A_E);
        TCNTransformation.TCNActivityDuration duration = this.getActivityDuration(nodeID);
        STNEdge minEdge = new STNEdge(A_E, A_S, new DefaultConstraintValue(duration.minDuration.neg()), true, false, TCNEdge.FlowDirection.BACKWARD);
        minEdge = this.addEdge(minEdge);
        STNEdge maxEdge = new STNEdge(A_S, A_E, new DefaultConstraintValue(duration.maxDuration), true, false, TCNEdge.FlowDirection.FORWARD);
        maxEdge = this.addEdge(maxEdge);
        NodeMapping node = new NodeMapping(this.getNodeName(nodeID), nodeInstance, (TCNTimePoint)A_S, null, (TCNTimePoint)A_E);
        this.processActivityValidityPeriod(nodeID, node);
        return this.addNodeMapping(node);
    }

    @Override
    protected JoinNodeMapping<LabeledTimePoint> transformANDJoin(int nodeID, IterationChain iterationChain, Label branches) {
        if (this.template.getNodeType(nodeID) != ProcessConstants.NodeType.NT_AND_JOIN) {
            throw new IllegalArgumentException("" + this.template.getNodeType(nodeID));
        }
        int topologicalID = this.template.getNodeTopologicalID(nodeID);
        NodeInstance nodeInstance = new NodeInstance(nodeID, iterationChain, topologicalID);
        LabeledTimePoint A_S = this.createTCNNode(nodeInstance, "S", branches);
        LabeledTimePoint A_E = this.createTCNNode(nodeInstance, "E", branches);
        this.addNode(A_S);
        this.addNode(A_E);
        this.createTCNEdge(A_S, A_E, branches, this.STRUCTURE_NODE_MIN_DURATION, this.STRUCTURE_NODE_MAX_DURATION, true);
        return this.addNodeMapping(new JoinNodeMapping(this.getNodeName(nodeID), nodeInstance, null, (TCNTimePoint)A_S, null, (TCNTimePoint)A_E));
    }

    @Override
    protected Label createInitialBranch() {
        return Proposition.EMPTY_PROPOSITION;
    }

    @Override
    protected STNEdge mergeEdges(STNEdge e1, STNEdge e2) {
        SimpleConstraintValue value = e1.getValue().getValue().compareTo(e2.getValue().getValue()) <= 0 ? e1.getValue() : e2.getValue();
        return new STNEdge(e1.getSourceNode(), e2.getTargetNode(), value, e1.isControlEdge() || e2.isControlEdge(), e1.isImplicit() && e2.isImplicit(), e1.getFlowDirection() == e2.getFlowDirection() ? e1.getFlowDirection() : TCNEdge.FlowDirection.UNKOWN);
    }
}

