/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation;

import de.aristaflow.adept2.model.timemodel.tcn.ChangeableCSTN;
import de.aristaflow.adept2.model.timemodel.tcn.Label;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledEdge;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledTimePoint;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledValue;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledValueSet;
import de.aristaflow.adept2.model.timemodel.tcn.cstnImpl.AbstractCSTNProjection;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.ContingentLabeledValue;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.DefaultContingentLabeledValue;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.DefaultLabeledEdge;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.DefaultLabeledNode;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.DefaultLabeledValue;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.DefaultLabeledValueSet;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.DefaultObservationTimePoint;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.ObservationBinding;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class ScenarioProjection
extends AbstractCSTNProjection {
    private final Label scenario;
    private Map<LabeledTimePoint, LabeledTimePoint> nodeMappingPrj = new HashMap<LabeledTimePoint, LabeledTimePoint>();
    private Map<LabeledTimePoint, LabeledTimePoint> nodeMappingSrc = new HashMap<LabeledTimePoint, LabeledTimePoint>();

    public ScenarioProjection(ChangeableCSTN cstn, Label scenario) {
        super(cstn, false);
        this.scenario = scenario;
    }

    @Override
    public List<Label.ChoiceVariable> getObservations() {
        List<Label.ChoiceVariable> baseObservations = super.getObservations();
        HashSet<Label.ChoiceVariable> observations = new HashSet<Label.ChoiceVariable>((int)((double)baseObservations.size() * 1.4));
        for (Label.ChoiceVariable var : baseObservations) {
            if (!var.getDecisionTimePoint().getLabel().satisfiable(this.scenario)) continue;
            observations.add(var);
        }
        return new ArrayList<Label.ChoiceVariable>(observations);
    }

    @Override
    protected LabeledTimePoint transformNode(LabeledTimePoint node) {
        if (!node.getLabel().satisfiable(this.scenario)) {
            return null;
        }
        LabeledTimePoint newNode = this.nodeMappingPrj.get(node);
        if (newNode != null) {
            return newNode;
        }
        if (node instanceof DefaultObservationTimePoint) {
            DefaultObservationTimePoint obsNode = (DefaultObservationTimePoint)node;
            if (this.scenario.containsVariable(obsNode.getObservation())) {
                newNode = new DefaultLabeledNode(node.getNodeInstance(), node.getEventID(), this.scenarioLabel(node.getLabel()));
            } else {
                Map<Long, ObservationBinding> edgeCodeMapping = obsNode.getEdgeCodeMapping();
                long[] edgeCodes = new long[edgeCodeMapping.size()];
                int[] observationIDs = new int[edgeCodeMapping.size()];
                int i = 0;
                for (Map.Entry<Long, ObservationBinding> entry : edgeCodeMapping.entrySet()) {
                    edgeCodes[i] = entry.getKey();
                    observationIDs[i] = entry.getValue().getValue();
                    ++i;
                }
                newNode = new DefaultObservationTimePoint(obsNode.getNodeInstance(), obsNode.getEventID(), this.scenarioLabel(obsNode.getLabel()), edgeCodes, observationIDs);
            }
        } else {
            newNode = node == this.getBaseTCN().getTimeBaseEvent() ? node : new DefaultLabeledNode(node.getNodeInstance(), node.getEventID(), this.scenarioLabel(node.getLabel()));
        }
        this.nodeMappingPrj.put(node, newNode);
        this.nodeMappingSrc.put(newNode, node);
        return newNode;
    }

    @Override
    protected LabeledTimePoint getBaseNode(LabeledTimePoint node) {
        return this.nodeMappingSrc.get(node);
    }

    protected Label scenarioLabel(Label label) {
        return label.removeLabel(this.scenario);
    }

    @Override
    public LabeledEdge getEdge(LabeledTimePoint from, LabeledTimePoint to) {
        assert (this.nodeMappingSrc.containsKey(from));
        assert (this.nodeMappingSrc.containsKey(to));
        return (LabeledEdge)super.getEdge(from, to);
    }

    @Override
    protected LabeledEdge transformEdge(LabeledTimePoint from, LabeledTimePoint to, LabeledEdge originalEdge) {
        assert (from.getLabel().satisfiable(this.scenario));
        assert (to.getLabel().satisfiable(this.scenario));
        Collection<LabeledValue> originalValues = ((LabeledValueSet)originalEdge.getValue()).getLabeledValues();
        HashMap<Label, LabeledValue> labels = new HashMap<Label, LabeledValue>((int)((double)originalValues.size() * 1.4));
        for (LabeledValue value : originalValues) {
            LabeledValue newValue;
            if (!value.getLabel().satisfiable(this.scenario) || (newValue = this.updateLabel(value, this.scenario)) == null) continue;
            DefaultLabeledValueSet.addOrReplaceIfNecessary(labels, newValue);
        }
        if (labels.size() == 0) {
            return null;
        }
        return new DefaultLabeledEdge(from, to, new DefaultLabeledValueSet(labels.values()), originalEdge.isControlEdge(), originalEdge.isImplicit(), originalEdge.getFlowDirection());
    }

    protected LabeledValue updateLabel(LabeledValue value, Label scenario) {
        DefaultLabeledValue newLabeledValue;
        Label newLabel = this.scenarioLabel(value.getLabel());
        if (value instanceof ContingentLabeledValue) {
            ContingentLabeledValue cl_XY = (ContingentLabeledValue)value;
            newLabeledValue = new DefaultContingentLabeledValue(newLabel, cl_XY.getCase(), cl_XY.getSTNValue(), cl_XY.getTrigger(), cl_XY.getContingentValue());
        } else {
            newLabeledValue = new DefaultLabeledValue(newLabel, value.getValue());
        }
        return newLabeledValue;
    }

    @Override
    public LabeledTimePoint insertTimePoint(LabeledTimePoint timePoint) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeTimePoint(LabeledTimePoint timePoint) {
        throw new UnsupportedOperationException();
    }
}

