/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation;

import de.aristaflow.adept2.model.common.timedata.TimeDistance;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledEdge;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledValueSet;
import de.aristaflow.adept2.model.timemodel.tcn.SimpleConstraintValue;
import de.aristaflow.adept2.model.timemodel.tcn.TCN;
import de.aristaflow.adept2.model.timemodel.tcn.TCNTimePoint;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.ContingentLabeledValue;
import de.aristaflow.adept2.model.timemodel.tools.DefaultWeightedEdge;
import de.aristaflow.adept2.model.timemodel.tools.DirectedGraph;
import de.aristaflow.adept2.model.timemodel.tools.GraphVisitor;
import de.aristaflow.adept2.model.timemodel.tools.Operand;
import de.aristaflow.adept2.model.timemodel.tools.WeightedEdge;
import java.util.Collection;

public class SemiReduciblePathsGraph<N extends TCNTimePoint>
implements DirectedGraph<N, WeightedEdge<N, Operand>> {
    private TCN<N, ? extends LabeledEdge> tcn;

    public SemiReduciblePathsGraph(TCN<N, ? extends LabeledEdge> tcn) {
        this.tcn = tcn;
    }

    @Override
    public Collection<N> getVertices() {
        return this.tcn.getTimePoints();
    }

    @Override
    public Collection<WeightedEdge<N, Operand>> getEdges() {
        throw new UnsupportedOperationException();
    }

    @Override
    public WeightedEdge<N, Operand> getEdge(N v1, N v2) {
        LabeledEdge edge = this.tcn.getEdge(v1, v2);
        if (edge == null) {
            return null;
        }
        TimeDistance weight = this.getValue(edge, false);
        TimeDistance contValue = this.getContingentValue(edge);
        if (contValue != null) {
            weight = contValue;
        }
        if (weight.isInfinity()) {
            return null;
        }
        return new DefaultWeightedEdge<N, SemiReducibleOperand>(v1, v2, new SemiReducibleOperand((LabeledValueSet)edge.getValue()));
    }

    public TimeDistance getValue(LabeledEdge edge, boolean maxValue) {
        SimpleConstraintValue[] values;
        int sgn = maxValue ? 1 : -1;
        TimeDistance timeDistance = null;
        SimpleConstraintValue[] simpleConstraintValueArray = values = ((LabeledValueSet)edge.getValue()).getValues();
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            SimpleConstraintValue constraintValue = simpleConstraintValueArray[n2];
            if (timeDistance == null) {
                timeDistance = constraintValue.getValue();
            } else if (constraintValue.getValue().compareTo(timeDistance) >= sgn) {
                timeDistance = constraintValue.getValue();
            }
            ++n2;
        }
        return timeDistance;
    }

    public TimeDistance getContingentValue(LabeledEdge edge) {
        TimeDistance contValue = null;
        SimpleConstraintValue[] simpleConstraintValueArray = ((LabeledValueSet)edge.getValue()).getValues();
        int n = simpleConstraintValueArray.length;
        int n2 = 0;
        while (n2 < n) {
            SimpleConstraintValue v = simpleConstraintValueArray[n2];
            if (v instanceof ContingentLabeledValue) {
                ContingentLabeledValue contingentLabeledValue = (ContingentLabeledValue)v;
                TimeDistance contingentValue = contingentLabeledValue.getContingentValue();
                if (contValue == null || contValue.compareTo(contingentValue) > 0) {
                    contValue = contingentValue;
                }
            }
            ++n2;
        }
        return contValue;
    }

    @Override
    public void visit(GraphVisitor<N, WeightedEdge<N, Operand>> visitor) {
        throw new UnsupportedOperationException();
    }

    public class SemiReducibleOperand
    implements Operand {
        public SemiReducibleOperand(LabeledValueSet labeledValueSet) {
        }

        @Override
        public int compareTo(Operand o) {
            return 0;
        }

        @Override
        public Operand add(Operand a) {
            return null;
        }

        @Override
        public int sign() {
            return 0;
        }
    }
}

