/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation;

import de.aristaflow.adept2.model.common.timedata.TimeDistance;
import de.aristaflow.adept2.model.common.timedata.defaultimplementation.DefaultTimeDistance;
import de.aristaflow.adept2.model.timemodel.tcn.ChangeableCSTN;
import de.aristaflow.adept2.model.timemodel.tcn.Label;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledEdge;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledTimePoint;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledValue;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledValueSet;
import de.aristaflow.adept2.model.timemodel.tcn.cstnImpl.AbstractCSTNProjection;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.DefaultLabeledEdge;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.DefaultLabeledValue;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.DefaultLabeledValueSet;
import java.util.ArrayList;

public class SinkDijkstra
extends AbstractCSTNProjection {
    public SinkDijkstra(ChangeableCSTN cstn) {
        super(cstn, true);
    }

    @Override
    protected LabeledEdge transformEdge(LabeledTimePoint from, LabeledTimePoint to, LabeledEdge originalEdge) {
        ArrayList<LabeledValue> values = new ArrayList<LabeledValue>();
        for (LabeledValue value : ((LabeledValueSet)originalEdge.getValue()).getLabeledValues()) {
            TimeDistance h_X = this.h(from, value.getLabel());
            TimeDistance h_Y = this.h(to, value.getLabel());
            TimeDistance u = h_X.add(value.getValue()).sub(h_Y);
            assert (u.compareTo(DefaultTimeDistance.ZERO_TIME_DISTANCE) >= 0);
            DefaultLabeledValue newValue = new DefaultLabeledValue(value.getLabel(), u);
            values.add(newValue);
        }
        return new DefaultLabeledEdge(from, to, new DefaultLabeledValueSet(values));
    }

    private TimeDistance h(LabeledTimePoint X, Label label) {
        LabeledTimePoint Z = (LabeledTimePoint)this.getBaseTCN().getTimeBaseEvent();
        LabeledEdge labeledEdge = (LabeledEdge)this.getBaseTCN().getEdge(Z, X);
        return this.scenarioProjection(labeledEdge, label);
    }

    private TimeDistance scenarioProjection(LabeledEdge edge, Label scenario) {
        TimeDistance min = DefaultTimeDistance.POSITIVE_INFINITE_TIME_DISTANCE;
        for (LabeledValue value : ((LabeledValueSet)edge.getValue()).getLabeledValues()) {
            if (!value.getLabel().satisfiable(scenario) || value.getValue().compareTo(min) >= 0) continue;
            min = value.getValue();
        }
        return min;
    }

    @Override
    protected LabeledEdge propagateUpdate(LabeledEdge edge) {
        ArrayList<LabeledValue> values = new ArrayList<LabeledValue>();
        LabeledTimePoint from = (LabeledTimePoint)edge.getSourceNode();
        LabeledTimePoint to = (LabeledTimePoint)edge.getTargetNode();
        for (LabeledValue value : ((LabeledValueSet)edge.getValue()).getLabeledValues()) {
            TimeDistance h_X = this.h(from, value.getLabel());
            TimeDistance u = h_X.sub(value.getValue());
            DefaultLabeledValue newValue = new DefaultLabeledValue(value.getLabel(), u);
            values.add(newValue);
        }
        return this.getBaseTCN().updateConstraint(new DefaultLabeledEdge(from, to, new DefaultLabeledValueSet(values)));
    }
}

