/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation;

import de.aristaflow.adept2.model.common.timedata.TimeDistance;
import de.aristaflow.adept2.model.common.timedata.defaultimplementation.DefaultTimeDistance;
import de.aristaflow.adept2.model.timemodel.GuardedInterval;
import de.aristaflow.adept2.model.timemodel.defaultimplementation.DefaultGuardedInterval;
import de.aristaflow.adept2.model.timemodel.tcn.CSTN;
import de.aristaflow.adept2.model.timemodel.tcn.CSTNU;
import de.aristaflow.adept2.model.timemodel.tcn.CompoundConstraintValue;
import de.aristaflow.adept2.model.timemodel.tcn.ConstraintValue;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledEdge;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledTimePoint;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledValue;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledValueSet;
import de.aristaflow.adept2.model.timemodel.tcn.STNU;
import de.aristaflow.adept2.model.timemodel.tcn.SimpleConstraintValue;
import de.aristaflow.adept2.model.timemodel.tcn.TCN;
import de.aristaflow.adept2.model.timemodel.tcn.TCNEdge;
import de.aristaflow.adept2.model.timemodel.tcn.TCNInstanceTimeModel;
import de.aristaflow.adept2.model.timemodel.tcn.TCNSolver;
import de.aristaflow.adept2.model.timemodel.tcn.TCNTemplateTimeModel;
import de.aristaflow.adept2.model.timemodel.tcn.TCNTimePoint;
import de.aristaflow.adept2.model.timemodel.tcn.cstnImpl.AbstractCSTNSolver;
import de.aristaflow.adept2.model.timemodel.tcn.cstnImpl.LabelBasedPC2Solver;
import de.aristaflow.adept2.model.timemodel.tcn.cstnuImpl.CSTNUDCSolver;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.ContingentLabeledValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

public class TCNAlgorithms {
    public static TCNSolver<LabeledTimePoint, LabeledValueSet, LabeledEdge> getSolver(TCN<LabeledTimePoint, LabeledEdge> cstnu) {
        return TCNAlgorithms.getSolver(cstnu.getClass());
    }

    public static TCNSolver<LabeledTimePoint, LabeledValueSet, LabeledEdge> getSolver(Class<? extends TCN> clazz) {
        AbstractCSTNSolver solver;
        if (CSTNU.class.isAssignableFrom(clazz)) {
            solver = new CSTNUDCSolver();
        } else if (CSTN.class.isAssignableFrom(clazz)) {
            solver = new LabelBasedPC2Solver();
        } else {
            throw new IllegalStateException();
        }
        return solver;
    }

    public static <N extends TCNTimePoint, V extends ConstraintValue, E extends TCNEdge<N, V>> Collection<Set<N>> findRigidComponents(TCN<N, E> tcn) {
        HashMap<TCNTimePoint, Set<TCNTimePoint>> localRigidComponents = new HashMap<TCNTimePoint, Set<TCNTimePoint>>();
        ArrayList<N> nodes = new ArrayList<N>(tcn.getTimePoints());
        ListIterator iter = nodes.listIterator(nodes.size());
        while (iter.hasPrevious()) {
            TCNTimePoint n1 = (TCNTimePoint)iter.previous();
            iter.remove();
            for (TCNTimePoint n2 : nodes) {
                Set<TCNTimePoint> set;
                E edge2;
                E edge1 = tcn.getEdge(n1, n2);
                if (edge1 == null || (edge2 = tcn.getEdge(n2, n1)) == null || !TCNAlgorithms.isRigidComponent(edge1, edge2)) continue;
                Set set1 = (Set)localRigidComponents.get(n1);
                Set set2 = (Set)localRigidComponents.get(n2);
                if (set1 == null && set2 == null) {
                    set = new HashSet();
                    localRigidComponents.put(n1, set);
                    localRigidComponents.put(n2, set);
                } else if (set1 != null && set2 == null) {
                    set = set1;
                    localRigidComponents.put(n2, set);
                } else if (set1 == null && set2 != null) {
                    set = set2;
                    localRigidComponents.put(n1, set);
                } else {
                    set = new HashSet(set1);
                    set.addAll(set2);
                    for (TCNTimePoint node : set) {
                        localRigidComponents.put(node, set);
                    }
                }
                set.add(n1);
                set.add(n2);
            }
        }
        return new HashSet<Set<N>>(localRigidComponents.values());
    }

    protected static <V extends ConstraintValue, E extends TCNEdge<?, V>> boolean isRigidComponent(E edge1, E edge2) {
        if (edge1.getValue() instanceof SimpleConstraintValue) {
            assert (edge2.getValue() instanceof SimpleConstraintValue);
            return TCNAlgorithms.isRigidComponent((SimpleConstraintValue)edge1.getValue(), (SimpleConstraintValue)edge2.getValue());
        }
        if (edge1 instanceof LabeledEdge) {
            return TCNAlgorithms.isRigidComponent((LabeledEdge)edge1, (LabeledEdge)edge2);
        }
        throw new IllegalArgumentException();
    }

    protected static boolean isRigidComponent(SimpleConstraintValue edge1, SimpleConstraintValue edge2) {
        TimeDistance sum = edge1.getValue().add(edge2.getValue());
        return sum.compareTo(DefaultTimeDistance.ZERO_TIME_DISTANCE) == 0;
    }

    protected static boolean isRigidComponent(LabeledEdge edge1, LabeledEdge edge2) {
        LabeledTimePoint node1 = (LabeledTimePoint)edge1.getSourceNode();
        LabeledTimePoint node2 = (LabeledTimePoint)edge2.getSourceNode();
        boolean[] rigidNode = new boolean[]{true, true};
        boolean rigid = false;
        for (LabeledValue value1 : ((LabeledValueSet)edge1.getValue()).getLabeledValues()) {
            for (LabeledValue value2 : ((LabeledValueSet)edge2.getValue()).getLabeledValues()) {
                if (!value1.getLabel().satisfiable(value2.getLabel())) continue;
                if (!TCNAlgorithms.isRigidComponent(value1, value2)) {
                    return false;
                }
                rigid = true;
                if (!value1.getLabel().isEmptyLabel() && !node1.getLabel().subsumes(value1.getLabel()) || !value2.getLabel().isEmptyLabel() && !node1.getLabel().subsumes(value2.getLabel())) {
                    rigidNode[0] = false;
                }
                if (!value1.getLabel().isEmptyLabel() && !node2.getLabel().subsumes(value1.getLabel()) || !value2.getLabel().isEmptyLabel() && !node2.getLabel().subsumes(value2.getLabel())) {
                    rigidNode[1] = false;
                }
                if (rigidNode[0] || rigidNode[1]) continue;
                return false;
            }
        }
        return rigid && (rigidNode[0] || rigidNode[1]);
    }

    public static <N extends TCNTimePoint, V extends CompoundConstraintValue, E extends TCNEdge<N, V>> N getSourceTimePoint(TCN<N, E> tcn) throws IllegalArgumentException {
        TCNTimePoint source = null;
        for (TCNTimePoint node : tcn.getTimePoints()) {
            boolean hasPredecessor = false;
            for (TCNTimePoint node2 : tcn.getTimePoints()) {
                TimeDistance outDist;
                TimeDistance inDist;
                E outgoing = tcn.getEdge(node, node2);
                E incoming = tcn.getEdge(node2, node);
                if (incoming != null && (inDist = TCNAlgorithms.getTimeDistance(incoming, false)).compareTo(DefaultTimeDistance.ZERO_TIME_DISTANCE) > 0) {
                    hasPredecessor = true;
                    break;
                }
                if (outgoing == null || (outDist = TCNAlgorithms.getTimeDistance(outgoing, true)).compareTo(DefaultTimeDistance.ZERO_TIME_DISTANCE) > 0) continue;
                hasPredecessor = true;
                break;
            }
            if (hasPredecessor) continue;
            if (source == null) {
                source = node;
                continue;
            }
            throw new IllegalArgumentException(String.format("More than one source node: '%s' and '%s'", source, node));
        }
        return (N)source;
    }

    public static <N extends TCNTimePoint, V extends CompoundConstraintValue, E extends TCNEdge<N, V>> N getTargetTimePoint(TCN<N, E> tcn) throws IllegalArgumentException {
        TCNTimePoint source = null;
        for (TCNTimePoint node : tcn.getTimePoints()) {
            boolean hasSuccessor = false;
            for (TCNTimePoint node2 : tcn.getTimePoints()) {
                TimeDistance outDist;
                TimeDistance inDist;
                E outgoing = tcn.getEdge(node, node2);
                E incoming = tcn.getEdge(node2, node);
                if (incoming != null && (inDist = TCNAlgorithms.getTimeDistance(incoming, false)).compareTo(DefaultTimeDistance.ZERO_TIME_DISTANCE) <= 0) {
                    hasSuccessor = true;
                    break;
                }
                if (outgoing == null || (outDist = TCNAlgorithms.getTimeDistance(outgoing, true)).compareTo(DefaultTimeDistance.ZERO_TIME_DISTANCE) <= 0) continue;
                hasSuccessor = true;
                break;
            }
            if (hasSuccessor) continue;
            if (source == null) {
                source = node;
                continue;
            }
            throw new IllegalArgumentException(String.format("More than one target node: '%s' and '%s'", source, node));
        }
        return (N)source;
    }

    public static <N extends TCNTimePoint> GuardedInterval<TimeDistance> getRestrictableDuration(TCNTemplateTimeModel<N, ?> timeModel) {
        TCN<N, ?> tcn = timeModel.getBaseTimeModel();
        if (!tcn.isConsistent()) {
            throw new IllegalArgumentException("tcn must be consistent!");
        }
        N sourceNode = timeModel.getProcessStartTimePoint();
        N targetNode = timeModel.getProcessEndTimePoint();
        if (sourceNode == null || targetNode == null) {
            throw new IllegalArgumentException("Process creation time point and process end time point of tcn must be set!");
        }
        return TCNAlgorithms.getRestrictableDuration(tcn, sourceNode, targetNode);
    }

    public static <N extends TCNTimePoint> GuardedInterval<TimeDistance> getRestrictableDuration(TCNInstanceTimeModel<N, ?> timeModel) {
        TCN<N, ?> tcn = timeModel.getBaseTimeModel();
        if (!tcn.isConsistent()) {
            throw new IllegalArgumentException("tcn must be consistent!");
        }
        N sourceNode = timeModel.getProcessStartTimePoint();
        N targetNode = timeModel.getProcessEndTimePoint();
        if (sourceNode == null || targetNode == null) {
            throw new IllegalArgumentException("Process creation time point and process end time point of tcn must be set!");
        }
        return TCNAlgorithms.getRestrictableDuration(tcn, sourceNode, targetNode);
    }

    public static <N extends TCNTimePoint, V extends CompoundConstraintValue, E extends TCNEdge<N, V>> GuardedInterval<TimeDistance> getRestrictableDuration(TCN<N, E> tcn, N sourceNode, N targetNode) {
        TimeDistance contingency;
        TimeDistance guardedMaxDur;
        TimeDistance guardedMinDur;
        if (sourceNode == null || targetNode == null) {
            throw new IllegalArgumentException("source and target node of the tcn must be given!");
        }
        if (!tcn.isConsistent()) {
            throw new IllegalArgumentException("TCN not minimal");
        }
        E flexMinDurEdge = tcn.getEdge(targetNode, sourceNode);
        if (flexMinDurEdge == null) {
            throw new IllegalArgumentException("TCN not minimal");
        }
        TimeDistance flexMinDur = TCNAlgorithms.getTimeDistance(flexMinDurEdge, true).neg();
        E flexMaxDurEdge = tcn.getEdge(sourceNode, targetNode);
        TimeDistance flexMaxDur = flexMaxDurEdge == null ? DefaultTimeDistance.POSITIVE_INFINITE_TIME_DISTANCE : TCNAlgorithms.getTimeDistance(flexMaxDurEdge, true);
        if (tcn instanceof STNU) {
            guardedMinDur = TCNAlgorithms.getMinGuardDistance((STNU)tcn, sourceNode, targetNode);
            guardedMaxDur = TCNAlgorithms.getMaxGuardDistance(tcn, sourceNode, targetNode);
            if (guardedMinDur == null) {
                guardedMinDur = flexMaxDur;
            }
            if (guardedMaxDur == null) {
                guardedMaxDur = flexMinDur;
            }
            if ((contingency = TCNAlgorithms.getContingency(tcn, sourceNode, targetNode)) == null) {
                contingency = DefaultTimeDistance.ZERO_TIME_DISTANCE;
            }
        } else {
            guardedMinDur = flexMaxDur;
            guardedMaxDur = flexMinDur;
            contingency = DefaultTimeDistance.ZERO_TIME_DISTANCE;
        }
        assert (flexMinDur.compareTo(DefaultTimeDistance.ZERO_TIME_DISTANCE) >= 0);
        assert (guardedMinDur.compareTo(DefaultTimeDistance.ZERO_TIME_DISTANCE) >= 0);
        assert (guardedMinDur.compareTo(flexMinDur) >= 0);
        assert (guardedMaxDur.compareTo(DefaultTimeDistance.ZERO_TIME_DISTANCE) >= 0);
        assert (guardedMaxDur.compareTo(flexMinDur) >= 0);
        assert (flexMaxDur.compareTo(DefaultTimeDistance.ZERO_TIME_DISTANCE) >= 0);
        assert (flexMaxDur.compareTo(guardedMaxDur) >= 0);
        return new DefaultGuardedInterval<TimeDistance>(flexMinDur, guardedMinDur, guardedMaxDur, flexMaxDur, contingency);
    }

    public static <V extends CompoundConstraintValue, E extends TCNEdge<?, V>> TimeDistance getTimeDistance(E edge, boolean maxValue) {
        SimpleConstraintValue[] values;
        int sgn = maxValue ? 1 : -1;
        TimeDistance timeDistance = null;
        SimpleConstraintValue[] simpleConstraintValueArray = values = ((CompoundConstraintValue)edge.getValue()).getValues();
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            SimpleConstraintValue constraintValue = simpleConstraintValueArray[n2];
            if (timeDistance == null) {
                timeDistance = constraintValue.getValue();
            } else if (constraintValue.getValue().compareTo(timeDistance) >= sgn) {
                timeDistance = constraintValue.getValue();
            }
            ++n2;
        }
        return timeDistance;
    }

    public static <N extends TCNTimePoint, V extends CompoundConstraintValue, E extends TCNEdge<N, V>> TimeDistance getMinGuardDistance(STNU<N, V, E> tcn, N baseNode, N targetNode) {
        HashMap<TCNTimePoint, TimeDistance> cycleDetection = new HashMap<TCNTimePoint, TimeDistance>();
        TimeDistance result = TCNAlgorithms.internalGetMinGuardIncoming(tcn, baseNode, targetNode, cycleDetection);
        System.out.println("minGuard(" + baseNode + ", " + targetNode + ") = " + result.toSeconds());
        return result;
    }

    protected static <N extends TCNTimePoint, V extends CompoundConstraintValue, E extends TCNEdge<N, V>> TimeDistance internalGetMinGuardIncoming(TCN<N, E> tcn, N baseNode, N targetNode, Map<TCNTimePoint, TimeDistance> cycleDetection) {
        if (cycleDetection.containsKey(targetNode)) {
            return cycleDetection.get(targetNode);
        }
        if (baseNode == targetNode) {
            return DefaultTimeDistance.ZERO_TIME_DISTANCE;
        }
        cycleDetection.put(targetNode, null);
        TimeDistance distance = null;
        Collection<E> incomingEdges = tcn.getIncomingEdges(targetNode);
        for (TCNEdge e : incomingEdges) {
            TimeDistance timePoint;
            TimeDistance dist = TCNAlgorithms.getTimeDistance(e, false);
            TimeDistance contDistance = TCNAlgorithms.getContingentValue(e);
            if (contDistance != null) {
                dist = contDistance;
            }
            if ((timePoint = TCNAlgorithms.internalGetMinGuardIncoming(tcn, baseNode, e.getSourceNode(), cycleDetection)) == null || timePoint.isInfinity()) continue;
            TimeDistance td = dist.add(timePoint);
            if (distance != null && distance.compareTo(td) <= 0) continue;
            distance = td;
        }
        cycleDetection.put(targetNode, distance);
        return distance;
    }

    public static <N extends TCNTimePoint, V extends CompoundConstraintValue, E extends TCNEdge<N, V>> TimeDistance getMaxGuardDistance(TCN<N, E> tcn, N baseNode, N targetNode) {
        HashMap<TCNTimePoint, TimeDistance> cycleDetection = new HashMap<TCNTimePoint, TimeDistance>();
        TimeDistance result = TCNAlgorithms.internalGetMaxGuardDistance(tcn, baseNode, targetNode, cycleDetection);
        return result;
    }

    protected static <N extends TCNTimePoint, V extends CompoundConstraintValue, E extends TCNEdge<N, V>> TimeDistance internalGetMaxGuardDistance(TCN<N, E> tcn, N baseNode, N targetNode, Map<TCNTimePoint, TimeDistance> cycleDetection) {
        if (cycleDetection.containsKey(targetNode)) {
            return cycleDetection.get(targetNode);
        }
        if (baseNode == targetNode) {
            return DefaultTimeDistance.ZERO_TIME_DISTANCE;
        }
        cycleDetection.put(targetNode, null);
        TimeDistance distance = null;
        Collection<E> outgoingEdges = tcn.getOutgoingEdges(targetNode);
        for (TCNEdge e : outgoingEdges) {
            TimeDistance timePoint;
            TimeDistance dist = TCNAlgorithms.getTimeDistance(e, false).neg();
            TimeDistance contDistance = TCNAlgorithms.getContingentValue(e);
            if (contDistance != null) {
                dist = contDistance.neg();
            }
            if ((timePoint = TCNAlgorithms.internalGetMaxGuardDistance(tcn, baseNode, e.getTargetNode(), cycleDetection)) == null || timePoint.isInfinity()) continue;
            TimeDistance td = dist.add(timePoint);
            TimeDistance timeDistance = distance = distance != null && distance.compareTo(td) >= 0 ? distance : td;
        }
        cycleDetection.put(targetNode, distance);
        return distance;
    }

    public static <N extends TCNTimePoint, V extends CompoundConstraintValue, E extends TCNEdge<N, V>> TimeDistance getContingency(TCN<N, E> tcn, N baseNode, N targetNode) {
        HashMap<TCNTimePoint, TimeDistance> cycleDetection = new HashMap<TCNTimePoint, TimeDistance>();
        TimeDistance result = TCNAlgorithms.internalGetContingency(tcn, baseNode, targetNode, cycleDetection);
        if (result == null) {
            return null;
        }
        return result.compareTo(DefaultTimeDistance.ZERO_TIME_DISTANCE) > 0 ? result : DefaultTimeDistance.ZERO_TIME_DISTANCE;
    }

    protected static <N extends TCNTimePoint, V extends CompoundConstraintValue, E extends TCNEdge<N, V>> TimeDistance internalGetContingency(TCN<N, E> tcn, N baseNode, N targetNode, Map<TCNTimePoint, TimeDistance> cycleDetection) {
        if (cycleDetection.containsKey(targetNode)) {
            return cycleDetection.get(targetNode);
        }
        if (baseNode == targetNode) {
            return DefaultTimeDistance.ZERO_TIME_DISTANCE;
        }
        cycleDetection.put(targetNode, null);
        TimeDistance contingency = null;
        Collection<E> incomingEdges = tcn.getIncomingEdges(targetNode);
        for (TCNEdge e : incomingEdges) {
            TimeDistance distUpper = TCNAlgorithms.getTimeDistance(e, false);
            if (distUpper.compareTo(DefaultTimeDistance.ZERO_TIME_DISTANCE) < 0) continue;
            E ec = tcn.getEdge(e.getTargetNode(), e.getSourceNode());
            TimeDistance distLower = null;
            if (ec != null) {
                distLower = TCNAlgorithms.getTimeDistance(ec, true);
            }
            TimeDistance cont = distLower == null || distLower.compareTo(DefaultTimeDistance.ZERO_TIME_DISTANCE) >= 0 ? distUpper : distUpper.add(distLower);
            TimeDistance recursion = TCNAlgorithms.internalGetContingency(tcn, baseNode, e.getSourceNode(), cycleDetection);
            if (recursion == null) continue;
            TimeDistance td = cont.neg().add(recursion);
            contingency = contingency != null && contingency.compareTo(td) >= 0 ? contingency : td;
            TimeDistance contMinDistance = TCNAlgorithms.getContingentMinValue(e);
            TimeDistance contMaxDistance = null;
            if (ec != null) {
                contMaxDistance = TCNAlgorithms.getContingentMaxValue(ec);
            }
            if (contMinDistance == null) continue;
            if (contMaxDistance == null) {
                contMaxDistance = distLower;
            }
            cont = contMinDistance.sub(contMaxDistance).neg();
            td = recursion.compareTo(DefaultTimeDistance.ZERO_TIME_DISTANCE) < 0 ? cont.add(recursion) : cont;
            TimeDistance timeDistance = contingency = contingency != null && contingency.compareTo(td) >= 0 ? contingency : td;
        }
        cycleDetection.put(targetNode, contingency);
        return contingency;
    }

    public static <V extends CompoundConstraintValue, E extends TCNEdge<?, V>> TimeDistance getContingentMaxValue(E edge) {
        TimeDistance contMaxValue = null;
        SimpleConstraintValue[] simpleConstraintValueArray = ((CompoundConstraintValue)edge.getValue()).getValues();
        int n = simpleConstraintValueArray.length;
        int n2 = 0;
        while (n2 < n) {
            ContingentLabeledValue contingentLabeledValue;
            SimpleConstraintValue v = simpleConstraintValueArray[n2];
            if (v instanceof ContingentLabeledValue && ContingentLabeledValue.ConstraintCase.UPPERCASE.equals((Object)(contingentLabeledValue = (ContingentLabeledValue)v).getCase())) {
                TimeDistance contingentValue = contingentLabeledValue.getContingentValue().neg();
                if (contMaxValue == null || contMaxValue.compareTo(contingentValue) < 0) {
                    contMaxValue = contingentValue;
                }
            }
            ++n2;
        }
        return contMaxValue;
    }

    public static <V extends CompoundConstraintValue, E extends TCNEdge<?, V>> TimeDistance getContingentMinValue(E edge) {
        TimeDistance contMinValue = null;
        SimpleConstraintValue[] simpleConstraintValueArray = ((CompoundConstraintValue)edge.getValue()).getValues();
        int n = simpleConstraintValueArray.length;
        int n2 = 0;
        while (n2 < n) {
            ContingentLabeledValue contingentLabeledValue;
            SimpleConstraintValue v = simpleConstraintValueArray[n2];
            if (v instanceof ContingentLabeledValue && ContingentLabeledValue.ConstraintCase.LOWERCASE.equals((Object)(contingentLabeledValue = (ContingentLabeledValue)v).getCase())) {
                TimeDistance contingentValue = contingentLabeledValue.getContingentValue();
                if (contMinValue == null || contMinValue.compareTo(contingentValue) > 0) {
                    contMinValue = contingentValue;
                }
            }
            ++n2;
        }
        return contMinValue;
    }

    public static <V extends CompoundConstraintValue, E extends TCNEdge<?, V>> TimeDistance getContingentValue(E edge) {
        TimeDistance contValue = null;
        SimpleConstraintValue[] simpleConstraintValueArray = ((CompoundConstraintValue)edge.getValue()).getValues();
        int n = simpleConstraintValueArray.length;
        int n2 = 0;
        while (n2 < n) {
            SimpleConstraintValue v = simpleConstraintValueArray[n2];
            if (v instanceof ContingentLabeledValue) {
                ContingentLabeledValue contingentLabeledValue = (ContingentLabeledValue)v;
                TimeDistance contingentValue = contingentLabeledValue.getContingentValue();
                if (contValue == null || contValue.compareTo(contingentValue) > 0) {
                    contValue = contingentValue;
                }
            }
            ++n2;
        }
        return contValue;
    }
}

