/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.timemodel.tcn.stnuImpl;

import de.aristaflow.adept2.model.common.timedata.TimeDistance;
import de.aristaflow.adept2.model.common.timedata.defaultimplementation.DefaultTimeDistance;
import de.aristaflow.adept2.model.timemodel.ChangeSet;
import de.aristaflow.adept2.model.timemodel.defaultimplementation.Path;
import de.aristaflow.adept2.model.timemodel.defaultimplementation.Triangle;
import de.aristaflow.adept2.model.timemodel.tcn.ChangeableSTNU;
import de.aristaflow.adept2.model.timemodel.tcn.ChangeableTCN;
import de.aristaflow.adept2.model.timemodel.tcn.Label;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledEdge;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledTimePoint;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledValue;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledValueSet;
import de.aristaflow.adept2.model.timemodel.tcn.STNU;
import de.aristaflow.adept2.model.timemodel.tcn.TCNEdge;
import de.aristaflow.adept2.model.timemodel.tcn.TCNInconsistencyException;
import de.aristaflow.adept2.model.timemodel.tcn.TCNSolver;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.AbstractSTNSolver;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.ContingentLabeledValue;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.DefaultContingentLabeledValue;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.DefaultLabeledEdge;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.DefaultLabeledValue;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.DefaultLabeledValueSet;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.PC2Solver;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.STNEdge;
import de.aristaflow.adept2.model.timemodel.tcn.stnuImpl.STNUAllMaxProjection;
import de.aristaflow.adept2.model.timemodel.tools.DuplicateFreeQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;

public class STNUDCSolver
extends AbstractSTNSolver<LabeledTimePoint, LabeledValueSet, LabeledEdge>
implements TCNSolver<LabeledTimePoint, LabeledValueSet, LabeledEdge> {
    private int updateCount;
    private STNUAllMaxProjection allMax;
    private Collection<Path<LabeledTimePoint>> changedEdges;

    public STNUDCSolver() {
    }

    public STNUDCSolver(Level debugLevel) {
        super(debugLevel);
    }

    @Override
    public <T extends ChangeableTCN<LabeledTimePoint, LabeledEdge>> T solve(T tcn) throws TCNInconsistencyException, InterruptedException {
        return this.solve(tcn, (ChangeSet<LabeledEdge, LabeledValueSet, Triangle<LabeledTimePoint>>)null);
    }

    @Override
    public <T extends ChangeableTCN<LabeledTimePoint, LabeledEdge>> T solve(T tcn, ChangeSet<LabeledEdge, LabeledValueSet, Triangle<LabeledTimePoint>> changeSet) throws TCNInconsistencyException, InterruptedException {
        if (tcn instanceof ChangeableSTNU) {
            return (T)this.solve((ChangeableSTNU)tcn, changeSet);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public ChangeableSTNU<LabeledTimePoint, LabeledValueSet, LabeledEdge> solve(ChangeableSTNU<LabeledTimePoint, LabeledValueSet, LabeledEdge> model, ChangeSet<LabeledEdge, LabeledValueSet, Triangle<LabeledTimePoint>> changeSet) throws TCNInconsistencyException, InterruptedException {
        ChangeableSTNU<LabeledTimePoint, LabeledValueSet, LabeledEdge> cstnu = model;
        if (cstnu.isControllable()) {
            return cstnu;
        }
        int nodeCount = cstnu.getTimePoints().size();
        int cutoff = nodeCount * cstnu.getEdges().size();
        PC2Solver<STNEdge> pc2solver = new PC2Solver<STNEdge>();
        this.allMax = new STNUAllMaxProjection(cstnu);
        DuplicateFreeQueue queue = new DuplicateFreeQueue(nodeCount * nodeCount * 2);
        Collection timePoints = model.getTimePoints();
        int iter = 0;
        while (iter < cutoff) {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
            assert (this.debug(Level.FINE, "\nIteration %s", iter));
            this.updateCount = 0;
            pc2solver.solve(this.allMax, this.changedEdges, null);
            this.getInitialPaths(timePoints, queue);
            this.changedEdges = new ArrayList<Path<LabeledTimePoint>>();
            boolean changes = false;
            while (!queue.isEmpty()) {
                if (Thread.currentThread().isInterrupted()) {
                    throw new InterruptedException();
                }
                Path path = (Path)((Object)queue.remove());
                LabeledTimePoint i = (LabeledTimePoint)path.getFirst();
                LabeledTimePoint j = (LabeledTimePoint)path.getSecond();
                for (LabeledTimePoint k : timePoints) {
                    if (i.equals(k) || j.equals(k)) continue;
                    changes |= this.processPath(cstnu, changeSet, i, j, k);
                    changes |= this.processPath(cstnu, changeSet, k, i, j);
                }
            }
            if (!changes) {
                assert (this.debug(Level.FINE, "Controllable!"));
                break;
            }
            assert (this.debug(Level.FINE, "%s Updates", this.updateCount));
            ++iter;
        }
        if (iter >= cutoff) {
            assert (this.debug(Level.FINE, "Upps Cutoff bound reached"));
            throw new TCNInconsistencyException("CutoffBound reached", cstnu);
        }
        cstnu.setControllable();
        return cstnu;
    }

    public boolean processPath(ChangeableSTNU<LabeledTimePoint, LabeledValueSet, LabeledEdge> model, ChangeSet<LabeledEdge, LabeledValueSet, Triangle<LabeledTimePoint>> changeSet, LabeledTimePoint i, LabeledTimePoint j, LabeledTimePoint k) throws TCNInconsistencyException {
        LabeledValue lowerCaseReduction;
        LabeledValue crossCaseReduction;
        LabeledValue upperCaseReduction;
        LabeledValue noCaseReduction;
        LabeledEdge e_ij = (LabeledEdge)model.getEdge(i, j);
        LabeledEdge e_jk = (LabeledEdge)model.getEdge(j, k);
        if (e_ij == null || e_jk == null) {
            return false;
        }
        boolean localChanges = false;
        assert (model != null);
        assert (e_ij != null);
        assert (e_jk != null);
        assert (e_ij.getTargetNode() == e_jk.getSourceNode());
        LabeledEdge e_ik = (LabeledEdge)model.getEdge(i, k);
        assert (this.debug(Level.FINE, "Evaluating (%s, %s) = (%s) \\cap (%s) + (%s)", i, k, e_ik, e_ij, e_jk));
        LabeledValue value = null;
        if (e_ik != null) {
            value = ((LabeledValueSet)e_ik.getValue()).getLabeledValues().iterator().next();
        }
        if ((noCaseReduction = this.NoCaseReduction(model, e_ij, e_jk)) != null) {
            LabeledValue newValue;
            LabeledValue labeledValue = newValue = value != null ? this.merge(noCaseReduction, value) : noCaseReduction;
            assert (this.debug(Level.FINEST, "\tAfter merge: %s", newValue));
            localChanges = newValue != value;
            value = newValue;
        }
        if ((upperCaseReduction = this.UpperCaseReduction(model, e_ij, e_jk)) != null) {
            LabeledValue newValue;
            LabeledValue labeledValue = newValue = value != null ? this.merge(upperCaseReduction, value) : upperCaseReduction;
            assert (this.debug(Level.FINEST, "\tAfter merge: %s", newValue));
            localChanges = newValue != value;
            value = newValue;
        }
        if ((crossCaseReduction = this.CrossCaseReduction(model, e_ij, e_jk)) != null) {
            LabeledValue newValue;
            LabeledValue labeledValue = newValue = value != null ? this.merge(crossCaseReduction, value) : crossCaseReduction;
            assert (this.debug(Level.FINEST, "\tAfter merge: %s", newValue));
            localChanges = newValue != value;
            value = newValue;
        }
        if ((lowerCaseReduction = this.LowerCaseReduction(model, e_ij, e_jk)) != null) {
            LabeledValue newValue;
            LabeledValue labeledValue = newValue = value != null ? this.merge(lowerCaseReduction, value) : lowerCaseReduction;
            assert (this.debug(Level.FINEST, "\tAfter merge: %s", newValue));
            localChanges = newValue != value;
            value = newValue;
        }
        assert (this.debug(Level.FINE, "   Generation Rules generated %s", value));
        assert (this.debug(Level.FINE, "   Intersection resulted in %s", value));
        LabeledValue labelRemovalReduction = this.LabelRemovalReduction(model, value, (LabeledTimePoint)e_ij.getSourceNode(), (LabeledTimePoint)e_jk.getTargetNode());
        if (labelRemovalReduction != null) {
            LabeledValue newValue = labelRemovalReduction;
            assert (this.debug(Level.FINEST, "\tAfter merge: %s", newValue));
            localChanges = newValue != value;
            value = newValue;
        }
        assert (this.debug(Level.FINE, "   Label Removal Rules resulted in %s", value));
        DefaultLabeledValueSet labeledValueSet = new DefaultLabeledValueSet(value);
        if (localChanges && (e_ik == null || !((Object)labeledValueSet).equals(e_ik.getValue()))) {
            if (!$assertionsDisabled) {
                Object[] objectArray = new Object[1];
                Object object = objectArray[0] = e_ik != null ? Boolean.valueOf(((Object)labeledValueSet).equals(e_ik.getValue())) : "null";
                if (!this.debug(Level.FINEST, "Equals: %s", objectArray)) {
                    throw new AssertionError();
                }
            }
            DefaultLabeledEdge labeledEdge = new DefaultLabeledEdge(i, k, labeledValueSet, e_ik != null && e_ik.isControlEdge(), e_ik == null || e_ik.isImplicit(), e_ik != null ? e_ik.getFlowDirection() : TCNEdge.FlowDirection.UNKOWN);
            assert (this.debug(Level.FINE, "  Updating\t %s to %s (because of %s and %s)", e_ik, labeledEdge, e_ij, e_jk));
            this.updateContingentConstraint(changeSet, model, labeledEdge, new Triangle<LabeledTimePoint>(new Path<LabeledTimePoint>(i, k), j), "STNUDC");
            return true;
        }
        assert (this.debug(Level.FINE, "  Ignoring\t %s to %s (because no changes)", e_ik, labeledValueSet));
        return false;
    }

    protected LabeledValue merge(LabeledValue newValue, LabeledValue oldValue) {
        if (newValue instanceof ContingentLabeledValue) {
            TimeDistance newTD;
            if (oldValue instanceof ContingentLabeledValue) {
                ContingentLabeledValue clNew = (ContingentLabeledValue)newValue;
                ContingentLabeledValue clOld = (ContingentLabeledValue)oldValue;
                int compareNonCont = clOld.getValue().compareTo(clNew.getValue());
                int compareCont = clOld.getContingentValue().compareTo(clNew.getContingentValue());
                if (compareCont > 0 || compareNonCont > 0) {
                    assert (clNew.getCase() == clOld.getCase()) : clOld + " vs. " + clNew;
                    assert (clNew.getTrigger() == clOld.getTrigger()) : "Trying to merge contingent constraints with different triggers!";
                    if (compareCont >= 0 && compareNonCont >= 0) {
                        return newValue;
                    }
                    TimeDistance nonContValeu = compareNonCont > 0 ? clNew.getValue() : clOld.getValue();
                    TimeDistance contValue = compareCont > 0 ? clNew.getContingentValue() : clOld.getContingentValue();
                    return this.updateLabeledValue(clNew, nonContValeu, contValue);
                }
                return oldValue;
            }
            ContingentLabeledValue clNew = (ContingentLabeledValue)newValue;
            TimeDistance oldTD = oldValue.getValue();
            int compareNonCont = oldTD.compareTo(newTD = clNew.getValue());
            if (compareNonCont >= 0) {
                return newValue;
            }
            TimeDistance contValue = clNew.getContingentValue();
            TimeDistance nonContValue = oldValue.getValue();
            return this.updateLabeledValue(clNew, nonContValue, contValue);
        }
        if (oldValue instanceof ContingentLabeledValue) {
            ContingentLabeledValue clOld = (ContingentLabeledValue)oldValue;
            int compareNonCont = clOld.getValue().compareTo(newValue.getValue());
            if (compareNonCont > 0) {
                TimeDistance nonContValue = newValue.getValue();
                TimeDistance contValue = clOld.getContingentValue();
                return this.updateLabeledValue(clOld, nonContValue, contValue);
            }
            return oldValue;
        }
        int compare = oldValue.getValue().compareTo(newValue.getValue());
        if (compare > 0) {
            return newValue;
        }
        return oldValue;
    }

    protected LabeledValue updateLabeledValue(ContingentLabeledValue oldValue, TimeDistance nonContValue, TimeDistance contValue) {
        DefaultLabeledValue value = nonContValue.compareTo(contValue) <= 0 ? new DefaultLabeledValue(oldValue.getLabel(), nonContValue) : new DefaultContingentLabeledValue(oldValue.getLabel(), oldValue.getCase(), nonContValue, oldValue.getTrigger(), contValue);
        return value;
    }

    protected ContingentLabeledValue getContingentDurationConstraint(STNU<LabeledTimePoint, LabeledValueSet, LabeledEdge> cstnu, LabeledTimePoint from, LabeledTimePoint to) {
        LabeledEdge edge = (LabeledEdge)cstnu.getEdge(from, to);
        return this.getContingentDurationConstraint(edge);
    }

    protected ContingentLabeledValue getContingentDurationConstraint(LabeledEdge edge) {
        ContingentLabeledValue res = null;
        if (edge != null) {
            assert (((LabeledValueSet)edge.getValue()).getLabeledValues().size() == 1);
            for (LabeledValue v : ((LabeledValueSet)edge.getValue()).getLabeledValues()) {
                if (!(v instanceof ContingentLabeledValue) || ((ContingentLabeledValue)v).getTrigger() != edge.getSourceNode() && ((ContingentLabeledValue)v).getTrigger() != edge.getTargetNode()) continue;
                if (res != null) {
                    throw new IllegalStateException();
                }
                res = (ContingentLabeledValue)v;
            }
            if (res == null) {
                throw new IllegalStateException();
            }
        }
        return res;
    }

    private LabeledValue LabelRemovalReduction(STNU<LabeledTimePoint, LabeledValueSet, LabeledEdge> cstnu, LabeledValue l_CA, LabeledTimePoint C, LabeledTimePoint A) throws TCNInconsistencyException {
        TimeDistance x;
        if (!(l_CA instanceof ContingentLabeledValue) || !ContingentLabeledValue.ConstraintCase.UPPERCASE.equals((Object)((ContingentLabeledValue)l_CA).getCase())) {
            return null;
        }
        ContingentLabeledValue cl_CA = (ContingentLabeledValue)l_CA;
        if (cl_CA.getTrigger() == C || cl_CA.getTrigger() == A) {
            return null;
        }
        ContingentLabeledValue cl_AB = this.getContingentDurationConstraint(cstnu, A, cl_CA.getTrigger());
        if (!ContingentLabeledValue.ConstraintCase.LOWERCASE.equals((Object)cl_AB.getCase())) {
            return null;
        }
        TimeDistance z = cl_CA.getContingentValue();
        if (z.compareTo((x = cl_AB.getContingentValue()).neg()) < 0) {
            return null;
        }
        assert (cl_AB.getCase().equals((Object)ContingentLabeledValue.ConstraintCase.LOWERCASE));
        assert (cl_CA.getCase().equals((Object)ContingentLabeledValue.ConstraintCase.UPPERCASE));
        TimeDistance value = z;
        Label proposition = cl_CA.getLabel();
        DefaultLabeledValue newLabel = new DefaultLabeledValue(proposition, value);
        assert (this.debug(Level.FINER, "\tLabelRemoval:\t Replacing %s by %s", cl_CA, newLabel));
        return newLabel;
    }

    private LabeledValue LowerCaseReduction(STNU<LabeledTimePoint, LabeledValueSet, LabeledEdge> cstnu, LabeledEdge QS, LabeledEdge ST) throws TCNInconsistencyException {
        assert (((LabeledValueSet)QS.getValue()).getLabeledValues().size() == 1);
        assert (((LabeledValueSet)ST.getValue()).getLabeledValues().size() == 1);
        LabeledValue l_ST = ((LabeledValueSet)ST.getValue()).getLabeledValues().iterator().next();
        if (l_ST instanceof ContingentLabeledValue) {
            return null;
        }
        LabeledValue l_QS = ((LabeledValueSet)QS.getValue()).getLabeledValues().iterator().next();
        if (!(l_QS instanceof ContingentLabeledValue) || !ContingentLabeledValue.ConstraintCase.LOWERCASE.equals((Object)((ContingentLabeledValue)l_QS).getCase())) {
            return null;
        }
        ContingentLabeledValue cl_QS = (ContingentLabeledValue)l_QS;
        TimeDistance v = l_ST.getValue();
        long cv = v.sign();
        if (cv >= 0L && (cv != 0L || ST.getSourceNode() == ST.getTargetNode())) {
            return null;
        }
        assert (ContingentLabeledValue.ConstraintCase.LOWERCASE.equals((Object)cl_QS.getCase()));
        assert (QS.getTargetNode() == ST.getSourceNode());
        assert (cl_QS.getTrigger() == QS.getTargetNode());
        TimeDistance value = l_ST.getValue().add(cl_QS.getContingentValue());
        Label proposition = this.mergeLabels(l_ST.getLabel(), cl_QS.getLabel());
        DefaultLabeledValue newLabel = new DefaultLabeledValue(proposition, value);
        assert (this.debug(Level.FINER, "\tLowerCase:\t %s + %s -> %s", cl_QS, l_ST, newLabel));
        return newLabel;
    }

    private LabeledValue CrossCaseReduction(STNU<LabeledTimePoint, LabeledValueSet, LabeledEdge> cstnu, LabeledEdge DC, LabeledEdge CA) throws TCNInconsistencyException {
        assert (((LabeledValueSet)DC.getValue()).getLabeledValues().size() == 1);
        assert (((LabeledValueSet)CA.getValue()).getLabeledValues().size() == 1);
        LabeledValue l_CA = ((LabeledValueSet)CA.getValue()).getLabeledValues().iterator().next();
        if (!(l_CA instanceof ContingentLabeledValue) || !ContingentLabeledValue.ConstraintCase.UPPERCASE.equals((Object)((ContingentLabeledValue)l_CA).getCase())) {
            return null;
        }
        ContingentLabeledValue cl_CA = (ContingentLabeledValue)l_CA;
        LabeledValue l_DC = ((LabeledValueSet)DC.getValue()).getLabeledValues().iterator().next();
        if (!(l_DC instanceof ContingentLabeledValue) || !ContingentLabeledValue.ConstraintCase.LOWERCASE.equals((Object)((ContingentLabeledValue)l_DC).getCase())) {
            return null;
        }
        ContingentLabeledValue cl_DC = (ContingentLabeledValue)l_DC;
        if (cl_CA.getContingentValue().sign() > 0 || cl_CA.getTrigger() == CA.getSourceNode()) {
            return null;
        }
        assert (cl_CA.getCase().equals((Object)ContingentLabeledValue.ConstraintCase.UPPERCASE));
        assert (cl_DC.getCase().equals((Object)ContingentLabeledValue.ConstraintCase.LOWERCASE));
        assert (DC.getTargetNode() == CA.getSourceNode());
        assert (cl_CA.getTrigger() != CA.getSourceNode());
        assert (cl_DC.getTrigger() == DC.getTargetNode());
        TimeDistance value = cl_CA.getContingentValue().add(cl_DC.getContingentValue());
        Label proposition = this.mergeLabels(cl_CA.getLabel(), cl_DC.getLabel());
        LabeledValue newLabel = this.createContingentConstraint(proposition, value, cl_CA.getTrigger());
        assert (this.debug(Level.FINER, "\tCrossCase:\t %s + %s -> %s", cl_DC, cl_CA, newLabel));
        return newLabel;
    }

    private LabeledValue UpperCaseReduction(STNU<LabeledTimePoint, LabeledValueSet, LabeledEdge> cstnu, LabeledEdge QS, LabeledEdge ST) throws TCNInconsistencyException {
        assert (((LabeledValueSet)QS.getValue()).getLabeledValues().size() == 1);
        assert (((LabeledValueSet)ST.getValue()).getLabeledValues().size() == 1);
        LabeledValue l_QS = ((LabeledValueSet)QS.getValue()).getLabeledValues().iterator().next();
        if (l_QS instanceof ContingentLabeledValue) {
            return null;
        }
        LabeledValue l_ST = ((LabeledValueSet)ST.getValue()).getLabeledValues().iterator().next();
        if (!(l_ST instanceof ContingentLabeledValue) || !ContingentLabeledValue.ConstraintCase.UPPERCASE.equals((Object)((ContingentLabeledValue)l_ST).getCase())) {
            return null;
        }
        ContingentLabeledValue cl_ST = (ContingentLabeledValue)l_ST;
        assert (cl_ST.getCase().equals((Object)ContingentLabeledValue.ConstraintCase.UPPERCASE));
        assert (QS.getTargetNode() == ST.getSourceNode());
        TimeDistance value = l_QS.getValue().add(cl_ST.getContingentValue());
        Label proposition = this.mergeLabels(l_QS.getLabel(), cl_ST.getLabel());
        LabeledValue newLabel = this.createContingentConstraint(proposition, value, cl_ST.getTrigger());
        assert (this.debug(Level.FINER, "\tUpperCase:\t %s + %s -> %s", l_QS, cl_ST, newLabel));
        return newLabel;
    }

    protected LabeledValue createContingentConstraint(Label proposition, TimeDistance value, LabeledTimePoint trigger) {
        DefaultContingentLabeledValue newLabel = new DefaultContingentLabeledValue(proposition, ContingentLabeledValue.ConstraintCase.UPPERCASE, DefaultTimeDistance.POSITIVE_INFINITE_TIME_DISTANCE, trigger, value);
        return newLabel;
    }

    private LabeledValue NoCaseReduction(STNU<LabeledTimePoint, LabeledValueSet, LabeledEdge> cstnu, LabeledEdge QS, LabeledEdge ST) throws TCNInconsistencyException {
        assert (((LabeledValueSet)QS.getValue()).getLabeledValues().size() == 1);
        assert (((LabeledValueSet)ST.getValue()).getLabeledValues().size() == 1);
        LabeledValue cl_ST = ((LabeledValueSet)ST.getValue()).getLabeledValues().iterator().next();
        LabeledValue cl_QS = ((LabeledValueSet)QS.getValue()).getLabeledValues().iterator().next();
        assert (cl_ST.getValue() != null);
        assert (cl_QS.getValue() != null);
        assert (QS.getTargetNode() == ST.getSourceNode());
        TimeDistance value = cl_QS.getValue().add(cl_ST.getValue());
        Label proposition = this.mergeLabels(cl_QS.getLabel(), cl_ST.getLabel());
        DefaultLabeledValue newLabel = new DefaultLabeledValue(proposition, value);
        assert (this.debug(Level.FINER, "\tNoCase:\t\t %s + %s -> %s", cl_QS, cl_ST, newLabel));
        return newLabel;
    }

    private void updateContingentConstraint(ChangeSet<LabeledEdge, LabeledValueSet, Triangle<LabeledTimePoint>> changeSet, ChangeableSTNU<LabeledTimePoint, LabeledValueSet, LabeledEdge> cstnu, LabeledEdge edge, Triangle<LabeledTimePoint> causedBy, String reason) throws TCNInconsistencyException {
        LabeledEdge oldEdge = (LabeledEdge)cstnu.getEdge((LabeledTimePoint)edge.getSourceNode(), (LabeledTimePoint)edge.getTargetNode());
        if (changeSet != null) {
            LabeledValueSet oldValue = oldEdge != null ? (LabeledValueSet)oldEdge.getValue() : null;
            this.logChange(changeSet, (Path)((Object)causedBy.getFirst()), (LabeledTimePoint)causedBy.getSecond(), edge, oldValue, reason);
        }
        this.checkConsistency(cstnu, edge, causedBy);
        cstnu.updateContingentConstraint(edge);
        this.changedEdges.add(new Path<LabeledTimePoint>((LabeledTimePoint)edge.getSourceNode(), (LabeledTimePoint)edge.getTargetNode()));
        this.allMax.removeDelta(edge);
        ++this.updateCount;
    }

    @Override
    public boolean checkConsistency(LabeledValueSet value1, LabeledValueSet value2) {
        for (LabeledValue labeledValue1 : value1.getLabeledValues()) {
            for (LabeledValue labeledValue2 : value2.getLabeledValues()) {
                if (this.isConsistent(labeledValue1, labeledValue2)) continue;
                return false;
            }
        }
        return true;
    }
}

