/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.timemodel.tcn.xml;

import de.aristaflow.adept2.model.common.PluginDataContainer;
import de.aristaflow.adept2.model.common.XMLExportTools;
import de.aristaflow.adept2.model.common.timedata.TimeDistance;
import de.aristaflow.adept2.model.timemodel.tcn.CSTN;
import de.aristaflow.adept2.model.timemodel.tcn.CSTNU;
import de.aristaflow.adept2.model.timemodel.tcn.IterationChain;
import de.aristaflow.adept2.model.timemodel.tcn.JoinNodeMapping;
import de.aristaflow.adept2.model.timemodel.tcn.Label;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledEdge;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledTimePoint;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledValue;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledValueSet;
import de.aristaflow.adept2.model.timemodel.tcn.NodeInstance;
import de.aristaflow.adept2.model.timemodel.tcn.NodeMapping;
import de.aristaflow.adept2.model.timemodel.tcn.STNU;
import de.aristaflow.adept2.model.timemodel.tcn.SplitNodeMapping;
import de.aristaflow.adept2.model.timemodel.tcn.TCN;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.ContingentLabeledValue;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.ContingentLabeledValueWithContingency;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.DefaultObservationTimePoint;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.ObservationBinding;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.Proposition;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeSet;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CSTNUXMLExportTools {
    public static final String NS = null;

    public Element createCSTNElement(Document document, TCN<LabeledTimePoint, LabeledEdge> cstn) {
        Element rootElement = document.createElementNS(NS, "cstnu");
        if (cstn instanceof CSTNU) {
            rootElement.setAttribute("type", "cstnu");
        } else if (cstn instanceof CSTN) {
            rootElement.setAttribute("type", "cstn");
        } else if (cstn instanceof STNU) {
            rootElement.setAttribute("type", "stnu");
        } else {
            throw new IllegalArgumentException();
        }
        rootElement.setAttributeNS(null, "version", "1.0");
        Element nodesElement = CSTNUXMLExportTools.addElement(document, rootElement, "tcnNodes");
        this.fillNodesElement(document, nodesElement, cstn.getTimePoints());
        CSTNUXMLExportTools.addElement(document, rootElement, "nodeMappings");
        Element edgesElement = CSTNUXMLExportTools.addElement(document, rootElement, "tcnEdges");
        this.fillEdgesElement(document, edgesElement, cstn.getEdges());
        return rootElement;
    }

    private void fillEdgesElement(Document document, Element edgesElement, Collection<LabeledEdge> tcnEdges) {
        for (LabeledEdge edge : tcnEdges) {
            Element edgeElement = this.createEdgeElement(document, edge);
            edgesElement.appendChild(edgeElement);
        }
    }

    private Element createEdgeElement(Document document, LabeledEdge edge) {
        Element edgeElement = document.createElementNS(NS, "labeledEdge");
        Element sourceNode = CSTNUXMLExportTools.addElement(document, edgeElement, "sourceNode");
        this.fillNodeReference(document, sourceNode, (LabeledTimePoint)edge.getSourceNode());
        Element targetNode = CSTNUXMLExportTools.addElement(document, edgeElement, "targetNode");
        this.fillNodeReference(document, targetNode, (LabeledTimePoint)edge.getTargetNode());
        edgeElement.setAttributeNS(NS, "controlEdge", "" + edge.isControlEdge());
        edgeElement.setAttributeNS(NS, "implicit", "" + edge.isImplicit());
        edgeElement.setAttributeNS(NS, "flowDirection", edge.getFlowDirection().toString());
        Element valueNode = CSTNUXMLExportTools.addElement(document, edgeElement, "value");
        this.fillLabeledValueSetElement(document, valueNode, (LabeledValueSet)edge.getValue());
        return edgeElement;
    }

    private void fillLabeledValueSetElement(Document document, Element valueNodeElement, LabeledValueSet values) {
        for (LabeledValue value : values.getLabeledValues()) {
            Element valueElement = this.createLabeledValueElement(document, value);
            valueNodeElement.appendChild(valueElement);
        }
    }

    private Element createLabeledValueElement(Document document, LabeledValue value) {
        Element valueElement;
        if (value instanceof ContingentLabeledValueWithContingency) {
            valueElement = this.createContingentLabeledValueWithContingencyElement(document, (ContingentLabeledValueWithContingency)value);
        } else if (value instanceof ContingentLabeledValue) {
            valueElement = this.createContingentLabeledValueElement(document, (ContingentLabeledValue)value);
        } else {
            valueElement = document.createElementNS(NS, "labeledValue");
            this.fillLabeledValueElement(document, valueElement, value);
        }
        return valueElement;
    }

    private Element createContingentLabeledValueWithContingencyElement(Document document, ContingentLabeledValueWithContingency value) {
        Element valueElement = this.createContingentLabeledValueElement(document, value);
        Element contingencyValueElement = CSTNUXMLExportTools.addElement(document, valueElement, "contingencyValue");
        this.fillTimeDistanceElement(document, contingencyValueElement, value.getContingency());
        return valueElement;
    }

    private Element createContingentLabeledValueElement(Document document, ContingentLabeledValue value) {
        Element valueElement = document.createElementNS(NS, "contingentLabeledValue");
        this.fillLabeledValueElement(document, valueElement, value);
        valueElement.setAttributeNS(NS, "constraintCase", value.getCase().toString());
        Element triggerElement = CSTNUXMLExportTools.addElement(document, valueElement, "trigger");
        this.fillNodeReference(document, triggerElement, value.getTrigger());
        Element timeDistance = CSTNUXMLExportTools.addElement(document, valueElement, "contingentValue");
        this.fillTimeDistanceElement(document, timeDistance, value.getContingentValue());
        return valueElement;
    }

    private void fillLabeledValueElement(Document document, Element valueElement, LabeledValue value) {
        valueElement.appendChild(this.createLabelElement(document, value.getLabel()));
        Element timeDistance = CSTNUXMLExportTools.addElement(document, valueElement, "value");
        this.fillTimeDistanceElement(document, timeDistance, value.getValue());
    }

    private void fillTimeDistanceElement(Document document, Element timeDistanceElement, TimeDistance value) {
        timeDistanceElement.setAttributeNS(NS, "months", "" + value.getMonths());
        timeDistanceElement.setAttributeNS(NS, "days", "" + value.getDays());
        timeDistanceElement.setAttributeNS(NS, "hours", "" + value.getHours());
        timeDistanceElement.setAttributeNS(NS, "minutes", "" + value.getMinutes());
        timeDistanceElement.setAttributeNS(NS, "seconds", "" + value.getSeconds());
        timeDistanceElement.setAttributeNS(NS, "milliseconds", "" + value.getMilliseconds());
    }

    private void fillNodeMappingElement(Document document, Element nodeMappingElement, Collection<NodeMapping<LabeledTimePoint>> nodeMapping) {
        for (NodeMapping<LabeledTimePoint> mapping : nodeMapping) {
            Element mappingElement = mapping.getClass().equals(SplitNodeMapping.class) ? this.createSplitNodeMappingElement(document, (SplitNodeMapping)mapping) : (mapping.getClass().equals(JoinNodeMapping.class) ? this.createJoinNodeMappingElement(document, (JoinNodeMapping)mapping) : this.createNodeMappingElement(document, mapping));
            nodeMappingElement.appendChild(mappingElement);
        }
    }

    private Element createNodeMappingElement(Document document, NodeMapping<LabeledTimePoint> mapping) {
        Element nodeMappingElement = document.createElementNS(NS, "nodeMapping");
        this.fillNodeMappingElement(document, nodeMappingElement, mapping);
        return nodeMappingElement;
    }

    private void fillNodeMappingElement(Document document, Element nodeMappingElement, NodeMapping<LabeledTimePoint> mapping) {
        nodeMappingElement.setAttributeNS(NS, "label", mapping.getLabel());
        Element nodeInstanceElement = this.createNodeInstanceElement(document, mapping.getNodeInstance());
        nodeMappingElement.appendChild(nodeInstanceElement);
        Element startNodeElement = document.createElementNS(NS, "startNodeReference");
        this.fillNodeReference(document, startNodeElement, mapping.getStartNode());
        nodeMappingElement.appendChild(startNodeElement);
        Element intermendiateNodesElement = document.createElementNS(NS, "intermediateNodes");
        LabeledTimePoint[] labeledTimePointArray = (LabeledTimePoint[])mapping.getIntermediateEvents();
        int n = labeledTimePointArray.length;
        int n2 = 0;
        while (n2 < n) {
            LabeledTimePoint n3 = labeledTimePointArray[n2];
            Element nodeElement = document.createElementNS(NS, "nodeReference");
            this.fillNodeReference(document, nodeElement, n3);
            intermendiateNodesElement.appendChild(nodeElement);
            ++n2;
        }
        nodeMappingElement.appendChild(intermendiateNodesElement);
        Element endNodeElement = document.createElementNS(NS, "endNodeReference");
        this.fillNodeReference(document, endNodeElement, mapping.getEndNode());
        nodeMappingElement.appendChild(endNodeElement);
    }

    private void fillNodeReference(Document document, Element nodeReferenceElement, LabeledTimePoint node) {
        this.fillNodeInstanceElement(document, nodeReferenceElement, node.getNodeInstance());
        nodeReferenceElement.setAttributeNS(NS, "eventID", node.getEventID());
    }

    private Element createJoinNodeMappingElement(Document document, JoinNodeMapping<LabeledTimePoint> mapping) {
        Element nodeMappingElement = document.createElementNS(NS, "joinNodeMapping");
        this.fillNodeMappingElement(document, nodeMappingElement, mapping);
        Element prefixNodesElement = document.createElementNS(NS, "prefixNodes");
        LabeledTimePoint[] prefixNodes = (LabeledTimePoint[])mapping.getPrefixNodes();
        NodeInstance[] branches = mapping.getBranches();
        int i = 0;
        while (i < prefixNodes.length) {
            LabeledTimePoint n = prefixNodes[i];
            NodeInstance cfr_ignored_0 = branches[i];
            Element nodeElement = document.createElementNS(NS, "nodeReference");
            this.fillNodeReference(document, nodeElement, n);
            prefixNodesElement.appendChild(nodeElement);
            ++i;
        }
        nodeMappingElement.appendChild(prefixNodesElement);
        return nodeMappingElement;
    }

    private Element createSplitNodeMappingElement(Document document, SplitNodeMapping<LabeledTimePoint> mapping) {
        Element nodeMappingElement = document.createElementNS(NS, "splitNodeMapping");
        this.fillNodeMappingElement(document, nodeMappingElement, mapping);
        Element prefixNodesElement = document.createElementNS(NS, "suffixNodes");
        LabeledTimePoint[] labeledTimePointArray = (LabeledTimePoint[])mapping.getSuffixNodes();
        int n = labeledTimePointArray.length;
        int n2 = 0;
        while (n2 < n) {
            LabeledTimePoint n3 = labeledTimePointArray[n2];
            Element nodeElement = document.createElementNS(NS, "nodeReference");
            this.fillNodeReference(document, nodeElement, n3);
            prefixNodesElement.appendChild(nodeElement);
            ++n2;
        }
        nodeMappingElement.appendChild(prefixNodesElement);
        return nodeMappingElement;
    }

    private void fillNodesElement(Document document, Element nodesElement, Collection<LabeledTimePoint> tcnNodes) {
        TreeSet<LabeledTimePoint> sortedSet = new TreeSet<LabeledTimePoint>(new Comparator<LabeledTimePoint>(){

            @Override
            public int compare(LabeledTimePoint node1, LabeledTimePoint node2) {
                if (node1.equals(node2)) {
                    return 0;
                }
                if (node1 instanceof DefaultObservationTimePoint || node2 instanceof DefaultObservationTimePoint) {
                    if (node1 instanceof DefaultObservationTimePoint && node2 instanceof DefaultObservationTimePoint) {
                        Proposition label2;
                        Proposition label1 = (Proposition)node1.getLabel();
                        if (label1.satisfiable(label2 = (Proposition)node2.getLabel())) {
                            for (ObservationBinding ob1 : label1.getObservations()) {
                                if (!ob1.getVariable().getDecisionTimePoint().equals(node2)) continue;
                                return 1;
                            }
                            for (ObservationBinding ob2 : label2.getObservations()) {
                                if (!ob2.getVariable().getDecisionTimePoint().equals(node1)) continue;
                                return -1;
                            }
                        }
                    } else {
                        if (node1 instanceof DefaultObservationTimePoint) {
                            return -1;
                        }
                        return 1;
                    }
                }
                int sgn = node1.hashCode() - node2.hashCode() > 0 ? 1 : -1;
                return sgn;
            }
        });
        sortedSet.addAll(tcnNodes);
        assert (sortedSet.size() == tcnNodes.size());
        for (LabeledTimePoint node : sortedSet) {
            Element nodeElement = node.getClass().equals(DefaultObservationTimePoint.class) ? this.createObservationNodeElement(document, (DefaultObservationTimePoint)node) : this.createNodeElement(document, node);
            nodesElement.appendChild(nodeElement);
        }
    }

    private Element createObservationNodeElement(Document document, DefaultObservationTimePoint node) {
        Element nodeElement = document.createElementNS(NS, "observationNode");
        this.fillNodeElement(document, node, nodeElement);
        Element decisionLabelsElement = document.createElementNS(NS, "decisionLabels");
        for (Map.Entry<Long, ObservationBinding> ds : node.getEdgeCodeMapping().entrySet()) {
            Element decisionLabel = document.createElementNS(NS, "decisionLabel");
            decisionLabelsElement.appendChild(decisionLabel);
            decisionLabel.setAttributeNS(NS, "edgeCode", String.valueOf(ds.getKey()));
            ObservationBinding observation = ds.getValue();
            decisionLabel.setAttributeNS(NS, "observationCode", String.valueOf(observation.getValue()));
        }
        nodeElement.appendChild(decisionLabelsElement);
        return nodeElement;
    }

    private Element createObservationBindingElement(Document document, ObservationBinding observation) {
        Element literalGroupElement = document.createElementNS(NS, "observation");
        Element splitNode = document.createElement("observationSource");
        this.fillNodeReference(document, splitNode, observation.getVariable().getDecisionTimePoint());
        literalGroupElement.appendChild(splitNode);
        literalGroupElement.setAttributeNS(NS, "observationCode", String.valueOf(observation.getValue()));
        literalGroupElement.setAttributeNS(NS, "edgeCode", String.valueOf(observation.getEdgeCode()));
        return literalGroupElement;
    }

    private Element createNodeElement(Document document, LabeledTimePoint node) {
        Element nodeElement = document.createElementNS(NS, "node");
        this.fillNodeElement(document, node, nodeElement);
        return nodeElement;
    }

    private void fillNodeElement(Document document, LabeledTimePoint node, Element nodeElement) {
        Element nodeInstanceElement = document.createElementNS(NS, "event");
        this.fillNodeInstanceElement(document, nodeInstanceElement, node.getNodeInstance());
        nodeInstanceElement.setAttributeNS(NS, "eventID", node.getEventID());
        nodeElement.appendChild(nodeInstanceElement);
        Element labelElement = this.createLabelElement(document, node.getLabel());
        nodeElement.appendChild(labelElement);
        Element pluginDataContainer = XMLExportTools.createPluginDataContainerElement((Document)document, (String)NS, (PluginDataContainer)node);
        nodeElement.appendChild(pluginDataContainer);
    }

    private Element createNodeInstanceElement(Document document, NodeInstance nodeInstance) {
        Element nodeInstanceElement = document.createElementNS(NS, "nodeInstance");
        this.fillNodeInstanceElement(document, nodeInstanceElement, nodeInstance);
        return nodeInstanceElement;
    }

    private void fillNodeInstanceElement(Document document, Element nodeInstanceElement, NodeInstance nodeInstance) {
        nodeInstanceElement.setAttributeNS(NS, "nodeID", "n" + Integer.toString(nodeInstance.getNodeID()));
        nodeInstanceElement.setAttributeNS(NS, "topologicalID", Integer.toString(nodeInstance.getTopologicalID()));
        Element iterationChain = this.createIterationChainElement(document, nodeInstance.getIteration());
        nodeInstanceElement.appendChild(iterationChain);
    }

    private Element createLabelElement(Document document, Label label) {
        if (label instanceof Proposition) {
            return this.createPropositionElement(document, (Proposition)label);
        }
        throw new IllegalArgumentException("label must be a Proposition");
    }

    private Element createPropositionElement(Document document, Proposition label) {
        Element propositionElement = document.createElementNS(NS, "proposition");
        for (ObservationBinding literal : label.getObservations()) {
            Element literalGroupElement = this.createObservationBindingElement(document, literal);
            propositionElement.appendChild(literalGroupElement);
        }
        return propositionElement;
    }

    private Element createIterationChainElement(Document document, IterationChain iterationChain) {
        Element iterationChainElement = document.createElementNS(NS, "iterationChain");
        IterationChain.Iteration[] iterationArray = iterationChain.getIterations();
        int n = iterationArray.length;
        int n2 = 0;
        while (n2 < n) {
            IterationChain.Iteration iteration = iterationArray[n2];
            Element iterationElement = this.createIterationElement(document, iteration);
            iterationChainElement.appendChild(iterationElement);
            ++n2;
        }
        return iterationChainElement;
    }

    private Element createIterationElement(Document document, IterationChain.Iteration iteration) {
        Element iterationElement = document.createElementNS(NS, "iteration");
        iterationElement.setAttributeNS(NS, "nodeID", "n" + String.valueOf(iteration.getNodeID()));
        iterationElement.setAttributeNS(NS, "iteration", String.valueOf(iteration.getIteration()));
        return iterationElement;
    }

    private static Element addElement(Document document, Element parent, String type) {
        return CSTNUXMLExportTools.addElement(document, NS, parent, type);
    }

    protected static Element addElement(Document document, String ns, Element parent, String type) {
        Element element = document.createElementNS(ns, type);
        parent.appendChild(element);
        return element;
    }
}

