/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.timemodel.tcn.xml;

import de.aristaflow.adept2.model.common.PluginData;
import de.aristaflow.adept2.model.common.defaultimplementation.DefaultPluginData;
import de.aristaflow.adept2.model.common.defaultimplementation.DefaultPluginDataContainer;
import de.aristaflow.adept2.model.common.timedata.TimeDistance;
import de.aristaflow.adept2.model.common.timedata.defaultimplementation.DefaultTimeDistance;
import de.aristaflow.adept2.model.timemodel.tcn.IterationChain;
import de.aristaflow.adept2.model.timemodel.tcn.JoinNodeMapping;
import de.aristaflow.adept2.model.timemodel.tcn.Label;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledEdge;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledTimePoint;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledValue;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledValueSet;
import de.aristaflow.adept2.model.timemodel.tcn.NodeInstance;
import de.aristaflow.adept2.model.timemodel.tcn.NodeMapping;
import de.aristaflow.adept2.model.timemodel.tcn.SplitNodeMapping;
import de.aristaflow.adept2.model.timemodel.tcn.TCN;
import de.aristaflow.adept2.model.timemodel.tcn.TCNEdge;
import de.aristaflow.adept2.model.timemodel.tcn.TCNTimePoint;
import de.aristaflow.adept2.model.timemodel.tcn.cstnImpl.DefaultCSTN;
import de.aristaflow.adept2.model.timemodel.tcn.cstnuImpl.DefaultCSTNU;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.AbstractTCN;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.ContingentLabeledValue;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.DefaultContingentLabeledValue;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.DefaultContingentLabeledValueWithContingency;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.DefaultLabeledEdge;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.DefaultLabeledNode;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.DefaultLabeledValue;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.DefaultLabeledValueSet;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.DefaultObservationTimePoint;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.ObservationBinding;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.Proposition;
import de.aristaflow.adept2.model.timemodel.tcn.xml.CSTNUXMLExportTools;
import de.aristaflow.adept2.util.xml.XMLHelperTools;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CSTNUXMLImportTools {
    protected static Element getElement(Node node) {
        return XMLHelperTools.getElement((Node)node);
    }

    public static TCN<LabeledTimePoint, LabeledEdge> getTCN(Element root) {
        if (!root.getTagName().equals("cstnu")) {
            throw new IllegalArgumentException("Can only load cstnus");
        }
        String type = root.getAttributeNS(CSTNUXMLExportTools.NS, "type");
        if (type == null || type.trim().length() == 0) {
            type = "cstnu";
        }
        Element element = CSTNUXMLImportTools.getElement(root.getFirstChild());
        Map<NodeInstance, Map<String, LabeledTimePoint>> nodeMap = CSTNUXMLImportTools.getLabeledNodes(element);
        ArrayList<LabeledTimePoint> tcnNodes = new ArrayList<LabeledTimePoint>();
        for (Map<String, LabeledTimePoint> m : nodeMap.values()) {
            for (LabeledTimePoint n : m.values()) {
                tcnNodes.add(n);
            }
        }
        if ("nodeMappings".equalsIgnoreCase((element = CSTNUXMLImportTools.getElement(element.getNextSibling())).getNodeName())) {
            element = CSTNUXMLImportTools.getElement(element.getNextSibling());
        }
        List<LabeledEdge> tcnEdges = CSTNUXMLImportTools.getLabeledEdges(element, nodeMap);
        HashSet<Label.ChoiceVariable> labels = new HashSet<Label.ChoiceVariable>();
        for (LabeledTimePoint node : tcnNodes) {
            if (!(node instanceof DefaultObservationTimePoint)) continue;
            labels.add(((DefaultObservationTimePoint)node).getObservation());
        }
        if ("cstnu".equalsIgnoreCase(type)) {
            return new DefaultCSTNU(tcnNodes, tcnEdges, labels);
        }
        if ("cstn".equalsIgnoreCase(type)) {
            return new DefaultCSTN(tcnNodes, tcnEdges, labels);
        }
        throw new IllegalArgumentException();
    }

    private static List<LabeledEdge> getLabeledEdges(Element element, Map<NodeInstance, Map<String, LabeledTimePoint>> tcnNodes) {
        assert (element.getNodeName().equals("tcnEdges"));
        ArrayList<LabeledEdge> edges = new ArrayList<LabeledEdge>();
        Element edgeElement = CSTNUXMLImportTools.getElement(element.getFirstChild());
        while (edgeElement != null) {
            LabeledEdge edge = CSTNUXMLImportTools.getLabeledEdge(edgeElement, tcnNodes);
            edges.add(edge);
            edgeElement = CSTNUXMLImportTools.getElement(edgeElement.getNextSibling());
        }
        return edges;
    }

    private static LabeledEdge getLabeledEdge(Element edgeElement, Map<NodeInstance, Map<String, LabeledTimePoint>> tcnNodes) {
        assert (edgeElement.getNodeName().equals("labeledEdge"));
        Element element = CSTNUXMLImportTools.getElement(edgeElement.getFirstChild());
        LabeledTimePoint sourceNode = CSTNUXMLImportTools.getNodeReference(element, tcnNodes);
        element = CSTNUXMLImportTools.getElement(element.getNextSibling());
        LabeledTimePoint targetNode = CSTNUXMLImportTools.getNodeReference(element, tcnNodes);
        boolean controlEdge = Boolean.parseBoolean(edgeElement.getAttributeNS(CSTNUXMLExportTools.NS, "controlEdge"));
        boolean implicit = Boolean.parseBoolean(edgeElement.getAttributeNS(CSTNUXMLExportTools.NS, "implicit"));
        TCNEdge.FlowDirection flowDirection = TCNEdge.FlowDirection.valueOf(edgeElement.getAttributeNS(CSTNUXMLExportTools.NS, "flowDirection"));
        element = CSTNUXMLImportTools.getElement(element.getNextSibling());
        LabeledValueSet value = CSTNUXMLImportTools.getLabeledValueSet(element, tcnNodes);
        return new DefaultLabeledEdge(sourceNode, targetNode, value, controlEdge, implicit, flowDirection);
    }

    private static LabeledValueSet getLabeledValueSet(Element element, Map<NodeInstance, Map<String, LabeledTimePoint>> tcnNodes) {
        Element valueElement = CSTNUXMLImportTools.getElement(element.getFirstChild());
        ArrayList<LabeledValue> values = new ArrayList<LabeledValue>();
        while (valueElement != null) {
            LabeledValue value = CSTNUXMLImportTools.getLabeledValue(valueElement, tcnNodes);
            values.add(value);
            valueElement = CSTNUXMLImportTools.getElement(valueElement.getNextSibling());
        }
        return new DefaultLabeledValueSet(values);
    }

    private static LabeledValue getLabeledValue(Element valueElement, Map<NodeInstance, Map<String, LabeledTimePoint>> tcnNodes) {
        DefaultLabeledValue value;
        Element el = CSTNUXMLImportTools.getElement(valueElement.getFirstChild());
        Label label = CSTNUXMLImportTools.getLabel(el, tcnNodes);
        el = CSTNUXMLImportTools.getElement(el.getNextSibling());
        TimeDistance timeDistance = CSTNUXMLImportTools.getTimeDistance(el);
        if (valueElement.getNodeName().equals("contingentLabeledValue")) {
            ContingentLabeledValue.ConstraintCase constraintCase = ContingentLabeledValue.ConstraintCase.valueOf(valueElement.getAttributeNS(CSTNUXMLExportTools.NS, "constraintCase"));
            el = CSTNUXMLImportTools.getElement(el.getNextSibling());
            LabeledTimePoint trigger = CSTNUXMLImportTools.getNodeReference(el, tcnNodes);
            el = CSTNUXMLImportTools.getElement(el.getNextSibling());
            TimeDistance contingentValue = CSTNUXMLImportTools.getTimeDistance(el);
            if ((el = CSTNUXMLImportTools.getElement(el.getNextSibling())) != null && el.getTagName().equals("contingencyValue")) {
                TimeDistance contingencyValue = CSTNUXMLImportTools.getTimeDistance(el);
                value = new DefaultContingentLabeledValueWithContingency(label, constraintCase, timeDistance, trigger, contingentValue, contingencyValue);
            } else {
                value = new DefaultContingentLabeledValue(label, constraintCase, timeDistance, trigger, contingentValue);
            }
        } else {
            value = new DefaultLabeledValue(label, timeDistance);
        }
        return value;
    }

    private static TimeDistance getTimeDistance(Element timeDistanceElement) {
        long millis = Long.MIN_VALUE;
        long seconds = Long.MIN_VALUE;
        long minutes = Long.MIN_VALUE;
        long hours = Long.MIN_VALUE;
        long days = Long.MIN_VALUE;
        long months = Long.MIN_VALUE;
        if (timeDistanceElement.hasAttributeNS(CSTNUXMLExportTools.NS, "months")) {
            months = Long.parseLong(timeDistanceElement.getAttributeNS(CSTNUXMLExportTools.NS, "months"));
        }
        if (timeDistanceElement.hasAttributeNS(CSTNUXMLExportTools.NS, "days")) {
            days = Long.parseLong(timeDistanceElement.getAttributeNS(CSTNUXMLExportTools.NS, "days"));
        }
        if (timeDistanceElement.hasAttributeNS(CSTNUXMLExportTools.NS, "hours")) {
            hours = Long.parseLong(timeDistanceElement.getAttributeNS(CSTNUXMLExportTools.NS, "hours"));
        }
        if (timeDistanceElement.hasAttributeNS(CSTNUXMLExportTools.NS, "minutes")) {
            minutes = Long.parseLong(timeDistanceElement.getAttributeNS(CSTNUXMLExportTools.NS, "minutes"));
        }
        if (timeDistanceElement.hasAttributeNS(CSTNUXMLExportTools.NS, "seconds")) {
            seconds = Long.parseLong(timeDistanceElement.getAttributeNS(CSTNUXMLExportTools.NS, "seconds"));
        }
        if (timeDistanceElement.hasAttributeNS(CSTNUXMLExportTools.NS, "milliseconds")) {
            millis = Long.parseLong(timeDistanceElement.getAttributeNS(CSTNUXMLExportTools.NS, "milliseconds"));
        }
        return new DefaultTimeDistance(millis, seconds, minutes, hours, days, months);
    }

    private static LabeledTimePoint getNodeReference(Element element, Map<NodeInstance, Map<String, LabeledTimePoint>> tcnNodes) {
        NodeInstance nodeInstance = CSTNUXMLImportTools.getNodeInstance(element);
        String eventID = element.getAttributeNS(CSTNUXMLExportTools.NS, "eventID");
        return tcnNodes.get(nodeInstance).get(eventID);
    }

    private static List<NodeMapping<LabeledTimePoint>> getNodeMappings(Element mappingElement, Map<NodeInstance, Map<String, LabeledTimePoint>> tcnNodes) {
        Element element = CSTNUXMLImportTools.getElement(mappingElement.getFirstChild());
        ArrayList<NodeMapping<LabeledTimePoint>> mappings = new ArrayList<NodeMapping<LabeledTimePoint>>();
        while (element != null) {
            NodeMapping<LabeledTimePoint> mapping = CSTNUXMLImportTools.getNodeMapping(element, tcnNodes);
            mappings.add(mapping);
            element = CSTNUXMLImportTools.getElement(element.getNextSibling());
        }
        return mappings;
    }

    private static NodeMapping<LabeledTimePoint> getNodeMapping(Element mappingElement, Map<NodeInstance, Map<String, LabeledTimePoint>> tcnNodes) {
        NodeMapping nodeMapping;
        String label = mappingElement.getAttributeNS(CSTNUXMLExportTools.NS, "label");
        Element element = CSTNUXMLImportTools.getElement(mappingElement.getFirstChild());
        NodeInstance nodeInstance = CSTNUXMLImportTools.getNodeInstance(element);
        element = CSTNUXMLImportTools.getElement(element.getNextSibling());
        LabeledTimePoint startNode = CSTNUXMLImportTools.getNodeReference(element, tcnNodes);
        element = CSTNUXMLImportTools.getElement(element.getNextSibling());
        Element child = CSTNUXMLImportTools.getElement(element.getFirstChild());
        ArrayList<LabeledTimePoint> intermediateEvents = new ArrayList<LabeledTimePoint>();
        while (child != null) {
            LabeledTimePoint intermediateNode = CSTNUXMLImportTools.getNodeReference(child, tcnNodes);
            intermediateEvents.add(intermediateNode);
            child = CSTNUXMLImportTools.getElement(child.getNextSibling());
        }
        element = CSTNUXMLImportTools.getElement(element.getNextSibling());
        LabeledTimePoint endNode = CSTNUXMLImportTools.getNodeReference(element, tcnNodes);
        if (mappingElement.getNodeName().equals("joinNodeMapping")) {
            element = CSTNUXMLImportTools.getElement(element.getNextSibling());
            Element pref = CSTNUXMLImportTools.getElement(element.getFirstChild());
            ArrayList<LabeledTimePoint> prefixNodes = new ArrayList<LabeledTimePoint>();
            while (pref != null) {
                LabeledTimePoint intermediateNode = CSTNUXMLImportTools.getNodeReference(pref, tcnNodes);
                prefixNodes.add(intermediateNode);
                pref = CSTNUXMLImportTools.getElement(pref.getNextSibling());
            }
            nodeMapping = new JoinNodeMapping(label, nodeInstance, (TCNTimePoint[])prefixNodes.toArray(new LabeledTimePoint[prefixNodes.size()]), (TCNTimePoint)startNode, (TCNTimePoint[])intermediateEvents.toArray(new LabeledTimePoint[intermediateEvents.size()]), (TCNTimePoint)endNode);
        } else if (mappingElement.getNodeName().equals("splitNodeMapping")) {
            element = CSTNUXMLImportTools.getElement(element.getNextSibling());
            Element pref = CSTNUXMLImportTools.getElement(element.getFirstChild());
            ArrayList<LabeledTimePoint> suffixNodes = new ArrayList<LabeledTimePoint>();
            while (pref != null) {
                LabeledTimePoint intermediateNode = CSTNUXMLImportTools.getNodeReference(pref, tcnNodes);
                suffixNodes.add(intermediateNode);
                pref = CSTNUXMLImportTools.getElement(pref.getNextSibling());
            }
            nodeMapping = new SplitNodeMapping(label, nodeInstance, (TCNTimePoint)startNode, (TCNTimePoint[])intermediateEvents.toArray(new LabeledTimePoint[intermediateEvents.size()]), (TCNTimePoint)endNode, (TCNTimePoint[])suffixNodes.toArray(new LabeledTimePoint[suffixNodes.size()]));
        } else {
            nodeMapping = new NodeMapping(label, nodeInstance, (TCNTimePoint)startNode, (TCNTimePoint[])intermediateEvents.toArray(new LabeledTimePoint[intermediateEvents.size()]), (TCNTimePoint)endNode);
        }
        return nodeMapping;
    }

    private static Map<NodeInstance, Map<String, LabeledTimePoint>> getLabeledNodes(Element nodesElement) {
        HashMap<NodeInstance, Map<String, LabeledTimePoint>> nodeMap = new HashMap<NodeInstance, Map<String, LabeledTimePoint>>();
        Element element = CSTNUXMLImportTools.getElement(nodesElement.getFirstChild());
        while (element != null) {
            LabeledTimePoint node = element.getTagName().equals("observationNode") ? CSTNUXMLImportTools.getObservationNode(element, nodeMap) : CSTNUXMLImportTools.getLabeledNode(element, nodeMap);
            HashMap<String, LabeledTimePoint> map = (HashMap<String, LabeledTimePoint>)nodeMap.get(node.getNodeInstance());
            if (map == null) {
                map = new HashMap<String, LabeledTimePoint>();
                nodeMap.put(node.getNodeInstance(), map);
            }
            map.put(node.getEventID(), node);
            element = CSTNUXMLImportTools.getElement(element.getNextSibling());
        }
        return nodeMap;
    }

    private static LabeledTimePoint getLabeledNode(Element nodeElement, Map<NodeInstance, Map<String, LabeledTimePoint>> tcnNodes) {
        Element pdcElement = null;
        Element element = CSTNUXMLImportTools.getElement(nodeElement.getFirstChild());
        NodeInstance nodeInstance = CSTNUXMLImportTools.getNodeInstance(element);
        String eventID = element.getAttributeNS(CSTNUXMLExportTools.NS, "eventID");
        element = CSTNUXMLImportTools.getElement(element.getNextSibling());
        Label label = CSTNUXMLImportTools.getLabel(element, tcnNodes);
        if ((element = CSTNUXMLImportTools.getElement(element.getNextSibling())) != null && element.getTagName().equals("pluginDataContainer")) {
            pdcElement = element;
        }
        if (nodeInstance.getNodeID() == Integer.MIN_VALUE) {
            return AbstractTCN.TIMEBASE_NODE;
        }
        DefaultLabeledNode labeledNode = new DefaultLabeledNode(nodeInstance, eventID, label);
        if (pdcElement != null) {
            CSTNUXMLImportTools.getPluginDataContainer((DefaultPluginDataContainer)labeledNode, pdcElement);
        }
        return labeledNode;
    }

    private static void getPluginDataContainer(DefaultPluginDataContainer container, Element pdcElement) {
        HashMap<String, DefaultPluginData> pluginDatas = new HashMap<String, DefaultPluginData>();
        Element pdElement = CSTNUXMLImportTools.getElement(pdcElement.getFirstChild());
        while (pdElement != null) {
            String extensionPoint = pdElement.getAttribute("extensionPoint");
            String pluginID = pdElement.getAttribute("pluginID");
            HashMap<String, String> innerMap = new HashMap<String, String>();
            Element pdEntry = CSTNUXMLImportTools.getElement(pdElement.getFirstChild());
            while (pdEntry != null) {
                innerMap.put(pdEntry.getAttribute("name"), pdEntry.getTextContent());
                pdEntry = CSTNUXMLImportTools.getElement(pdEntry.getNextSibling());
            }
            DefaultPluginData pluginData = new DefaultPluginData(pluginID, innerMap);
            pluginDatas.put(pluginID, pluginData);
            container.addSupportedPlugin(extensionPoint, pluginID, (PluginData)pluginData);
            pdElement = CSTNUXMLImportTools.getElement(pdElement.getNextSibling());
        }
    }

    private static NodeInstance getNodeInstance(Element nodeInstanceElement) {
        String nodeIDString = nodeInstanceElement.getAttributeNS(CSTNUXMLExportTools.NS, "nodeID");
        assert (nodeIDString != null && nodeIDString.length() > 1) : ((Element)nodeInstanceElement.getParentNode()).getTagName();
        int nodeID = Integer.parseInt(nodeIDString.substring(1));
        String topoIDString = nodeInstanceElement.getAttributeNS(CSTNUXMLExportTools.NS, "topologicalID");
        int topologicalID = topoIDString != null && topoIDString.length() > 0 ? Integer.parseInt(topoIDString) : -1;
        Element element = CSTNUXMLImportTools.getElement(nodeInstanceElement.getFirstChild());
        IterationChain iterationChain = CSTNUXMLImportTools.getIterationChain(element);
        return new NodeInstance(nodeID, iterationChain, topologicalID);
    }

    private static IterationChain getIterationChain(Element chainElement) {
        assert (chainElement.getNodeName().equals("iterationChain"));
        ArrayList<IterationChain.Iteration> iterations = new ArrayList<IterationChain.Iteration>();
        Element element = CSTNUXMLImportTools.getElement(chainElement.getFirstChild());
        while (element != null) {
            IterationChain.Iteration iteration = CSTNUXMLImportTools.getIteration(element);
            iterations.add(iteration);
            element = CSTNUXMLImportTools.getElement(element.getNextSibling());
        }
        IterationChain iterationChain = new IterationChain(iterations.toArray(new IterationChain.Iteration[iterations.size()]));
        return iterationChain;
    }

    private static IterationChain.Iteration getIteration(Element element) {
        assert (element.getNodeName().equals("iteration"));
        String nodeIDString = element.getAttributeNS(CSTNUXMLExportTools.NS, "nodeID");
        int nodeID = Integer.parseInt(nodeIDString.substring(1));
        String iterationString = element.getAttributeNS(CSTNUXMLExportTools.NS, "iteration");
        int iteration = Integer.parseInt(iterationString);
        return new IterationChain.Iteration(nodeID, iteration);
    }

    private static LabeledTimePoint getObservationNode(Element nodeElement, Map<NodeInstance, Map<String, LabeledTimePoint>> tcnNodes) {
        assert (nodeElement.getTagName().equals("observationNode"));
        Element element = CSTNUXMLImportTools.getElement(nodeElement.getFirstChild());
        NodeInstance nodeInstance = CSTNUXMLImportTools.getNodeInstance(element);
        String eventID = element.getAttributeNS(CSTNUXMLExportTools.NS, "eventID");
        element = CSTNUXMLImportTools.getElement(element.getNextSibling());
        Label label = CSTNUXMLImportTools.getLabel(element, tcnNodes);
        element = CSTNUXMLImportTools.getElement(element.getNextSibling());
        Element pdcElement = null;
        if (element.getTagName().equals("pluginDataContainer")) {
            pdcElement = element;
            element = CSTNUXMLImportTools.getElement(element.getNextSibling());
        }
        HashMap<Long, Integer> decisionLabels = new HashMap<Long, Integer>();
        Element ds = CSTNUXMLImportTools.getElement(element.getFirstChild());
        while (ds != null) {
            long edgeCode = Long.parseLong(ds.getAttributeNS(CSTNUXMLExportTools.NS, "edgeCode"));
            int observationID = Integer.parseInt(ds.getAttributeNS(CSTNUXMLExportTools.NS, "observationCode"));
            decisionLabels.put(edgeCode, observationID);
            ds = CSTNUXMLImportTools.getElement(ds.getNextSibling());
        }
        long[] edgeCodes = new long[decisionLabels.size()];
        int[] observationIDs = new int[decisionLabels.size()];
        int i = 0;
        for (Map.Entry x : decisionLabels.entrySet()) {
            edgeCodes[i] = ((Long)x.getKey()).intValue();
            observationIDs[i++] = (Integer)x.getValue();
        }
        DefaultObservationTimePoint observationTimePoint = new DefaultObservationTimePoint(nodeInstance, eventID, label, edgeCodes, observationIDs);
        if (pdcElement != null) {
            CSTNUXMLImportTools.getPluginDataContainer((DefaultPluginDataContainer)observationTimePoint, pdcElement);
        }
        return observationTimePoint;
    }

    private static Label getLabel(Element element, Map<NodeInstance, Map<String, LabeledTimePoint>> tcnNodes) {
        assert (element.getNodeName().equals("proposition"));
        ArrayList<ObservationBinding> literals = new ArrayList<ObservationBinding>();
        Element lit = CSTNUXMLImportTools.getElement(element.getFirstChild());
        while (lit != null) {
            ObservationBinding group = CSTNUXMLImportTools.getObservationBinding(lit, tcnNodes);
            literals.add(group);
            lit = CSTNUXMLImportTools.getElement(lit.getNextSibling());
        }
        return new Proposition(literals);
    }

    private static ObservationBinding getObservationBinding(Element element, Map<NodeInstance, Map<String, LabeledTimePoint>> tcnNodes) {
        assert (element.getTagName().equals("observation"));
        Element nv = CSTNUXMLImportTools.getElement(element.getFirstChild());
        LabeledTimePoint splitNode = CSTNUXMLImportTools.getNodeReference(nv, tcnNodes);
        assert (splitNode instanceof DefaultObservationTimePoint);
        DefaultObservationTimePoint observationNode = (DefaultObservationTimePoint)splitNode;
        int value = Integer.parseInt(element.getAttributeNS(CSTNUXMLExportTools.NS, "observationCode")) & 0xFFFF;
        long edgeCode = Integer.parseInt(element.getAttributeNS(CSTNUXMLExportTools.NS, "edgeCode"));
        return new ObservationBinding(observationNode.getObservation(), edgeCode, value);
    }
}

