/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.timemodel.tcn.xml;

import de.aristaflow.adept2.model.timemodel.tcn.LabeledEdge;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledTimePoint;
import de.aristaflow.adept2.model.timemodel.tcn.TCN;
import de.aristaflow.adept2.model.timemodel.tcn.TCNEdge;
import de.aristaflow.adept2.model.timemodel.tcn.TCNTimePoint;
import de.aristaflow.adept2.model.timemodel.tcn.xml.CSTNUXMLExportTools;
import de.aristaflow.adept2.model.timemodel.tcn.xml.TCNXMLImport;
import de.aristaflow.adept2.util.LoggerTools;
import de.aristaflow.adept2.util.xml.XMLFormatException;
import de.aristaflow.adept2.util.xml.XMLHelperTools;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;
import javax.xml.validation.Schema;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TCNXMLExport {
    private Logger logger = LoggerTools.getLogger((Object)this);
    private CSTNUXMLExportTools cstnuExportTools = new CSTNUXMLExportTools();

    public <N extends TCNTimePoint, E extends TCNEdge<N, ?>> Document getDocumentForTCN(TCN<N, E> tcn) throws XMLFormatException {
        Document document = XMLHelperTools.createDocument();
        TCN<LabeledTimePoint, LabeledEdge> bugFixTCN = tcn;
        Element root = this.cstnuExportTools.createCSTNElement(document, bugFixTCN);
        document.appendChild(root);
        try {
            XMLHelperTools.validateStream((InputStream)XMLHelperTools.getInputStreamForDocument((Document)document), (Schema)TCNXMLImport.getSchema());
        }
        catch (IOException e) {
            throw new XMLFormatException((Throwable)e);
        }
        return document;
    }

    public <N extends TCNTimePoint, E extends TCNEdge<N, ?>> InputStream getInputStreamForTCN(TCN<N, E> tcn) throws XMLFormatException, IOException {
        return XMLHelperTools.getInputStreamForDocument((Document)this.getDocumentForTCN(tcn));
    }

    public <N extends TCNTimePoint, E extends TCNEdge<N, ?>> String getXMLStringForTCN(TCN<N, E> tcn) throws XMLFormatException, IOException {
        return XMLHelperTools.getXMLStringForDocument((Document)this.getDocumentForTCN(tcn));
    }

    public <N extends TCNTimePoint, E extends TCNEdge<N, ?>> void writeTCNToFile(TCN<N, E> tcn, File file) throws IOException, XMLFormatException {
        Document doc = this.getDocumentForTCN(tcn);
        XMLHelperTools.writeDocumentToFile((Document)doc, (File)file, null);
    }
}

