/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.timemodel.tcn.xml;

import de.aristaflow.adept2.model.timemodel.tcn.LabeledEdge;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledTimePoint;
import de.aristaflow.adept2.model.timemodel.tcn.TCN;
import de.aristaflow.adept2.model.timemodel.tcn.xml.CSTNUXMLImportTools;
import de.aristaflow.adept2.util.xml.VersionException;
import de.aristaflow.adept2.util.xml.XMLFormatException;
import de.aristaflow.adept2.util.xml.XMLHelperTools;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class TCNXMLImport {
    private static Schema cstnuSchema;

    public TCN<LabeledTimePoint, LabeledEdge> getTCNFromFile(File file) throws VersionException, XMLFormatException, IOException {
        Document document = XMLHelperTools.getDocumentFromFile((File)file, null, null);
        return this.getTCNFromDocument(document);
    }

    public TCN<LabeledTimePoint, LabeledEdge> getTCNFromStream(InputStream inputStream) throws XMLFormatException, IOException {
        Document document = XMLHelperTools.getDocumentFromStream((InputStream)inputStream);
        return this.getTCNFromDocument(document);
    }

    public TCN<LabeledTimePoint, LabeledEdge> getTCNFromDocument(Document document) throws XMLFormatException {
        XMLHelperTools.validateDoc((Document)document, (Schema)TCNXMLImport.getSchema());
        Element root = document.getDocumentElement();
        return CSTNUXMLImportTools.getTCN(root);
    }

    public static Schema getSchema() {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        try {
            Schema schema = null;
            if (cstnuSchema == null) {
                cstnuSchema = schemaFactory.newSchema(TCNXMLImport.class.getResource("cstnu.xsd"));
            }
            schema = cstnuSchema;
            return schema;
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
    }
}

